/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.train.api.TrainCourseVideosApi;
import com.tydic.nbchat.train.api.bo.course.TrainVideosQueryReqBO;
import com.tydic.nbchat.train.api.bo.course.TrainVideosRspBO;
import com.tydic.nbchat.train.mapper.NbchatTrainCatalogMapper;
import com.tydic.nbchat.train.mapper.TrainCourseVideosMapper;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TrainCourseVideosImpl
implements TrainCourseVideosApi {
    private static final Logger log = LoggerFactory.getLogger(TrainCourseVideosImpl.class);
    @Resource
    private TrainCourseVideosMapper trainCourseVideosMapper;
    @Resource
    private NbchatTrainCatalogMapper trainCatalogMapper;

    public RspList getTrainCourseVideos(TrainVideosQueryReqBO request) {
        log.info("\u67e5\u8be2\u89c6\u9891\u6587\u4ef6\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)request);
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.trainCourseVideosMapper.selectAll(request.getCourseName(), request.getTenantCode());
        ArrayList list = new ArrayList();
        NiccCommonUtil.copyList((List)page.getResult(), list, TrainVideosRspBO.class);
        list.forEach(item -> {
            if (item.getVideoUrl() != null && item.getVideoUrl().contains("/files/")) {
                item.setPlayUrl(item.getVideoUrl().replace("/files/", "/files/player.html?src="));
            }
            List strings = this.trainCatalogMapper.selectBySectionIdStr(item.getSectionId());
            item.setCatalogTitle((String)strings.get(0));
        });
        return BaseRspUtils.createSuccessRspList(list, (long)page.getTotal());
    }
}

