/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.tydic.nbchat.train.api.TrainExamQaApi;
import com.tydic.nbchat.train.api.bo.eums.QuestionType;
import com.tydic.nbchat.train.api.bo.exam.NbchatExamQuestionBO;
import com.tydic.nbchat.train.api.bo.exam.NbchatQaRecordBO;
import com.tydic.nbchat.train.api.bo.train.NbchatExamQaBO;
import com.tydic.nbchat.train.mapper.NbchatExamQaRecordMapper;
import com.tydic.nbchat.train.mapper.NbchatExamQuestionMapper;
import com.tydic.nbchat.train.mapper.po.NbchatExamNewTestPaper;
import com.tydic.nbchat.train.mapper.po.NbchatExamQaRecord;
import com.tydic.nbchat.train.mapper.po.NbchatExamQuestion;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TrainExamQaServiceImpl
implements TrainExamQaApi {
    private static final Logger log = LoggerFactory.getLogger(TrainExamQaServiceImpl.class);
    @Resource
    NbchatExamQuestionMapper nbchatExamQuestionMapper;
    @Resource
    NbchatExamQaRecordMapper nbchatExamQaRecordMapper;

    public Rsp createNewPaper(NbchatExamQaBO request) {
        log.info("\u521b\u5efaqa\u8bd5\u9898:{}", (Object)request);
        NbchatExamNewTestPaper po = new NbchatExamNewTestPaper();
        po.setQuestions(Integer.valueOf(999));
        po.setTenantCode(request.getTenantCode());
        po.setCourseId(request.getCourseId());
        po.setQuestionType(QuestionType.QA_MIN.getCode());
        List questions = this.nbchatExamQuestionMapper.checkNewTestPaper(po);
        if (CollectionUtils.isEmpty((Collection)questions)) {
            return BaseRspUtils.createErrorRsp((String)"\u6ca1\u6709\u53ef\u7528\u7684\u8bd5\u9898");
        }
        List qId = questions.stream().map(NbchatExamQuestion::getQuestionId).collect(Collectors.toList());
        NbchatExamQaRecord record = new NbchatExamQaRecord();
        record.setId(IdWorker.nextAutoIdStr());
        record.setTenantCode(request.getTenantCode());
        record.setUserId(request.getUserId());
        record.setCourseId(request.getCourseId());
        record.setQuestionPaper(JSON.toJSONString(qId));
        record.setCreateTime(new Date());
        this.nbchatExamQaRecordMapper.insertSelective(record);
        List questionList = this.nbchatExamQuestionMapper.queryQuestions(qId);
        ArrayList res = new ArrayList();
        NiccCommonUtil.copyList((List)questionList, res, NbchatExamQuestionBO.class);
        NbchatQaRecordBO rsp = new NbchatQaRecordBO();
        rsp.setId(record.getId());
        rsp.setQuestions(res);
        return BaseRspUtils.createSuccessRsp((Object)rsp);
    }

    public Rsp getExamQaRecord(NbchatExamQaBO request) {
        log.info("\u83b7\u53d6qa\u8003\u8bd5\u8bb0\u5f55:{}", (Object)request);
        NbchatQaRecordBO rsp = new NbchatQaRecordBO();
        NbchatExamQaRecord po = new NbchatExamQaRecord();
        po.setTenantCode(request.getTenantCode());
        po.setUserId(request.getUserId());
        po.setCourseId(request.getCourseId());
        NbchatExamQaRecord record = this.nbchatExamQaRecordMapper.selectRecord(po);
        if (ObjectUtils.isEmpty((Object)record)) {
            return BaseRspUtils.createSuccessRsp(null);
        }
        rsp.setId(record.getId());
        rsp.setAnswers(record.getAnswerContent());
        String questionPaper = record.getQuestionPaper();
        if (JSON.isValidArray((String)questionPaper)) {
            List qId = JSON.parseArray((String)questionPaper, String.class);
            List questionList = this.nbchatExamQuestionMapper.queryQuestions(qId);
            ArrayList questionBOList = new ArrayList();
            NiccCommonUtil.copyList((List)questionList, questionBOList, NbchatExamQuestionBO.class);
            rsp.setQuestions(questionBOList);
        }
        return BaseRspUtils.createSuccessRsp((Object)rsp);
    }

    public Rsp saveRecord(NbchatExamQaBO request) {
        log.info("\u4fdd\u5b58qa\u8bb0\u5f55:{}", (Object)request);
        NbchatExamQaRecord po = new NbchatExamQaRecord();
        po.setId(request.getId());
        po.setAnswerContent(request.getAnswerContent());
        this.nbchatExamQaRecordMapper.update(po);
        return BaseRspUtils.createSuccessRsp(null);
    }
}

