/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl;

import com.tydic.nbchat.train.api.NbchatUserTrainRecordApi;
import com.tydic.nbchat.train.api.TrainSectionVideoApi;
import com.tydic.nbchat.train.api.bo.course.TranUserCourseSaveReqBO;
import com.tydic.nbchat.train.api.bo.video.SectionVideoRspBO;
import com.tydic.nbchat.train.api.bo.video.SectionVideoStstReqBO;
import com.tydic.nbchat.train.mapper.NbchatTrainRecordMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainSectionsMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainSectionsVideoMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainRecord;
import com.tydic.nbchat.train.mapper.po.NbchatTrainSections;
import com.tydic.nbchat.train.mapper.po.NbchatTrainSectionsVideo;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class TrainSectionVideoServiceImpl
implements TrainSectionVideoApi {
    private static final Logger log = LoggerFactory.getLogger(TrainSectionVideoServiceImpl.class);
    @Resource
    NbchatTrainRecordMapper nbchatTrainRecordMapper;
    @Resource
    NbchatTrainSectionsMapper nbchatTrainSectionsMapper;
    @Resource
    NbchatTrainSectionsVideoMapper nbchatTrainSectionsVideoMapper;
    @Resource
    NbchatUserTrainRecordApi nbchatUserTrainRecordApi;

    public Rsp handleVideoStst(SectionVideoStstReqBO request) {
        log.debug("\u5904\u7406\u89c6\u9891\u7edf\u8ba1\u4fe1\u606f\uff1a{}", (Object)request);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{request.getCourseId(), request.getStar()})) {
            TranUserCourseSaveReqBO reqBO = new TranUserCourseSaveReqBO();
            reqBO.setCourseId(request.getCourseId());
            reqBO.setUserId(request.getUserId());
            reqBO.setStar(request.getStar());
            Rsp rsp = this.nbchatUserTrainRecordApi.collectCourse(reqBO);
            log.info("\u6536\u85cf\u7ed3\u679c\uff1a{}", (Object)rsp);
            return rsp;
        }
        NbchatTrainSectionsVideo secRecord = this.nbchatTrainSectionsVideoMapper.queryBySecIdUserId(request.getSectionId(), request.getUserId());
        if (ObjectUtils.isEmpty((Object)secRecord)) {
            NbchatTrainSectionsVideo record = new NbchatTrainSectionsVideo();
            BeanUtils.copyProperties((Object)request, (Object)record);
            record.setIsZan(request.getLike());
            record.setViewProcess(request.getProgress());
            record.setCreateTime(new Date());
            this.nbchatTrainSectionsVideoMapper.insertSelective(record);
        } else {
            secRecord.setIsZan(request.getLike());
            secRecord.setViewProcess(request.getProgress());
            this.nbchatTrainSectionsVideoMapper.update(secRecord);
        }
        NbchatTrainSections index = new NbchatTrainSections();
        index.setSectionId(request.getSectionId());
        if (StringUtils.isNotEmpty((CharSequence)request.getLike())) {
            index.setZanNum(Integer.valueOf(1));
        }
        if (ObjectUtils.isNotEmpty((Object)request.getViewNum())) {
            index.setViewNum(Integer.valueOf(1));
        }
        if (ObjectUtils.anyNotNull((Object[])new Object[]{index.getZanNum(), index.getViewNum()})) {
            this.nbchatTrainSectionsMapper.updateVideoIndex(index);
        }
        return BaseRspUtils.createSuccessRsp(null);
    }

    public Rsp queryVideoIndex(SectionVideoStstReqBO request) {
        NbchatTrainRecord trainRecord;
        log.info("\u67e5\u8be2\u89c6\u9891\u70b9\u51fb\u6307\u6807\uff1a{}", (Object)request);
        NbchatTrainSections section = this.nbchatTrainSectionsMapper.selectByPrimaryKey(request.getSectionId());
        if (ObjectUtils.isEmpty((Object)section)) {
            return BaseRspUtils.createErrorRsp((String)"\u65e0\u6b64\u7ae0\u8282\u4fe1\u606f");
        }
        SectionVideoRspBO rsp = new SectionVideoRspBO();
        BeanUtils.copyProperties((Object)section, (Object)rsp);
        NbchatTrainSectionsVideo sectionsVideo = this.nbchatTrainSectionsVideoMapper.queryBySecIdUserId(request.getSectionId(), request.getUserId());
        if (ObjectUtils.isNotEmpty((Object)sectionsVideo)) {
            rsp.setViewProcess(sectionsVideo.getViewProcess());
            rsp.setIsZan(sectionsVideo.getIsZan());
        }
        if (ObjectUtils.isNotEmpty((Object)(trainRecord = this.nbchatTrainRecordMapper.selectByUserAndCourseId(request.getUserId(), request.getCourseId())))) {
            rsp.setIsStar(trainRecord.getStar());
        }
        int countStar = this.nbchatTrainRecordMapper.countStar(request.getCourseId());
        rsp.setStarNum(Integer.valueOf(countStar));
        return BaseRspUtils.createSuccessRsp((Object)rsp);
    }
}

