/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl;

import com.tydic.nbchat.train.api.bo.eums.VipFlagType;
import com.tydic.nbchat.train.core.service.UserVipService;
import com.tydic.nbchat.user.api.NbchatUserApi;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.eums.UserVipType;
import com.tydic.nicc.dc.base.bo.Rsp;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserVipServiceImpl
implements UserVipService {
    private static final Logger log = LoggerFactory.getLogger(UserVipServiceImpl.class);
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=10000)
    private NbchatUserApi nbchatUserApi;

    @Override
    public String getUserVipFlag(String userId) {
        try {
            if (StringUtils.isBlank((CharSequence)userId)) {
                log.warn("\u7528\u6237ID\u4e3a\u7a7a\uff0c\u8fd4\u56de\u666e\u901a\u7528\u6237\u72b6\u6001");
                return VipFlagType.COMMON_USER.getCode();
            }
            Rsp userInfoRsp = this.nbchatUserApi.getUserInfo(userId);
            if (!userInfoRsp.isSuccess() || userInfoRsp.getData() == null) {
                log.warn("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25: userId={}, error={}", (Object)userId, (Object)userInfoRsp.getRspDesc());
                return VipFlagType.COMMON_USER.getCode();
            }
            NbchatUserInfo userInfo = (NbchatUserInfo)userInfoRsp.getData();
            if (userInfo.getVipInfo() != null) {
                String vipStatus = userInfo.getVipInfo().getVipStatus();
                String vipType = userInfo.getVipInfo().getVipType();
                log.info("\u7528\u6237VIP\u4fe1\u606f: userId={}, vipStatus={}, vipType={}", new Object[]{userId, vipStatus, vipType});
                if ("1".equals(vipStatus) && StringUtils.isNotBlank((CharSequence)vipType)) {
                    String mappedVipFlag = this.mapVipTypeToVipFlag(vipType);
                    log.info("\u7528\u6237VIP\u6709\u6548\uff0cVIP\u7c7b\u578b: {}, \u6620\u5c04\u540e\u7684vip_flag: {}", (Object)vipType, (Object)mappedVipFlag);
                    return mappedVipFlag;
                }
            }
            log.info("\u7528\u6237VIP\u72b6\u6001\u65e0\u6548\u6216\u4e0d\u5b58\u5728\uff0c\u8fd4\u56de\u666e\u901a\u7528\u6237\u72b6\u6001: userId={}", (Object)userId);
            return VipFlagType.COMMON_USER.getCode();
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u7528\u6237VIP\u72b6\u6001\u5f02\u5e38: userId={}, error={}", new Object[]{userId, e.getMessage(), e});
            return VipFlagType.COMMON_USER.getCode();
        }
    }

    private String mapVipTypeToVipFlag(String vipType) {
        if (UserVipType.SCORE_PACKAGE.getCode().equals(vipType)) {
            return VipFlagType.COMMON_USER.getCode();
        }
        if (UserVipType.EXPERIENCE.getCode().equals(vipType)) {
            return VipFlagType.COMMON_USER.getCode();
        }
        if (UserVipType.ADVANCED.getCode().equals(vipType)) {
            return VipFlagType.VIP.getCode();
        }
        if (UserVipType.PROFESSIONAL.getCode().equals(vipType) || UserVipType.PROFESSIONAL_MAX.getCode().equals(vipType)) {
            return VipFlagType.PROFESSIONAL_VIP.getCode();
        }
        if (UserVipType.ENTERPRISE_VIP.getCode().equals(vipType)) {
            return VipFlagType.ENTERPRISE_VIP.getCode();
        }
        log.warn("\u672a\u77e5\u7684VIP\u7c7b\u578b: {}, \u9ed8\u8ba4\u8fd4\u56de\u666e\u901a\u7528\u6237\u6743\u9650", (Object)vipType);
        return VipFlagType.COMMON_USER.getCode();
    }
}

