/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.degree;

import com.tydic.nbchat.train.api.bo.eums.ProjectType;
import com.tydic.nbchat.train.core.service.impl.degree.DegreeApi;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DegreeFactory {
    private static final Logger log = LoggerFactory.getLogger(DegreeFactory.class);
    private final List<DegreeApi> degreeApis;

    public DegreeFactory(List<DegreeApi> degreeApis) {
        this.degreeApis = degreeApis;
    }

    public DegreeApi getDegreeApi(String projectType) {
        for (DegreeApi degreeApi : this.degreeApis) {
            if (!degreeApi.projectType().equals(projectType)) continue;
            return degreeApi;
        }
        throw new RuntimeException("\u627e\u4e0d\u5230DegreeApi\u5b9e\u73b0\u63a5\u53e3: projectType=" + projectType);
    }

    public String createDegree(String degreeId, ProjectType type) {
        DegreeApi degreeApi = this.getDegreeApi(type.getCode());
        String degreePath = null;
        try {
            degreePath = degreeApi.createDegree(degreeId);
        }
        catch (Exception e) {
            log.error("\u5236\u4f5c\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
        return degreePath;
    }
}

