/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.degree.tuotuo;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.springframework.core.io.ClassPathResource;

class ImageProcessor {
    private static final String FONT_NAME = "Alibaba PuHuiTi Regular";
    private static final int FONT_SIZE_NORMAL = 36;
    private static final Color FONT_COLOR_NORMAL = Color.BLACK;
    private Graphics2D graphics;
    private BufferedImage image;

    public ImageProcessor() throws IOException {
        this.initGraphics();
    }

    private void initGraphics() throws IOException {
        this.image = ImageIO.read(new ClassPathResource("images/degree_template_tt.jpg").getInputStream());
        this.graphics = (Graphics2D)this.image.getGraphics();
        this.graphics.setFont(new Font(FONT_NAME, 1, 36));
        this.graphics.setColor(FONT_COLOR_NORMAL);
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public ImageProcessor userName(String userName) {
        this.drawText(userName, 300, 710);
        return this;
    }

    public ImageProcessor projectName(String projectName) {
        this.drawText(projectName, 170, 870);
        return this;
    }

    public ImageProcessor issueTime(String issueTime) {
        this.graphics.setFont(new Font(FONT_NAME, 0, 36));
        this.drawText(issueTime, 650, 1450);
        return this;
    }

    public String build() throws IOException {
        return this.saveImage();
    }

    private void drawText(String text, int x, int y) {
        this.graphics.drawString(text, x, y);
    }

    private String saveImage() throws IOException {
        String path = "/tmp/" + System.currentTimeMillis() + "_degree.png";
        ImageIO.write((RenderedImage)this.image, "png", new File(path));
        return path;
    }
}

