/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.degree.tuotuo;

import com.tydic.nbchat.train.api.bo.eums.ProjectType;
import com.tydic.nbchat.train.core.service.impl.degree.DegreeApi;
import com.tydic.nbchat.train.core.service.impl.degree.tuotuo.ImageProcessor;
import com.tydic.nbchat.train.mapper.NbchatTrainTaskDegreeMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainTaskDegree;
import java.time.LocalDate;
import java.time.ZoneId;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TuotuoDegreeService
implements DegreeApi {
    private static final Logger log = LoggerFactory.getLogger(TuotuoDegreeService.class);
    @Resource
    NbchatTrainTaskDegreeMapper nbchatTrainTaskDegreeMapper;

    @Override
    public String projectType() {
        return ProjectType.Tuotuo.getCode();
    }

    @Override
    public String createDegree(String degreeId) throws Exception {
        NbchatTrainTaskDegree taskDegree = this.nbchatTrainTaskDegreeMapper.queryById(degreeId);
        log.info("\u8bc1\u4e66\u4fe1\u606f\uff1a{}", (Object)taskDegree);
        LocalDate localDate = taskDegree.getIssueDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        String issueDate = localDate.getYear() + "\u5e74" + localDate.getMonthValue() + "\u6708" + localDate.getDayOfMonth() + "\u65e5";
        return new ImageProcessor().userName(taskDegree.getUserName()).projectName("\u300a" + taskDegree.getDegreeName() + "\u300b\u8bfe\u7a0b").issueTime(issueDate).build();
    }
}

