/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.degree.zhongjiao;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.train.api.bo.eums.ProjectType;
import com.tydic.nbchat.train.api.bo.train.task.ImageBuilder;
import com.tydic.nbchat.train.api.bo.train.task.ImageInfo;
import com.tydic.nbchat.train.api.bo.train.task.TextBuilder;
import com.tydic.nbchat.train.api.bo.train.task.TextInfo;
import com.tydic.nbchat.train.core.config.NbchatTrainConfigProperties;
import com.tydic.nbchat.train.core.service.impl.degree.DegreeApi;
import com.tydic.nbchat.train.core.service.impl.degree.zhongjiao.ImageProcessor;
import com.tydic.nbchat.train.core.util.QRCodeGenerator;
import com.tydic.nbchat.train.mapper.NameMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainTaskDegreeMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainTaskDegree;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ZhongjiaoDegreeService
implements DegreeApi {
    private static final Logger log = LoggerFactory.getLogger(ZhongjiaoDegreeService.class);
    @Resource
    NbchatTrainTaskDegreeMapper nbchatTrainTaskDegreeMapper;
    @Resource
    NameMapper nameMapper;
    private final NbchatTrainConfigProperties nbchatTrainConfigProperties;

    public ZhongjiaoDegreeService(NbchatTrainConfigProperties nbchatTrainConfigProperties) {
        this.nbchatTrainConfigProperties = nbchatTrainConfigProperties;
    }

    @Override
    public String projectType() {
        return ProjectType.Zhongjiao.getCode();
    }

    @Override
    public String createDegree(String degreeId) throws Exception {
        NbchatTrainTaskDegree taskDegree = this.nbchatTrainTaskDegreeMapper.queryById(degreeId);
        log.info("\u8bc1\u4e66\u4fe1\u606f\uff1a{}", (Object)taskDegree);
        JSONObject userInfo = this.nameMapper.queryUserInfo(taskDegree.getUserId(), taskDegree.getTenantCode());
        if (ZhongjiaoDegreeService.isAnyEmpty(userInfo)) {
            log.error("\u5236\u4f5c\u8bc1\u4e66-\u7528\u6237\u4fe1\u606f\u975e\u6cd5\uff0c\u8bf7\u68c0\u67e5\uff1a{}", (Object)userInfo);
            return "";
        }
        String ancestors = this.nameMapper.queryDeptAncestors(taskDegree.getDeptId());
        log.info("\u7528\u6237\u6240\u5c5e\u673a\u6784\u7956\u5148\uff1a{}", (Object)ancestors);
        if (StringUtils.isEmpty((CharSequence)ancestors)) {
            log.error("\u7528\u6237\u6240\u5c5e\u673a\u6784\u7956\u5148\u4e3a\u7a7a");
            return "";
        }
        ArrayList<String> texts = new ArrayList<String>();
        texts.add(userInfo.getString("user_reality_name"));
        texts.add(userInfo.getString("gender"));
        texts.add(userInfo.getString("birthday"));
        texts.add(userInfo.getString("id_card"));
        texts.add(degreeId);
        String group = "";
        String postName = "";
        List userPostIds = this.nameMapper.queryPostId(taskDegree.getUserId(), taskDegree.getTenantCode());
        String postIds = taskDegree.getPostId();
        if (StringUtils.isEmpty((CharSequence)postIds)) {
            postName = this.nameMapper.queryPostNameList(userPostIds);
        } else {
            ArrayList<String> pids = new ArrayList<String>();
            for (String pid : userPostIds) {
                if (!postIds.contains(pid)) continue;
                pids.add(pid);
            }
            if (CollectionUtils.isNotEmpty(pids)) {
                postName = this.nameMapper.queryPostNameList(pids);
            }
        }
        String[] arr = ancestors.split(",");
        texts.add(arr.length >= 2 ? this.nameMapper.queryDeptName(arr[1]) : "");
        texts.add(arr.length >= 3 ? this.nameMapper.queryDeptName(arr[2]) : "");
        if (arr.length >= 4) {
            group = Optional.ofNullable(this.nameMapper.queryDeptName(arr[3])).orElse("");
            postName = Optional.ofNullable(postName).orElse(" ");
        }
        texts.add(group + "(" + (StringUtils.isEmpty((CharSequence)postName) ? "" : postName) + ")");
        ArrayList<TextInfo> textInfos = new ArrayList<TextInfo>();
        LocalDate localDate = taskDegree.getIssueDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        textInfos.add(TextBuilder.year((String)String.valueOf(localDate.getYear())));
        textInfos.add(TextBuilder.month((String)String.valueOf(localDate.getMonthValue())));
        textInfos.add(TextBuilder.day((String)String.valueOf(localDate.getDayOfMonth())));
        Integer score = this.nameMapper.queryUserScore(taskDegree.getUserId(), taskDegree.getTaskId());
        textInfos.add(TextBuilder.score((String)(score + "\u5206")));
        textInfos.add(TextBuilder.level((String)ZhongjiaoDegreeService.getScoreLevel(score)));
        String urlPrefix = this.nbchatTrainConfigProperties.getDegreeTaskUrlPrefix();
        urlPrefix = urlPrefix.replace("{TASKID}", taskDegree.getTaskId()).replace("{USERID}", taskDegree.getUserId());
        String qrImgPath = QRCodeGenerator.generateQRCodeImage(urlPrefix);
        ArrayList<ImageInfo> imageInfos = new ArrayList<ImageInfo>();
        imageInfos.add(ImageBuilder.avatar((String)userInfo.getString("avatar")));
        imageInfos.add(ImageBuilder.qrCode((String)qrImgPath));
        localDate = taskDegree.getValidityPeriod() >= 99 ? localDate.withYear(2099).withMonth(1).withDayOfYear(1) : localDate.plusMonths(taskDegree.getValidityPeriod().intValue());
        String issueDate = localDate.getYear() + "\u5e74" + localDate.getMonthValue() + "\u6708" + localDate.getDayOfMonth() + "\u65e5";
        String imgPath = new ImageProcessor().texts(texts).textInfos(textInfos).imageInfos(imageInfos).issueDate(issueDate).title(taskDegree.getDegreeName()).build();
        log.info("\u751f\u6210\u56fe\u7247\u6210\u529f\uff0c\u56fe\u7247\u8def\u5f84\uff1a{}", (Object)imgPath);
        return imgPath;
    }

    public static String getScoreLevel(Integer score) {
        if (score >= 90) {
            return "\u4f18\u79c0";
        }
        if (score >= 70) {
            return "\u826f\u597d";
        }
        if (score >= 60) {
            return "\u5408\u683c";
        }
        return "\u4e0d\u5408\u683c";
    }

    public static boolean isAnyEmpty(JSONObject userInfo) {
        return StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{userInfo.getString("user_reality_name"), userInfo.getString("gender"), userInfo.getString("birthday"), userInfo.getString("id_card"), userInfo.getString("avatar")});
    }
}

