/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.event;

import com.alibaba.fastjson.JSON;
import com.tydic.nbchat.train.api.bo.task.NbchatTaskRecordBO;
import com.tydic.nbchat.train.api.bo.train.scene.NbchatTrainTaskBO;
import com.tydic.nbchat.train.api.bo.train.scene.NbchatTrainTaskDegreeBO;
import com.tydic.nbchat.train.api.trainTask.CreateDegreeApi;
import com.tydic.nbchat.train.api.trainTask.TrainTaskApi;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DetectUserDegreeService {
    private static final Logger log = LoggerFactory.getLogger(DetectUserDegreeService.class);
    private final TrainTaskApi trainTaskApi;
    private final CreateDegreeApi createDegreeApi;

    public DetectUserDegreeService(TrainTaskApi trainTaskApi, CreateDegreeApi createDegreeApi) {
        this.trainTaskApi = trainTaskApi;
        this.createDegreeApi = createDegreeApi;
    }

    public void handle(NbchatTrainTaskBO request) {
        log.info("\u68c0\u6d4b\u7528\u6237\u8bc1\u4e66\uff1a{}", (Object)JSON.toJSONString((Object)request));
        request.setIsDegree(EntityValidType.NORMAL.getCode());
        RspList rspList = this.trainTaskApi.queryTask(request);
        if (!rspList.isSuccess() || rspList.getRows().isEmpty()) {
            log.info("\u68c0\u6d4b\u7528\u6237\u8bc1\u4e66-\u672a\u67e5\u8be2\u5230\u6b64\u7528\u6237\u7684\u4efb\u52a1\u5217\u8868\uff1a{}|{}", (Object)request.getTenantCode(), (Object)request.getUserId());
            return;
        }
        List rows = rspList.getRows();
        for (NbchatTaskRecordBO row : rows) {
            if (!"2".equals(row.getStatus())) continue;
            log.info("\u68c0\u6d4b\u7528\u6237\u8bc1\u4e66-\u7528\u6237[{}]\u7684\u4efb\u52a1[{}|{}]\u5df2\u5b8c\u6210", new Object[]{request.getUserId(), row.getTaskId(), row.getTaskName()});
            NbchatTrainTaskDegreeBO bo = new NbchatTrainTaskDegreeBO();
            bo.setTaskId(String.valueOf(row.getTaskId()));
            bo.setTenantCode(request.getTenantCode());
            bo.setUserId(request.getUserId());
            Rsp rsp = this.createDegreeApi.create(bo);
            log.info("\u68c0\u6d4b\u7528\u6237\u8bc1\u4e66-\u53d1\u653e\u8bc1\u4e66\u7ed3\u679c\uff1a{}", (Object)rsp);
        }
    }
}

