/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.event;

import com.tydic.nbchat.train.core.service.impl.event.ModifyTaskEvent;
import com.tydic.nbchat.train.core.service.impl.event.UserCompleteTaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class EventPublishFactory {
    private static final Logger log = LoggerFactory.getLogger(EventPublishFactory.class);
    private static ApplicationEventPublisher applicationEventPublisher;

    public EventPublishFactory(ApplicationEventPublisher applicationEventPublisher) {
        EventPublishFactory.applicationEventPublisher = applicationEventPublisher;
    }

    public static void publish(Object event) {
        applicationEventPublisher.publishEvent(event);
    }

    public static void publishUserCompleteTaskEvent(String tenantCode, String userId) {
        Object source = new Object();
        UserCompleteTaskEvent<Object> event = new UserCompleteTaskEvent<Object>(source, tenantCode, userId);
        log.info("\u53d1\u9001\u8bc1\u4e66\u5b8c\u6210\u4e8b\u4ef6\uff1a{}|{}", (Object)tenantCode, (Object)userId);
        applicationEventPublisher.publishEvent(event);
    }

    public static void publishModifyTaskEvent(String tenantCode, String taskId) {
        Object source = new Object();
        ModifyTaskEvent<Object> event = new ModifyTaskEvent<Object>(source, tenantCode, taskId);
        log.info("\u53d1\u9001\u4efb\u52a1\u53d8\u66f4\u4e8b\u4ef6\uff1a{}|{}", (Object)tenantCode, (Object)taskId);
        applicationEventPublisher.publishEvent(event);
    }
}

