/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.event.listener;

import com.alibaba.fastjson.JSON;
import com.tydic.nbchat.train.api.bo.train.scene.NbchatTrainTaskBO;
import com.tydic.nbchat.train.core.service.impl.event.DetectUserDegreeService;
import com.tydic.nbchat.train.core.service.impl.event.ModifyTaskEvent;
import com.tydic.nbchat.train.core.service.impl.trainTask.QueryUserService;
import com.tydic.nbchat.train.mapper.NbchatTrainTaskMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainTask;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ModifyTaskListener
implements ApplicationListener<ModifyTaskEvent> {
    private static final Logger log = LoggerFactory.getLogger(ModifyTaskListener.class);
    @Resource
    NbchatTrainTaskMapper nbchatTrainTaskMapper;
    private final DetectUserDegreeService detectUserDegreeService;
    private final QueryUserService queryUserService;

    public ModifyTaskListener(DetectUserDegreeService detectUserDegreeService, QueryUserService queryUserService) {
        this.detectUserDegreeService = detectUserDegreeService;
        this.queryUserService = queryUserService;
    }

    @Async
    public void onApplicationEvent(ModifyTaskEvent event) {
        log.info("\u76d1\u542c\u5230\u3010\u4efb\u52a1\u4fee\u6539\u4e8b\u4ef6\u3011\uff1a{}", (Object)JSON.toJSONString((Object)((Object)event)));
        Integer taskId = Integer.valueOf(event.getTaskId());
        NbchatTrainTask trainTask = this.nbchatTrainTaskMapper.queryTask(taskId);
        List<String> userIds = this.queryUserService.getDeptPostUsers(taskId, trainTask.getSupportSubDept(), trainTask.getPostId(), trainTask.getTenantCode());
        if (CollectionUtils.isEmpty(userIds)) {
            userIds = this.queryUserService.getUsers(taskId);
        }
        long start = System.currentTimeMillis();
        for (String userId : userIds) {
            NbchatTrainTaskBO request = new NbchatTrainTaskBO();
            request.setTenantCode(event.getTenantCode());
            request.setUserId(userId);
            request.setId(Integer.valueOf(event.getTaskId()));
            this.detectUserDegreeService.handle(request);
        }
        log.info("\u76d1\u542c\u5230\u3010\u4efb\u52a1\u4fee\u6539\u4e8b\u4ef6\u3011-\u5904\u7406\u8017\u65f6\uff1a{}/ms", (Object)(System.currentTimeMillis() - start));
    }
}

