/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.event.listener;

import com.alibaba.fastjson.JSON;
import com.tydic.nbchat.train.api.bo.train.scene.NbchatTrainTaskBO;
import com.tydic.nbchat.train.core.service.impl.event.DetectUserDegreeService;
import com.tydic.nbchat.train.core.service.impl.event.UserCompleteTaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class UserCompleteTaskListener
implements ApplicationListener<UserCompleteTaskEvent> {
    private static final Logger log = LoggerFactory.getLogger(UserCompleteTaskListener.class);
    private final DetectUserDegreeService detectUserDegreeService;

    public UserCompleteTaskListener(DetectUserDegreeService detectUserDegreeService) {
        this.detectUserDegreeService = detectUserDegreeService;
    }

    @Async
    public void onApplicationEvent(UserCompleteTaskEvent event) {
        log.info("\u76d1\u542c\u5230\u3010\u8bc1\u4e66\u89e6\u70b9\u4e8b\u4ef6\u3011-\uff1a{}", (Object)JSON.toJSONString((Object)((Object)event)));
        NbchatTrainTaskBO request = new NbchatTrainTaskBO();
        request.setTenantCode(event.getTenantCode());
        request.setUserId(event.getUserId());
        request.setStartStatus("1");
        long start = System.currentTimeMillis();
        this.detectUserDegreeService.handle(request);
        log.info("\u3010\u8bc1\u4e66\u89e6\u70b9\u4e8b\u4ef6\u3011-\u5904\u7406\u8017\u65f6\uff1a{}/ms", (Object)(System.currentTimeMillis() - start));
    }
}

