/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.train.api.NbcahtExamQuestionApi;
import com.tydic.nbchat.train.api.bo.QuestionSaveRequest;
import com.tydic.nbchat.train.api.bo.eums.QuestionType;
import com.tydic.nbchat.train.api.bo.question.Question;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExamReadListener
implements ReadListener {
    private static final Logger log = LoggerFactory.getLogger(ExamReadListener.class);
    private final NbcahtExamQuestionApi nbcahtExamQuestionApi;
    private final String courseId;
    private final String tenantCode;

    public ExamReadListener(NbcahtExamQuestionApi nbcahtExamQuestionApi, String courseId, String tenantCode) {
        this.nbcahtExamQuestionApi = nbcahtExamQuestionApi;
        this.courseId = courseId;
        this.tenantCode = tenantCode;
    }

    public void invokeHead(Map headMap, AnalysisContext context) {
        super.invokeHead(headMap, context);
        log.info("\u89e3\u6790\u5230\u4e00\u6761\u5934\u6570\u636e:{}|{}", (Object)headMap.size(), (Object)JSONObject.toJSONString((Object)headMap));
    }

    public void invoke(Object o, AnalysisContext analysisContext) {
        LinkedHashMap map = (LinkedHashMap)o;
        log.info("\u89e3\u6790\u5230\u4e00\u6761\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)map));
        this.checkExcelFormat(map);
        QuestionSaveRequest question1 = QuestionSaveRequest.builder().courseId(this.courseId).tenantCode(this.tenantCode).questionType(QuestionType.getCodeByName((String)((String)map.get(0)))).build();
        Question question2 = Question.builder().question((String)map.get(1)).difficulty((String)map.get(2)).explan((String)map.get(3)).build();
        List items = map.values().stream().skip(6L).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        String[] split = ((String)map.get(5)).toUpperCase().split(",");
        ArrayList<Integer> answers = new ArrayList<Integer>();
        for (String s : split) {
            answers.add(s.charAt(0) - 65);
        }
        this.nbcahtExamQuestionApi.consumerQuestion(question1, question2, items, answers);
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
        log.info("\u89e3\u6790\u7ed3\u675f");
    }

    public void checkExcelFormat(LinkedHashMap<Integer, String> map) {
        if (ObjectUtils.isEmpty(map) || map.size() < 7) {
            log.warn("\u9898\u76ee\u6570\u636e\u4e0d\u5b8c\u6574:{}", map);
            throw new RuntimeException("\u9898\u76ee\u6570\u636e\u4e0d\u5b8c\u6574");
        }
        if (StringUtils.isEmpty((CharSequence)map.get(5))) {
            log.warn("\u9898\u76ee\u6b63\u786e\u7b54\u6848\u4e3a\u7a7a:{}", map);
            throw new RuntimeException("\u9898\u76ee\u6b63\u786e\u7b54\u6848\u4e3a\u7a7a");
        }
    }
}

