/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.order;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.tydic.nbchat.admin.api.SysTenantManagementApi;
import com.tydic.nbchat.admin.api.bo.SysTenantManagementReqBO;
import com.tydic.nbchat.admin.api.bo.eum.OrderStatusEnum;
import com.tydic.nbchat.train.api.CustomizeOrderApi;
import com.tydic.nbchat.train.api.bo.eums.CustomizePayType;
import com.tydic.nbchat.train.api.bo.eums.CustomizeStatusEnum;
import com.tydic.nbchat.train.api.bo.eums.VipFlagType;
import com.tydic.nbchat.train.api.bo.tdh.TdhCustomizeRecordModifyStatusReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhCustomizeRecordQueryReqBO;
import com.tydic.nbchat.train.api.tdh.TdhCustomizeRecordOperationsApi;
import com.tydic.nbchat.train.core.busi.TdhAnchorBusiService;
import com.tydic.nbchat.train.core.busi.TdhHumanBusiService;
import com.tydic.nbchat.train.mapper.NameMapper;
import com.tydic.nbchat.train.mapper.SysUserGrayRelMapper;
import com.tydic.nbchat.train.mapper.TdhCustomizeRecordMapper;
import com.tydic.nbchat.train.mapper.po.TdhCustomizeRecord;
import com.tydic.nbchat.train.mapper.po.TdhVirtualAnchor;
import com.tydic.nbchat.train.mapper.po.TdhVirtualHuman;
import com.tydic.nbchat.user.api.NoticeApi;
import com.tydic.nbchat.user.api.UserVipApi;
import com.tydic.nbchat.user.api.UserVipRightsApi;
import com.tydic.nbchat.user.api.bo.eums.CustomizeTypeEnum;
import com.tydic.nbchat.user.api.bo.eums.UserVipType;
import com.tydic.nbchat.user.api.bo.notice.NoticeBO;
import com.tydic.nbchat.user.api.bo.vip.NbchatUserVipRightsBO;
import com.tydic.nbchat.user.api.bo.vip.UserVipBO;
import com.tydic.nbchat.user.api.bo.vip.UserVipQueryReqBO;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomizeOrderServiceImpl
implements CustomizeOrderApi {
    private static final Logger log = LoggerFactory.getLogger(CustomizeOrderServiceImpl.class);
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=3000)
    private UserVipRightsApi userVipRightsApi;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=100000)
    private NoticeApi noticeApi;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=100000)
    private UserVipApi userVipApi;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=100000)
    private SysTenantManagementApi sysTenantManagementApi;
    @Resource
    private NameMapper nameMapper;
    @Resource
    private TdhCustomizeRecordMapper tdhCustomizeRecordMapper;
    @Resource
    private SysUserGrayRelMapper sysUserGrayRelMapper;
    private final TdhHumanBusiService tdhHumanBusiService;
    private final TdhAnchorBusiService tdhAnchorBusiService;
    private final TdhCustomizeRecordOperationsApi tdhCustomizeRecordOperationsApi;

    public CustomizeOrderServiceImpl(TdhCustomizeRecordOperationsApi tdhCustomizeRecordOperationsApi, TdhHumanBusiService tdhHumanBusiService, TdhAnchorBusiService tdhAnchorBusiService) {
        this.tdhCustomizeRecordOperationsApi = tdhCustomizeRecordOperationsApi;
        this.tdhHumanBusiService = tdhHumanBusiService;
        this.tdhAnchorBusiService = tdhAnchorBusiService;
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp createOrder(TdhCustomizeRecordQueryReqBO request) {
        log.info("\u521b\u5efa\u8ba2\u5355:{}", (Object)request);
        this.setVipInfo(request);
        Integer salePrice = this.getPayPrice(request);
        this.buildCustomRecord(request, salePrice);
        this.saveCustomizeRecord(request);
        return BaseRspUtils.createSuccessRsp((Object)request.getOrderNo());
    }

    private void setVipInfo(TdhCustomizeRecordQueryReqBO request) {
        UserVipQueryReqBO req = new UserVipQueryReqBO();
        req.setTenantCode(request.getTenantCode());
        req.set_userId(request.getUserId());
        Rsp userVip = this.userVipApi.getUserVip(req);
        if (userVip.isSuccess()) {
            if (userVip.getData() == null) {
                request.setVipType(VipFlagType.COMMON_USER.getCode());
                request.setVipTypeSub(VipFlagType.COMMON_USER.getCode());
            } else {
                request.setVipType(((UserVipBO)userVip.getData()).getVipType());
                request.setVipTypeSub(((UserVipBO)userVip.getData()).getVipVersion());
                request.setVipFlag(((UserVipBO)userVip.getData()).getVipType());
            }
        }
    }

    public Integer getPayPrice(TdhCustomizeRecordQueryReqBO request) {
        SysTenantManagementReqBO reqBO;
        Rsp rsp;
        if (ObjectUtils.isNotEmpty((Object)request.getOrderPrice())) {
            return request.getOrderPrice();
        }
        if (!"00000000".equals(request.getTenantCode()) && (rsp = this.sysTenantManagementApi.queryCustomConfig(reqBO = SysTenantManagementReqBO.builder().targetTenantCode(request.getTenantCode()).build())).isSuccess()) {
            Integer price;
            JSONObject data = (JSONObject)rsp.getData();
            String customizeType = request.getCustomizeType();
            if (CustomizeTypeEnum._25DMTK2.equalsCode(customizeType)) {
                customizeType = CustomizeTypeEnum._25DMTK.getCode();
            }
            if (CustomizeTypeEnum._AUDIO2.equalsCode(customizeType)) {
                customizeType = CustomizeTypeEnum._AUDIO.getCode();
            }
            if (ObjectUtils.isNotEmpty((Object)(price = data.getJSONObject("custom").getJSONObject(customizeType).getInteger("price")))) {
                return price;
            }
        }
        return this.nameMapper.querySalePrice(request.getSkuId());
    }

    public void buildCustomRecord(TdhCustomizeRecordQueryReqBO request, Integer salePrice) {
        request.setOrderPrice(salePrice);
        request.setTdhName(StringUtils.left((String)request.getTdhName(), (int)10));
        request.setVoiceName(StringUtils.left((String)request.getVoiceName(), (int)10));
        request.setOrderNo(IdWorker.nextAutoIdStr());
        this.handleGrayTypeSwitch(request);
        if (request.getCustomizeType().startsWith(CustomizeTypeEnum._AUDIO.getCode())) {
            this.createAnchorIfNeeded(request);
        } else {
            this.createHumanIfNeeded(request);
        }
    }

    private void handleGrayTypeSwitch(TdhCustomizeRecordQueryReqBO request) {
        if (CustomizeTypeEnum._AUDIO.equalsCode(request.getCustomizeType())) {
            if (this.isGrayUserOrTenant(request, CustomizeTypeEnum._AUDIO2.getCode())) {
                request.setCustomizeType(CustomizeTypeEnum._AUDIO2.getCode());
            }
        } else if (CustomizeTypeEnum._25DMTK.equalsCode(request.getCustomizeType()) && this.isGrayUserOrTenant(request, CustomizeTypeEnum._25DMTK2.getCode())) {
            request.setCustomizeType(CustomizeTypeEnum._25DMTK2.getCode());
        }
    }

    private boolean isGrayUserOrTenant(TdhCustomizeRecordQueryReqBO request, String grayTypeCode) {
        return this.sysUserGrayRelMapper.exists(request.getUserId(), request.getTenantCode(), grayTypeCode) > 0;
    }

    private void createAnchorIfNeeded(TdhCustomizeRecordQueryReqBO request) {
        TdhVirtualAnchor anchor = this.tdhAnchorBusiService.addAnchor(request);
        request.setVolcId(anchor.getVoice());
    }

    private void createHumanIfNeeded(TdhCustomizeRecordQueryReqBO request) {
        String type = request.getCustomizeType();
        TdhVirtualHuman human = this.tdhHumanBusiService.createHuman(request, CustomizeTypeEnum.convertType((String)type));
        request.setTdhId(human.getTdhId());
    }

    public void saveCustomizeRecord(TdhCustomizeRecordQueryReqBO request) {
        TdhCustomizeRecord po = new TdhCustomizeRecord();
        BeanUtils.copyProperties((Object)request, (Object)po);
        po.setCustomizeParamsString(JSON.toJSONString((Object)request.getCustomizeParams()));
        po.setOrderStatus(OrderStatusEnum.UNPAID.getCode());
        po.setCustomizeStatus(CustomizeStatusEnum.ORDER_CREATE.getCode());
        po.setUpdateUser(request.getUserId());
        po.setType(CustomizeTypeEnum.getType((String)request.getCustomizeType()));
        this.tdhCustomizeRecordMapper.insertSelective(po);
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp updateRights(NbchatUserVipRightsBO request) {
        log.info("\u66f4\u65b0\u7528\u6237VIP\u6570\u5b57\u4eba\u6743\u76ca:{}", (Object)request);
        if (StringUtils.isEmpty((CharSequence)request.getRightsType())) {
            return BaseRspUtils.createErrorRsp((String)"\u6743\u76ca\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Rsp rsp = this.userVipRightsApi.deductRights(request);
        if (!rsp.isSuccess()) {
            log.error("\u66f4\u65b0\u7528\u6237VIP\u6743\u76ca\u5931\u8d25:{}", (Object)request);
            return BaseRspUtils.createErrorRsp((String)"\u8ba2\u5355\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
        }
        request.setStartTime(new Date());
        if (StringUtils.isNotEmpty((CharSequence)request.getExCode())) {
            int skuNum = this.nameMapper.querySkuNum(request.getExCode());
            request.setEndTime(DateTimeUtil.DateAddDayOfYear((int)skuNum));
            this.nameMapper.statusToUsed(request.getExCode());
            request.setPayType(CustomizePayType.GIFT.getCode());
        } else {
            request.setEndTime(DateTimeUtil.DateAddYear((int)1));
        }
        this.handle(request);
        return BaseRspUtils.createSuccessRsp((Object)"\u66f4\u65b0\u7528\u6237VIP\u6743\u76ca\u6210\u529f");
    }

    public Rsp freeCustomize(NbchatUserVipRightsBO request) {
        log.info("\u514d\u8d39\u5b9a\u5236:{}", (Object)request);
        if (!request.getIsFreeExperience().booleanValue()) {
            UserVipQueryReqBO req = new UserVipQueryReqBO();
            req.setTenantCode(request.getTenantCode());
            req.set_userId(request.getUserId());
            Rsp userVip = this.userVipApi.getUserVip(req);
            if (!userVip.isSuccess() || userVip.getData() == null || !this.vipHasRights(((UserVipBO)userVip.getData()).getVipType())) {
                return BaseRspUtils.createErrorRsp((String)"\u7528\u6237\u4e0d\u662f\u4e13\u4e1a\u3001Max\u4f1a\u5458\uff0c\u4e0d\u4eab\u6709\u8be5\u6743\u76ca");
            }
            request.setStartTime(new Date());
            request.setEndTime(((UserVipBO)userVip.getData()).getVipEnd());
            request.setVipFlag(VipFlagType.PROFESSIONAL_VIP.getCode());
            JSONObject extInfo = new JSONObject();
            extInfo.put("vipFlag", (Object)VipFlagType.PROFESSIONAL_VIP.getCode());
            request.setExtInfo(extInfo.toString());
            request.setPayType(CustomizePayType.PROFESS.getCode());
        }
        this.handle(request);
        return BaseRspUtils.createSuccessRsp((Object)"\u514d\u8d39\u5b9a\u5236\u6210\u529f");
    }

    public boolean vipHasRights(String vipType) {
        return UserVipType.PROFESSIONAL.getCode().equals(vipType) || UserVipType.PROFESSIONAL_MAX.getCode().equals(vipType);
    }

    private void handle(NbchatUserVipRightsBO request) {
        TdhCustomizeRecord po = new TdhCustomizeRecord();
        po.setOrderNo(request.getOrderNo());
        po.setOrderStatus(OrderStatusEnum.PAY_SUCCESS.getCode());
        po.setCustomizeStatus(CustomizeStatusEnum.CUSTOMIZE_COMPLETED.getCode());
        po.setStartTime(request.getStartTime());
        po.setEndTime(request.getEndTime());
        po.setExtInfo(request.getExtInfo());
        po.setPayType(request.getPayType());
        this.tdhCustomizeRecordMapper.updateOrderStatus(po);
        TdhCustomizeRecordModifyStatusReqBO bo = new TdhCustomizeRecordModifyStatusReqBO();
        bo.setOrderNo(request.getOrderNo());
        bo.setVipFlag(request.getVipFlag());
        bo.setCustomizeStatus(CustomizeStatusEnum.CUSTOMIZE_COMPLETED.getCode());
        String codeByType = CustomizeTypeEnum.getCodeByType((String)request.getCustomizeType());
        bo.setCustomizeType(codeByType);
        this.tdhCustomizeRecordOperationsApi.modifyStatus(bo);
        NoticeBO notice = new NoticeBO();
        notice.setUserId(request.getUserId());
        notice.setTenantCode(request.getTenantCode());
        notice.setType(NoticeBO.Type.TDH);
        notice.setAction(NoticeBO.Action.CUSTOM);
        notice.setOrderId(request.getOrderNo());
    }
}

