/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.outer;

import com.tydic.nbchat.train.api.OuterCreationResourceApi;
import com.tydic.nbchat.train.api.bo.eums.OuterResourceBizCode;
import com.tydic.nbchat.train.api.outer.OuterResourceBO;
import com.tydic.nbchat.train.api.outer.OuterResourceQueryReqBO;
import com.tydic.nbchat.train.api.outer.OuterResourceSaveReqBO;
import com.tydic.nbchat.train.api.outer.TdhCreationTaskBO;
import com.tydic.nbchat.train.core.busi.TdhCreationBusiService;
import com.tydic.nbchat.train.mapper.PptExamOuterSourceMapper;
import com.tydic.nbchat.train.mapper.po.PptExamOuterSourceWithBLOBs;
import com.tydic.nbchat.train.mapper.po.TdhCreationRecord;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class OuterCreationResourceServiceImpl
implements OuterCreationResourceApi {
    private static final Logger log = LoggerFactory.getLogger(OuterCreationResourceServiceImpl.class);
    @Resource
    private PptExamOuterSourceMapper pptExamOuterSourceMapper;
    private final TdhCreationBusiService tdhCreationBusiService;

    public OuterCreationResourceServiceImpl(TdhCreationBusiService tdhCreationBusiService) {
        this.tdhCreationBusiService = tdhCreationBusiService;
    }

    @MethodParamVerifyEnable
    public Rsp<String> saveResource(OuterResourceSaveReqBO request) {
        if (StringUtils.isBlank((CharSequence)request.getRequestId())) {
            String requestId = IdWorker.nextAutoIdStr();
            request.setRequestId(requestId);
            log.info("\u521b\u4f5c\u8d44\u6e90\u540c\u6b65-\u4fdd\u5b58:{}", (Object)request);
            PptExamOuterSourceWithBLOBs record = new PptExamOuterSourceWithBLOBs();
            record.setRequestId(request.getRequestId());
            record.setTenantCode(request.getTenantCode());
            record.setUserId(request.getUserId());
            record.setSourceUrl(request.getSourceUrl());
            record.setSourceContent(request.getSourceContent());
            record.setCreateTime(new Date());
            this.pptExamOuterSourceMapper.insertSelective(record);
            return BaseRspUtils.createSuccessRsp((Object)requestId);
        }
        log.info("\u521b\u4f5c\u8d44\u6e90\u540c\u6b65-\u66f4\u65b0:{}", (Object)request);
        PptExamOuterSourceWithBLOBs record = new PptExamOuterSourceWithBLOBs();
        record.setRequestId(request.getRequestId());
        record.setResultUrl(request.getResultUrl());
        record.setResultContent(request.getResultContent());
        record.setUpdateTime(new Date());
        record.setBizId(request.getBizId());
        record.setBizCode(request.getBizCode());
        record.setStatus("2");
        int i = this.pptExamOuterSourceMapper.updateByPrimaryKeySelective(record);
        if (i > 0) {
            return BaseRspUtils.createSuccessRsp((Object)request.getRequestId());
        }
        return BaseRspUtils.createErrorRsp((String)"\u8d44\u6e90\u66f4\u65b0\u5931\u8d25");
    }

    public Rsp<OuterResourceBO> getResource(OuterResourceQueryReqBO request) {
        PptExamOuterSourceWithBLOBs source = this.pptExamOuterSourceMapper.selectByPrimaryKey(request.getRequestId());
        OuterResourceBO outerResourceBO = new OuterResourceBO();
        if (source != null) {
            BeanUtils.copyProperties((Object)source, (Object)outerResourceBO);
            String creationId = source.getBizId();
            if (OuterResourceBizCode.tdh_creation.getCode().equals(source.getBizCode())) {
                TdhCreationRecord record;
                TdhCreationTaskBO taskBO = this.tdhCreationBusiService.getTdhTask(source.getBizId());
                outerResourceBO.setTdhTaskResult(taskBO);
                if (StringUtils.isNotBlank((CharSequence)taskBO.getPlayUrl())) {
                    outerResourceBO.setResultContent(taskBO.getCreationName());
                    outerResourceBO.setResultUrl(taskBO.getPlayUrl());
                }
                if (StringUtils.isNotBlank((CharSequence)taskBO.getTaskId())) {
                    creationId = taskBO.getCreationId();
                }
                if ((record = this.tdhCreationBusiService.getTdhRecord(creationId)) != null) {
                    outerResourceBO.setLastTime(record.getUpdateTime());
                    outerResourceBO.setThumbUrl(record.getPreviewUrl());
                }
            }
            return BaseRspUtils.createSuccessRsp((Object)outerResourceBO);
        }
        return BaseRspUtils.createErrorRsp((String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
    }
}

