/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.ppt;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.admin.api.SysUserStarApi;
import com.tydic.nbchat.admin.api.bo.eum.StarType;
import com.tydic.nbchat.admin.api.bo.file.FileUploadRequest;
import com.tydic.nbchat.admin.api.fileMannager.FileManageService;
import com.tydic.nbchat.admin.api.star.UserStarRequest;
import com.tydic.nbchat.train.api.bo.eums.PPTSortType;
import com.tydic.nbchat.train.api.bo.eums.StateEnum;
import com.tydic.nbchat.train.api.bo.eums.TemplateSourceType;
import com.tydic.nbchat.train.api.bo.eums.VipFlagType;
import com.tydic.nbchat.train.api.bo.ppt.ImageConversionReqBO;
import com.tydic.nbchat.train.api.bo.ppt.ImageConversionRspBO;
import com.tydic.nbchat.train.api.bo.ppt.PPTCounterQueryReqBO;
import com.tydic.nbchat.train.api.bo.ppt.PPTCreationRecordBO;
import com.tydic.nbchat.train.api.bo.ppt.PPTLayoutBO;
import com.tydic.nbchat.train.api.bo.ppt.PPTLayoutWrapper;
import com.tydic.nbchat.train.api.bo.ppt.PPTSortReqBO;
import com.tydic.nbchat.train.api.bo.ppt.PPTThemeBO;
import com.tydic.nbchat.train.api.bo.ppt.PPTThemeMatchReqBO;
import com.tydic.nbchat.train.api.bo.ppt.PPTThemeReqBO;
import com.tydic.nbchat.train.api.bo.ppt.PPTThemeRspBO;
import com.tydic.nbchat.train.api.ppt.PPTApi;
import com.tydic.nbchat.train.core.busi.PptCounterBusiService;
import com.tydic.nbchat.train.core.service.impl.tdh.TdhAnalysisService;
import com.tydic.nbchat.train.core.util.PptThemeMatcherProcessor;
import com.tydic.nbchat.train.mapper.PptCreationRecordMapper;
import com.tydic.nbchat.train.mapper.PptLayoutMapper;
import com.tydic.nbchat.train.mapper.PptThemeMapper;
import com.tydic.nbchat.train.mapper.RpPptUsageMapper;
import com.tydic.nbchat.train.mapper.TdhTemplateMapper;
import com.tydic.nbchat.train.mapper.po.PptCreationRecord;
import com.tydic.nbchat.train.mapper.po.PptLayout;
import com.tydic.nbchat.train.mapper.po.PptLayoutSelectCondition;
import com.tydic.nbchat.train.mapper.po.PptTheme;
import com.tydic.nbchat.train.mapper.po.RpPptUsage;
import com.tydic.nbchat.train.mapper.po.TdhTemplate;
import com.tydic.nicc.common.bo.file.FileManageSaveBO;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.common.nbchat.msg.SendMessageContext;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.mq.starter.api.KKMqProducerHelper;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PPTServiceImpl
implements PPTApi {
    private static final Logger log = LoggerFactory.getLogger(PPTServiceImpl.class);
    @Resource
    PptCreationRecordMapper pptCreationRecordMapper;
    @Resource
    PptLayoutMapper pptLayoutMapper;
    @Resource
    PptThemeMapper pptThemeMapper;
    @Resource
    private TdhTemplateMapper tdhTemplateMapper;
    @Resource
    private RpPptUsageMapper rpPptUsageMapper;
    @Resource
    private KKMqProducerHelper kkMqProducerHelper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=100000)
    private SysUserStarApi sysUserStarApi;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
    private FileManageService fileManageService;
    private final TdhAnalysisService tdhAnalysisService;
    private final PptCounterBusiService pptCounterBusiService;

    public PPTServiceImpl(TdhAnalysisService tdhAnalysisService, PptCounterBusiService pptCounterBusiService) {
        this.tdhAnalysisService = tdhAnalysisService;
        this.pptCounterBusiService = pptCounterBusiService;
    }

    public Rsp save(PPTCreationRecordBO request) {
        PptCreationRecord po = new PptCreationRecord();
        BeanUtils.copyProperties((Object)request, (Object)po);
        if (StringUtils.isEmpty((CharSequence)po.getPptId())) {
            int i;
            po.setPptId(IdWorker.nextAutoIdStr());
            po.setCreateTime(new Date());
            po.setUpdateTime(new Date());
            if (StringUtils.isEmpty((CharSequence)request.getLayout())) {
                po.setLayout("{}");
            }
            if ((i = this.pptCreationRecordMapper.insertSelective(po)) > 0 && (request.getStatus() == null || 2 != request.getStatus())) {
                this.pptCounterBusiService.incrementPptCounter(po.getTenantCode(), po.getUserId(), po.getPptType());
            }
            try {
                SendMessageContext context = SendMessageContext.buildForPptFinish((String)po.getTenantCode(), (String)po.getUserId(), (String)po.getPptId(), (String)po.getCreationName());
                log.info("\u53d1\u9001\u7ad9\u5185\u4fe1\u901a\u77e5\u4e8b\u4ef6\u6d88\u606f: {}", (Object)context);
                this.kkMqProducerHelper.sendMsg("NBCHAT_SYS_MESSAGE_RECORD_TOPIC", (Object)context);
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u7ad9\u5185\u4fe1\u901a\u77e5\u4e8b\u4ef6\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            }
        } else {
            PptCreationRecord ppt = this.pptCreationRecordMapper.queryById(po.getPptId());
            if (ObjectUtils.isNotEmpty((Object)ppt)) {
                String userId = ppt.getUserId();
                if (request.getUserId().equals(userId)) {
                    po.setUpdateTime(new Date());
                    int n = this.pptCreationRecordMapper.update(po);
                } else {
                    return BaseRspUtils.createErrorRsp((String)"\u975e\u672c\u4eba\u521b\u4f5c\u8bb0\u5f55\uff0c\u65e0\u6743\u9650\u4fee\u6539");
                }
            }
        }
        this.tdhAnalysisService.savePptAnalysis(po.getTenantCode(), po.getUserId(), po.getPptId());
        return BaseRspUtils.createSuccessRsp((Object)po.getPptId());
    }

    public Rsp query(PPTCreationRecordBO request) {
        log.info("\u67e5\u8be2ppt\u5185\u5bb9-\u5f00\u59cb\uff1a{}", (Object)request);
        if (StringUtils.isEmpty((CharSequence)request.getPptId())) {
            return BaseRspUtils.createErrorRsp((String)"pptId\u4e0d\u5f97\u4e3a\u7a7a");
        }
        PptCreationRecord pptRecord = this.pptCreationRecordMapper.queryById(request.getPptId());
        if (ObjectUtils.isEmpty((Object)pptRecord)) {
            return BaseRspUtils.createSuccessRsp((Object)"\u65e0\u6b64ppt\u4fe1\u606f");
        }
        PPTCreationRecordBO rspBO = new PPTCreationRecordBO();
        BeanUtils.copyProperties((Object)pptRecord, (Object)rspBO);
        try {
            RpPptUsage pptUsage = this.rpPptUsageMapper.queryByPptId(request.getPptId());
            if (ObjectUtils.isNotEmpty((Object)pptUsage) && StringUtils.isNotBlank((CharSequence)pptUsage.getUseThemeId())) {
                PptTheme pptTheme = this.pptThemeMapper.queryById(pptUsage.getUseThemeId());
                if (ObjectUtils.isNotEmpty((Object)pptTheme)) {
                    rspBO.setScene(pptTheme.getScene());
                    rspBO.setStyle(pptTheme.getStyle());
                    rspBO.setColor(pptTheme.getColor());
                    log.info("\u67e5\u8be2PPT\u4e3b\u9898\u4fe1\u606f\u6210\u529f\uff1apptId={}, useThemeId={}, scene={}, style={}, color={}", new Object[]{request.getPptId(), pptUsage.getUseThemeId(), pptTheme.getScene(), pptTheme.getStyle(), pptTheme.getColor()});
                } else {
                    log.info("\u672a\u627e\u5230PPT\u4e3b\u9898\u4fe1\u606f\uff1apptId={}, useThemeId={}", (Object)request.getPptId(), (Object)pptUsage.getUseThemeId());
                }
            } else {
                log.info("\u672a\u627e\u5230PPT\u4f7f\u7528\u7edf\u8ba1\u4fe1\u606f\u6216useThemeId\u4e3a\u7a7a\uff1apptId={}", (Object)request.getPptId());
            }
        }
        catch (Exception e) {
            log.warn("\u67e5\u8be2PPT\u4f7f\u7528\u7edf\u8ba1\u4fe1\u606f\u5f02\u5e38\uff1apptId={}, error={}", new Object[]{request.getPptId(), e.getMessage(), e});
        }
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public Rsp layoutQuery(PPTLayoutBO request) {
        log.info("\u5e03\u5c40\u67e5\u8be2-\u5f00\u59cb:{}", (Object)request);
        PptTheme pptTheme = this.pptThemeMapper.queryById(request.getThemeId());
        if (ObjectUtils.isEmpty((Object)pptTheme)) {
            return BaseRspUtils.createSuccessRsp((Object)"\u672a\u67e5\u8be2\u5230\u8be5\u4e3b\u9898");
        }
        PptLayoutSelectCondition cond = new PptLayoutSelectCondition();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        List pptLayouts = this.pptLayoutMapper.selectAll(cond);
        ArrayList res = new ArrayList();
        NiccCommonUtil.copyList((List)pptLayouts, res, PPTLayoutBO.class);
        PPTLayoutWrapper rsp = new PPTLayoutWrapper();
        rsp.setConfig(pptTheme.getConfig());
        rsp.setLayoutList(res);
        return BaseRspUtils.createSuccessRsp((Object)rsp);
    }

    public RspList themeQuery(PPTThemeBO request) {
        log.info("\u4e3b\u9898\u67e5\u8be2-\u5f00\u59cb:{}", (Object)request);
        PptTheme cond = new PptTheme();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        cond.setThemeState(StateEnum.STATE.AVAILABLE.getCode());
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.pptThemeMapper.selectAll(cond);
        if (page.getTotal() > 0L) {
            log.info("\u4e3b\u9898\u67e5\u8be2-\u67e5\u8be2\u5230\u6570\u636e\uff1a{}", (Object)page.getTotal());
            List result = page.getResult();
            ArrayList res = new ArrayList();
            NiccCommonUtil.copyList((List)result, res, PPTThemeBO.class);
            res.forEach(rsp -> rsp.setIsStar(this.isStar(request, rsp.getThemeId())));
            return BaseRspUtils.createSuccessRspList(res, (long)page.getTotal());
        }
        log.info("\u4e3b\u9898\u67e5\u8be2-\u672a\u67e5\u8be2\u5230\u6570\u636e");
        return BaseRspUtils.createSuccessRspList(new ArrayList(), (long)0L);
    }

    public RspList themeAdminList(PPTThemeBO request) {
        log.info("\u4e3b\u9898\u67e5\u8be2-\u5f00\u59cb:{}", (Object)request);
        PptTheme cond = new PptTheme();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        cond.setTenantCode(null);
        cond.setTargetTenant(request.getTargetTenant());
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.pptThemeMapper.selectAll(cond);
        if (page.getTotal() > 0L) {
            log.info("\u4e3b\u9898\u67e5\u8be2-\u67e5\u8be2\u5230\u6570\u636e\uff1a{}", (Object)page.getTotal());
            List result = page.getResult();
            ArrayList res = new ArrayList();
            NiccCommonUtil.copyList((List)result, res, PPTThemeBO.class);
            return BaseRspUtils.createSuccessRspList(res, (long)page.getTotal());
        }
        log.info("\u4e3b\u9898\u67e5\u8be2-\u672a\u67e5\u8be2\u5230\u6570\u636e");
        return BaseRspUtils.createSuccessRspList(new ArrayList(), (long)0L);
    }

    public Rsp themeInfo(PPTThemeBO request) {
        log.info("\u4e3b\u9898\u67e5\u8be2-\u5f00\u59cb:{}", (Object)request);
        PptTheme cond = this.pptThemeMapper.queryById(request.getThemeId());
        if (ObjectUtils.isEmpty((Object)cond)) {
            return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u8be5\u4e3b\u9898");
        }
        PPTThemeBO res = new PPTThemeBO();
        BeanUtils.copyProperties((Object)cond, (Object)res);
        return BaseRspUtils.createSuccessRsp((Object)res, (String)"\u67e5\u8be2\u6210\u529f");
    }

    public RspList themeStarList(PPTThemeBO request) {
        log.info("\u4e3b\u9898\u67e5\u8be2-\u5f00\u59cb:{}", (Object)request);
        PptTheme cond = new PptTheme();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        cond.setThemeState(StateEnum.STATE.AVAILABLE.getCode());
        if (StringUtils.isEmpty((CharSequence)cond.getBusiType())) {
            cond.setBusiType("ppt_theme");
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.pptThemeMapper.selectStarThemeByCondition(cond);
        if (page.getTotal() > 0L) {
            log.info("\u4e3b\u9898\u67e5\u8be2-\u67e5\u8be2\u5230\u6570\u636e\uff1a{}", (Object)page.getTotal());
            List result = page.getResult();
            ArrayList res = new ArrayList();
            NiccCommonUtil.copyList((List)result, res, PPTThemeBO.class);
            return BaseRspUtils.createSuccessRspList(res, (long)page.getTotal());
        }
        log.info("\u4e3b\u9898\u67e5\u8be2-\u672a\u67e5\u8be2\u5230\u6570\u636e");
        return BaseRspUtils.createSuccessRspList(new ArrayList(), (long)0L);
    }

    public long getPptCounterDay(PPTCounterQueryReqBO request) {
        return this.pptCounterBusiService.getPptCounter(request.getUserId(), request.getPptType());
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp themeSave(PPTThemeReqBO request) {
        log.debug("\u4fdd\u5b58PPT\u6a21\u677f\uff1a{}", (Object)request);
        String themeId = Optional.ofNullable(request.getThemeInfo().getThemeId()).orElse(IdWorker.nextAutoIdStr());
        ArrayList<String> layoutIdList = new ArrayList<String>();
        PPTThemeBO themeInfo = request.getThemeInfo();
        List layoutBOList = request.getLayoutBOList();
        this.createOrUpdateTheme(themeInfo, themeId, request);
        this.saveOrUpdateLayouts(layoutBOList, themeId, request, layoutIdList);
        this.compared(layoutIdList, themeId);
        log.info("\u6210\u529f\u4fdd\u5b58PPT\u6a21\u677f");
        PPTThemeRspBO response = new PPTThemeRspBO();
        response.setThemId(themeId);
        response.setLayoutId(layoutIdList);
        return BaseRspUtils.createSuccessRsp((Object)response, (String)"\u4fdd\u5b58\u6210\u529f");
    }

    private PptTheme createOrUpdateTheme(PPTThemeBO themeInfo, String themeId, PPTThemeReqBO request) {
        PptTheme pptTheme = new PptTheme();
        BeanUtils.copyProperties((Object)themeInfo, (Object)pptTheme);
        String themeTargetTenant = this.getTargetTenant(themeInfo.getThemeSource(), themeInfo.getTargetTenant(), request.getTenantCode());
        String themeTargetUserId = this.getTargetUserId(themeInfo.getThemeSource(), themeInfo.getTargetTenant(), request.getUserId());
        pptTheme.setUserId(themeTargetUserId);
        pptTheme.setTenantCode(themeTargetTenant);
        pptTheme.setThemeId(themeId);
        pptTheme.setOrderIndex(request.getOrderIndex());
        pptTheme.setIsValid(EntityValidType.NORMAL.getCode());
        pptTheme.setUpdateTime(new Date());
        if (StringUtils.isBlank((CharSequence)themeInfo.getThemeId())) {
            pptTheme.setCreateTime(new Date());
            pptTheme.setVipFlag(Optional.ofNullable(pptTheme.getVipFlag()).orElse(VipFlagType.COMMON_USER.getCode()));
            this.pptThemeMapper.insertSelective(pptTheme);
            log.info("\u4fdd\u5b58ppt \u6a21\u677f-\u65b0\u589e\u4e3b\u9898\u6210\u529f", (Object)pptTheme);
        } else {
            this.pptThemeMapper.update(pptTheme);
            log.info("\u4fdd\u5b58ppt \u6a21\u677f-\u66f4\u65b0\u4e3b\u9898\u6210\u529f", (Object)pptTheme);
        }
        return pptTheme;
    }

    private void saveOrUpdateLayouts(List<PPTLayoutBO> layoutBOList, String themeId, PPTThemeReqBO request, List<String> layoutIdList) {
        if (CollectionUtils.isNotEmpty(layoutBOList)) {
            for (int i = 0; i < layoutBOList.size(); ++i) {
                PPTLayoutBO layoutBO = layoutBOList.get(i);
                String layoutTargetTenant = this.getTargetTenant(request.getThemeInfo().getThemeSource(), request.getThemeInfo().getTargetTenant(), request.getTenantCode());
                String layoutTargetUserId = this.getTargetUserId(request.getThemeInfo().getThemeSource(), request.getThemeInfo().getTargetTenant(), request.getUserId());
                PptLayout pptLayout = new PptLayout();
                BeanUtils.copyProperties((Object)layoutBO, (Object)pptLayout);
                pptLayout.setUserId(layoutTargetUserId);
                pptLayout.setTenantCode(layoutTargetTenant);
                pptLayout.setThemeId(themeId);
                pptLayout.setComposeType(request.getThemeInfo().getComposeType());
                pptLayout.setSort(i);
                pptLayout.setUpdateTime(new Date());
                if (StringUtils.isBlank((CharSequence)layoutBO.getLayoutId())) {
                    pptLayout.setLayoutId(IdWorker.nextAutoIdStr());
                    pptLayout.setCreateTime(new Date());
                    pptLayout.setVipFlag(Optional.ofNullable(pptLayout.getVipFlag()).orElse(VipFlagType.COMMON_USER.getCode()));
                    pptLayout.setIsValid(EntityValidType.NORMAL.getCode());
                    this.pptLayoutMapper.insertSelective(pptLayout);
                    log.info("\u4fdd\u5b58ppt \u6a21\u677f-\u65b0\u589e\u5e03\u5c40\u6210\u529f", (Object)pptLayout.getLayoutName());
                } else {
                    this.pptLayoutMapper.update(pptLayout);
                    log.info("\u4fdd\u5b58ppt \u6a21\u677f-\u66f4\u65b0\u5e03\u5c40\u6210\u529f", (Object)pptLayout.getLayoutName());
                }
                layoutIdList.add(pptLayout.getLayoutId());
            }
        }
    }

    private String getTargetTenant(String sourceType, String targetTenant, String defaultTenant) {
        if (TemplateSourceType.SYSTEM_BUILT_IN.getCode().equals(sourceType)) {
            return StateEnum.SOURCE.PUBLIC.getCode().equals(targetTenant) ? "00000000" : Optional.ofNullable(targetTenant).filter(StringUtils::isNotBlank).orElse(defaultTenant);
        }
        return defaultTenant;
    }

    private String getTargetUserId(String sourceType, String targetTenant, String defaultUserId) {
        if (TemplateSourceType.SYSTEM_BUILT_IN.getCode().equals(sourceType)) {
            return StateEnum.SOURCE.PUBLIC.getCode().equals(targetTenant) ? StateEnum.SOURCE.PUBLIC.getCode() : Optional.ofNullable(targetTenant).filter(StringUtils::isNotBlank).orElse(defaultUserId);
        }
        return defaultUserId;
    }

    public RspList imageConversion(ImageConversionReqBO request) {
        log.info("\u56fe\u7247\u8f6c\u6362-\u5f00\u59cb:{}", (Object)request);
        String tenantCode = request.getTenantCode();
        String userId = request.getUserId();
        ArrayList rspBOList = new ArrayList();
        Optional.ofNullable(request.getImages()).ifPresent(images -> images.forEach(image -> {
            ImageConversionRspBO rspBO = new ImageConversionRspBO();
            String newImage = this.imageDownload((String)image, tenantCode, userId);
            rspBO.setOldImage(image);
            rspBO.setNewImage(newImage);
            rspBOList.add(rspBO);
        }));
        return BaseRspUtils.createSuccessRspList(rspBOList);
    }

    public RspList queryCreateHistory(PPTCreationRecordBO request) {
        log.info("ppt\u521b\u4f5c\u8bb0\u5f55\u67e5\u8be2-\u5f00\u59cb:{}", (Object)request);
        PptCreationRecord record = new PptCreationRecord();
        record.setTenantCode(request.getTenantCode());
        record.setUserId(request.getUserId());
        record.setPptType(request.getPptType());
        record.setPptTypes(request.getPptTypes());
        record.setPptStatus(request.getPptStatus());
        record.setIsValid(EntityValidType.NORMAL.getCode());
        record.setStatusList(request.getStatusList());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{request.getTargetTenant(), request.getTargetUid()})) {
            record.setUserId(request.getTargetUid());
            record.setTenantCode(request.getTargetTenant());
        }
        ArrayList list = new ArrayList();
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.pptCreationRecordMapper.selectAll(record);
        log.info("ppt\u521b\u4f5c\u8bb0\u5f55\u67e5\u8be2-\u67e5\u8be2\u5230\u6570\u636e\uff1a{}", (Object)page.getTotal());
        NiccCommonUtil.copyList((List)page.getResult(), list, PPTCreationRecordBO.class);
        return BaseRspUtils.createSuccessRspList(list, (long)page.getTotal());
    }

    public Rsp releaseTemplate(PPTThemeReqBO request) {
        PptTheme pptTheme = new PptTheme();
        pptTheme.setThemeId(request.getThemeInfo().getThemeId());
        pptTheme.setThemeState(request.getThemeInfo().getThemeState());
        pptTheme.setUpdateTime(new Date());
        pptTheme.setIsValid(request.getThemeInfo().getIsValid());
        this.pptThemeMapper.update(pptTheme);
        PptLayoutSelectCondition pptLayout = new PptLayoutSelectCondition();
        pptLayout.setThemeId(request.getThemeInfo().getThemeId());
        pptLayout.setIsValid(EntityValidType.NORMAL.getCode());
        this.pptLayoutMapper.selectAll(pptLayout).forEach(layout -> {
            layout.setThemeState(request.getThemeInfo().getThemeState());
            layout.setUpdateTime(new Date());
            layout.setIsValid(request.getThemeInfo().getIsValid());
            this.pptLayoutMapper.update(layout);
        });
        return BaseRspUtils.createSuccessRsp((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp copyHistory(PPTCreationRecordBO request) {
        PptCreationRecord pptCreationRecord = this.pptCreationRecordMapper.queryById(request.getPptId());
        if (ObjectUtils.isEmpty((Object)pptCreationRecord)) {
            return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u8be5\u8bb0\u5f55");
        }
        PptCreationRecord newRecord = new PptCreationRecord();
        BeanUtils.copyProperties((Object)pptCreationRecord, (Object)newRecord);
        newRecord.setPptId(IdWorker.nextAutoIdStr());
        newRecord.setUserId(request.getUserId());
        newRecord.setTenantCode(request.getTenantCode());
        newRecord.setCreateTime(new Date());
        newRecord.setUpdateTime(new Date());
        int i = this.pptCreationRecordMapper.insertSelective(newRecord);
        if (i > 0) {
            this.pptCounterBusiService.incrementPptCounter(newRecord.getTenantCode(), newRecord.getUserId(), newRecord.getPptType());
        }
        return BaseRspUtils.createSuccessRsp((Object)newRecord, (String)"\u590d\u5236\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp delete(PPTCreationRecordBO request) {
        PptTheme pptTheme = new PptTheme();
        pptTheme.setThemeId(request.getThemeId());
        pptTheme.setIsValid(EntityValidType.DELETE.getCode());
        int theme = this.pptThemeMapper.update(pptTheme);
        log.info("\u5220\u9664\u4e3b\u9898\u6210\u529f-{}|{}", (Object)theme, (Object)request.getThemeId());
        int layout = this.pptLayoutMapper.updateByThemeId(request.getThemeId());
        log.info("\u5220\u9664\u5e03\u5c40\u6210\u529f-{}|{}", (Object)layout, (Object)request.getThemeId());
        return BaseRspUtils.createSuccessRsp((Object)"\u5220\u9664\u6210\u529f");
    }

    public Rsp copyTheme(PPTCreationRecordBO request) {
        PptTheme pptTheme = this.pptThemeMapper.queryById(request.getThemeId());
        if (ObjectUtils.isEmpty((Object)pptTheme)) {
            return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u8be5\u4e3b\u9898");
        }
        PptTheme newTheme = new PptTheme();
        BeanUtils.copyProperties((Object)pptTheme, (Object)newTheme);
        newTheme.setThemeId(IdWorker.nextAutoIdStr());
        newTheme.setUserId(request.getUserId());
        newTheme.setTenantCode(request.getTenantCode());
        newTheme.setCreateTime(new Date());
        newTheme.setUpdateTime(new Date());
        this.pptThemeMapper.insertSelective(newTheme);
        PptLayoutSelectCondition cond = new PptLayoutSelectCondition();
        cond.setThemeId(request.getThemeId());
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        List pptLayouts = this.pptLayoutMapper.selectAll(cond);
        if (CollectionUtils.isNotEmpty((Collection)pptLayouts)) {
            pptLayouts.forEach(pptLayout -> {
                PptLayout newLayout = new PptLayout();
                BeanUtils.copyProperties((Object)pptLayout, (Object)newLayout);
                newLayout.setLayoutId(IdWorker.nextAutoIdStr());
                newLayout.setThemeId(newTheme.getThemeId());
                newLayout.setCreateTime(new Date());
                newLayout.setUpdateTime(new Date());
                this.pptLayoutMapper.insertSelective(newLayout);
            });
        }
        return BaseRspUtils.createSuccessRsp((Object)newTheme, (String)"\u590d\u5236\u6210\u529f");
    }

    @MethodParamVerifyEnable
    @Transactional(rollbackFor={Exception.class})
    public Rsp sort(PPTSortReqBO request) {
        if (!PPTSortType.isExist((String)request.getSortType()).booleanValue()) {
            return BaseRspUtils.createErrorRsp((String)"\u6392\u5e8f\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        List idList = request.getPptIds();
        if (PPTSortType.PPT_THEME.getCode().equals(request.getSortType())) {
            ArrayList pptThemes = new ArrayList();
            IntStream.range(0, idList.size()).forEach(i -> {
                String id = (String)idList.get(i);
                PptTheme pptTheme = new PptTheme();
                pptTheme.setThemeId(id);
                pptTheme.setOrderIndex(Integer.valueOf(i));
                pptThemes.add(pptTheme);
            });
            this.pptThemeMapper.updateList(pptThemes);
        } else if (PPTSortType.PPT_LAYOUT.getCode().equals(request.getSortType())) {
            ArrayList pptLayouts = new ArrayList();
            IntStream.range(0, idList.size()).forEach(i -> {
                String id = (String)idList.get(i);
                PptLayout pptLayout = new PptLayout();
                pptLayout.setLayoutId(id);
                pptLayout.setSort(i);
                pptLayouts.add(pptLayout);
            });
            this.pptLayoutMapper.updateList(pptLayouts);
        } else if (PPTSortType.PPT_VIDEO.getCode().equals(request.getSortType()) || PPTSortType.PPT_ORAL.getCode().equals(request.getSortType())) {
            this.tdhTemplateSort(idList);
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u6392\u5e8f\u6210\u529f");
    }

    public Rsp matchTheme(PPTThemeMatchReqBO request) {
        List pptThemeList = this.pptThemeMapper.findByScene(request.getScene());
        if (CollectionUtils.isEmpty((Collection)pptThemeList)) {
            log.warn("{}\u7528\u6237\u67e5\u8be2\u7684{}\u573a\u666f\u4e0b\u6ca1\u6709\u4e3b\u9898", (Object)request.getUserId(), (Object)request.getScene());
            return BaseRspUtils.createErrorRsp((String)"\u8be5\u573a\u666f\u4e0b\u6ca1\u6709\u4e3b\u9898,\u8bf7\u8054\u7cfb\u8fd0\u8425\u4eba\u5458!");
        }
        Optional<PptTheme> optionalPptTheme = PptThemeMatcherProcessor.findBestMatch(pptThemeList, request.getStyle(), request.getColor());
        PPTThemeBO rspBO = new PPTThemeBO();
        optionalPptTheme.ifPresent(theme -> BeanUtils.copyProperties((Object)theme, (Object)rspBO));
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    private String imageDownload(String imageUrl, String tenantCode, String userId) {
        try {
            String fileName = "a.jpg";
            URL url = new URL(imageUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setInstanceFollowRedirects(false);
            String redirectUrl = conn.getHeaderField("Location");
            URL redirectURL = new URL(redirectUrl);
            HttpURLConnection redirectConn = (HttpURLConnection)redirectURL.openConnection();
            BufferedInputStream in = new BufferedInputStream(redirectConn.getInputStream());
            System.out.println(redirectUrl);
            byte[] buffer = new byte[((InputStream)in).available()];
            FileUploadRequest uploadRequest = new FileUploadRequest();
            uploadRequest.setTenantCode(tenantCode);
            uploadRequest.setUploadUser(userId);
            uploadRequest.setFileName(fileName);
            uploadRequest.setFile(buffer);
            ((InputStream)in).close();
            RspList fileManageSaveBOS = this.fileManageService.fileUploadRequest(uploadRequest);
            log.info("\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6bd5\uff0c\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)fileManageSaveBOS));
            if (fileManageSaveBOS.isSuccess()) {
                return ((FileManageSaveBO)fileManageSaveBOS.getRows().get(0)).getAccessUrl();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @Transactional(rollbackFor={Exception.class})
    public void compared(List<String> list, String themeId) {
        PptLayoutSelectCondition cond = new PptLayoutSelectCondition();
        cond.setThemeId(themeId);
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        List pptLayouts = this.pptLayoutMapper.selectAll(cond);
        log.info("\u4e0a\u67b6/\u4e0b\u67b6\u5e03\u5c40-\u67e5\u8be2\u5230\u7684\u5e03\u5c40|\u4f20\u5165\u5e03\u5c40\uff1a{}|{}", (Object)pptLayouts.size(), (Object)list.size());
        if (CollectionUtils.isNotEmpty((Collection)pptLayouts) && CollectionUtils.isNotEmpty(list)) {
            pptLayouts.forEach(pptLayout -> {
                if (!list.contains(pptLayout.getLayoutId())) {
                    log.info("\u5220\u9664\u4e0d\u5b58\u5728\u7684\u5e03\u5c40\uff1a{}", (Object)pptLayout.getLayoutName());
                    pptLayout.setIsValid(EntityValidType.DELETE.getCode());
                    this.pptLayoutMapper.update(pptLayout);
                }
            });
        }
    }

    public void tdhTemplateSort(List<String> idList) {
        ArrayList tdhTemplates = new ArrayList();
        IntStream.range(0, idList.size()).forEach(i -> {
            String id = (String)idList.get(i);
            TdhTemplate tdhTemplate = new TdhTemplate();
            tdhTemplate.setTpId(id);
            tdhTemplate.setOrderIndex(Integer.valueOf(i));
            tdhTemplates.add(tdhTemplate);
        });
        this.tdhTemplateMapper.updateList(tdhTemplates);
    }

    public String isStar(PPTThemeBO reqBO, String busiId) {
        UserStarRequest request = new UserStarRequest();
        request.setBusiId(busiId);
        request.setBusiType("ppt_theme");
        request.setUserId(reqBO.getUserId());
        request.setTenantCode(reqBO.getTenantCode());
        Rsp rsp = null;
        try {
            rsp = this.sysUserStarApi.getStar(request);
        }
        catch (Exception e) {
            log.warn("\u6570\u5b57\u4eba\u9762\u677f-\u83b7\u53d6\u7528\u6237\u6a21\u677f-\u67e5\u8be2\u6536\u85cf\u72b6\u6001\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        return rsp != null && rsp.isSuccess() ? StarType.FAVORITED.getCode() : StarType.UNFAVORITED.getCode();
    }

    public Rsp<?> queryByPptId(PPTCreationRecordBO request) {
        log.info("\u6839\u636epptId\u67e5\u8be2\u4f5c\u54c1\u8be6\u60c5-\u5f00\u59cb\uff1a{}", (Object)request.getPptId());
        if (StringUtils.isEmpty((CharSequence)request.getPptId())) {
            return BaseRspUtils.createErrorRsp((String)"pptId\u4e0d\u5f97\u4e3a\u7a7a");
        }
        PptCreationRecord pptRecord = this.pptCreationRecordMapper.queryById(request.getPptId());
        if (ObjectUtils.isEmpty((Object)pptRecord)) {
            return BaseRspUtils.createSuccessRsp((Object)"\u65e0\u6b64ppt\u4fe1\u606f");
        }
        PPTCreationRecordBO rspBO = new PPTCreationRecordBO();
        BeanUtils.copyProperties((Object)pptRecord, (Object)rspBO);
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }
}

