/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.ppt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.tydic.nbchat.admin.api.SysTreeCategoryApi;
import com.tydic.nbchat.admin.api.bo.category.SysTreeCategoryReqBO;
import com.tydic.nbchat.admin.api.bo.category.SysTreeCategoryRsqBO;
import com.tydic.nbchat.robot.api.NbchatRobotToolsApi;
import com.tydic.nbchat.robot.api.bo.tools.RobotPromptMessageRequest;
import com.tydic.nbchat.robot.api.bo.tools.RobotToolsChatResponse;
import com.tydic.nbchat.train.api.bo.ppt.PPTThemeMatchReqBO;
import com.tydic.nbchat.train.api.bo.ppt.PPTThemeMatchRspBO;
import com.tydic.nbchat.train.api.ppt.PPTThemeApi;
import com.tydic.nbchat.train.core.service.UserVipService;
import com.tydic.nbchat.train.core.service.tdh.aimatch.matcher.CommonTemplateMatchProcessor;
import com.tydic.nbchat.train.core.service.tdh.aimatch.matcher.PptThemeMatchStrategy;
import com.tydic.nbchat.train.core.util.RegularUtil;
import com.tydic.nbchat.train.mapper.TdhMaterialPackageMapper;
import com.tydic.nbchat.train.mapper.po.TdhMaterialPackage;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class PPTThemeServiceImpl
implements PPTThemeApi {
    private static final Logger log = LoggerFactory.getLogger(PPTThemeServiceImpl.class);
    private static final String SCENE_KEY = "scene";
    private static final String STYLE_KEY = "style";
    private static final String COLOR_KEY = "color";
    private static final String CATEGORY_KEY = "m";
    private static final String SUB_CATEGORY_KEY = "n";
    private static final String MATERIAL_NAME_KEY = "a";
    private static final String MATERIAL_KEYWORDS_KEY = "k";
    private static final String MATERIAL_KEY = "s";
    private static final String DEFAULT_IMAGE_PROMPT_ID = "ppt_picture_filter";
    private static final String DEFAULT_IMAGE_PKG_NAME = "\u6982\u5ff5\u56fe\u5f62";
    private static final String MATERIAL_CATEGORY_BUSI_TYPE = "material_pack";
    private static final int MATERIAL_CATEGORY_NUM = 9999999;
    @Resource
    private TdhMaterialPackageMapper tdhMaterialPackageMapper;
    @Resource
    private PptThemeMatchStrategy pptThemeMatchStrategy;
    @Resource
    private UserVipService userVipService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
    private SysTreeCategoryApi sysTreeCategoryApi;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
    private NbchatRobotToolsApi nbchatRobotToolsApi;

    public Rsp aiMatchTheme(PPTThemeMatchReqBO request) {
        PPTThemeMatchRspBO rspBO = new PPTThemeMatchRspBO();
        rspBO.setPresetId(request.getPresetId());
        rspBO.setRobotType(request.getRobotType());
        rspBO.setContent(this.processThemeMatching(request, rspBO));
        request.setPresetId(request.getImagePromptId() == null ? DEFAULT_IMAGE_PROMPT_ID : request.getImagePromptId());
        List presetPrompts = request.getPresetPrompts();
        presetPrompts.add(this.getCompleteMaterialPacks());
        request.setPresetPrompts(presetPrompts);
        rspBO.setPkgId(this.processImagePackageMatching(request));
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    private String processThemeMatching(PPTThemeMatchReqBO request, PPTThemeMatchRspBO rspBO) {
        JSONObject jsonObject = this.getChatResult(request);
        if (jsonObject != null) {
            rspBO.setAiRecommend(jsonObject.toString());
        }
        String userVipFlag = this.userVipService.getUserVipFlag(request.getUserId());
        log.info("PPT\u4e3b\u9898\u5339\u914d - \u7528\u6237VIP\u72b6\u6001: userId={}, vipFlag={}", (Object)request.getUserId(), (Object)userVipFlag);
        return CommonTemplateMatchProcessor.matchTemplateWithAi(this.pptThemeMatchStrategy, request.getTenantCode(), request.getUserId(), userVipFlag, jsonObject, null, null, null);
    }

    private String processImagePackageMatching(PPTThemeMatchReqBO request) {
        JSONObject imageJsonObject = this.getChatResult(request);
        if (imageJsonObject != null) {
            try {
                String materialPackageName = imageJsonObject.getString(MATERIAL_NAME_KEY);
                TdhMaterialPackage record = new TdhMaterialPackage();
                record.setPkgName(materialPackageName);
                record.setStatus(EntityValidType.NORMAL.getCode());
                record.setIsValid(EntityValidType.NORMAL.getCode());
                List packageList = this.tdhMaterialPackageMapper.selectByCondition(record);
                if (!packageList.isEmpty()) {
                    return ((TdhMaterialPackage)packageList.get(0)).getPkgId();
                }
            }
            catch (Exception e) {
                log.error("AI\u5339\u914d\u7d20\u6750\u5305-\u89e3\u6790\u7d20\u6750\u5305JSON\u54cd\u5e94\u65f6\u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        log.info("AI\u5339\u914d\u7d20\u6750\u5305-\u65e0\u6cd5\u83b7\u53d6AI\u5339\u914d\u7d20\u6750\u5305\uff0c\u5c06\u91c7\u7528\u56fa\u5b9a\u7d20\u6750\u5305\uff1a{}", (Object)DEFAULT_IMAGE_PKG_NAME);
        String pkgId = this.tdhMaterialPackageMapper.findByPkgName(DEFAULT_IMAGE_PKG_NAME);
        log.info("AI\u5339\u914d\u7d20\u6750\u5305-\u56fa\u5b9a\u7d20\u6750\u5305ID: {}", (Object)pkgId);
        return pkgId == null ? this.tdhMaterialPackageMapper.findRandomMaterialPackageId() : pkgId;
    }

    private JSONObject getChatResult(PPTThemeMatchReqBO request) {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getPresetId())) {
            log.warn("AI\u5339\u914d-\u8bf7\u6c42\u65e0\u6548\u9884\u8bbeID\u4e3a\u7a7a");
            return null;
        }
        try {
            RobotPromptMessageRequest promptMessageRequest = new RobotPromptMessageRequest();
            BeanUtils.copyProperties((Object)request, (Object)promptMessageRequest);
            Rsp rsp = this.nbchatRobotToolsApi.getChatResult(promptMessageRequest);
            if (!rsp.isSuccess() || rsp.getData() == null) {
                log.warn("AI\u5339\u914d-\u5931\u8d25\uff0c\u9884\u8bbeID: {}", (Object)request.getPresetId());
                return null;
            }
            RobotToolsChatResponse data = (RobotToolsChatResponse)rsp.getData();
            String content = RegularUtil.extractJsonString(data.getContent());
            if (StringUtils.isBlank((CharSequence)content)) {
                log.warn("AI\u5339\u914d-\u6a21\u578b\u8fd4\u56de\u5185\u5bb9\u4e2d\u672a\u627e\u5230\u5408\u6cd5\u7684JSON\uff0c\u9884\u8bbeID: {}", (Object)request.getPresetId());
                return null;
            }
            log.info("AI\u5339\u914d-\u6a21\u578b\u8fd4\u56de\u5185\u5bb9\u4e2d\u627e\u5230\u5408\u6cd5\u7684JSON\uff0c\u9884\u8bbeID: {}, \u5185\u5bb9: {}", (Object)request.getPresetId(), (Object)content);
            return JSON.parseObject((String)content);
        }
        catch (Exception e) {
            log.error("AI\u5339\u914d-\u5904\u7406AI\u804a\u5929\u7ed3\u679c\u65f6\u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private String getCompleteMaterialPacks() {
        log.info("\u5f00\u59cb\u6784\u5efa\u7d20\u6750\u5305\u5b8c\u6574\u6570\u636e");
        TdhMaterialPackage record = new TdhMaterialPackage();
        record.setStatus(EntityValidType.NORMAL.getCode());
        record.setIsValid(EntityValidType.NORMAL.getCode());
        List packageList = this.tdhMaterialPackageMapper.selectByCondition(record);
        log.info("AI\u5339\u914d\u7d20\u6750\u5305-\u67e5\u8be2\u5230\u7d20\u6750\u5305\u6570\u91cf: {}", (Object)packageList.size());
        SysTreeCategoryReqBO sysTreeCategoryReqBO = new SysTreeCategoryReqBO();
        sysTreeCategoryReqBO.setBusiType(MATERIAL_CATEGORY_BUSI_TYPE);
        sysTreeCategoryReqBO.setLimit(9999999);
        RspList rspList = this.sysTreeCategoryApi.getCategoryList(sysTreeCategoryReqBO);
        if (!rspList.isSuccess() || CollectionUtils.isEmpty((Collection)rspList.getRows())) {
            log.error("AI\u5339\u914d\u7d20\u6750\u5305-\u67e5\u8be2\u7d20\u6750\u5305\u5206\u7c7b\u5931\u8d25: {}", (Object)rspList);
            return null;
        }
        List treeCategoryRsqBOList = rspList.getRows();
        log.info("AI\u5339\u914d\u7d20\u6750\u5305-\u67e5\u8be2\u5230\u7d20\u6750\u5305\u5206\u7c7b\u6570\u91cf: {}", (Object)(treeCategoryRsqBOList != null ? treeCategoryRsqBOList.size() : 0));
        Map<String, String> categoryMap = treeCategoryRsqBOList.stream().collect(Collectors.toMap(SysTreeCategoryRsqBO::getCateId, SysTreeCategoryRsqBO::getCateName));
        JSONArray resultArray = new JSONArray();
        Map<String, List<TdhMaterialPackage>> categoryPackageMap = packageList.stream().filter(pkg -> StringUtils.isNotBlank((CharSequence)pkg.getCategory1())).collect(Collectors.groupingBy(TdhMaterialPackage::getCategory1));
        categoryPackageMap.forEach((mainCategory, packages) -> {
            JSONObject mainCategoryObj = new JSONObject();
            mainCategoryObj.put(CATEGORY_KEY, categoryMap.get(mainCategory));
            Map<String, List<TdhMaterialPackage>> subCategoryPackageMap = packages.stream().filter(pkg -> StringUtils.isNotBlank((CharSequence)pkg.getCategory2())).collect(Collectors.groupingBy(TdhMaterialPackage::getCategory2));
            JSONArray subCategoriesArray = new JSONArray();
            subCategoryPackageMap.forEach((subCategory, subPackages) -> {
                for (TdhMaterialPackage pkg : subPackages) {
                    JSONObject subCategoryObj = new JSONObject();
                    subCategoryObj.put(SUB_CATEGORY_KEY, categoryMap.get(subCategory));
                    subCategoryObj.put(MATERIAL_NAME_KEY, (Object)pkg.getPkgName());
                    JSONArray keywordsArray = new JSONArray();
                    if (StringUtils.isNotBlank((CharSequence)pkg.getKeywords())) {
                        keywordsArray.add((Object)pkg.getKeywords());
                    }
                    subCategoryObj.put(MATERIAL_KEYWORDS_KEY, (Object)keywordsArray);
                    subCategoriesArray.add((Object)subCategoryObj);
                }
            });
            mainCategoryObj.put(MATERIAL_KEY, (Object)subCategoriesArray);
            resultArray.add((Object)mainCategoryObj);
        });
        String result = resultArray.toJSONString();
        log.info("AI\u5339\u914d\u7d20\u6750\u5305-\u5b8c\u6574\u7d20\u6750\u5305\u6570\u636e\u4e3a: {}", (Object)result);
        return result;
    }
}

