/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.tydic.nbchat.train.api.bo.tdh.TdhAiMatchReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhAiMatchRspBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhAudioQueryRspBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhVirtualAnchorQueryRspBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhVirtualHumanQueryRspBO;
import com.tydic.nbchat.train.api.tdh.TdhAiMatchApi;
import com.tydic.nbchat.train.api.tdh.enums.PptTypeEnum;
import com.tydic.nbchat.train.core.service.UserVipService;
import com.tydic.nbchat.train.core.service.tdh.aimatch.MatchResult;
import com.tydic.nbchat.train.core.service.tdh.aimatch.PptContext;
import com.tydic.nbchat.train.core.service.tdh.aimatch.factory.ContentFactory;
import com.tydic.nbchat.train.core.service.tdh.aimatch.factory.ContentFactorySelector;
import com.tydic.nbchat.train.core.service.tdh.aimatch.strategy.Recommender;
import com.tydic.nbchat.train.mapper.TdhAudioMapper;
import com.tydic.nbchat.train.mapper.TdhVirtualAnchorMapper;
import com.tydic.nbchat.train.mapper.TdhVirtualHumanMapper;
import com.tydic.nbchat.train.mapper.po.TdhAudio;
import com.tydic.nbchat.train.mapper.po.TdhVirtualAnchor;
import com.tydic.nbchat.train.mapper.po.TdhVirtualHuman;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class TdhAiMatchServiceImpl
implements TdhAiMatchApi {
    private static final Logger log = LoggerFactory.getLogger(TdhAiMatchServiceImpl.class);
    @Resource
    private ContentFactorySelector factorySelector;
    @Resource
    private TdhVirtualHumanMapper tdhVirtualHumanMapper;
    @Resource
    private TdhVirtualAnchorMapper tdhVirtualAnchorMapper;
    @Resource
    private TdhAudioMapper tdhAudioMapper;
    @Resource
    private UserVipService userVipService;

    public Rsp aiMatch(TdhAiMatchReqBO request) {
        log.info("\u667a\u80fd\u5339\u914d-\u5f00\u59cb\u5904\u7406\uff0c\u7528\u6237: {}, PPT\u7c7b\u578b: {}, \u6807\u9898: {}", new Object[]{request.getUserId(), request.getPptType(), request.getTitleContent()});
        try {
            PptTypeEnum pptTypeEnum;
            if (!this.isValidRequest(request)) {
                return BaseRspUtils.createErrorRsp((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u5b8c\u6574");
            }
            try {
                pptTypeEnum = PptTypeEnum.fromCode((String)request.getPptType());
            }
            catch (IllegalArgumentException e) {
                return BaseRspUtils.createErrorRsp((String)("\u4e0d\u652f\u6301\u7684PPT\u7c7b\u578b: " + request.getPptType()));
            }
            String userVipFlag = this.userVipService.getUserVipFlag(request.getUserId());
            log.debug("\u667a\u80fd\u5339\u914d-\u7528\u6237VIP\u72b6\u6001: userId={}, vipFlag={}", (Object)request.getUserId(), (Object)userVipFlag);
            PptContext context = this.buildContext(request, pptTypeEnum);
            context.setUserVipFlag(userVipFlag);
            ContentFactory factory = this.factorySelector.selectFactory(pptTypeEnum);
            Recommender recommender = factory.createRecommender();
            MatchResult result = recommender.recommend(context);
            TdhAiMatchRspBO response = this.buildResponse(result);
            log.info("\u667a\u80fd\u5339\u914d-\u5b8c\u6210\u5904\u7406\uff0c\u6570\u5b57\u4eba: {}, \u6a21\u677f: {}", (Object)response.getTdhId(), (Object)response.getTpId());
            return BaseRspUtils.createSuccessRsp((Object)response);
        }
        catch (Exception e) {
            log.error("\u667a\u80fd\u5339\u914d-\u5904\u7406\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            return BaseRspUtils.createErrorRsp((String)"\u667a\u80fd\u5339\u914d\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    private boolean isValidRequest(TdhAiMatchReqBO request) {
        return request != null && request.getPptType() != null && request.getTitleContent() != null && request.getCreationContent() != null && request.getTemplatePresetId() != null && request.getAvatarPresetId() != null;
    }

    private PptContext buildContext(TdhAiMatchReqBO request, PptTypeEnum pptTypeEnum) {
        PptContext context = new PptContext();
        BeanUtils.copyProperties((Object)request, (Object)context);
        context.setPptType(pptTypeEnum);
        return context;
    }

    private TdhAiMatchRspBO buildResponse(MatchResult result) {
        TdhAiMatchRspBO response = new TdhAiMatchRspBO();
        response.setTdhId(result.getTdhId());
        response.setTpId(result.getTpId());
        response.setAudioId(result.getAudioId());
        response.setReason(result.getReason());
        response.setAiRecommend(result.getAiRecommend());
        if (StringUtils.isNotBlank((CharSequence)result.getTdhId())) {
            try {
                TdhVirtualHuman tdhVirtualHuman = this.tdhVirtualHumanMapper.queryById(result.getTdhId());
                if (tdhVirtualHuman != null) {
                    response.setTdhHumanInfo(this.convertToTdhInfo(tdhVirtualHuman));
                    log.debug("\u667a\u80fd\u5339\u914d-\u83b7\u53d6\u6570\u5b57\u4eba\u8be6\u60c5: {}", (Object)tdhVirtualHuman.getTdhName());
                } else {
                    log.warn("\u667a\u80fd\u5339\u914d-\u6570\u5b57\u4eba\u8be6\u60c5\u4e0d\u5b58\u5728: {}", (Object)result.getTdhId());
                    response.setTdhHumanInfo(new TdhVirtualHumanQueryRspBO());
                }
            }
            catch (Exception e) {
                log.error("\u667a\u80fd\u5339\u914d-\u83b7\u53d6\u6570\u5b57\u4eba\u8be6\u60c5\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
                response.setTdhHumanInfo(new TdhVirtualHumanQueryRspBO());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)result.getAudioId())) {
            try {
                TdhAudio tdhAudio = this.tdhAudioMapper.queryById(result.getAudioId());
                if (tdhAudio != null) {
                    response.setAudioInfo(this.convertToAudioInfo(tdhAudio));
                    log.debug("\u667a\u80fd\u5339\u914d-\u83b7\u53d6\u80cc\u666f\u97f3\u4e50\u8be6\u60c5: {}", (Object)tdhAudio.getObjectName());
                } else {
                    log.warn("\u667a\u80fd\u5339\u914d-\u80cc\u666f\u97f3\u4e50\u8be6\u60c5\u4e0d\u5b58\u5728: {}", (Object)result.getAudioId());
                    response.setAudioInfo(new TdhAudioQueryRspBO());
                }
            }
            catch (Exception e) {
                log.error("\u667a\u80fd\u5339\u914d-\u83b7\u53d6\u80cc\u666f\u97f3\u4e50\u8be6\u60c5\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
                response.setAudioInfo(new TdhAudioQueryRspBO());
            }
        }
        return response;
    }

    private TdhVirtualHumanQueryRspBO convertToTdhInfo(TdhVirtualHuman tdhVirtualHuman) {
        TdhVirtualHumanQueryRspBO tdhInfo = new TdhVirtualHumanQueryRspBO();
        BeanUtils.copyProperties((Object)tdhVirtualHuman, (Object)tdhInfo);
        if (StringUtils.isNotBlank((CharSequence)tdhVirtualHuman.getTargetVoice())) {
            try {
                TdhVirtualAnchor voiceAnchor = this.tdhVirtualAnchorMapper.queryById(tdhVirtualHuman.getTargetVoice());
                TdhVirtualAnchorQueryRspBO voiceInfo = new TdhVirtualAnchorQueryRspBO();
                if (voiceAnchor != null) {
                    BeanUtils.copyProperties((Object)voiceAnchor, (Object)voiceInfo);
                    log.debug("\u667a\u80fd\u5339\u914d-\u83b7\u53d6\u97f3\u8272\u4fe1\u606f: \u6570\u5b57\u4ebaID={}, \u97f3\u8272ID={}, \u97f3\u8272\u540d\u79f0={}", new Object[]{tdhVirtualHuman.getTdhId(), tdhVirtualHuman.getTargetVoice(), voiceAnchor.getName()});
                } else {
                    log.warn("\u667a\u80fd\u5339\u914d-\u97f3\u8272\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u97f3\u8272ID: {}", (Object)tdhVirtualHuman.getTargetVoice());
                }
                tdhInfo.setVoiceInfo(voiceInfo);
            }
            catch (Exception e) {
                log.error("\u667a\u80fd\u5339\u914d-\u67e5\u8be2\u97f3\u8272\u4fe1\u606f\u5f02\u5e38\uff0c\u97f3\u8272ID: {}, \u9519\u8bef: {}", new Object[]{tdhVirtualHuman.getTargetVoice(), e.getMessage(), e});
            }
        }
        return tdhInfo;
    }

    private TdhAudioQueryRspBO convertToAudioInfo(TdhAudio tdhAudio) {
        TdhAudioQueryRspBO rspBO = new TdhAudioQueryRspBO();
        BeanUtils.copyProperties((Object)tdhAudio, (Object)rspBO);
        return rspBO;
    }
}

