/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.train.api.bo.eums.AnalysisEnum;
import com.tydic.nbchat.train.api.bo.tdh.TdhAnalysisBO;
import com.tydic.nbchat.train.core.bo.BatchJobReportBO;
import com.tydic.nbchat.train.mapper.NameMapper;
import com.tydic.nbchat.train.mapper.SysDictConfigMapper;
import com.tydic.nbchat.train.mapper.TdhCreationAnalysisMapper;
import com.tydic.nbchat.train.mapper.po.SysDictConfig;
import com.tydic.nbchat.train.mapper.po.TdhAnalysisDTO;
import com.tydic.nbchat.train.mapper.po.TdhCreationAnalysis;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.volcengine.ApiClient;
import com.volcengine.ApiException;
import com.volcengine.ark.ArkApi;
import com.volcengine.ark.model.CreateBatchInferenceJobRequest;
import com.volcengine.ark.model.CreateBatchInferenceJobResponse;
import com.volcengine.ark.model.FilterForListBatchInferenceJobsInput;
import com.volcengine.ark.model.FoundationModelForCreateBatchInferenceJobInput;
import com.volcengine.ark.model.InputFileTosLocationForCreateBatchInferenceJobInput;
import com.volcengine.ark.model.ListBatchInferenceJobsRequest;
import com.volcengine.ark.model.ListBatchInferenceJobsResponse;
import com.volcengine.ark.model.ModelReferenceForCreateBatchInferenceJobInput;
import com.volcengine.ark.model.OutputDirTosLocationForCreateBatchInferenceJobInput;
import com.volcengine.sign.Credentials;
import com.volcengine.tos.TOSV2;
import com.volcengine.tos.TOSV2ClientBuilder;
import com.volcengine.tos.TosClientException;
import com.volcengine.tos.TosServerException;
import com.volcengine.tos.model.object.AbortMultipartUploadInput;
import com.volcengine.tos.model.object.AbortMultipartUploadOutput;
import com.volcengine.tos.model.object.CompleteMultipartUploadV2Input;
import com.volcengine.tos.model.object.CompleteMultipartUploadV2Output;
import com.volcengine.tos.model.object.CreateMultipartUploadInput;
import com.volcengine.tos.model.object.CreateMultipartUploadOutput;
import com.volcengine.tos.model.object.GetObjectV2Input;
import com.volcengine.tos.model.object.GetObjectV2Output;
import com.volcengine.tos.model.object.PutObjectInput;
import com.volcengine.tos.model.object.PutObjectOutput;
import com.volcengine.tos.model.object.UploadPartV2Input;
import com.volcengine.tos.model.object.UploadPartV2Output;
import com.volcengine.tos.model.object.UploadedPartV2;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class TdhAnalysisService {
    private static final Logger log = LoggerFactory.getLogger(TdhAnalysisService.class);
    private static final Map<String, List<String>> VIDEO_SCENE_MAP = new HashMap<String, List<String>>();
    private static final Map<String, List<String>> VIDEO_CONTENT_MAP = new HashMap<String, List<String>>();
    private static final String INPUT_OBJECT = "video_class/%s/input_%d.jsonl";
    private static final String OUTPUT_OBJECT = "video_class/%s/";
    private static final String OUTPUT_FILE = "%s%s/output/results.jsonl";
    private TOSV2 tos;
    private ArkApi api;
    @Resource
    private NameMapper nameMapper;
    @Resource
    private SysDictConfigMapper sysDictConfigMapper;
    @Resource
    private TdhCreationAnalysisMapper tdhCreationAnalysisMapper;
    @Value(value="${nbchat-train.config.video-analysis.doubao.accessKey:AKLTMTAxNWYxMjIxZDFkNGU0MzllYzJjM2U0NmY1OGMxMmU}")
    private String accessKey;
    @Value(value="${nbchat-train.config.video-analysis.doubao.secretKey:WXpnME5tWmhNV0V3TnpVd05HVmtZV0psTWpobVlqUTFNbU13TkRSbU5XUQ==}")
    private String secretKey;
    @Value(value="${nbchat-train.config.video-analysis.doubao.tos.endpoint:tos-cn-beijing.volces.com}")
    private String endpoint;
    @Value(value="${nbchat-train.config.video-analysis.doubao.tos.region:cn-beijing}")
    private String region;
    @Value(value="${nbchat-train.config.video-analysis.doubao.tos.bucketName:wangyanchao}")
    private String bucketName;

    @PostConstruct
    public void init() {
        VIDEO_SCENE_MAP.putAll(this.videoAnalysisCategoryMapInit("videoUsageScenarios"));
        VIDEO_CONTENT_MAP.putAll(this.videoAnalysisCategoryMapInit("videoContentClassification"));
        this.tos = new TOSV2ClientBuilder().build(this.region, this.endpoint, this.accessKey, this.secretKey);
        this.api = new ArkApi(new ApiClient().setCredentials(Credentials.getCredentials((String)this.accessKey, (String)this.secretKey)).setRegion(this.region));
    }

    private Map<String, List<String>> videoAnalysisCategoryMapInit(String dicCode) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        List categories = this.sysDictConfigMapper.selectByCode(dicCode);
        categories.forEach(category -> {
            List categorySubs = this.sysDictConfigMapper.selectByCode(category.getDictValue());
            result.put(category.getDictName(), categorySubs.stream().map(SysDictConfig::getDictName).collect(Collectors.toList()));
        });
        return result;
    }

    public void savePptAnalysis(String tenantCode, String userId, String id) {
        TdhAnalysisBO req = TdhAnalysisBO.builder().userId(userId).tenantCode(tenantCode).taskId(id).analysisType(AnalysisEnum.PPT.getCode()).build();
        this.save(req);
    }

    public Rsp<String> save(TdhAnalysisBO request) {
        try {
            TdhCreationAnalysis analysis = this.nameMapper.queryVipDays(request.getUserId(), request.getTenantCode());
            Integer regDays = this.nameMapper.queryRegDays(request.getUserId(), request.getTenantCode());
            if (analysis == null) {
                analysis = new TdhCreationAnalysis();
            }
            analysis.setRegisterDays(regDays);
            analysis.setCreateTime(new Date());
            analysis.setAnalysisType(request.getAnalysisType());
            analysis.setTaskId(request.getTaskId());
            log.info("\u4fdd\u5b58\u89c6\u9891\u5206\u6790\u6570\u636e: {}", (Object)request);
            TdhCreationAnalysis dto = this.tdhCreationAnalysisMapper.queryById(analysis.getTaskId());
            int i = dto == null ? this.tdhCreationAnalysisMapper.insertSelective(analysis) : this.tdhCreationAnalysisMapper.update(analysis);
            if (i > 0) {
                return BaseRspUtils.createSuccessRsp((Object)"\u4fdd\u5b58\u89c6\u9891\u5206\u6790\u6570\u636e\u6210\u529f");
            }
            return BaseRspUtils.createErrorRsp((String)"\u4fdd\u5b58\u89c6\u9891\u5206\u6790\u6570\u636e\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u89c6\u9891\u5206\u6790\u6570\u636e\u5f02\u5e38: {}|", (Object)request, (Object)e);
            return BaseRspUtils.createErrorRsp((String)"\u4fdd\u5b58\u89c6\u9891\u5206\u6790\u6570\u636e\u5931\u8d25\u5f02\u5e38");
        }
    }

    public String analysisTdh(String inputObjectKey, String dateStr) {
        if (StringUtils.isBlank((CharSequence)inputObjectKey)) {
            log.error("\u89c6\u9891\u5206\u6790\u4efb\u52a1\u5217\u8868\u6570\u636e\u4e0a\u4f20\u81f3TOS\u5931\u8d25");
            return null;
        }
        String outputObjectKey = String.format(OUTPUT_OBJECT, dateStr);
        FoundationModelForCreateBatchInferenceJobInput foundationModel = new FoundationModelForCreateBatchInferenceJobInput();
        foundationModel.setName("doubao-1-5-lite-32k");
        foundationModel.setModelVersion("250115");
        InputFileTosLocationForCreateBatchInferenceJobInput inputFileTosLocation = new InputFileTosLocationForCreateBatchInferenceJobInput();
        inputFileTosLocation.setBucketName(this.bucketName);
        inputFileTosLocation.setObjectKey(inputObjectKey);
        OutputDirTosLocationForCreateBatchInferenceJobInput outputDirTosLocation = new OutputDirTosLocationForCreateBatchInferenceJobInput();
        outputDirTosLocation.setBucketName(this.bucketName);
        outputDirTosLocation.setObjectKey(outputObjectKey);
        ModelReferenceForCreateBatchInferenceJobInput modelReference = new ModelReferenceForCreateBatchInferenceJobInput();
        modelReference.setFoundationModel(foundationModel);
        CreateBatchInferenceJobRequest request = new CreateBatchInferenceJobRequest();
        request.setName(String.format("\u89c6\u9891\u5206\u6790-%s-%s", dateStr, IdWorker.nextAutoIdStr()));
        request.setDescription(String.format("\u901a\u8fc7\u4f20\u5165\u7684\u89c6\u9891\u53e3\u64ad\u7a3f\uff0c\u5bf9\u8be5\u89c6\u9891\u8d4b\u4e88\u4f7f\u7528\u573a\u666f\u53ca\u89c6\u9891\u5185\u5bb9\u5206\u7c7b\u6807\u7b7e\n%s \u5b9a\u65f6\u521b\u5efa\u4efb\u52a1", dateStr));
        request.setModelReference(modelReference);
        request.setInputFileTosLocation(inputFileTosLocation);
        request.setOutputDirTosLocation(outputDirTosLocation);
        request.setProjectName("default");
        try {
            log.info("\u706b\u5c71\u65b9\u821f \u6279\u91cf\u4efb\u52a1\u521b\u5efa \u8bf7\u6c42\uff1a{}", (Object)JSON.toJSONString((Object)request));
            CreateBatchInferenceJobResponse response = this.api.createBatchInferenceJob(request);
            log.info("\u706b\u5c71\u65b9\u821f \u6279\u91cf\u4efb\u52a1\u521b\u5efa \u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)response));
            return response.getId();
        }
        catch (ApiException e) {
            log.warn("\u706b\u5c71\u65b9\u821f \u6279\u91cf\u4efb\u52a1\u521b\u5efa \u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public String analysisTdh(List<TdhAnalysisDTO> tdhAnalysisList) {
        if (CollectionUtils.isEmpty(tdhAnalysisList)) {
            log.warn("\u89c6\u9891\u5206\u6790\u4efb\u52a1\u5217\u8868\u4e3a\u7a7a");
            return null;
        }
        String dateStr = DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyyMMdd");
        String inputObjectKey = this.uploadJsonlToTos(tdhAnalysisList, dateStr);
        if (StringUtils.isBlank((CharSequence)inputObjectKey)) {
            log.error("\u89c6\u9891\u5206\u6790\u4efb\u52a1\u5217\u8868\u6570\u636e\u4e0a\u4f20\u81f3TOS\u5931\u8d25");
            return null;
        }
        return this.analysisTdh(inputObjectKey, dateStr);
    }

    public List<BatchJobReportBO> analysisVideochatReports(List<String> batchJobIds) {
        ListBatchInferenceJobsResponse response;
        if (CollectionUtils.isEmpty(batchJobIds)) {
            return null;
        }
        FilterForListBatchInferenceJobsInput filter = new FilterForListBatchInferenceJobsInput();
        filter.setIds(batchJobIds);
        ListBatchInferenceJobsRequest request = new ListBatchInferenceJobsRequest();
        request.setProjectName("default");
        request.setFilter(filter);
        try {
            log.info("\u706b\u5c71\u65b9\u821f \u67e5\u8be2\u6279\u91cf\u4efb\u52a1\u5217\u8868 \u8bf7\u6c42\uff1a{}", (Object)JSON.toJSONString((Object)request));
            response = this.api.listBatchInferenceJobs(request);
            log.info("\u706b\u5c71\u65b9\u821f \u67e5\u8be2\u6279\u91cf\u4efb\u52a1\u5217\u8868 \u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)response));
        }
        catch (ApiException e) {
            log.warn("\u706b\u5c71\u65b9\u821f \u67e5\u8be2\u6279\u91cf\u4efb\u52a1\u5217\u8868 \u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            return null;
        }
        return response.getItems().stream().map(o -> {
            BatchJobReportBO data = new BatchJobReportBO();
            data.setId(o.getId());
            data.setName(o.getName());
            data.setStatus(o.getStatus().getPhase());
            data.setInputObjectKey(o.getInputFileTosLocation().getObjectKey());
            data.setOutputObjectKey(o.getOutputDirTosLocation().getObjectKey());
            return data;
        }).collect(Collectors.toList());
    }

    @Async(value="tdhAnalysisTaskExecutor")
    public void videoAnalysisReport(String batchJobId, String outputObjectKey) {
        log.info("\u67e5\u8be2\u5e76\u89e3\u6790\u6279\u91cf\u63a8\u7406\u4efb\u52a1\u7ed3\u679c\uff0cbatchJobId-{}\uff0coutputObjectKey-{}", (Object)batchJobId, (Object)outputObjectKey);
        String objectKey = String.format(OUTPUT_FILE, outputObjectKey, batchJobId);
        log.info("\u67e5\u8be2\u5e76\u89e3\u6790\u6279\u91cf\u63a8\u7406\u4efb\u52a1\u7ed3\u679c\uff0c\u6587\u4ef6\u5730\u5740-{}", (Object)objectKey);
        JSONArray jsonArray = new JSONArray();
        GetObjectV2Input request = new GetObjectV2Input().setBucket(this.bucketName).setKey(objectKey);
        try (GetObjectV2Output response = this.tos.getObject(request);
             InputStreamReader isr = new InputStreamReader(response.getContent());
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                jsonArray.add((Object)JSONObject.parseObject((String)line));
            }
        }
        catch (TosClientException | IOException e) {
            log.warn("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u8bf7\u6c42\u914d\u7f6e\u5931\u8d25", e);
            return;
        }
        catch (TosServerException e) {
            log.warn("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            return;
        }
        log.info("\u67e5\u8be2\u5e76\u89e3\u6790\u6279\u91cf\u63a8\u7406\u4efb\u52a1\u7ed3\u679c\uff0c\u6210\u529f {} \u6761", (Object)jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            this.analysisContent(jsonArray.getJSONObject(i));
        }
    }

    public void analysisContent(JSONObject data) {
        if (!data.containsKey((Object)"custom_id")) {
            return;
        }
        String taskId = data.getString("custom_id");
        if (!data.containsKey((Object)"response")) {
            return;
        }
        JSONObject response = data.getJSONObject("response");
        if (!response.containsKey((Object)"body")) {
            return;
        }
        JSONObject body = response.getJSONObject("body");
        if (!body.containsKey((Object)"choices")) {
            return;
        }
        JSONArray choices = body.getJSONArray("choices");
        if (choices.isEmpty()) {
            return;
        }
        JSONObject choice = choices.getJSONObject(0);
        if (!choice.containsKey((Object)"message")) {
            return;
        }
        JSONObject message = choice.getJSONObject("message");
        if (!message.containsKey((Object)"content")) {
            return;
        }
        String content = message.getString("content").replace("\n", "");
        if (!JSON.isValidObject((String)content)) {
            log.warn("\u89c6\u9891\u5206\u6790\u5927\u6a21\u578b\u6570\u636e\u8fd4\u56de\u683c\u5f0f\u9519\u8bef");
            return;
        }
        try {
            Map<String, String> category;
            int analysisCategoriesSize;
            JSONArray jsonArray;
            boolean update = true;
            TdhCreationAnalysis analysis = this.tdhCreationAnalysisMapper.queryById(taskId);
            if (analysis == null) {
                update = false;
                analysis = this.tdhCreationAnalysisMapper.queryDefaultByTaskId(taskId);
                if (analysis == null) {
                    analysis = new TdhCreationAnalysis();
                    analysis.setTaskId(taskId);
                    analysis.setAnalysisType("0");
                }
            }
            analysis.setVideoClass(data.toJSONString());
            JSONObject jsonObject = JSON.parseObject((String)content);
            if (jsonObject.containsKey((Object)"videoScene") && CollectionUtils.isNotEmpty((Collection)(jsonArray = jsonObject.getJSONArray("videoScene")))) {
                analysisCategoriesSize = jsonArray.size();
                if (analysisCategoriesSize > 2 && (category = this.analysisCategory(jsonArray.getJSONObject(2), VIDEO_SCENE_MAP)) != null) {
                    analysis.setSceneCategory3(category.get("category"));
                    analysis.setSceneCategorySub3(category.get("subCategory"));
                }
                if (analysisCategoriesSize > 1 && (category = this.analysisCategory(jsonArray.getJSONObject(1), VIDEO_SCENE_MAP)) != null) {
                    analysis.setSceneCategory2(category.get("category"));
                    analysis.setSceneCategorySub2(category.get("subCategory"));
                }
                if ((category = this.analysisCategory(jsonArray.getJSONObject(0), VIDEO_SCENE_MAP)) != null) {
                    analysis.setSceneCategory(category.get("category"));
                    analysis.setSceneCategorySub(category.get("subCategory"));
                }
            }
            if (jsonObject.containsKey((Object)"videoContent") && CollectionUtils.isNotEmpty((Collection)(jsonArray = jsonObject.getJSONArray("videoContent")))) {
                analysisCategoriesSize = jsonArray.size();
                if (analysisCategoriesSize > 2 && (category = this.analysisCategory(jsonArray.getJSONObject(2), VIDEO_CONTENT_MAP)) != null) {
                    analysis.setContentCategory3(category.get("category"));
                    analysis.setContentCategorySub3(category.get("subCategory"));
                }
                if (analysisCategoriesSize > 1 && (category = this.analysisCategory(jsonArray.getJSONObject(1), VIDEO_CONTENT_MAP)) != null) {
                    analysis.setContentCategory2(category.get("category"));
                    analysis.setContentCategorySub2(category.get("subCategory"));
                }
                if ((category = this.analysisCategory(jsonArray.getJSONObject(0), VIDEO_CONTENT_MAP)) != null) {
                    analysis.setContentCategory(category.get("category"));
                    analysis.setContentCategorySub(category.get("subCategory"));
                }
            }
            if (update) {
                this.tdhCreationAnalysisMapper.update(analysis);
            } else {
                this.tdhCreationAnalysisMapper.insertSelective(analysis);
            }
        }
        catch (Exception e) {
            log.warn("\u89c6\u9891\u5206\u6790\u6570\u636e\u89e3\u6790\u5e76\u5b58\u5e93\u5931\u8d25\uff1a{}-{}", new Object[]{taskId, content, e});
        }
    }

    private Map<String, String> analysisCategory(JSONObject jsonObject, Map<String, List<String>> baseCategory) {
        List<String> baseSubCategory;
        if (!jsonObject.containsKey((Object)"category")) {
            return null;
        }
        JSONObject categoryJson = jsonObject.getJSONObject("category");
        String category = categoryJson.getString("name");
        String subCategory = categoryJson.getString("subCategory");
        if (baseCategory.containsKey(category) && (baseSubCategory = baseCategory.get(category)).contains(subCategory)) {
            HashMap<String, String> result = new HashMap<String, String>(2);
            result.put("category", category);
            result.put("subCategory", subCategory);
            return result;
        }
        Map<String, String> result = TdhAnalysisService.findCategoryInValue(baseCategory, category);
        if (result == null) {
            result = TdhAnalysisService.findCategoryInValue(baseCategory, subCategory);
        }
        return result;
    }

    private static Map<String, String> findCategoryInValue(Map<String, List<String>> baseCategory, String category) {
        if ("\u5176\u4ed6".equals(category)) {
            return null;
        }
        return baseCategory.entrySet().stream().filter(o -> ((List)o.getValue()).contains(category)).map(o -> {
            HashMap<String, String> result = new HashMap<String, String>(2);
            result.put("category", (String)o.getKey());
            result.put("subCategory", category);
            return result;
        }).findFirst().orElse(null);
    }

    public String getInputObjectKey(String dateStr) {
        return String.format(INPUT_OBJECT, dateStr, System.currentTimeMillis());
    }

    public String createMultipartUploadToTos(String inputObjectKey) {
        try {
            CreateMultipartUploadInput input = CreateMultipartUploadInput.builder().bucket(this.bucketName).key(inputObjectKey).build();
            log.info("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u521d\u59cb\u5316\u5206\u7247\u4e0a\u4f20 \u8bf7\u6c42\uff1a{}", (Object)JSON.toJSONString((Object)input));
            CreateMultipartUploadOutput output = this.tos.createMultipartUpload(input);
            log.info("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u521d\u59cb\u5316\u5206\u7247\u4e0a\u4f20 \u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)output));
            if (output == null) {
                return null;
            }
            return output.getUploadID();
        }
        catch (TosClientException e) {
            log.warn("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u8bf7\u6c42\u914d\u7f6e\u5931\u8d25", (Throwable)e);
        }
        catch (TosServerException e) {
            log.warn("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    public void abortMultipartUploadToTos(String inputObjectKey, String uploadId) {
        try {
            AbortMultipartUploadInput input = AbortMultipartUploadInput.builder().bucket(this.bucketName).key(inputObjectKey).uploadID(uploadId).build();
            log.info("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u521d\u59cb\u5316\u5206\u7247\u4e0a\u4f20 \u8bf7\u6c42\uff1a{}", (Object)JSON.toJSONString((Object)input));
            AbortMultipartUploadOutput output = this.tos.abortMultipartUpload(input);
            log.info("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u521d\u59cb\u5316\u5206\u7247\u4e0a\u4f20 \u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)output));
        }
        catch (TosClientException e) {
            log.warn("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u8bf7\u6c42\u914d\u7f6e\u5931\u8d25", (Throwable)e);
        }
        catch (TosServerException e) {
            log.warn("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String uploadPartToTos(String inputObjectKey, String uploadId, int partNumber, List<TdhAnalysisDTO> tdhAnalysisList) {
        if (CollectionUtils.isEmpty(tdhAnalysisList)) {
            return null;
        }
        String promptTemplate = this.nameMapper.queryPromptTemplateByPresetId("video_class");
        if (StringUtils.isBlank((CharSequence)promptTemplate)) {
            log.error("\u672a\u67e5\u8be2\u5230 video_class \u641c\u7d22\u8bcd");
            return null;
        }
        String jsonlData = tdhAnalysisList.stream().map(o -> {
            JSONObject message = new JSONObject();
            message.put("role", (Object)"user");
            message.put("content", (Object)promptTemplate.replace("#ARG0", o.getOralDraft()));
            JSONArray messages = new JSONArray();
            messages.add((Object)message);
            JSONObject body = new JSONObject();
            body.put("messages", (Object)messages);
            JSONObject request = new JSONObject();
            request.put("custom_id", (Object)o.getTaskId());
            request.put("body", (Object)body);
            return request.toJSONString();
        }).collect(Collectors.joining("\n"));
        try (ByteArrayInputStream bais = new ByteArrayInputStream(jsonlData.getBytes());){
            UploadPartV2Input input = UploadPartV2Input.builder().bucket(this.bucketName).key(inputObjectKey).uploadID(uploadId).partNumber(partNumber).content((InputStream)bais).build();
            log.info("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u4e0a\u4f20\u5206\u7247 \u8bf7\u6c42\uff1a{}", (Object)JSON.toJSONString((Object)input));
            UploadPartV2Output output = this.tos.uploadPart(input);
            log.info("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u4e0a\u4f20\u5206\u7247 \u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)output));
            if (output == null) {
                String string = null;
                return string;
            }
            String string = output.getEtag();
            return string;
        }
        catch (TosClientException | IOException e) {
            log.warn("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u8bf7\u6c42\u914d\u7f6e\u5931\u8d25", e);
            return null;
        }
        catch (TosServerException e) {
            log.warn("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    public void completeMultipartUploadToTos(String inputObjectKey, String uploadId, List<UploadedPartV2> parts) {
        try {
            CompleteMultipartUploadV2Input input = CompleteMultipartUploadV2Input.builder().bucket(this.bucketName).key(inputObjectKey).uploadID(uploadId).uploadedParts(parts).build();
            log.info("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u5408\u5e76\u5206\u7247 \u8bf7\u6c42\uff1a{}", (Object)JSON.toJSONString((Object)input));
            CompleteMultipartUploadV2Output output = this.tos.completeMultipartUpload(input);
            log.info("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u5408\u5e76\u5206\u7247 \u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)output));
        }
        catch (TosClientException e) {
            log.warn("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u8bf7\u6c42\u914d\u7f6e\u5931\u8d25", (Throwable)e);
        }
        catch (TosServerException e) {
            log.warn("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
    }

    public String uploadJsonlToTos(List<TdhAnalysisDTO> tdhAnalysisList, String dateStr) {
        block10: {
            String string;
            if (CollectionUtils.isEmpty(tdhAnalysisList)) {
                return null;
            }
            String promptTemplate = this.nameMapper.queryPromptTemplateByPresetId("video_class");
            if (StringUtils.isBlank((CharSequence)promptTemplate)) {
                log.error("\u672a\u67e5\u8be2\u5230 video_class \u641c\u7d22\u8bcd");
                return null;
            }
            String jsonlData = tdhAnalysisList.stream().map(o -> {
                JSONObject message = new JSONObject();
                message.put("role", (Object)"user");
                message.put("content", (Object)promptTemplate.replace("#ARG0", o.getOralDraft()));
                JSONArray messages = new JSONArray();
                messages.add((Object)message);
                JSONObject body = new JSONObject();
                body.put("messages", (Object)messages);
                JSONObject request = new JSONObject();
                request.put("custom_id", (Object)o.getTaskId());
                request.put("body", (Object)body);
                return request.toJSONString();
            }).collect(Collectors.joining("\n"));
            String inputObjectKey = this.getInputObjectKey(dateStr);
            ByteArrayInputStream bais = new ByteArrayInputStream(jsonlData.getBytes());
            try {
                PutObjectInput input = PutObjectInput.builder().bucket(this.bucketName).key(inputObjectKey).content((InputStream)bais).build();
                log.info("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u4e0a\u4f20\u6587\u4ef6 \u8bf7\u6c42\uff1a{}", (Object)JSON.toJSONString((Object)input));
                PutObjectOutput output = this.tos.putObject(input);
                log.info("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u4e0a\u4f20\u6587\u4ef6 \u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)output));
                string = inputObjectKey;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bais.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (TosClientException | IOException e) {
                    log.warn("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u8bf7\u6c42\u914d\u7f6e\u5931\u8d25", e);
                    break block10;
                }
                catch (TosServerException e) {
                    log.warn("\u706b\u5c71\u4e91 \u5bf9\u8c61\u5b58\u50a8 TOS \u8bf7\u6c42\u5931\u8d25", (Throwable)e);
                }
            }
            bais.close();
            return string;
        }
        return null;
    }
}

