/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.train.api.bo.eums.StateEnum;
import com.tydic.nbchat.train.api.bo.eums.TdhAudioType;
import com.tydic.nbchat.train.api.bo.tdh.TdhAudioBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhAudioReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhAudioSortReqBO;
import com.tydic.nbchat.train.api.tdh.TdhAudioApi;
import com.tydic.nbchat.train.mapper.TdhAudioMapper;
import com.tydic.nbchat.train.mapper.po.TdhAudio;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TdhAudioServiceImpl
implements TdhAudioApi {
    private static final Logger log = LoggerFactory.getLogger(TdhAudioServiceImpl.class);
    @Resource
    TdhAudioMapper tdhAudioMapper;

    @CacheEvict(cacheNames={"nbchat-train:tdh_audio"}, allEntries=true)
    public Rsp save(TdhAudioBO request) {
        log.info("\u4fdd\u5b58\u80cc\u666f\u97f3\u4e50 - ID: {}, \u540d\u79f0: {}", (Object)request.getObjectId(), (Object)request.getObjectName());
        TdhAudio po = new TdhAudio();
        BeanUtils.copyProperties((Object)request, (Object)po);
        if (StringUtils.isEmpty((CharSequence)request.getObjectId())) {
            po.setObjectId(IdWorker.nextAutoIdStr());
            po.setCreateTime(new Date());
            po.setObjectSource(StateEnum.SOURCE.SELF.getCode());
            this.tdhAudioMapper.insertSelective(po);
        } else {
            this.tdhAudioMapper.update(po);
        }
        return BaseRspUtils.createSuccessRsp(null);
    }

    public RspList query(TdhAudioBO request) {
        log.info("\u67e5\u8be2\u80cc\u666f\u97f3\u4e50\u5217\u8868 - \u79df\u6237: {}, \u7528\u6237: {}", (Object)request.getTenantCode(), (Object)request.getUserId());
        TdhAudio cond = new TdhAudio();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        Page tdhAudios = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.tdhAudioMapper.selectAll(cond);
        ArrayList bos = new ArrayList();
        NiccCommonUtil.copyList((List)tdhAudios.getResult(), bos, TdhAudioBO.class);
        return BaseRspUtils.createSuccessRspList(bos, (long)tdhAudios.getTotal());
    }

    @CacheEvict(cacheNames={"nbchat-train:tdh_audio"}, allEntries=true)
    public Rsp delete(TdhAudioBO request) {
        log.info("\u5220\u9664\u80cc\u666f\u97f3\u4e50 - ID: {}", (Object)request.getObjectId());
        if (StringUtils.isBlank((CharSequence)request.getObjectId())) {
            return BaseRspUtils.createErrorRsp((String)"objectId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TdhAudio po = new TdhAudio();
        po.setObjectId(request.getObjectId());
        po.setIsValid(request.getIsValid());
        int i = this.tdhAudioMapper.update(po);
        if (i > 0) {
            return BaseRspUtils.createSuccessRsp((Object)request.getObjectId());
        }
        return BaseRspUtils.createErrorRsp((String)"\u5220\u9664\u5931\u8d25");
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp saveAudioForAdmin(TdhAudioReqBO request) {
        log.info("\u8fd0\u8425\u5e73\u53f0\u914d\u7f6e\u80cc\u666f\u97f3\u4e50 - ID: {}, \u540d\u79f0: {}", (Object)request.getObjectId(), (Object)request.getObjectName());
        TdhAudio po = new TdhAudio();
        BeanUtils.copyProperties((Object)request, (Object)po);
        if (TdhAudioType.CUSTOM.getCode().equals(request.getObjectSource())) {
            if (StringUtils.isBlank((CharSequence)request.getSpecifyTenantCode())) {
                request.setSpecifyTenantCode(request.getTenantCode());
            }
            po.setUserId(request.getSpecifyTenantCode());
            po.setTenantCode(request.getSpecifyTenantCode());
            po.setObjectSource(StateEnum.SOURCE.SELF.getCode());
        } else {
            po.setUserId("00000000");
            po.setTenantCode("00000000");
            po.setObjectSource(StateEnum.SOURCE.SYSTEM.getCode());
        }
        if (StringUtils.isEmpty((CharSequence)request.getObjectId())) {
            po.setObjectId(IdWorker.nextAutoIdStr());
            po.setCreateTime(new Date());
            po.setCategory("1");
            po.setIsValid(EntityValidType.DELETE.getCode());
            this.tdhAudioMapper.insertSelective(po);
        } else {
            TdhAudio existing = this.tdhAudioMapper.queryById(request.getObjectId());
            if (existing == null) {
                return BaseRspUtils.createErrorRsp((String)"\u80cc\u666f\u97f3\u4e50\u4e0d\u5b58\u5728");
            }
            po.setOrderIndex(null);
            this.tdhAudioMapper.update(po);
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    public RspList queryAudioForAdmin(TdhAudioBO request) {
        log.info("\u8fd0\u8425\u5e73\u53f0\u67e5\u8be2\u80cc\u666f\u97f3\u4e50\u5217\u8868 - \u79df\u6237: {}, \u7528\u6237: {}", (Object)request.getTenantCode(), (Object)request.getUserId());
        TdhAudio cond = new TdhAudio();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        if (StringUtils.isNotBlank((CharSequence)request.getSpecifyTenantCode())) {
            cond.setTenantCode(request.getSpecifyTenantCode());
            cond.setUserId(request.getSpecifyTenantCode());
        } else {
            cond.setUserId(null);
            cond.setTenantCode(null);
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List tdhAudios = this.tdhAudioMapper.selectList(cond);
        ArrayList bos = new ArrayList();
        NiccCommonUtil.copyList((List)tdhAudios, bos, TdhAudioBO.class);
        bos.forEach(item -> {
            if (StringUtils.isNotBlank((CharSequence)item.getTenantCode())) {
                item.setSpecifyTenantCode(item.getTenantCode());
            }
        });
        return BaseRspUtils.createSuccessRspList(bos, (long)page.getTotal());
    }

    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(cacheNames={"nbchat-train:tdh_audio"}, allEntries=true)
    public Rsp sortAudioForAdmin(TdhAudioSortReqBO request) {
        log.info("\u8fd0\u8425\u5e73\u53f0\u80cc\u666f\u97f3\u4e50\u6392\u5e8f - \u6570\u91cf: {}", (Object)request.getSortObjectIds().size());
        ArrayList audioList = new ArrayList();
        IntStream.range(0, request.getSortObjectIds().size()).forEach(i -> {
            TdhAudio audio = new TdhAudio();
            audio.setObjectId((String)request.getSortObjectIds().get(i));
            audio.setOrderIndex(Integer.valueOf(i));
            audioList.add(audio);
        });
        this.tdhAudioMapper.updateBatchSelective(audioList);
        return BaseRspUtils.createSuccessRsp((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @CacheEvict(cacheNames={"nbchat-train:tdh_audio"}, allEntries=true)
    public Rsp deleteAudioForAdmin(TdhAudioBO request) {
        log.info("\u8fd0\u8425\u5e73\u53f0\u80cc\u666f\u97f3\u4e50\u5220\u9664 - ID: {}", (Object)request.getObjectId());
        if (StringUtils.isBlank((CharSequence)request.getObjectId())) {
            return BaseRspUtils.createErrorRsp((String)"objectId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TdhAudio po = new TdhAudio();
        po.setObjectId(request.getObjectId());
        int i = this.tdhAudioMapper.deleteById(request.getObjectId());
        if (i > 0) {
            return BaseRspUtils.createSuccessRsp((Object)request.getObjectId());
        }
        return BaseRspUtils.createErrorRsp((String)"\u5220\u9664\u5931\u8d25");
    }
}

