/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.admin.api.SysRobotConfigApi;
import com.tydic.nbchat.robot.api.NbchatRobotToolsApi;
import com.tydic.nbchat.robot.api.bo.eums.RobotType;
import com.tydic.nbchat.robot.api.bo.tools.RobotPromptMessageRequest;
import com.tydic.nbchat.robot.api.bo.tools.RobotToolsChatResponse;
import com.tydic.nbchat.train.api.NbchatTrainSectionApi;
import com.tydic.nbchat.train.api.bo.eums.AiCourseGeneType;
import com.tydic.nbchat.train.api.bo.eums.ElementEnum;
import com.tydic.nbchat.train.api.bo.tdh.ReplaceTempBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhAutoCreateBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhPDFAnalysisBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhPartGeneratorReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhPartsAutoBO;
import com.tydic.nbchat.train.api.bo.train.catalog.TrainCatalogBO;
import com.tydic.nbchat.train.api.bo.train.catalog.TrainCatalogQueryReqBO;
import com.tydic.nbchat.train.api.tdh.TdhAutoCreateApi;
import com.tydic.nbchat.train.core.config.NbchatTrainConfigProperties;
import com.tydic.nbchat.train.mapper.NbchatTrainCourseMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainSectionsMapper;
import com.tydic.nbchat.train.mapper.TdhCreationRecordMapper;
import com.tydic.nbchat.train.mapper.TdhTemplateMapper;
import com.tydic.nbchat.train.mapper.TdhVideoTempMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourse;
import com.tydic.nbchat.train.mapper.po.NbchatTrainSections;
import com.tydic.nbchat.train.mapper.po.TdhCreationRecord;
import com.tydic.nbchat.train.mapper.po.TdhTemplate;
import com.tydic.nbchat.train.mapper.po.TdhVideoTemp;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.http.RestApiHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.HttpClientHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class TdhAutoCreateServiceImpl
implements TdhAutoCreateApi {
    private static final Logger log = LoggerFactory.getLogger(TdhAutoCreateServiceImpl.class);
    @Resource
    TdhVideoTempMapper tdhVideoTempMapper;
    @Resource
    NbchatTrainCourseMapper nbchatTrainCourseMapper;
    @Resource
    TdhCreationRecordMapper tdhCreationRecordMapper;
    @Resource
    NbchatTrainSectionsMapper nbchatTrainSectionsMapper;
    @Resource
    TdhTemplateMapper tdhTemplateMapper;
    @Resource
    RestApiHelper restApiHelper;
    @Resource
    NbchatTrainSectionApi nbchatTrainSectionApi;
    @Resource
    NbchatTrainConfigProperties nbchatTrainConfigProperties;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=180000)
    private NbchatRobotToolsApi nbchatRobotToolsApi;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=3000)
    private SysRobotConfigApi sysRobotConfigApi;

    public Rsp autoCreate(TdhAutoCreateBO request) {
        JSONObject obj;
        log.info("\u81ea\u52a8\u751f\u6210\u89c6\u9891\uff1a{}", (Object)request);
        NbchatTrainCourse course = this.nbchatTrainCourseMapper.selectByPrimaryKey(request.getCourseId());
        if (ObjectUtils.isEmpty((Object)course) || StringUtils.isEmpty((CharSequence)course.getCourseDesc())) {
            return BaseRspUtils.createErrorRsp((String)"\u65e0\u7b80\u4ecb\u6587\u5b57\u5185\u5bb9\uff0c\u8bf7\u5148\u751f\u6210\u7b80\u4ecb\u5185\u5bb9");
        }
        RspList<TrainCatalogBO> cataRsp = this.queryCatalogs(request);
        if (cataRsp.getCount() == 0L) {
            return BaseRspUtils.createErrorRsp((String)"\u65e0\u7ae0\u8282\u6587\u5b57\u5185\u5bb9\uff0c\u8bf7\u5148\u751f\u6210\u7ae0\u8282\u5185\u5bb9");
        }
        boolean isPPT = false;
        if (StringUtils.isNotEmpty((CharSequence)course.getExtInfo()) && (obj = JSONObject.parseObject((String)course.getExtInfo())).get((Object)"createType").equals("ppt")) {
            isPPT = true;
        }
        List catalogs = cataRsp.getRows();
        JSONObject jsonObject = new JSONObject();
        this.addCommonArgs(request, jsonObject);
        String tdhApi = this.nbchatTrainConfigProperties.getTdhApi();
        if (video_intro.equals(request.getAutoCreateType())) {
            this.cleanVideoUrl(request);
            jsonObject.put("creationName", (Object)this.createName(course.getCourseName(), "\u7b80\u4ecb"));
            this.createCourseIntroTemp(request, course, jsonObject, isPPT);
            this.createCatalogTemp(request, course, catalogs, jsonObject, isPPT);
            if (Objects.equals(request.getPreview(), preview_request)) {
                return this.saveCreationRecord(request, jsonObject);
            }
            return this.postApi(tdhApi, jsonObject);
        }
        if (video_section.equals(request.getAutoCreateType())) {
            this.cleanVideoUrl(request);
            int orderNum = 1;
            for (TrainCatalogBO catalog : catalogs) {
                if (request.getCatalogId().equals(catalog.getCatalogId())) {
                    jsonObject.put("creationName", (Object)this.createName(course.getCourseName(), catalog.getCatalogTitle()));
                    this.createSectionIntro(request, catalog, orderNum, jsonObject);
                    this.createSectionKey(request, catalog, jsonObject);
                }
                ++orderNum;
            }
            if (Objects.equals(request.getPreview(), preview_request)) {
                return this.saveCreationRecord(request, jsonObject);
            }
            return this.postApi(tdhApi, jsonObject);
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u672a\u9884\u8bbe\u6b64\u914d\u7f6e\u6a21\u677f\u7c7b\u578b");
    }

    public Rsp getTemplate(TdhAutoCreateBO request) {
        log.info("\u67e5\u8be2\u6a21\u677f: {}", (Object)request);
        TdhVideoTemp cond = new TdhVideoTemp();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        cond.setTenantCode(null);
        cond.setIsValid(Integer.valueOf(Integer.parseInt(EntityValidType.NORMAL.getCode())));
        TdhVideoTemp videoTemp = this.tdhVideoTempMapper.selectTmp(cond);
        if (!Optional.ofNullable(videoTemp).isPresent()) {
            if (request.getTmpType().equals(section_content_temp_code)) {
                cond.setKeyNum(Integer.valueOf(6));
                videoTemp = this.tdhVideoTempMapper.selectTmp(cond);
                return BaseRspUtils.createSuccessRsp((Object)videoTemp);
            }
            if (request.getTmpType().equals(course_cata_temp_code)) {
                cond.setCataNum(Integer.valueOf(6));
                videoTemp = this.tdhVideoTempMapper.selectTmp(cond);
                return BaseRspUtils.createSuccessRsp((Object)videoTemp);
            }
            return BaseRspUtils.createErrorRsp((String)"\u672a\u5339\u914d\u5230\u6a21\u677f");
        }
        return BaseRspUtils.createSuccessRsp((Object)videoTemp);
    }

    public Rsp replaceTemp(ReplaceTempBO request) {
        log.info("\u66ff\u6362\u6a21\u677f:{}", (Object)request);
        TdhTemplate cond = new TdhTemplate();
        cond.setReplaceTag(EntityValidType.NORMAL.getCode());
        cond.setTpId(request.getTpId());
        TdhTemplate tdhTemplate = this.tdhTemplateMapper.selectTemp(cond);
        if (ObjectUtils.isEmpty((Object)tdhTemplate)) {
            return BaseRspUtils.createErrorRsp((String)"\u8be5\u6a21\u677f\u975e\u53ef\u66ff\u6362\u6a21\u677f");
        }
        TdhVideoTemp tdhVideoTemp = this.tdhVideoTempMapper.queryById(tdhTemplate.getTmpId());
        String tempContent = tdhVideoTemp.getContent();
        if (CollectionUtils.isNotEmpty((Collection)request.getTextList())) {
            return BaseRspUtils.createSuccessRsp((Object)"");
        }
        String robotType = this.sysRobotConfigApi.getRobotValue(request.getTenantCode(), request.getUserId());
        if (StringUtils.isNotEmpty((CharSequence)request.getContent())) {
            JSONObject entity = new JSONObject();
            entity.put("content", (Object)request.getContent());
            entity.put("name", (Object)"\u672a\u5b9a\u4e49");
            HashMap<String, String> map = this.parseKeys(entity, robotType);
            JSONObject keyTempRes = TdhAutoCreateServiceImpl.buildTemplate(map, tempContent);
            JSONObject jsonObject = new JSONObject();
            if (StringUtils.isEmpty((CharSequence)request.getJsonObject())) {
                this.defaultConfig(jsonObject, "1", "1080p", "16:9");
            } else {
                jsonObject = JSONObject.parseObject((String)request.getJsonObject());
            }
            JSONArray parts = jsonObject.getJSONArray("parts");
            parts.clear();
            parts.add((Object)keyTempRes);
            return BaseRspUtils.createSuccessRsp((Object)jsonObject);
        }
        return BaseRspUtils.createErrorRsp((String)"\u53c2\u6570\u5f02\u5e38");
    }

    public Rsp autoParts(TdhPartsAutoBO request) {
        log.info("\u81ea\u52a8\u521b\u5efa\u7247\u6bb5\uff1a{}", (Object)request);
        TdhCreationRecord rec = new TdhCreationRecord();
        BeanUtils.copyProperties((Object)request, (Object)rec);
        rec.setCreationId(IdWorker.nextAutoIdStr());
        rec.setCreationState("2");
        Rsp rsp = this.saveCreationRecord(rec);
        request.setCreationId(rec.getCreationId());
        String parts = this.createParts(request);
        return BaseRspUtils.createSuccessRsp((Object)parts);
    }

    public Rsp partGenerator(TdhPartGeneratorReqBO request) {
        if (CollectionUtils.isEmpty((Collection)request.getParts())) {
            return BaseRspUtils.createSuccessRsp((Object)"\u5185\u5bb9\u4e0d\u5f97\u4e3a\u7a7a");
        }
        List pdfParts = JSONObject.parseArray((String)JSON.toJSONString((Object)request.getParts()), JSONObject.class);
        String parts = this.buildPartTemp(pdfParts, request.getTenantCode(), request.getUserId());
        return BaseRspUtils.createSuccessRsp((Object)parts);
    }

    public String createParts(TdhPartsAutoBO request) {
        log.info("\u81ea\u52a8\u521b\u5efa\u7247\u6bb5-\u4efb\u52a1\u5f00\u59cb\uff1a{}", (Object)request);
        JSONObject body = new JSONObject();
        body.put("url", (Object)request.getPdfUrl());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json;charset=UTF-8");
        String response = HttpClientHelper.doPost((String)this.nbchatTrainConfigProperties.getTdhAnalysisPdfUrl(), headers, (Object)body.toJSONString(), (int)120000);
        log.info("\u81ea\u52a8\u521b\u5efa\u7247\u6bb5-\u8c03\u7528tdh\u63a5\u53e3\u89e3\u6790pdf\u7ed3\u679c:{}", (Object)response);
        RspList rspList = (RspList)JSONObject.parseObject((String)response, RspList.class);
        if (!rspList.isSuccess()) {
            log.warn("\u81ea\u52a8\u521b\u5efa\u7247\u6bb5-\u4efb\u52a1\u5931\u8d25\uff0c\u5220\u9664\u8349\u7a3f\uff1a{}", (Object)request.getCreationId());
            this.updateCreation(request.getCreationId(), EntityValidType.DELETE.getCode(), "", "");
            return "";
        }
        List rows = rspList.getRows();
        String partTemp = this.buildPartTemp(rows, request.getTenantCode(), request.getUserId());
        this.updateCreation(request.getCreationId(), "", "0", partTemp);
        return partTemp;
    }

    public String buildPartTemp(List<JSONObject> rows, String tenantCode, String userId) {
        TdhVideoTemp cond = new TdhVideoTemp();
        cond.setTmpType(parts_content_horizontal_temp_code);
        TdhVideoTemp horizontalTemp = this.tdhVideoTempMapper.selectTmp(cond);
        cond.setTmpType(parts_content_vertical_temp_code);
        TdhVideoTemp verticalTemp = this.tdhVideoTempMapper.selectTmp(cond);
        if (ObjectUtils.anyNull((Object[])new Object[]{horizontalTemp, verticalTemp})) {
            log.warn("\u672a\u914d\u7f6e\u6a2a\u5c4f\u3001\u7ad6\u5c4f\u7247\u6bb5\u5185\u5bb9\u6a21\u677f");
            return "";
        }
        String content = horizontalTemp.getContent();
        JSONObject jsonObject = JSONObject.parseObject((String)content);
        JSONObject config = jsonObject.getJSONObject("config");
        JSONArray jsonArray = jsonObject.getJSONArray("parts");
        JSONObject part = jsonArray.getJSONObject(0);
        LinkedHashMap<String, TdhPDFAnalysisBO> urlMap = new LinkedHashMap<String, TdhPDFAnalysisBO>();
        StringBuilder strB = new StringBuilder();
        for (JSONObject row : rows) {
            TdhPDFAnalysisBO bo = (TdhPDFAnalysisBO)JSONObject.parseObject((String)row.toJSONString(), TdhPDFAnalysisBO.class);
            String text = bo.getText();
            String page = bo.getPage();
            String arg = "\u3010P" + (String)page + "\u3011:\"" + text + "\"";
            strB.append(arg).append("\n");
            urlMap.put(page, bo);
        }
        String robotType = this.sysRobotConfigApi.getRobotValue(tenantCode, userId);
        String partsContentRes = this.getPartsContentRes(strB.toString(), robotType);
        if (StringUtils.isEmpty((CharSequence)partsContentRes)) {
            log.warn("\u81ea\u52a8\u521b\u5efa\u7247\u6bb5-ai\u5904\u7406\u6570\u636e\u4e3a\u7a7a\uff1a{}", (Object)partsContentRes);
            return "";
        }
        HashMap<String, String> aiResMap = new HashMap<String, String>();
        List split = Arrays.stream(partsContentRes.trim().split("\u3010P")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        for (String row : split) {
            String num = row.substring(0, row.indexOf("\u3011"));
            String partContent = row.substring(row.indexOf("\u3011") + 1);
            if (StringUtils.isNotEmpty((CharSequence)partContent) && (partContent.charAt(0) == ':' || partContent.charAt(0) == '\uff1a')) {
                partContent = partContent.replace(":", "");
                partContent = partContent.replace("\uff1a", "");
            }
            aiResMap.put(num, partContent);
        }
        log.info("\u81ea\u52a8\u521b\u5efa\u7247\u6bb5-\u5f85\u5904\u7406\u9875\u6570\uff1a{}", (Object)split.size());
        JSONArray array = new JSONArray();
        for (Map.Entry entry : urlMap.entrySet()) {
            String num = (String)entry.getKey();
            TdhPDFAnalysisBO imageInfo = (TdhPDFAnalysisBO)entry.getValue();
            int w = Integer.parseInt(imageInfo.getW());
            int h = Integer.parseInt(imageInfo.getH());
            String url = imageInfo.getUrl();
            String partContent = (String)aiResMap.get(num);
            String partStr = part.toJSONString();
            if (w < h) {
                part = this.matchTemp(verticalTemp);
                partStr = part.toJSONString();
                Integer y = Integer.parseInt(part.getJSONArray("videos").getJSONObject(0).getString("y"));
                widthHeight = this.getSize(config, null, y, w, h);
                log.debug("\u7ad6\u7248-\u8ba1\u7b97\u56fe\u7247\u5c3a\u5bf8\u5927\u5c0f\u7ed3\u679c:{}|{}", (Object)widthHeight[0], (Object)widthHeight[1]);
                partStr = partStr.replace(ElementEnum.image_w.getCode(), "" + widthHeight[0]).replace(ElementEnum.image_h.getCode(), "" + widthHeight[1]);
            } else {
                Integer x = Integer.parseInt(part.getJSONArray("videos").getJSONObject(0).getString("x"));
                widthHeight = this.getSize(config, x, null, w, h);
                log.debug("\u6a2a\u7248-\u8ba1\u7b97\u56fe\u7247\u5c3a\u5bf8\u5927\u5c0f\u7ed3\u679c:{}|{}", (Object)widthHeight[0], (Object)widthHeight[1]);
                partStr = partStr.replace(ElementEnum.image_w.getCode(), "" + widthHeight[0]).replace(ElementEnum.image_h.getCode(), "" + widthHeight[1]);
            }
            if (StringUtils.isEmpty((CharSequence)partContent)) {
                partStr = partStr.replace(ElementEnum.parts_content.getCode(), "\u672a\u751f\u6210\uff0c\u8bf7\u8865\u5145").replace(ElementEnum.bg_url.getCode(), url);
                array.add((Object)JSONObject.parseObject((String)partStr));
                continue;
            }
            partContent = partContent.replaceAll("\"", "\\\\\"");
            partStr = partStr.replace(ElementEnum.parts_content.getCode(), partContent).replace(ElementEnum.bg_url.getCode(), url);
            array.add((Object)JSONObject.parseObject((String)partStr));
        }
        jsonArray.clear();
        jsonArray.addAll((Collection)array);
        return jsonObject.toJSONString();
    }

    public int[] getSize(JSONObject config, Integer x, Integer y, Integer originW, Integer originH) {
        log.debug("\u8ba1\u7b97\u56fe\u7247\u5c3a\u5bf8\u5927\u5c0f:{}|{}|{}|{}|{}", new Object[]{config, x, y, originW, originH});
        String resolution = config.getString("resolution");
        String size = config.getString("size");
        if (resolution.equals("1080p")) {
            if (!ObjectUtils.isEmpty((Object)y)) {
                return this.calWH(1920, 1080, originW, originH, null, y);
            }
            if (!ObjectUtils.isEmpty((Object)x)) {
                return this.calWH(1920, 1080, originW, originH, x, null);
            }
        }
        return new int[]{1920, 1080};
    }

    public int[] calWH(Integer standW, Integer standH, Integer originW, Integer originH, Integer x, Integer y) {
        if (!ObjectUtils.isEmpty((Object)x)) {
            int imageW = standW - 2 * x;
            int imageH = imageW * originH / originW;
            return new int[]{imageW, imageH};
        }
        if (!ObjectUtils.isEmpty((Object)y)) {
            int imageH = standH - 2 * y;
            int imageW = imageH * originW / originH;
            return new int[]{imageW, imageH};
        }
        return new int[]{1920, 1080};
    }

    public JSONObject matchTemp(TdhVideoTemp temp) {
        JSONObject jsonObject = JSONObject.parseObject((String)temp.getContent());
        JSONArray jsonArray = jsonObject.getJSONArray("parts");
        JSONObject part = jsonArray.getJSONObject(0);
        return part;
    }

    public void cleanVideoUrl(TdhAutoCreateBO request) {
        if (StringUtils.isNotEmpty((CharSequence)request.getCourseId())) {
            if (StringUtils.isNotEmpty((CharSequence)request.getSectionId())) {
                NbchatTrainSections cond = new NbchatTrainSections();
                cond.setSectionId(request.getSectionId());
                cond.setVideoUrl("");
                this.nbchatTrainSectionsMapper.updateByPrimaryKeySelective(cond);
                return;
            }
            NbchatTrainCourse cond = new NbchatTrainCourse();
            cond.setCourseId(request.getCourseId());
            cond.setVideoUrl("");
            this.nbchatTrainCourseMapper.updateByPrimaryKeySelective(cond);
        }
    }

    public Rsp saveCreationRecord(TdhAutoCreateBO request, JSONObject jsonObject) {
        TdhCreationRecord save = new TdhCreationRecord();
        BeanUtils.copyProperties((Object)request, (Object)save);
        save.setCreationId(IdWorker.nextAutoIdStr());
        save.setCreationName(jsonObject.getString("creationName"));
        save.setCreationContent(jsonObject.toJSONString());
        return this.saveCreationRecord(save);
    }

    public Rsp saveCreationRecord(TdhCreationRecord save) {
        int i = this.tdhCreationRecordMapper.insertSelective(save);
        if (i > 0) {
            JSONObject rsp = new JSONObject();
            rsp.put("creationId", (Object)save.getCreationId());
            return BaseRspUtils.createSuccessRsp((Object)rsp);
        }
        return BaseRspUtils.createErrorRsp((String)"\u751f\u6210\u8349\u7a3f\u5931\u8d25");
    }

    public void updateCreation(String sectionId, String isValid, String creationState, String content) {
        TdhCreationRecord cond = new TdhCreationRecord();
        cond.setCreationId(sectionId);
        cond.setIsValid(isValid);
        cond.setCreationState(creationState);
        cond.setCreationContent(content);
        this.tdhCreationRecordMapper.update(cond);
    }

    public Rsp createCourseIntroTemp(TdhAutoCreateBO request, NbchatTrainCourse course, JSONObject jsonObject, Boolean isPPT) {
        Rsp introTempRsp;
        log.info("\u521b\u5efa\u8bfe\u7a0b\u7b80\u4ecb\u6a21\u677f");
        request.setTmpType(course_intro_temp_code);
        if (isPPT.booleanValue()) {
            request.setCataNum(Integer.valueOf(0));
        }
        if (!(introTempRsp = this.getTemplate(request)).isSuccess()) {
            log.info("\u8bfe\u7a0b\u7b80\u4ecb\u672a\u5339\u914d\u5230\u6a21\u677f");
            return introTempRsp;
        }
        String tempConten = ((TdhVideoTemp)introTempRsp.getData()).getContent();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ElementEnum.course_name.getCode(), course.getCourseName());
        JSONObject introTempRes = TdhAutoCreateServiceImpl.buildTemplate(map, tempConten);
        JSONArray parts = jsonObject.getJSONArray("parts");
        parts.add((Object)introTempRes);
        return BaseRspUtils.createSuccessRsp((Object)"\u521b\u5efa\u8bfe\u7a0b\u7b80\u4ecb\u6a21\u677f\u6210\u529f");
    }

    public Rsp createCatalogTemp(TdhAutoCreateBO request, NbchatTrainCourse course, List<TrainCatalogBO> catalogs, JSONObject jsonObject, Boolean isPPT) {
        Rsp catalogTempRsp;
        log.info("\u521b\u5efa\u8bfe\u7a0b\u76ee\u5f55\u6a21\u677f");
        request.setTmpType(course_cata_temp_code);
        request.setCataNum(Integer.valueOf(catalogs.size()));
        if (isPPT.booleanValue()) {
            request.setCataNum(Integer.valueOf(0));
        }
        if (!(catalogTempRsp = this.getTemplate(request)).isSuccess()) {
            log.info("\u8bfe\u7a0b\u76ee\u5f55\u672a\u5339\u914d\u5230\u6a21\u677f");
            return catalogTempRsp;
        }
        String tempContent = ((TdhVideoTemp)catalogTempRsp.getData()).getContent();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ElementEnum.course_desc.getCode(), course.getCourseDesc());
        for (TrainCatalogBO catalog : catalogs) {
            map.put(ElementEnum.course_catalog.concatNum(Integer.valueOf(catalogs.indexOf(catalog) + 1)), catalog.getCatalogTitle());
        }
        JSONObject catalogTempRes = TdhAutoCreateServiceImpl.buildTemplate(map, tempContent);
        JSONArray parts = jsonObject.getJSONArray("parts");
        parts.add((Object)catalogTempRes);
        return BaseRspUtils.createSuccessRsp((Object)"\u521b\u5efa\u8bfe\u7a0b\u76ee\u5f55\u6a21\u677f\u6210\u529f");
    }

    public Rsp createSectionIntro(TdhAutoCreateBO request, TrainCatalogBO catalog, Integer sectionNum, JSONObject jsonObject) {
        log.info("\u81ea\u52a8\u751f\u6210\u7ae0\u8282\u4ecb\u7ecd\u9875\u6a21\u677f");
        request.setTmpType(section_intro_temp_code);
        Rsp sectionTempRsp = this.getTemplate(request);
        if (!sectionTempRsp.isSuccess()) {
            log.info("\u7ae0\u8282\u4ecb\u7ecd\u9875\u672a\u5339\u914d\u5230\u6a21\u677f");
            return sectionTempRsp;
        }
        String tempContent = ((TdhVideoTemp)sectionTempRsp.getData()).getContent();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ElementEnum.section_num.getCode(), sectionNum.toString());
        map.put(ElementEnum.catalog_level_1_name.getCode(), catalog.getCatalogTitle());
        JSONObject sectionTempRes = TdhAutoCreateServiceImpl.buildTemplate(map, tempContent);
        JSONArray parts = jsonObject.getJSONArray("parts");
        parts.add((Object)sectionTempRes);
        return BaseRspUtils.createSuccessRsp((Object)"\u521b\u5efa\u8bfe\u7a0b\u76ee\u5f55\u6a21\u677f\u6210\u529f");
    }

    public Rsp createSectionKey(TdhAutoCreateBO request, TrainCatalogBO catalog, JSONObject jsonObject) {
        log.info("\u81ea\u52a8\u751f\u6210\u7ae0\u8282\u5173\u952e\u70b9\u6a21\u677f");
        NbchatTrainSections section = this.nbchatTrainSectionsMapper.selectByPrimaryKey(catalog.getSectionId());
        JSONObject sectionObj = JSONObject.parseObject((String)section.getContent());
        if (ObjectUtils.isEmpty((Object)sectionObj)) {
            return BaseRspUtils.createErrorRsp((String)"\u7ae0\u8282\u5185\u5bb9\u4e0d\u5f97\u4e3a\u7a7a");
        }
        String robotType = this.sysRobotConfigApi.getRobotValue(request.getTenantCode(), request.getUserId());
        JSONArray jsonArray = sectionObj.getJSONArray("subtitle");
        for (Object o : jsonArray) {
            JSONObject obj = (JSONObject)o;
            HashMap<String, String> map = new HashMap<String, String>();
            Integer keyNums = this.parseKeys(obj, map, robotType);
            request.setTmpType(section_content_temp_code);
            request.setKeyNum(keyNums);
            Rsp keyTempRsp = this.getTemplate(request);
            if (!keyTempRsp.isSuccess()) {
                log.info("\u7ae0\u8282\u4ecb\u7ecd\u9875\u672a\u5339\u914d\u5230\u6a21\u677f");
                return keyTempRsp;
            }
            String tempContent = ((TdhVideoTemp)keyTempRsp.getData()).getContent();
            JSONObject keyTempRes = TdhAutoCreateServiceImpl.buildTemplate(map, tempContent);
            JSONArray parts = jsonObject.getJSONArray("parts");
            parts.add((Object)keyTempRes);
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u521b\u5efa\u8bfe\u7a0b\u76ee\u5f55\u6a21\u677f\u6210\u529f");
    }

    public HashMap<String, String> parseKeys(JSONObject entity, String robotType) {
        HashMap<String, String> map = new HashMap<String, String>();
        this.parseKeys(entity, map, robotType);
        return map;
    }

    public Integer parseKeys(JSONObject entity, HashMap<String, String> map, String robotType) {
        String content = entity.getString("content");
        String name = entity.getString("name");
        map.put(ElementEnum.catalog_level_2_content.getCode(), content);
        map.put(ElementEnum.catalog_level_2_name.getCode(), name);
        String param = name + "\n" + content;
        JSONArray keys = this.getRobotKeyRes(param, robotType);
        Integer keyNum = 0;
        for (Object key : keys) {
            Integer n = keyNum;
            keyNum = keyNum + 1;
            JSONObject entity1 = (JSONObject)key;
            map.put(ElementEnum.key.concatNum(keyNum), entity1.getString("title"));
            map.put(ElementEnum.key_content.concatNum(keyNum), entity1.getString("content"));
        }
        return keyNum;
    }

    public JSONArray getRobotKeyRes(String args, String robotType) {
        RobotPromptMessageRequest msgRequest = new RobotPromptMessageRequest();
        msgRequest.setRobotType(robotType);
        msgRequest.setTrim(true);
        msgRequest.setPresetId(AiCourseGeneType.train_ppt_extract.getCode());
        msgRequest.setPresetPrompts(new ArrayList<String>(Collections.singletonList(args)));
        Rsp chatResult = this.nbchatRobotToolsApi.getChatResult(msgRequest);
        log.info("\u83b7\u53d6\u5173\u952e\u70b9-\u5185\u5bb9\u7ed3\u679c:{}", (Object)chatResult);
        if (!chatResult.isSuccess()) {
            return new JSONArray();
        }
        String content = ((RobotToolsChatResponse)chatResult.getData()).getContent();
        if (RobotType.ZP_AI.getCode().equals(robotType)) {
            content = content.replaceAll("\uff0c", ",");
        }
        if (JSONArray.isValidArray((String)content)) {
            return JSONArray.parseArray((String)content);
        }
        log.warn("\u975e\u6cd5\u683c\u5f0fjson");
        return new JSONArray();
    }

    public String getPartsContentRes(String args, String robotType) {
        log.info("\u6574\u7406pdf\u7247\u6bb5\u5185\u5bb9-\u539f\u59cb\u6570\u636e:{}", (Object)args);
        RobotPromptMessageRequest msgRequest = new RobotPromptMessageRequest();
        msgRequest.setRobotType(robotType);
        msgRequest.setTrim(true);
        msgRequest.setPresetId(AiCourseGeneType.tdh_pdf_parts_content.getCode());
        msgRequest.setPresetPrompts(Collections.singletonList(args));
        Rsp chatResult = this.nbchatRobotToolsApi.getChatResult(msgRequest);
        log.info("\u6574\u7406pdf\u7247\u6bb5\u5185\u5bb9\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)chatResult));
        if (!chatResult.isSuccess()) {
            return "";
        }
        return ((RobotToolsChatResponse)chatResult.getData()).getContent().trim();
    }

    public RspList<TrainCatalogBO> queryCatalogs(TdhAutoCreateBO request) {
        TrainCatalogQueryReqBO queryCatalog = new TrainCatalogQueryReqBO();
        queryCatalog.setCourseId(request.getCourseId());
        return this.nbchatTrainSectionApi.getSectionCatalogs(queryCatalog);
    }

    public void addCommonArgs(TdhAutoCreateBO request, JSONObject jsonObject) {
        jsonObject.put("creationId", (Object)IdWorker.nextAutoIdStr());
        jsonObject.put("tenantCode", (Object)request.getTenantCode());
        jsonObject.put("userId", (Object)request.getUserId());
        jsonObject.put("courseId", (Object)request.getCourseId());
        jsonObject.put("sectionId", (Object)request.getSectionId());
        this.defaultConfig(jsonObject, request.getQuality(), request.getResolution(), request.getSize());
    }

    public void defaultConfig(JSONObject jsonObject, String quality, String resolution, String size) {
        JSONObject config = new JSONObject();
        config.put("quality", (Object)quality);
        config.put("resolution", (Object)resolution);
        config.put("size", (Object)size);
        jsonObject.put("config", (Object)config);
        jsonObject.put("parts", new ArrayList());
    }

    public Rsp postApi(String url, JSONObject jsonObject) {
        log.info("\u8bf7\u6c42\u6a21\u677f\uff1a{}", (Object)jsonObject.toJSONString());
        String response = this.restApiHelper.post(url, jsonObject.toJSONString());
        log.info("\u8c03\u7528\u6570\u5b57\u4eba\u751f\u6210\u63a5\u53e3-\u8fd4\u56de\u7ed3\u679c:{}", (Object)response);
        return (Rsp)JSON.parseObject((String)response, Rsp.class);
    }

    public static JSONObject buildTemplate(Map<String, String> maps, String content) {
        log.info("\u5f00\u59cb\u6784\u5efa\u6a21\u677f\uff1a{}|{}", maps, (Object)content);
        for (Map.Entry<String, String> entry : maps.entrySet()) {
            String value = entry.getValue();
            String s = value.replaceAll("\\\\", "").replaceAll("\"", "\\\\\"");
            content = content.replaceAll(entry.getKey(), Matcher.quoteReplacement(s));
        }
        content = content.replaceAll("#(\\w+)#", "\u672a\u5b9a\u4e49");
        JSONObject jsonObject = JSONObject.parseObject((String)content);
        log.info("\u6a21\u677f\u5185\u5bb9:{}", (Object)jsonObject.toJSONString());
        return jsonObject;
    }
}

