/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.train.api.bo.eums.StateEnum;
import com.tydic.nbchat.train.api.bo.tdh.TdhBackgroundQueryReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhBackgroundQueryRspBO;
import com.tydic.nbchat.train.api.tdh.TdhBackgroundApi;
import com.tydic.nbchat.train.mapper.TdhBackgroundMapper;
import com.tydic.nbchat.train.mapper.po.TdhBackground;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;

@Service
public class TdhBackgroundServiceImpl
implements TdhBackgroundApi {
    private static final Logger log = LoggerFactory.getLogger(TdhBackgroundServiceImpl.class);
    @Resource
    private TdhBackgroundMapper tdhBackgroundMapper;

    public RspList<TdhBackgroundQueryRspBO> getBackgroundList(TdhBackgroundQueryReqBO reqBO) {
        log.info("\u67e5\u8be2\u80cc\u666f\u5217\u8868 - \u79df\u6237: {}, \u7528\u6237: {}", (Object)reqBO.getTenantCode(), (Object)reqBO.getUserId());
        TdhBackground cond = new TdhBackground();
        BeanUtils.copyProperties((Object)reqBO, (Object)cond);
        cond.setTenantCode(null);
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        Page info = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        this.tdhBackgroundMapper.selectAll(cond);
        List result = info.getResult();
        ArrayList rspList = new ArrayList();
        NiccCommonUtil.copyList((List)result, rspList, TdhBackgroundQueryRspBO.class);
        return BaseRspUtils.createSuccessRspList(rspList, (long)info.getTotal());
    }

    @CacheEvict(cacheNames={"nbchat-train:tdh_background"}, allEntries=true)
    public RspList<TdhBackgroundQueryRspBO> save(TdhBackgroundQueryReqBO reqBO) {
        log.info("\u4fdd\u5b58\u80cc\u666f - \u79df\u6237: {}, \u6570\u91cf: {}", (Object)reqBO.getTenantCode(), (Object)(reqBO.getUrlList() != null ? reqBO.getUrlList().size() : 0));
        ArrayList rspBOList = new ArrayList();
        TdhBackground cond = new TdhBackground();
        BeanUtils.copyProperties((Object)reqBO, (Object)cond);
        reqBO.getUrlList().forEach(tdhBackgroundUrlBO -> {
            cond.setName(tdhBackgroundUrlBO.getName());
            cond.setCategory(tdhBackgroundUrlBO.getCategory());
            cond.setObjectUrl(tdhBackgroundUrlBO.getObjectUrl());
            cond.setObjectSize(tdhBackgroundUrlBO.getObjectSize());
            cond.setObjectType(tdhBackgroundUrlBO.getObjectType());
            cond.setOrderIndex(tdhBackgroundUrlBO.getOrderIndex());
            cond.setFirstFrame(tdhBackgroundUrlBO.getFirstFrame());
            if (StringUtils.isNotEmpty((CharSequence)tdhBackgroundUrlBO.getObjectId())) {
                cond.setObjectId(tdhBackgroundUrlBO.getObjectId());
                this.tdhBackgroundMapper.update(cond);
            } else {
                cond.setIsValid(EntityValidType.NORMAL.getCode());
                cond.setCreateTime(new Date());
                cond.setObjectSource(StateEnum.SOURCE.SELF.getCode());
                cond.setObjectId(IdWorker.nextAutoIdStr());
                this.tdhBackgroundMapper.insertSelective(cond);
            }
            TdhBackgroundQueryRspBO rsp = new TdhBackgroundQueryRspBO();
            BeanUtils.copyProperties((Object)cond, (Object)rsp);
            rspBOList.add(rsp);
        });
        return BaseRspUtils.createSuccessRspList(rspBOList, (long)rspBOList.size());
    }
}

