/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.train.api.bo.eums.ShareType;
import com.tydic.nbchat.train.api.bo.tdh.TdhCreationRecordAdminReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhCreationRecordReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhCreationRecordRspBO;
import com.tydic.nbchat.train.api.tdh.TdhCreationRecordApi;
import com.tydic.nbchat.train.mapper.NameMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainCourseMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainSectionsMapper;
import com.tydic.nbchat.train.mapper.TdhCreationHistoryMapper;
import com.tydic.nbchat.train.mapper.TdhCreationRecordMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourse;
import com.tydic.nbchat.train.mapper.po.NbchatTrainSections;
import com.tydic.nbchat.train.mapper.po.TdhCreationHistory;
import com.tydic.nbchat.train.mapper.po.TdhCreationRecord;
import com.tydic.nbchat.train.mapper.po.TdhCreationRecordSelectCondition;
import com.tydic.nbchat.train.mapper.po.VipInfo;
import com.tydic.nbchat.train.mapper.po.VipItem;
import com.tydic.nbchat.user.api.UserBaseInfoApi;
import com.tydic.nbchat.user.api.bo.user.UserBaseInfo;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.mq.starter.api.KKMqProducerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TdhCreationRecordServiceImpl
implements TdhCreationRecordApi {
    private static final Logger log = LoggerFactory.getLogger(TdhCreationRecordServiceImpl.class);
    @Resource
    private NameMapper nameMapper;
    @Resource
    private KKMqProducerHelper kkMqProducerHelper;
    @Resource
    private NbchatTrainCourseMapper trainCourseMapper;
    @Resource
    private NbchatTrainSectionsMapper trainSectionsMapper;
    @Resource
    private TdhCreationRecordMapper tdhCreationRecordMapper;
    @Resource
    private TdhCreationHistoryMapper tdhCreationHistoryMapper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
    private UserBaseInfoApi userBaseInfoApi;

    private List<TdhCreationRecordRspBO> packageRspList(List<TdhCreationRecord> result) {
        ArrayList<TdhCreationRecordRspBO> rspList = new ArrayList<TdhCreationRecordRspBO>();
        NiccCommonUtil.copyList(result, rspList, TdhCreationRecordRspBO.class);
        rspList.forEach(list -> {
            Rsp rsp;
            if (StringUtils.isNotEmpty((CharSequence)list.getUserId()) && (rsp = this.userBaseInfoApi.getByUserId(list.getTenantCode(), list.getUserId())).isSuccess()) {
                UserBaseInfo baseInfo = (UserBaseInfo)rsp.getData();
                list.setName(baseInfo.getName());
            }
        });
        return rspList;
    }

    public RspList<TdhCreationRecordRspBO> queryList(TdhCreationRecordReqBO request) {
        TdhCreationRecord cond = new TdhCreationRecord();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        if (ShareType.DEFAULT_SHARE.getCode().equals(request.getIsShare())) {
            cond.setIsShare(null);
        }
        if (ShareType.IS_SHARE.getCode().equals(request.getIsShare())) {
            cond.setUserId(null);
        }
        if (ShareType.ID_SHARE.getCode().equals(request.getIsShare())) {
            cond.setUserId(null);
            cond.setIsShare(null);
        }
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        Page info = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.tdhCreationRecordMapper.selectAll(cond);
        List result = info.getResult();
        return BaseRspUtils.createSuccessRspList(this.packageRspList(result), (long)info.getTotal());
    }

    public RspList<TdhCreationRecordRspBO> queryAdminList(TdhCreationRecordAdminReqBO request) {
        TdhCreationRecordSelectCondition cond = new TdhCreationRecordSelectCondition();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        ArrayList vipItems = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)request.getVipTypes())) {
            NiccCommonUtil.copyList((List)request.getVipTypes(), vipItems, VipItem.class);
        }
        cond.setVipTypes(vipItems);
        log.info("\u6570\u5b57\u4eba\u9762\u677f-\u67e5\u8be2\u8349\u7a3f\u5217\u8868\uff1a{}", (Object)cond);
        try (Page info = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());){
            this.tdhCreationRecordMapper.selectByCondition(cond);
            ArrayList rspList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)info.getResult())) {
                NiccCommonUtil.copyList((List)info.getResult(), rspList, TdhCreationRecordRspBO.class);
            }
            RspList rspList2 = BaseRspUtils.createSuccessRspList(rspList, (long)info.getTotal());
            return rspList2;
        }
    }

    public Rsp<TdhCreationRecordRspBO> queryRecord(TdhCreationRecordReqBO request) {
        TdhCreationRecord res = this.tdhCreationRecordMapper.queryById(request.getCreationId(), "1");
        if (ObjectUtils.isEmpty((Object)res)) {
            return BaseRspUtils.createErrorRsp((String)("\u672a\u627e\u5230\u8be5\u8349\u7a3f\u6216\u5df2\u5931\u6548\uff1a" + request.getCreationId()));
        }
        TdhCreationRecordRspBO rspBO = new TdhCreationRecordRspBO();
        BeanUtils.copyProperties((Object)res, (Object)rspBO);
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public Rsp checkVersion(TdhCreationRecordReqBO request) {
        TdhCreationRecord res = this.tdhCreationRecordMapper.queryById(request.getCreationId(), "1");
        if (ObjectUtils.isEmpty((Object)res)) {
            return BaseRspUtils.createErrorRsp((String)("\u672a\u627e\u5230\u8be5\u8349\u7a3f\u6216\u5df2\u5931\u6548\uff1a" + request.getCreationId()));
        }
        if (!res.getVersion().equals(request.getVersion())) {
            return BaseRspUtils.createErrorRsp((String)("\u6570\u636e\u7248\u672c\u5df2\u8fc7\u671f\uff0c\u5f53\u524d\u7248\u672c\uff1a" + res.getVersion()));
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u7248\u672c\u6821\u9a8c\u6210\u529f");
    }

    @Transactional
    public Rsp save(TdhCreationRecordReqBO request) {
        String courseId = request.getCourseId();
        String sectionId = request.getSectionId();
        TdhCreationRecord save = new TdhCreationRecord();
        if (StringUtils.isBlank((CharSequence)request.getCreationId())) {
            log.info("\u6570\u5b57\u4eba\u9762\u677f-\u521b\u5efa\u8349\u7a3f\uff1a{}", (Object)request.getCreationId());
            BeanUtils.copyProperties((Object)request, (Object)save);
            save.setCreationContent(request.getCreationContent());
            save.setCreationConfig(request.getCreationConfig());
            save.setCreationId(IdWorker.nextAutoIdStr());
            save.setIsShare(ShareType.DEFAULT_SHARE.getCode());
            save.setUpdateTime(new Date());
            this.setVipInfoAndRegisterDays(save, request.getUserId(), request.getTenantCode());
            this.saveTdhCreationHistory(save);
            this.tdhCreationRecordMapper.insertSelective(save);
        } else {
            if ("1".equals(request.getIsValid())) {
                TdhCreationRecord res = this.tdhCreationRecordMapper.queryById(request.getCreationId(), "1");
                if (ObjectUtils.isEmpty((Object)res)) {
                    return BaseRspUtils.createErrorRsp((String)("\u672a\u627e\u5230\u8be5\u8349\u7a3f\u6216\u5df2\u5931\u6548\uff1a" + request.getCreationId()));
                }
                if (!res.getVersion().equals(request.getVersion())) {
                    return BaseRspUtils.createErrorRsp((String)("\u6570\u636e\u7248\u672c\u5df2\u8fc7\u671f\uff0c\u5f53\u524d\u7248\u672c\uff1a" + res.getVersion()));
                }
            }
            BeanUtils.copyProperties((Object)request, (Object)save);
            save.setCreationId(request.getCreationId());
            save.setCreationContent(request.getCreationContent());
            save.setCreationConfig(request.getCreationConfig());
            save.setPartCount(request.getPartCount());
            save.setUpdateTime(new Date());
            save.setUserId(null);
            this.setVipInfoAndRegisterDays(save, request.getUserId(), request.getTenantCode());
            this.saveTdhCreationHistory(save);
            int i = this.tdhCreationRecordMapper.update(save);
            log.info("\u6570\u5b57\u4eba\u9762\u677f-\u66f4\u65b0\u8349\u7a3f\uff1a{}, creation_content = {}", (Object)request.getCreationId(), (Object)(StringUtils.isNotBlank((CharSequence)request.getCreationContent()) ? request.getCreationContent().length() : 0));
            if (i <= 0) {
                return BaseRspUtils.createErrorRsp((String)"\u66f4\u65b0\u8349\u7a3f\u5931\u8d25");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)courseId) && StringUtils.isBlank((CharSequence)sectionId)) {
            NbchatTrainCourse trainCourse = this.trainCourseMapper.selectByPrimaryKey(courseId);
            NbchatTrainCourse nbchatTrainCourse = new NbchatTrainCourse();
            if (trainCourse != null) {
                if (trainCourse.getVideoSource() == 1) {
                    nbchatTrainCourse.setVideoSource(Integer.valueOf(0));
                }
                nbchatTrainCourse.setCourseId(courseId);
                nbchatTrainCourse.setVideoUrl("");
                this.trainCourseMapper.updateByPrimaryKeySelective(nbchatTrainCourse);
                log.info("\u6570\u5b57\u4eba\u9762\u677f-\u66f4\u65b0\u8bfe\u7a0b:{}", (Object)courseId);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)courseId) && StringUtils.isNotBlank((CharSequence)sectionId)) {
            NbchatTrainSections sections = this.trainSectionsMapper.selectByPrimaryKey(sectionId);
            NbchatTrainSections nbchatTrainSections = new NbchatTrainSections();
            if (sections != null) {
                if (sections.getVideoSource() == 1) {
                    nbchatTrainSections.setVideoSource(Integer.valueOf(0));
                }
                nbchatTrainSections.setSectionId(sectionId);
                nbchatTrainSections.setVideoUrl("");
                this.trainSectionsMapper.updateByPrimaryKeySelective(nbchatTrainSections);
                log.info("\u6570\u5b57\u4eba\u9762\u677f-\u66f4\u65b0\u8bfe\u7a0b|\u7ae0\u8282:{}|{}", (Object)courseId, (Object)sectionId);
            }
        }
        save.setCreationContent("");
        return BaseRspUtils.createSuccessRsp((Object)save);
    }

    private void saveTdhCreationHistory(TdhCreationRecord save) {
        if ("0".equals(save.getIsValid())) {
            log.info("\u5220\u9664\u8349\u7a3f\u65e0\u9700\u4fdd\u5b58\u6570\u636e\u5230oss");
            return;
        }
        TdhCreationHistory history = new TdhCreationHistory();
        history.setCreationId(save.getCreationId());
        this.tdhCreationHistoryMapper.insertHistory(history);
        save.setVersion(history.getId());
        this.kkMqProducerHelper.sendMsg("NBCHAT_TRAIN_DRAFT_UPLOAD_OSS_TOPIC", (Object)save);
    }

    private void setVipInfoAndRegisterDays(TdhCreationRecord record, String userId, String tenantCode) {
        VipInfo vipInfo = this.nameMapper.queryVipItem(userId, tenantCode);
        Integer registerDays = this.nameMapper.queryRegDays(userId, tenantCode);
        if (vipInfo != null) {
            record.setVipType(vipInfo.getVipType());
            record.setVipTypeSub(vipInfo.getVipTypeSub());
            record.setVipUseDays(vipInfo.getVipUseDays());
        }
        if (registerDays != null) {
            record.setRegisterDays(registerDays);
        }
    }
}

