/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.admin.api.rp.OpQueryApi;
import com.tydic.nbchat.admin.api.rp.OpQueryVideoBO;
import com.tydic.nbchat.train.api.bo.constants.RedisConstants;
import com.tydic.nbchat.train.api.bo.eums.ShareType;
import com.tydic.nbchat.train.api.bo.eums.TaskStateType;
import com.tydic.nbchat.train.api.bo.eums.VerifyStateEnum;
import com.tydic.nbchat.train.api.bo.tdh.TdhBatchDeleteTaskReqBo;
import com.tydic.nbchat.train.api.bo.tdh.TdhCreationTaskReqBo;
import com.tydic.nbchat.train.api.bo.tdh.TdhCreationTaskRspBo;
import com.tydic.nbchat.train.api.tdh.TdhCreationTaskApi;
import com.tydic.nbchat.train.core.config.UserConcurrencyConfig;
import com.tydic.nbchat.train.core.config.VerifyConfigProperties;
import com.tydic.nbchat.train.mapper.TdhCreationAnalysisMapper;
import com.tydic.nbchat.train.mapper.TdhCreationRecordMapper;
import com.tydic.nbchat.train.mapper.TdhCreationTaskMapper;
import com.tydic.nbchat.train.mapper.po.TdhCreationAnalysis;
import com.tydic.nbchat.train.mapper.po.TdhCreationRecord;
import com.tydic.nbchat.train.mapper.po.TdhCreationTask;
import com.tydic.nbchat.user.api.NbchatUserApi;
import com.tydic.nbchat.user.api.UserBaseInfoApi;
import com.tydic.nbchat.user.api.bo.user.UserBaseInfo;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.redis.RedisZsetHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class TdhCreationTaskServiceImpl
implements TdhCreationTaskApi {
    private static final Logger log = LoggerFactory.getLogger(TdhCreationTaskServiceImpl.class);
    @Resource
    TdhCreationTaskMapper tdhCreationTaskMapper;
    @Resource
    TdhCreationRecordMapper tdhCreationRecordMapper;
    @Resource
    TdhCreationAnalysisMapper tdhCreationAnalysisMapper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=10000)
    private NbchatUserApi userApi;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=10000)
    private UserBaseInfoApi userBaseInfoApi;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=3000)
    private OpQueryApi opQueryApi;
    private final RedisHelper redisHelper;
    private final RedisZsetHelper redisZsetHelper;
    private final UserConcurrencyConfig userConcurrencyConfig;
    private final VerifyConfigProperties verifyConfigProperties;

    public TdhCreationTaskServiceImpl(RedisHelper redisHelper, RedisZsetHelper redisZsetHelper, UserConcurrencyConfig userConcurrencyConfig, VerifyConfigProperties verifyConfigProperties) {
        this.redisHelper = redisHelper;
        this.redisZsetHelper = redisZsetHelper;
        this.userConcurrencyConfig = userConcurrencyConfig;
        this.verifyConfigProperties = verifyConfigProperties;
    }

    public RspList<TdhCreationTaskRspBo> getCreationList(TdhCreationTaskReqBo request) {
        if (StringUtils.isNotBlank((CharSequence)request.getTaskId())) {
            TdhCreationTask task = this.tdhCreationTaskMapper.queryById(request.getTaskId());
            if (ObjectUtils.isNotEmpty((Object)task)) {
                TdhCreationTaskRspBo rspBo = new TdhCreationTaskRspBo();
                BeanUtils.copyProperties((Object)task, (Object)rspBo);
                return BaseRspUtils.createSuccessRspList(List.of(rspBo), (long)1L);
            }
            return BaseRspUtils.createErrorRspList((String)"\u67e5\u8be2\u5931\u8d25\uff1a\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        TdhCreationTask cond = new TdhCreationTask();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        if (ShareType.DEFAULT_SHARE.getCode().equals(request.getIsShare())) {
            cond.setIsShare(null);
        }
        if (ShareType.IS_SHARE.getCode().equals(request.getIsShare())) {
            cond.setUserId(null);
        }
        if (ShareType.ID_SHARE.getCode().equals(request.getIsShare())) {
            cond.setUserId(null);
            cond.setIsShare(null);
        }
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{request.getTargetTenant(), request.getTargetUid()})) {
            cond.setUserId(request.getTargetUid());
            cond.setTenantCode(request.getTargetTenant());
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.tdhCreationTaskMapper.selectAll(cond);
        List result = page.getResult();
        ArrayList rspList = new ArrayList();
        NiccCommonUtil.copyList((List)result, rspList, TdhCreationTaskRspBo.class);
        for (TdhCreationTaskRspBo bo : rspList) {
            Rsp rsp;
            if (ObjectUtils.allNotNull((Object[])new Object[]{bo.getStartTime(), bo.getEndTime()})) {
                bo.setDuration(Long.valueOf((bo.getEndTime().getTime() - bo.getStartTime().getTime()) / 1000L));
            }
            if (ObjectUtils.isEmpty((Object)bo.getEndTime())) {
                bo.setDuration(Long.valueOf((new Date().getTime() - bo.getStartTime().getTime()) / 1000L));
            }
            if (TaskStateType.IN_THE_LINE.getCode().equals(bo.getTaskState())) {
                bo.setQueueNum(Integer.valueOf(this.calQueueNum(bo)));
            }
            this.calculateProcessRate(bo);
            TdhCreationAnalysis record = this.tdhCreationAnalysisMapper.queryById(bo.getTaskId());
            if (ObjectUtils.isNotEmpty((Object)record)) {
                bo.setCreateSource(record.getCreateSource());
            }
            if (StringUtils.isNotEmpty((CharSequence)bo.getUserId())) {
                TdhCreationRecord obj;
                Rsp baseRsp = this.userBaseInfoApi.getByUserId(bo.getTenantCode(), bo.getUserId());
                if (baseRsp.isSuccess()) {
                    UserBaseInfo baseInfo = (UserBaseInfo)baseRsp.getData();
                    bo.setName(baseInfo.getName());
                }
                if (ObjectUtils.isNotEmpty((Object)(obj = this.tdhCreationRecordMapper.querySampleById(bo.getCreationId(), "0")))) {
                    bo.setPreviewUrl(obj.getPreviewUrl());
                    bo.setCreationSource(obj.getCreationSource());
                }
            }
            if (StringUtils.isEmpty((CharSequence)request.getTaskId())) {
                bo.setCreationContent(null);
            }
            bo.setQueueType("0");
            if (TDH_NONE_TYPE.contains(bo.getTdhType())) {
                bo.setQueueType("1");
            }
            if ((rsp = this.opQueryApi.opQueryVideo(bo.getTaskId())).isSuccess()) {
                bo.setViewerCount(Integer.valueOf(((OpQueryVideoBO)rsp.getData()).getViewBySameVideoShareUserNum()));
                bo.setViewNum(Integer.valueOf(((OpQueryVideoBO)rsp.getData()).getPlayBySameVideoShareUserNum()));
                bo.setLikeCount(Integer.valueOf(((OpQueryVideoBO)rsp.getData()).getUpvoteNum()));
            }
            if (!VerifyStateEnum.NOT_PASS.equals(bo.getVerifyState())) continue;
            bo.setPreviewUrl(this.verifyConfigProperties.getHorizontal());
            bo.setPlayUrl(null);
            bo.setVideoUrl(null);
        }
        return BaseRspUtils.createSuccessRspList(rspList, (long)page.getTotal());
    }

    public int calQueueNum(TdhCreationTaskRspBo bo) {
        int queueNum = 0;
        try {
            String id = bo.getTaskId();
            String key = this.determineQueueKey(bo.getTdhType(), bo.getIdleQueue());
            Long rank = this.redisZsetHelper.zSetRank(key, id);
            if (rank == null || rank < 1L) {
                log.info("\u6392\u961f\u60c5\u51b5\uff1a{} | {} | {}", new Object[]{id, key, 1});
                return 1;
            }
            Set preTasks = this.redisZsetHelper.zSetRange(key, Long.valueOf(0L), Long.valueOf(rank - 1L));
            AtomicInteger selfCount = new AtomicInteger(0);
            Map<String, Integer> otherCounts = this.countOtherUserTask(preTasks, bo.getUserId(), selfCount);
            queueNum = this.preQueueNum(otherCounts) + selfCount.get() + 1;
            log.info("\u6392\u961f\u60c5\u51b5\uff1a{} | {} | {}", new Object[]{id, key, queueNum});
        }
        catch (Exception e) {
            log.error("\u8ba1\u7b97\u6392\u961f\u5e8f\u53f7\u5f02\u5e38", (Throwable)e);
        }
        return queueNum;
    }

    private String determineQueueKey(String taskType, String isIdleQueue) {
        if ("1".equals(isIdleQueue)) {
            return TDH_NONE_TYPE.contains(taskType) ? "nbchat-tdh:idle:task_queue_none" : "nbchat-tdh:idle:task_queue_mtk";
        }
        return TDH_NONE_TYPE.contains(taskType) ? "nbchat-tdh:task_queue_none" : "nbchat-tdh:task_queue_mtk";
    }

    private Map<String, Integer> countOtherUserTask(Set<String> objects, String uId, AtomicInteger baseCount) {
        HashMap<String, Integer> userCountMap = new HashMap<String, Integer>();
        for (String tid : objects) {
            String userId = (String)this.redisZsetHelper.hget("nbchat-tdh:task_info:" + tid, "user_id");
            String tenantCode = (String)this.redisZsetHelper.hget("nbchat-tdh:task_info:" + tid, "tenant_code");
            if (uId.equals(userId)) {
                baseCount.set(baseCount.get() + 1);
                continue;
            }
            String userType = (String)this.redisZsetHelper.hget("nbchat-tdh:task_info:" + tid, "user_type");
            if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{userId, tenantCode, userType})) continue;
            String key = tenantCode + "-" + userId + "-" + userType;
            userCountMap.put(key, userCountMap.getOrDefault(key, 0) + 1);
        }
        log.info("\u5f53\u524d\u7528\u6237\u4efb\u52a1\u6570\uff1a{} | \u5176\u4ed6\u7528\u6237\u4efb\u52a1\u6570\uff1a{}", (Object)baseCount.get(), userCountMap);
        return userCountMap;
    }

    private int preQueueNum(Map<String, Integer> userCountMap) {
        int queueNo = 0;
        Map<String, Integer> concurrencyMap = this.userConcurrencyConfig.getUserConcurrencyMap();
        for (Map.Entry<String, Integer> entry : userCountMap.entrySet()) {
            String userType = entry.getKey().split("-")[2];
            Integer userTaskCount = entry.getValue();
            queueNo += Math.min(userTaskCount, concurrencyMap.get(userType));
        }
        return queueNo;
    }

    private void calculateProcessRate(TdhCreationTaskRspBo bo) {
        if (TaskStateType.MISSION_COMPLETED.getCode().equals(bo.getTaskState())) {
            bo.setProcessRate("100%");
        } else if (TaskStateType.GENERATING.getCode().equals(bo.getTaskState())) {
            if (bo.getPartCountTotal() > 1) {
                float partRate = 0.9f * (float)bo.getPartCountDone().intValue() / (float)bo.getPartCountTotal().intValue() * 100.0f;
                bo.setProcessRate(String.format("%.0f%%", Float.valueOf(partRate)));
                String redisKey = RedisConstants.processKey((String)bo.getTaskId());
                if (this.redisHelper.hasKey(redisKey)) {
                    Float processRate = Float.valueOf(((Double)this.redisHelper.get(redisKey)).floatValue());
                    float concatRate = 0.1f * processRate.floatValue();
                    bo.setProcessRate(String.format("%.0f%%", Float.valueOf(partRate + concatRate)));
                }
                if (bo.getPartCountDone() == 0) {
                    bo.setProcessRate("1%");
                }
                if ("100%".equals(bo.getProcessRate()) && TaskStateType.MISSION_COMPLETED.getCode().equals(bo.getTaskState())) {
                    bo.setProcessRate("98%");
                }
            } else {
                Integer esMakeDur = bo.getEstimatedMakeDuration();
                if (esMakeDur != null) {
                    long makeDurSec = (new Date().getTime() - bo.getStartTime().getTime()) / 1000L;
                    if (makeDurSec > (long)esMakeDur.intValue()) {
                        bo.setProcessRate("98%");
                    } else {
                        float partRate = 1.0f * (float)makeDurSec / (float)esMakeDur.intValue() * 100.0f;
                        bo.setProcessRate(String.format("%.0f%%", Float.valueOf(partRate)));
                    }
                }
            }
        } else {
            bo.setProcessRate("0%");
        }
    }

    public Rsp<TdhCreationTaskRspBo> getCreationInfo(TdhCreationTaskReqBo request) {
        TdhCreationTask task = this.tdhCreationTaskMapper.queryById(request.getTaskId());
        if (ObjectUtils.isNotEmpty((Object)task)) {
            TdhCreationTaskRspBo rspBo = new TdhCreationTaskRspBo();
            BeanUtils.copyProperties((Object)task, (Object)rspBo);
            return BaseRspUtils.createSuccessRsp((Object)rspBo);
        }
        return BaseRspUtils.createErrorRsp((String)"\u67e5\u8be2\u5931\u8d25\uff1a\u4efb\u52a1\u4e0d\u5b58\u5728");
    }

    public Rsp delete(TdhCreationTaskReqBo request) {
        log.info("\u6570\u5b57\u4eba\u9762\u677f-\u5220\u9664\u4f5c\u54c1:{}", (Object)request);
        if (StringUtils.isEmpty((CharSequence)request.getTaskId())) {
            return BaseRspUtils.createErrorRsp((String)"\u4f5c\u54c1id\u4e0d\u5f97\u4e3a\u7a7a");
        }
        int i = this.tdhCreationTaskMapper.deleteById(request.getTaskId());
        return BaseRspUtils.createSuccessRsp((Object)i);
    }

    public Rsp batchDelete(TdhBatchDeleteTaskReqBo request) {
        log.info("\u6570\u5b57\u4eba-\u6279\u91cf\u5220\u9664\u4f5c\u54c1:{}--\u5f00\u59cb", (Object)request);
        if (StringUtils.isEmpty((CharSequence)request.getUserId())) {
            return BaseRspUtils.createErrorRsp((String)"\u7528\u6237id\u4e0d\u5f97\u4e3a\u7a7a");
        }
        if (request.getTaskIds() == null || request.getTaskIds().isEmpty()) {
            return BaseRspUtils.createErrorRsp((String)"\u5fc5\u987b\u9009\u62e9\u81f3\u5c11\u4e00\u4e2a\u9700\u8981\u5220\u9664\u7684\u4efb\u52a1");
        }
        int i = 0;
        try {
            i = this.tdhCreationTaskMapper.deleteTasksByUserAndIds(request);
            log.info("\u6570\u5b57\u4eba-\u6279\u91cf\u5220\u9664\u4f5c\u54c1:{}--\u6210\u529f", (Object)request);
        }
        catch (Exception e) {
            log.error("\u6570\u5b57\u4eba-\u6279\u91cf\u5220\u9664\u4f5c\u54c1:{}--\u5931\u8d25\uff1a{}", (Object)request, (Object)e.getMessage());
            return BaseRspUtils.createErrorRsp((String)"\u6570\u5b57\u4eba-\u6279\u91cf\u5220\u9664\u4f5c\u54c1\u5931\u8d25");
        }
        return BaseRspUtils.createSuccessRsp((Object)i);
    }

    public Rsp update(TdhCreationTaskReqBo request) {
        log.info("\u6570\u5b57\u4eba\u9762\u677f-\u66f4\u65b0\u4f5c\u54c1:{}", (Object)request);
        if (StringUtils.isEmpty((CharSequence)request.getTaskId())) {
            return BaseRspUtils.createErrorRsp((String)"\u4f5c\u54c1id\u4e0d\u5f97\u4e3a\u7a7a");
        }
        TdhCreationTask tdhCreationTask = new TdhCreationTask();
        BeanUtils.copyProperties((Object)request, (Object)tdhCreationTask);
        tdhCreationTask.setUserId(null);
        int i = this.tdhCreationTaskMapper.update(tdhCreationTask);
        log.info("\u6570\u5b57\u4eba\u9762\u677f-\u66f4\u65b0\u4f5c\u54c1\u7ed3\u679c:{}", (Object)i);
        return BaseRspUtils.createSuccessRsp((Object)i, (String)"\u66f4\u65b0\u6210\u529f");
    }

    public void add(AtomicInteger var) {
        var.set(var.get() + 10);
    }
}

