/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.alibaba.nacos.common.utils.StringUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.train.api.bo.eums.CustomizeStatusEnum;
import com.tydic.nbchat.train.api.bo.eums.CustomizeType;
import com.tydic.nbchat.train.api.bo.tdh.TdhCustomizeQcUpdateReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhCustomizeRecordModifyStatusReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhCustomizeRecordPriceChangeReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhCustomizeRecordQueryReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhCustomizeRecordQueryRspBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhVirtualAnchorQueryReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhVirtualHumanReqBO;
import com.tydic.nbchat.train.api.tdh.TdhCustomizeRecordOperationsApi;
import com.tydic.nbchat.train.core.busi.TdhAnchorBusiService;
import com.tydic.nbchat.train.core.busi.TdhHumanBusiService;
import com.tydic.nbchat.train.mapper.NameMapper;
import com.tydic.nbchat.train.mapper.TdhCustomizeRecordMapper;
import com.tydic.nbchat.train.mapper.TdhQualInspTempMapper;
import com.tydic.nbchat.train.mapper.TdhVirtualAnchorMapper;
import com.tydic.nbchat.train.mapper.TdhVirtualHumanMapper;
import com.tydic.nbchat.train.mapper.po.TdhCustomizeRecord;
import com.tydic.nbchat.train.mapper.po.TdhCustomizeRecordCondition;
import com.tydic.nbchat.train.mapper.po.TdhVirtualAnchor;
import com.tydic.nbchat.train.mapper.po.TdhVirtualHuman;
import com.tydic.nbchat.user.api.NbchatUserApi;
import com.tydic.nbchat.user.api.NoticeApi;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.eums.CustomizeTypeEnum;
import com.tydic.nbchat.user.api.bo.eums.UserTypeEnum;
import com.tydic.nbchat.user.api.bo.notice.NoticeBO;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class TdhCustomizeRecordOperationsServiceImpl
implements TdhCustomizeRecordOperationsApi {
    private static final Logger log = LoggerFactory.getLogger(TdhCustomizeRecordOperationsServiceImpl.class);
    private final TdhCustomizeRecordMapper tdhCustomizeRecordMapper;
    private final TdhAnchorBusiService tdhAnchorBusiService;
    private final TdhHumanBusiService tdhHumanBusiService;
    private final NameMapper nameMapper;
    private final TdhVirtualAnchorMapper tdhVirtualAnchorMapper;
    private final TdhVirtualHumanMapper tdhVirtualHumanMapper;
    private final TdhQualInspTempMapper tdhQualInspTempMapper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=100000)
    private NbchatUserApi nbchatUserApi;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=100000)
    private NoticeApi noticeApi;

    public TdhCustomizeRecordOperationsServiceImpl(TdhCustomizeRecordMapper tdhCustomizeRecordMapper, TdhAnchorBusiService tdhAnchorBusiService, TdhHumanBusiService tdhHumanBusiService, NameMapper nameMapper, TdhVirtualAnchorMapper tdhVirtualAnchorMapper, TdhVirtualHumanMapper tdhVirtualHumanMapper, TdhQualInspTempMapper tdhQualInspTempMapper) {
        this.tdhCustomizeRecordMapper = tdhCustomizeRecordMapper;
        this.tdhAnchorBusiService = tdhAnchorBusiService;
        this.tdhHumanBusiService = tdhHumanBusiService;
        this.nameMapper = nameMapper;
        this.tdhVirtualHumanMapper = tdhVirtualHumanMapper;
        this.tdhVirtualAnchorMapper = tdhVirtualAnchorMapper;
        this.tdhQualInspTempMapper = tdhQualInspTempMapper;
    }

    public RspList list(TdhCustomizeRecordQueryReqBO reqBO) {
        reqBO.setUserId(null);
        reqBO.setTenantCode(null);
        ArrayList result = new ArrayList();
        if (StringUtils.isNotBlank((String)reqBO.getPhone())) {
            Rsp rsp = this.nbchatUserApi.getUserByPhone(reqBO.getPhone());
            if (!rsp.isSuccess()) {
                log.error("\u8fd0\u8425\u5e73\u53f0-\u5f62\u8c61\u5b9a\u5236-\u624b\u673a\u53f7\u67e5\u8be2-\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0cphone:{}|{}", (Object)reqBO.getPhone(), (Object)rsp.getRspDesc());
                return BaseRspUtils.createSuccessRspList(result, (long)0L);
            }
            NbchatUserInfo nbchatUserInfo = (NbchatUserInfo)rsp.getData();
            if (nbchatUserInfo == null) {
                log.info("\u8fd0\u8425\u5e73\u53f0-\u5f62\u8c61\u5b9a\u5236-\u624b\u673a\u53f7\u67e5\u8be2-\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f\uff0cphone:{}", (Object)reqBO.getPhone());
                return BaseRspUtils.createSuccessRspList(result, (long)0L);
            }
            reqBO.setUserId(nbchatUserInfo.getUserId());
        }
        TdhCustomizeRecordCondition condition = new TdhCustomizeRecordCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)condition);
        if (StringUtils.isNotBlank((String)reqBO.getQcStatus())) {
            condition.setCustomizeStatus(CustomizeStatusEnum.CUSTOMIZE_COMPLETED.getCode());
        }
        if (condition.getQcTimeStart() != null && condition.getQcTimeEnd() != null) {
            condition.setCustomizeStatus(CustomizeStatusEnum.CUSTOMIZE_COMPLETED.getCode());
        }
        Page page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        this.tdhCustomizeRecordMapper.list(condition);
        if (CollectionUtils.isEmpty((Collection)page)) {
            return BaseRspUtils.createSuccessRspList(result, (long)page.getTotal());
        }
        NiccCommonUtil.copyList((List)page.getResult(), result, TdhCustomizeRecordQueryRspBO.class);
        List userList = result.stream().map(TdhCustomizeRecordQueryRspBO::getUserId).collect(Collectors.toList());
        RspList rsp = this.nbchatUserApi.getUserInfoList(userList);
        if (!rsp.isSuccess()) {
            log.error("\u8fd0\u8425\u5e73\u53f0-\u5f62\u8c61\u5b9a\u5236-\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0cuserList:{}|{}", userList, (Object)rsp.getRspDesc());
            return BaseRspUtils.createSuccessRspList(result, (long)page.getTotal());
        }
        List userInfoList = rsp.getRows();
        Map<String, String> userIdToPhoneMap = userInfoList.stream().collect(Collectors.toMap(NbchatUserInfo::getUserId, u -> StringUtils.isNotEmpty((String)u.getPhone()) ? u.getPhone() : ""));
        Map<String, String> userIdToNameMap = userInfoList.stream().collect(Collectors.toMap(NbchatUserInfo::getUserId, NbchatUserInfo::getName));
        List updatedList = result.stream().peek(record -> {
            String name;
            String phone = (String)userIdToPhoneMap.get(record.getUserId());
            if (phone != null) {
                record.setPhone(phone);
            }
            if ((name = (String)userIdToNameMap.get(record.getUserId())) != null) {
                record.setName(name);
            }
            if ("00000000".equals(record.getTenantCode())) {
                record.setUserType(UserTypeEnum.COMMON_USER.getName());
            } else {
                record.setUserType(UserTypeEnum.COMPANY_USER.getName());
            }
        }).collect(Collectors.toList());
        log.info("\u8fd0\u8425\u5e73\u53f0-\u5f62\u8c61\u5b9a\u5236-\u67e5\u8be2\u6210\u529f\uff0creqBO:{}|{}", (Object)reqBO, (Object)page.getTotal());
        return BaseRspUtils.createSuccessRspList(updatedList, (long)page.getTotal());
    }

    public Rsp info(TdhCustomizeRecordQueryReqBO reqBO) {
        TdhCustomizeRecord customizeRecord = this.tdhCustomizeRecordMapper.selectByPrimaryKey(reqBO.getId());
        if (customizeRecord == null) {
            log.error("\u8fd0\u8425\u5e73\u53f0-\u5f62\u8c61\u5b9a\u5236-\u660e\u7ec6\u67e5\u8be2-\u672a\u67e5\u8be2\u5230\u8bb0\u5f55\uff0cid:{}", (Object)reqBO.getId());
            return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u8bb0\u5f55");
        }
        Rsp rsp = this.nbchatUserApi.getUserInfo(customizeRecord.getUserId());
        if (!rsp.isSuccess() || rsp.getData() == null) {
            log.error("\u8fd0\u8425\u5e73\u53f0-\u5f62\u8c61\u5b9a\u5236-\u660e\u7ec6\u67e5\u8be2-\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0cuserId:{}|{}", (Object)customizeRecord.getUserId(), (Object)rsp.getRspDesc());
            return BaseRspUtils.createErrorRsp((String)"\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        NbchatUserInfo userInfo = (NbchatUserInfo)rsp.getData();
        TdhCustomizeRecordQueryRspBO rspBO = new TdhCustomizeRecordQueryRspBO();
        BeanUtils.copyProperties((Object)customizeRecord, (Object)rspBO);
        rspBO.setPhone(userInfo.getPhone());
        rspBO.setName(userInfo.getName());
        rspBO.setCompanyName(this.nameMapper.queryTenantNameByCode(customizeRecord.getTenantCode()));
        if ("00000000".equals(customizeRecord.getTenantCode())) {
            rspBO.setUserType(UserTypeEnum.COMMON_USER.getName());
        } else {
            rspBO.setUserType(UserTypeEnum.COMPANY_USER.getName());
        }
        log.info("\u8fd0\u8425\u5e73\u53f0-\u5f62\u8c61\u5b9a\u5236-\u660e\u7ec6\u67e5\u8be2\u6210\u529f\uff0creqBO:{}|{}", (Object)reqBO, (Object)rspBO);
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    @MethodParamVerifyEnable
    @Transactional(rollbackFor={Exception.class})
    public Rsp priceChange(TdhCustomizeRecordPriceChangeReqBO request) {
        if (request.getOrderPrice() <= 0) {
            log.warn("\u8fd0\u8425\u5e73\u53f0-\u5f62\u8c61\u5b9a\u5236-\u8ba2\u5355\u6539\u4ef7\u5931\u8d25\uff0c\u4ef7\u683c\u4e0d\u5408\u6cd5\uff0crequest:{}", (Object)request);
            return BaseRspUtils.createErrorRsp((String)"\u4ef7\u683c\u4e0d\u5408\u6cd5");
        }
        TdhCustomizeRecord record = this.tdhCustomizeRecordMapper.findByOrderNo(request.getOrderNo());
        TdhCustomizeRecord updated = new TdhCustomizeRecord();
        BeanUtils.copyProperties((Object)request, (Object)updated);
        String orderNo = IdWorker.nextAutoIdStr();
        updated.setOrderNo(orderNo);
        int update = this.tdhCustomizeRecordMapper.updateByOrderNo(updated, request.getOrderNo());
        if (update <= 0) {
            log.error("\u8fd0\u8425\u5e73\u53f0-\u5f62\u8c61\u5b9a\u5236-\u8ba2\u5355\u6539\u4ef7\u5931\u8d25\uff0crequest:{}|{}", (Object)request, (Object)updated);
            return BaseRspUtils.createErrorRsp((String)"\u8ba2\u5355\u6539\u4ef7\u5931\u8d25");
        }
        if (CustomizeType.AUDIO.getCode().equals(record.getCustomizeType())) {
            TdhVirtualAnchor tdhVirtualAnchor = this.tdhVirtualAnchorMapper.findByOrderNoAndUserId(request.getOrderNo(), record.getUserId());
            reqBO = new TdhVirtualAnchor();
            reqBO.setOrderNo(orderNo);
            reqBO.setAnchorId(tdhVirtualAnchor.getAnchorId());
            this.tdhVirtualAnchorMapper.update(reqBO);
        } else {
            TdhVirtualHuman tdhVirtualHuman = this.tdhVirtualHumanMapper.findByOrderNoAndUserId(request.getOrderNo(), record.getUserId());
            reqBO = new TdhVirtualHuman();
            reqBO.setOrderNo(orderNo);
            reqBO.setTdhId(tdhVirtualHuman.getTdhId());
            this.tdhVirtualHumanMapper.update((TdhVirtualHuman)reqBO);
        }
        log.info("\u8fd0\u8425\u5e73\u53f0-\u5f62\u8c61\u5b9a\u5236-\u8ba2\u5355\u6539\u4ef7\u6210\u529f\uff0crequest:{}|{}", (Object)request, (Object)updated);
        TdhCustomizeRecord customizeRecord = this.tdhCustomizeRecordMapper.findByOrderNo(orderNo);
        TdhCustomizeRecordQueryRspBO rspBO = new TdhCustomizeRecordQueryRspBO();
        BeanUtils.copyProperties((Object)customizeRecord, (Object)rspBO);
        return BaseRspUtils.createSuccessRsp((Object)rspBO, (String)"\u8ba2\u5355\u6539\u4ef7\u6210\u529f");
    }

    @MethodParamVerifyEnable
    public Rsp modifyStatus(TdhCustomizeRecordModifyStatusReqBO request) {
        log.info("\u5b9a\u5236-\u4fee\u6539\u72b6\u6001\uff0crequest:{}", (Object)request);
        if (!CustomizeTypeEnum.isExistCode((String)request.getCustomizeType()) || !CustomizeStatusEnum.isExistCode((String)request.getCustomizeStatus()).booleanValue()) {
            return BaseRspUtils.createErrorRsp((String)"\u72b6\u6001\u6216\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
        TdhCustomizeRecord customizeRecord = new TdhCustomizeRecord();
        BeanUtils.copyProperties((Object)request, (Object)customizeRecord);
        int update = this.tdhCustomizeRecordMapper.updateByOrderNo(customizeRecord, request.getOrderNo());
        if (update < 1) {
            return BaseRspUtils.createErrorRsp((String)"\u4fee\u6539\u72b6\u6001\u5931\u8d25");
        }
        TdhCustomizeRecord record = this.tdhCustomizeRecordMapper.findByOrderNo(request.getOrderNo());
        NoticeBO noticeBO = CustomizeTypeEnum.isAudioType((String)request.getCustomizeType()) ? this.handleAudioCustomize(request, record) : this.handleHumanCustomize(request, record);
        this.sendNoticeSilently(noticeBO);
        return BaseRspUtils.createSuccessRsp(null);
    }

    private NoticeBO handleAudioCustomize(TdhCustomizeRecordModifyStatusReqBO req, TdhCustomizeRecord record) {
        TdhVirtualAnchorQueryReqBO anchorReq = new TdhVirtualAnchorQueryReqBO();
        anchorReq.setOrderNo(req.getOrderNo());
        anchorReq.setCustomizeStatus(req.getCustomizeStatus());
        NoticeBO notice = this.baseNotice(record, NoticeBO.Type.AUDIO);
        if (CustomizeStatusEnum.REVIEW_COMPLETED.getCode().equals(req.getCustomizeStatus())) {
            anchorReq.setVolcId(req.getVolcId());
            anchorReq.setDemoUrl(req.getVoiceDemo());
        } else if (CustomizeStatusEnum.CANCEL.getCode().equals(req.getCustomizeStatus())) {
            anchorReq.setIsValid(EntityValidType.DELETE.getCode());
            notice.setAction(NoticeBO.Action.CANCEL);
        } else if (CustomizeStatusEnum.CUSTOMIZE_COMPLETED.getCode().equals(req.getCustomizeStatus())) {
            notice.setAction(NoticeBO.Action.CUSTOM);
        }
        this.tdhAnchorBusiService.updateAnchor(anchorReq);
        return notice;
    }

    private NoticeBO handleHumanCustomize(TdhCustomizeRecordModifyStatusReqBO req, TdhCustomizeRecord record) {
        TdhVirtualHumanReqBO humanReq = new TdhVirtualHumanReqBO();
        humanReq.setOrderNo(req.getOrderNo());
        humanReq.setCustomizeStatus(req.getCustomizeStatus());
        humanReq.setVipFlag(req.getVipFlag());
        NoticeBO notice = this.baseNotice(record, NoticeBO.Type.TDH);
        if (CustomizeStatusEnum.REVIEW_COMPLETED.getCode().equals(req.getCustomizeStatus())) {
            humanReq.setTdhImg(req.getTdhImg());
            humanReq.setTdhImgThu(req.getTdhImg());
        } else if (CustomizeStatusEnum.CANCEL.getCode().equals(req.getCustomizeStatus())) {
            humanReq.setIsValid(EntityValidType.DELETE.getCode());
            notice.setAction(NoticeBO.Action.CANCEL);
        } else if (CustomizeStatusEnum.CUSTOMIZE_COMPLETED.getCode().equals(req.getCustomizeStatus())) {
            notice.setAction(NoticeBO.Action.CUSTOM);
            humanReq.setTdhImg(record.getTdhImg());
            humanReq.setTdhImgThu(record.getTdhImg());
        }
        this.tdhHumanBusiService.updateHuman(humanReq);
        return notice;
    }

    private NoticeBO baseNotice(TdhCustomizeRecord record, NoticeBO.Type type) {
        NoticeBO n = new NoticeBO();
        n.setTenantCode(record.getTenantCode());
        n.setOrderId(record.getOrderNo());
        n.setUserId(record.getUserId());
        n.setType(type);
        return n;
    }

    private void sendNoticeSilently(NoticeBO noticeBO) {
        if (noticeBO == null || noticeBO.getAction() == null) {
            return;
        }
        try {
            this.noticeApi.notice(noticeBO);
        }
        catch (Exception e) {
            log.error("\u901a\u77e5\u53d1\u9001\u5931\u8d25, notice:{}", (Object)noticeBO, (Object)e);
        }
    }

    public Rsp updateQc(TdhCustomizeQcUpdateReqBO request) {
        log.info("\u8fd0\u8425\u5e73\u53f0-\u5f62\u8c61/\u58f0\u97f3\u5b9a\u5236-\u8d28\u68c0\u72b6\u6001\u66f4\u65b0\uff0crequest:{}", (Object)request);
        TdhCustomizeRecord update = new TdhCustomizeRecord();
        update.setOrderNo(request.getOrderNo());
        update.setQcStatus(request.getQcStatus());
        update.setQcDesc(request.getQcDesc());
        update.setUpdateUser(request.get_userId());
        update.setUpdateTime(new Date());
        update.setQcTime(new Date());
        int ret = this.tdhCustomizeRecordMapper.updateByOrderNo(update, request.getOrderNo());
        if (ret <= 0) {
            log.error("\u8fd0\u8425\u5e73\u53f0-\u5f62\u8c61/\u58f0\u97f3\u5b9a\u5236-\u8d28\u68c0\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0crequest:{}|{}", (Object)request, (Object)update);
            return BaseRspUtils.createErrorRsp((String)"\u8d28\u68c0\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty((Collection)request.getQcIds())) {
            this.tdhQualInspTempMapper.addUseCountByPrimaryKeys(request.getQcIds());
        }
        return BaseRspUtils.createSuccessRsp((Object)update.getOrderNo(), (String)"\u8d28\u68c0\u72b6\u6001\u66f4\u65b0\u6210\u529f");
    }
}

