/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.train.api.bo.eums.CustomizePayType;
import com.tydic.nbchat.train.api.bo.eums.CustomizeStatusEnum;
import com.tydic.nbchat.train.api.bo.eums.CustomizeType;
import com.tydic.nbchat.train.api.bo.eums.QCStateEnum;
import com.tydic.nbchat.train.api.bo.tdh.TdhCustomizeRecordQueryReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhCustomizeRecordQueryRspBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhCustomizeRecordShareReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhCustomizeRecordShareRspBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhCustomizeRecordUpdateInfoReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhVirtualAnchorQueryReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhVirtualHumanReqBO;
import com.tydic.nbchat.train.api.tdh.TdhCustomizeRecordApi;
import com.tydic.nbchat.train.core.busi.TdhAnchorBusiService;
import com.tydic.nbchat.train.core.busi.TdhHumanBusiService;
import com.tydic.nbchat.train.core.config.VerifyConfigProperties;
import com.tydic.nbchat.train.core.entity.ExpireEnum;
import com.tydic.nbchat.train.mapper.TdhCustomizeRecordMapper;
import com.tydic.nbchat.train.mapper.po.TdhCustomizeRecord;
import com.tydic.nbchat.user.api.NbchatUserApi;
import com.tydic.nbchat.user.api.NoticeApi;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.eums.UserVipType;
import com.tydic.nbchat.user.api.bo.notice.NoticeBO;
import com.tydic.nbchat.user.api.bo.vip.UserVipBO;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TdhCustomizeRecordServiceImpl
implements TdhCustomizeRecordApi {
    private static final Logger log = LoggerFactory.getLogger(TdhCustomizeRecordServiceImpl.class);
    private final TdhCustomizeRecordMapper tdhCustomizeRecordMapper;
    private final TdhAnchorBusiService tdhAnchorBusiService;
    private final TdhHumanBusiService tdhHumanBusiService;
    private final VerifyConfigProperties verifyConfigProperties;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=100000)
    private NoticeApi noticeApi;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=10000)
    NbchatUserApi nbchatUserApi;

    public TdhCustomizeRecordServiceImpl(TdhCustomizeRecordMapper tdhCustomizeRecordMapper, TdhAnchorBusiService tdhAnchorBusiService, TdhHumanBusiService tdhHumanBusiService, VerifyConfigProperties verifyConfigProperties) {
        this.tdhCustomizeRecordMapper = tdhCustomizeRecordMapper;
        this.tdhAnchorBusiService = tdhAnchorBusiService;
        this.tdhHumanBusiService = tdhHumanBusiService;
        this.verifyConfigProperties = verifyConfigProperties;
    }

    public RspList<TdhCustomizeRecordQueryRspBO> orderList(TdhCustomizeRecordQueryReqBO reqBO) {
        ArrayList result = new ArrayList();
        TdhCustomizeRecord customizeRecord = new TdhCustomizeRecord();
        BeanUtils.copyProperties((Object)reqBO, (Object)customizeRecord);
        customizeRecord.setIsValid(EntityValidType.NORMAL.getCode());
        Page page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        if (CustomizeType.AUDIO.getCode().equals(reqBO.getCustomizeType())) {
            this.tdhCustomizeRecordMapper.findListByAudio(customizeRecord);
        } else {
            this.tdhCustomizeRecordMapper.findListByVideo(customizeRecord);
        }
        if (CollectionUtils.isEmpty((Collection)page)) {
            return BaseRspUtils.createSuccessRspList(result, (long)page.getTotal());
        }
        NiccCommonUtil.copyList((List)page.getResult(), result, TdhCustomizeRecordQueryRspBO.class);
        for (TdhCustomizeRecordQueryRspBO bo : result) {
            if (QCStateEnum.VIOLATION.equals(bo.getQcStatus())) {
                bo.setTdhImg(this.verifyConfigProperties.getVertical());
                bo.setTdhDemo(null);
            }
            if ("00000000".equals(reqBO.getTenantCode())) {
                try {
                    if (CustomizePayType.isProfess((String)bo.getPayType())) {
                        Rsp userInfo = this.nbchatUserApi.getUserInfo(bo.getUserId());
                        if (!userInfo.isSuccess()) continue;
                        UserVipBO vipInfo = ((NbchatUserInfo)userInfo.getData()).getVipInfo();
                        if (UserVipType.isProfessional((String)vipInfo.getVipType())) {
                            String vipStatus = vipInfo.getVipStatus();
                            bo.setIsExpire(vipStatus.equals("1") ? ExpireEnum.no.getCode() : ExpireEnum.yes.getCode());
                            continue;
                        }
                        bo.setIsExpire(ExpireEnum.yes.getCode());
                        continue;
                    }
                    if (!this.isExpire(bo.getEndTime())) continue;
                    bo.setIsExpire(ExpireEnum.yes.getCode());
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38: ", (Throwable)e);
                }
                continue;
            }
            if (!this.isExpire(bo.getEndTime())) continue;
            bo.setIsExpire(ExpireEnum.yes.getCode());
        }
        return BaseRspUtils.createSuccessRspList(result, (long)page.getTotal());
    }

    public boolean isExpire(Date date) {
        return ObjectUtils.isNotEmpty((Object)date) && date.before(new Date());
    }

    @MethodParamVerifyEnable
    public Rsp<TdhCustomizeRecordQueryRspBO> orderInfo(TdhCustomizeRecordQueryReqBO reqBO) {
        TdhCustomizeRecord customizeRecord = this.tdhCustomizeRecordMapper.findByOrderNoAndUserId(reqBO.getOrderNo(), reqBO.getUserId());
        if (customizeRecord == null) {
            log.error("\u6211\u7684\u5b9a\u5236-\u5f62\u8c61\u5b9a\u5236-\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2-\u672a\u67e5\u8be2\u5230\u8bb0\u5f55\uff0cid:{}", (Object)reqBO.getId());
            return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u8bb0\u5f55");
        }
        TdhCustomizeRecordQueryRspBO rspBO = new TdhCustomizeRecordQueryRspBO();
        BeanUtils.copyProperties((Object)customizeRecord, (Object)rspBO);
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    @MethodParamVerifyEnable
    @Transactional(rollbackFor={Exception.class})
    public Rsp updateInfo(TdhCustomizeRecordUpdateInfoReqBO request) {
        TdhCustomizeRecord tdhCustomizeRecord = this.tdhCustomizeRecordMapper.findByOrderNoAndUserId(request.getOrderNo(), request.getUserId());
        if (tdhCustomizeRecord == null) {
            log.error("\u6211\u7684\u5b9a\u5236-\u5f62\u8c61\u5b9a\u5236-\u8ba2\u5355\u4fe1\u606f\u66f4\u65b0-\u672a\u67e5\u8be2\u5230\u8bb0\u5f55\uff0creqBO:{}", (Object)request);
            return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u8bb0\u5f55");
        }
        if (EntityValidType.DELETE.getCode().equals(request.getIsValid()) && CustomizeStatusEnum.CUSTOMIZE_COMPLETED.getCode().equals(tdhCustomizeRecord.getCustomizeType())) {
            log.warn("\u6211\u7684\u5b9a\u5236-\u5f62\u8c61\u5b9a\u5236-\u8ba2\u5355\u4fe1\u606f\u66f4\u65b0-\u5df2\u5b8c\u6210\u7684\u8ba2\u5355\u4e0d\u80fd\u53d6\u6d88\uff0creqBO:{}", (Object)request);
            return BaseRspUtils.createErrorRsp((String)"\u5df2\u5b8c\u6210\u7684\u8ba2\u5355\u4e0d\u80fd\u53d6\u6d88");
        }
        if (request.getCustomizeType().startsWith(CustomizeType.AUDIO.getCode())) {
            request.setTdhName(null);
        } else {
            request.setVoiceName(null);
        }
        TdhCustomizeRecord customizeRecord = new TdhCustomizeRecord();
        BeanUtils.copyProperties((Object)request, (Object)customizeRecord);
        int result = this.tdhCustomizeRecordMapper.updateByOrderNoAndUserId(customizeRecord);
        if (result <= 0) {
            log.error("\u6211\u7684\u5b9a\u5236-\u5f62\u8c61\u5b9a\u5236-\u8ba2\u5355\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff0creqBO:{}|{}", (Object)request, (Object)result);
            return BaseRspUtils.createErrorRsp((String)"\u66f4\u65b0\u5931\u8d25");
        }
        NoticeBO noticeBO = new NoticeBO();
        noticeBO.setTenantCode(request.getTenantCode());
        if (CustomizeType.AUDIO.getCode().equals(customizeRecord.getCustomizeType())) {
            reqBO = new TdhVirtualAnchorQueryReqBO();
            reqBO.setOrderNo(request.getOrderNo());
            reqBO.setUserId(request.getUserId());
            reqBO.setName(request.getVoiceName());
            if (EntityValidType.DELETE.getCode().equals(request.getIsValid())) {
                reqBO.setCustomizeStatus(CustomizeStatusEnum.CANCEL.getCode());
                reqBO.setIsValid(EntityValidType.DELETE.getCode());
                noticeBO.setOrderId(request.getOrderNo());
                noticeBO.setUserId(request.getUserId());
                noticeBO.setType(NoticeBO.Type.AUDIO);
                noticeBO.setAction(NoticeBO.Action.CANCEL);
            }
            this.tdhAnchorBusiService.updateAnchor(reqBO);
            log.info("\u6211\u7684\u5b9a\u5236-\u58f0\u97f3\u5b9a\u5236-\u4fee\u6539\u72b6\u6001\u6210\u529f\uff0crequest:{}|{}", (Object)request, (Object)customizeRecord);
        } else {
            reqBO = new TdhVirtualHumanReqBO();
            reqBO.setOrderNo(request.getOrderNo());
            reqBO.setUserId(request.getUserId());
            reqBO.setTdhName(request.getTdhName());
            if (EntityValidType.DELETE.getCode().equals(request.getIsValid())) {
                reqBO.setIsValid(EntityValidType.DELETE.getCode());
                reqBO.setCustomizeStatus(CustomizeStatusEnum.CANCEL.getCode());
                noticeBO.setOrderId(request.getOrderNo());
                noticeBO.setUserId(request.getUserId());
                noticeBO.setType(NoticeBO.Type.TDH);
                noticeBO.setAction(NoticeBO.Action.CANCEL);
            }
            this.tdhHumanBusiService.updateHuman((TdhVirtualHumanReqBO)reqBO);
            log.info("\u6211\u7684\u5b9a\u5236-\u5f62\u8c61\u5b9a\u5236-\u4fee\u6539\u72b6\u6001\u6210\u529f\uff0crequest:{}|{}", (Object)request, (Object)customizeRecord);
        }
        TdhCustomizeRecord record = this.tdhCustomizeRecordMapper.findByOrderNoAndUserId(request.getOrderNo(), request.getUserId());
        if (EntityValidType.DELETE.getCode().equals(request.getIsValid())) {
            try {
                this.noticeApi.notice(noticeBO);
            }
            catch (Exception e) {
                log.error("\u6211\u7684\u5b9a\u5236-\u5f62\u8c61\u5b9a\u5236-\u4fee\u6539\u72b6\u6001\u5931\u8d25-\u53d1\u9001\u901a\u77e5\u5931\u8d25\uff0creqBO:{}|{}", (Object)request, (Object)e.getMessage());
            }
            record.setCustomizeStatus(CustomizeStatusEnum.CANCEL.getCode());
        }
        TdhCustomizeRecordQueryRspBO rspBO = new TdhCustomizeRecordQueryRspBO();
        BeanUtils.copyProperties((Object)record, (Object)rspBO);
        log.info("\u6211\u7684\u5b9a\u5236-\u5f62\u8c61\u5b9a\u5236-\u8ba2\u5355\u4fe1\u606f\u66f4\u65b0\u6210\u529f\uff0creqBO:{}|{}", (Object)request, (Object)result);
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }

    public Rsp updateFirstViewTime(TdhCustomizeRecordQueryReqBO request) {
        int i = this.tdhCustomizeRecordMapper.updateViewTime(request.getOrderNo(), request.getUserId());
        return BaseRspUtils.createSuccessRsp(null);
    }

    public Rsp updateShare(TdhCustomizeRecordShareReqBO request) {
        TdhCustomizeRecord tdhCustomizeRecord = this.tdhCustomizeRecordMapper.findByOrderNoAndUserId(request.getOrderNo(), request.getUserId());
        if (tdhCustomizeRecord == null) {
            log.error("\u6211\u7684\u5b9a\u5236-\u5f62\u8c61\u5b9a\u5236-\u8ba2\u5355\u4fe1\u606f\u66f4\u65b0-\u672a\u67e5\u8be2\u5230\u8bb0\u5f55\uff0creqBO:{}", (Object)request);
            return BaseRspUtils.createErrorRsp((String)"\u672a\u67e5\u8be2\u5230\u8bb0\u5f55");
        }
        if (CustomizeType.AUDIO.getCode().equals(request.getCustomizeType())) {
            reqBO = new TdhVirtualAnchorQueryReqBO();
            reqBO.setOrderNo(request.getOrderNo());
            reqBO.setUserId(request.getUserId());
            reqBO.setAnchorSource(request.getShareStatus());
            this.tdhAnchorBusiService.updateAnchor(reqBO);
            log.info("\u6211\u7684\u5b9a\u5236-\u58f0\u97f3\u5b9a\u5236-\u4fee\u6539\u79df\u6237\u5171\u4eab\u6210\u529f\uff0crequest:{}|{}", (Object)request, (Object)reqBO);
        } else {
            reqBO = new TdhVirtualHumanReqBO();
            reqBO.setOrderNo(request.getOrderNo());
            reqBO.setUserId(request.getUserId());
            reqBO.setTdhSource(request.getShareStatus());
            this.tdhHumanBusiService.updateHuman((TdhVirtualHumanReqBO)reqBO);
            log.info("\u6211\u7684\u5b9a\u5236-\u5f62\u8c61\u5b9a\u5236-\u4fee\u6539\u79df\u6237\u5171\u4eab\u6210\u529f\uff0crequest:{}|{}", (Object)request, (Object)reqBO);
        }
        TdhCustomizeRecordShareRspBO rspBO = new TdhCustomizeRecordShareRspBO();
        BeanUtils.copyProperties((Object)tdhCustomizeRecord, (Object)rspBO);
        rspBO.setShareStatus(request.getShareStatus());
        log.info("\u6211\u7684\u5b9a\u5236-\u5f62\u8c61\u5b9a\u5236-\u8ba2\u5355\u4fe1\u606f\u66f4\u65b0\u6210\u529f\uff0creqBO:{}", (Object)rspBO);
        return BaseRspUtils.createSuccessRsp((Object)rspBO);
    }
}

