/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.train.api.bo.tdh.TdhFontBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhFontQueryReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhFontQueryRspBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhSubtitleStyleQueryReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhSubtitleStyleQueryRspBO;
import com.tydic.nbchat.train.api.tdh.TdhFontApi;
import com.tydic.nbchat.train.mapper.TdhFontMapper;
import com.tydic.nbchat.train.mapper.TdhSubtitleStyleMapper;
import com.tydic.nbchat.train.mapper.po.TdhFontQueryCondition;
import com.tydic.nbchat.train.mapper.po.TdhSubtitleStyle;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TdhFontServiceImpl
implements TdhFontApi {
    private static final Logger log = LoggerFactory.getLogger(TdhFontServiceImpl.class);
    @Resource
    private TdhFontMapper tdhFontMapper;
    @Resource
    private TdhSubtitleStyleMapper tdhSubtitleStyleMapper;
    private final RedisHelper redisHelper;

    public TdhFontServiceImpl(RedisHelper redisHelper) {
        this.redisHelper = redisHelper;
    }

    public RspList<TdhFontQueryRspBO> getFontList(TdhFontQueryReqBO queryReqBO) {
        ArrayList<TdhFontQueryRspBO> fonts = (ArrayList<TdhFontQueryRspBO>)this.redisHelper.get("nbchat-train:fonts");
        if (fonts != null && !fonts.isEmpty()) {
            return BaseRspUtils.createSuccessRspList(fonts);
        }
        fonts = new ArrayList<TdhFontQueryRspBO>();
        ArrayList fontBOS = new ArrayList();
        TdhFontQueryCondition condition = new TdhFontQueryCondition();
        BeanUtils.copyProperties((Object)queryReqBO, (Object)condition);
        condition.setIsValid(EntityValidType.NORMAL.getCode());
        List fontList = this.tdhFontMapper.selectByCondition(condition);
        NiccCommonUtil.copyList((List)fontList, fontBOS, TdhFontBO.class);
        LinkedHashMap fontMap = new LinkedHashMap();
        for (TdhFontBO tdhFontBO : fontBOS) {
            String family = tdhFontBO.getFamily();
            if (!fontMap.containsKey(family)) {
                fontMap.put(family, new ArrayList());
            }
            ((List)fontMap.get(family)).add(tdhFontBO);
        }
        for (Map.Entry entry : fontMap.entrySet()) {
            fonts.add(new TdhFontQueryRspBO((String)entry.getKey(), (List)entry.getValue()));
        }
        this.redisHelper.set("nbchat-train:fonts", fonts, 604800L);
        return BaseRspUtils.createSuccessRspList(fonts);
    }

    public RspList getSubtitleStyleList(TdhSubtitleStyleQueryReqBO queryReqBO) {
        ArrayList rspBOList = new ArrayList();
        TdhSubtitleStyle condition = new TdhSubtitleStyle();
        BeanUtils.copyProperties((Object)queryReqBO, (Object)condition);
        condition.setIsValid(EntityValidType.NORMAL.getCode());
        Page page = PageHelper.startPage((int)queryReqBO.getPage(), (int)queryReqBO.getLimit());
        this.tdhSubtitleStyleMapper.selectByAll(condition);
        if (CollectionUtils.isEmpty((Collection)page.getResult())) {
            return BaseRspUtils.createSuccessRspList(rspBOList, (long)0L);
        }
        NiccCommonUtil.copyList((List)page.getResult(), rspBOList, TdhSubtitleStyleQueryRspBO.class);
        return BaseRspUtils.createSuccessRspList(rspBOList, (long)page.getTotal());
    }
}

