/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.train.api.bo.eums.StateEnum;
import com.tydic.nbchat.train.api.bo.tdh.TdhForegroundAdminReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhForegroundQueryReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhForegroundQueryRspBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhForegroundSortReqBO;
import com.tydic.nbchat.train.api.tdh.TdhForegroundApi;
import com.tydic.nbchat.train.mapper.TdhForegroundMapper;
import com.tydic.nbchat.train.mapper.po.TdhForeground;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TdhForegroundServiceImpl
implements TdhForegroundApi {
    private static final Logger log = LoggerFactory.getLogger(TdhForegroundServiceImpl.class);
    @Resource
    TdhForegroundMapper tdhForegroundMapper;

    public RspList<TdhForegroundQueryRspBO> getForegroundList(TdhForegroundQueryReqBO reqBO) {
        log.info("\u67e5\u8be2\u524d\u666f\u5217\u8868 - \u79df\u6237: {}, \u7528\u6237: {}", (Object)reqBO.getTenantCode(), (Object)reqBO.getUserId());
        TdhForeground cond = new TdhForeground();
        BeanUtils.copyProperties((Object)reqBO, (Object)cond);
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        cond.setTpState(StateEnum.STATE.AVAILABLE.getCode());
        Page info = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        this.tdhForegroundMapper.selectAll(cond);
        List result = info.getResult();
        ArrayList rspList = new ArrayList();
        NiccCommonUtil.copyList((List)result, rspList, TdhForegroundQueryRspBO.class);
        return BaseRspUtils.createSuccessRspList(rspList, (long)info.getTotal());
    }

    @CacheEvict(cacheNames={"nbchat-train:tdh_foreground"}, allEntries=true)
    public RspList save(TdhForegroundQueryReqBO reqBO) {
        log.info("\u4fdd\u5b58\u524d\u666f - \u79df\u6237: {}, \u6570\u91cf: {}", (Object)reqBO.getTenantCode(), (Object)(reqBO.getUrlList() != null ? reqBO.getUrlList().size() : 0));
        ArrayList rspList = new ArrayList();
        TdhForeground cond = new TdhForeground();
        BeanUtils.copyProperties((Object)reqBO, (Object)cond);
        reqBO.getUrlList().forEach(urlBO -> {
            cond.setObjectId(urlBO.getObjectId());
            cond.setName(urlBO.getName());
            cond.setCategory(urlBO.getCategory());
            cond.setObjectUrl(urlBO.getObjectUrl());
            cond.setObjectType(urlBO.getObjectType());
            cond.setCreateTime(new Date());
            cond.setObjectSource(StateEnum.SOURCE.SELF.getCode());
            cond.setTpState(StateEnum.STATE.AVAILABLE.getCode());
            cond.setIsValid(reqBO.getIsValid());
            cond.setTag(urlBO.getTag());
            cond.setSloop(urlBO.getSloop());
            cond.setObjectConfig(urlBO.getObjectConfig());
            cond.setThumbnail(urlBO.getThumbnail());
            cond.setPreviewUrl(urlBO.getPreviewUrl());
            cond.setDuration(urlBO.getDuration());
            cond.setOrderIndex(urlBO.getOrderIndex());
            if (StringUtils.isNotEmpty((CharSequence)urlBO.getObjectId())) {
                TdhForeground tdhForegroundPo = this.tdhForegroundMapper.queryById(urlBO.getObjectId());
                if (tdhForegroundPo != null && StateEnum.SOURCE.SELF.getCode().equals(tdhForegroundPo.getObjectSource())) {
                    cond.setObjectSource(null);
                    log.info("\u6570\u5b57\u4eba\u9762\u677f-\u66f4\u65b0\u524d\u666f\uff1a{}", (Object)cond);
                    this.tdhForegroundMapper.update(cond);
                }
            } else {
                cond.setObjectId(IdWorker.nextAutoIdStr());
                this.tdhForegroundMapper.insertSelective(cond);
                log.info("\u6570\u5b57\u4eba\u9762\u677f-\u4fdd\u5b58\u524d\u666f\uff1a{}", (Object)cond);
            }
            TdhForegroundQueryRspBO rsp = new TdhForegroundQueryRspBO();
            BeanUtils.copyProperties((Object)cond, (Object)rsp);
            rspList.add(rsp);
        });
        return BaseRspUtils.createSuccessRspList(rspList, (long)rspList.size());
    }

    @CacheEvict(cacheNames={"nbchat-train:tdh_foreground"}, allEntries=true)
    public RspList saveAdmin(TdhForegroundAdminReqBO reqBO) {
        log.info("\u7ba1\u7406\u5458\u4fdd\u5b58\u524d\u666f - \u79df\u6237: {}, \u76ee\u6807\u79df\u6237: {}", (Object)reqBO.getTenantCode(), (Object)reqBO.getTargetTenant());
        ArrayList<TdhForegroundQueryRspBO> rspList = new ArrayList<TdhForegroundQueryRspBO>();
        TdhForeground cond = new TdhForeground();
        BeanUtils.copyProperties((Object)reqBO, (Object)cond);
        this.setDefaultValues(cond, reqBO);
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getObjectId())) {
            if (StringUtils.isBlank((CharSequence)reqBO.getTargetTenant())) {
                cond.setTenantCode(null);
                cond.setUserId(null);
                cond.setObjectSource(null);
            }
            log.info("\u8fd0\u8425\u914d\u7f6e-\u7247\u5934\u7247\u5c3e\u914d\u7f6e\u66f4\u65b0\uff1a{}", (Object)cond);
            this.tdhForegroundMapper.updateAdmin(cond);
        } else {
            cond.setObjectId(IdWorker.nextAutoIdStr());
            cond.setCreateTime(new Date());
            cond.setObjectType(StringUtils.isNotBlank((CharSequence)reqBO.getObjectType()) ? reqBO.getObjectType() : ".png");
            this.tdhForegroundMapper.insertSelective(cond);
            log.info("\u8fd0\u8425\u914d\u7f6e-\u7247\u5934\u7247\u5c3e\u914d\u7f6e\u4fdd\u5b58\uff1a{}", (Object)cond);
        }
        TdhForegroundQueryRspBO rsp = new TdhForegroundQueryRspBO();
        BeanUtils.copyProperties((Object)cond, (Object)rsp);
        rspList.add(rsp);
        return BaseRspUtils.createSuccessRspList(rspList, (long)rspList.size());
    }

    private void setDefaultValues(TdhForeground cond, TdhForegroundAdminReqBO reqBO) {
        String targetTenant = Optional.ofNullable(reqBO.getTargetTenant()).filter(StringUtils::isNotBlank).orElse(reqBO.getTenantCode());
        if (StateEnum.SOURCE.PUBLIC.getCode().equals(reqBO.getTargetTenant()) || StateEnum.SOURCE.SYSTEM.getCode().equals(reqBO.getObjectSource())) {
            cond.setUserId(StateEnum.SOURCE.PUBLIC.getCode());
            cond.setTenantCode("00000000");
            cond.setObjectSource(StateEnum.SOURCE.SYSTEM.getCode());
            cond.setTpState(StringUtils.isNotBlank((CharSequence)reqBO.getTpState()) ? reqBO.getTpState() : StateEnum.STATE.UNAVAILABLE.getCode());
        } else {
            cond.setUserId(targetTenant);
            cond.setTenantCode(targetTenant);
            cond.setObjectSource(StateEnum.SOURCE.SELF.getCode());
            cond.setTpState(StringUtils.isNotBlank((CharSequence)reqBO.getTpState()) ? reqBO.getTpState() : StateEnum.STATE.UNAVAILABLE.getCode());
        }
    }

    public RspList<TdhForegroundQueryRspBO> getForegroundAdminList(TdhForegroundQueryReqBO reqBO) {
        log.info("\u7ba1\u7406\u5458\u67e5\u8be2\u524d\u666f\u5217\u8868 - \u79df\u6237: {}, \u76ee\u6807\u79df\u6237: {}", (Object)reqBO.getTenantCode(), (Object)reqBO.getTargetTenant());
        TdhForeground cond = new TdhForeground();
        BeanUtils.copyProperties((Object)reqBO, (Object)cond);
        cond.setUserId(null);
        String targetTenant = Optional.ofNullable(reqBO.getTargetTenant()).filter(StringUtils::isNotBlank).orElse(reqBO.getTenantCode());
        if (StateEnum.SOURCE.PUBLIC.getCode().equals(reqBO.getTargetTenant())) {
            cond.setUserId(StateEnum.SOURCE.PUBLIC.getCode());
            cond.setTenantCode("00000000");
            cond.setObjectSource(StateEnum.SOURCE.SYSTEM.getCode());
        } else {
            cond.setUserId(targetTenant);
            cond.setTenantCode(targetTenant);
            cond.setObjectSource(StateEnum.SOURCE.SELF.getCode());
        }
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        Page info = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        this.tdhForegroundMapper.selectAdminAll(cond);
        List result = info.getResult();
        ArrayList rspList = new ArrayList();
        NiccCommonUtil.copyList((List)result, rspList, TdhForegroundQueryRspBO.class);
        return BaseRspUtils.createSuccessRspList(rspList, (long)info.getTotal());
    }

    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(cacheNames={"nbchat-train:tdh_foreground"}, allEntries=true)
    public Rsp sort(TdhForegroundSortReqBO reqBO) {
        log.info("\u524d\u666f\u6392\u5e8f - \u6570\u91cf: {}", (Object)(reqBO.getObjectIds() != null ? reqBO.getObjectIds().size() : 0));
        ArrayList foregroundList = new ArrayList();
        IntStream.range(0, reqBO.getObjectIds().size()).forEach(i -> {
            TdhForeground foreground = new TdhForeground();
            foreground.setObjectId((String)reqBO.getObjectIds().get(i));
            foreground.setOrderIndex(Integer.valueOf(i));
            foregroundList.add(foreground);
        });
        this.tdhForegroundMapper.updateBatchSelective(foregroundList);
        return BaseRspUtils.createSuccessRsp((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    public Rsp getForeground(TdhForegroundQueryReqBO reqBO) {
        log.info("\u67e5\u8be2\u524d\u666f\u8be6\u60c5 - ID: {}", (Object)reqBO.getObjectId());
        TdhForeground res = this.tdhForegroundMapper.queryById(reqBO.getObjectId());
        if (res != null) {
            TdhForegroundQueryRspBO rsp = new TdhForegroundQueryRspBO();
            BeanUtils.copyProperties((Object)res, (Object)rsp);
            return BaseRspUtils.createSuccessRsp((Object)rsp);
        }
        log.info("\u672a\u627e\u5230\u8be5\u914d\u7f6e\u6216\u5df2\u5931\u6548\uff1a{}", (Object)reqBO.getObjectId());
        return BaseRspUtils.createErrorRsp((String)"\u672a\u627e\u5230\u8be5\u914d\u7f6e\u9879\u6216\u5df2\u5931\u6548");
    }
}

