/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.admin.api.SysUserStarApi;
import com.tydic.nbchat.admin.api.bo.SysUserStarBo;
import com.tydic.nbchat.admin.api.star.UserStarListRequest;
import com.tydic.nbchat.train.api.bo.eums.StateEnum;
import com.tydic.nbchat.train.api.bo.tdh.TdhIndexHumanQueryRspBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhIndexTemplateDeleteReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhIndexTemplateQueryReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhIndexTemplateQueryRspBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhIndexTemplateSortReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhIndexTemplateStatusReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhVirtualHumanQueryRspBO;
import com.tydic.nbchat.train.api.tdh.TdhIndexTemplateApi;
import com.tydic.nbchat.train.mapper.TdhIndexTemplateMapper;
import com.tydic.nbchat.train.mapper.TdhVirtualHumanMapper;
import com.tydic.nbchat.train.mapper.po.TdhIndexTemplate;
import com.tydic.nbchat.train.mapper.po.TdhVirtualHuman;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class TdhIndexTemplateServiceImpl
implements TdhIndexTemplateApi {
    private static final Logger log = LoggerFactory.getLogger(TdhIndexTemplateServiceImpl.class);
    private final TdhIndexTemplateMapper tdhIndexTemplateMapper;
    private final TdhVirtualHumanMapper tdhVirtualHumanMapper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=10000)
    private SysUserStarApi sysUserStarApi;

    public TdhIndexTemplateServiceImpl(TdhIndexTemplateMapper tdhIndexTemplateMapper, TdhVirtualHumanMapper tdhVirtualHumanMapper) {
        this.tdhIndexTemplateMapper = tdhIndexTemplateMapper;
        this.tdhVirtualHumanMapper = tdhVirtualHumanMapper;
    }

    public RspList<TdhIndexTemplateQueryRspBO> list(TdhIndexTemplateQueryReqBO request) {
        ArrayList rspBOList = new ArrayList();
        TdhIndexTemplate tdhIndexTemplate = new TdhIndexTemplate();
        BeanUtils.copyProperties((Object)request, (Object)tdhIndexTemplate);
        tdhIndexTemplate.setTenantCode(null);
        tdhIndexTemplate.setIsValid(EntityValidType.NORMAL.getCode());
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.tdhIndexTemplateMapper.selectList(tdhIndexTemplate);
        if (CollectionUtils.isEmpty((Collection)page.getResult())) {
            return BaseRspUtils.createSuccessRspList(rspBOList, (long)0L);
        }
        NiccCommonUtil.copyList((List)page.getResult(), rspBOList, TdhIndexTemplateQueryRspBO.class);
        return BaseRspUtils.createSuccessRspList(rspBOList, (long)page.getTotal());
    }

    public Rsp info(TdhIndexTemplateQueryReqBO reqBO) {
        TdhIndexTemplate tdhIndexTemplate = this.tdhIndexTemplateMapper.selectByPrimaryKey(reqBO.getTplId());
        if (tdhIndexTemplate != null) {
            TdhIndexTemplateQueryRspBO rspBO = new TdhIndexTemplateQueryRspBO();
            BeanUtils.copyProperties((Object)tdhIndexTemplate, (Object)rspBO);
            return BaseRspUtils.createSuccessRsp((Object)rspBO, (String)"\u67e5\u8be2\u6210\u529f");
        }
        return BaseRspUtils.createErrorRsp((String)"\u67e5\u8be2\u5931\u8d25-\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u677f");
    }

    public RspList<TdhIndexTemplateQueryRspBO> adminList(TdhIndexTemplateQueryReqBO request) {
        ArrayList rspBOList = new ArrayList();
        TdhIndexTemplate tdhIndexTemplate = new TdhIndexTemplate();
        BeanUtils.copyProperties((Object)request, (Object)tdhIndexTemplate);
        tdhIndexTemplate.setTenantCode(null);
        if (StringUtils.isBlank((CharSequence)request.getIsValid())) {
            tdhIndexTemplate.setIsValid(null);
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.tdhIndexTemplateMapper.selectList(tdhIndexTemplate);
        if (CollectionUtils.isEmpty((Collection)page.getResult())) {
            return BaseRspUtils.createSuccessRspList(rspBOList, (long)0L);
        }
        NiccCommonUtil.copyList((List)page.getResult(), rspBOList, TdhIndexTemplateQueryRspBO.class);
        return BaseRspUtils.createSuccessRspList(rspBOList, (long)page.getTotal());
    }

    public Rsp addTemplate(TdhIndexTemplateQueryReqBO reqBO) {
        try {
            if (StringUtils.isBlank((CharSequence)reqBO.getTplName())) {
                return BaseRspUtils.createErrorRsp((String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getTplType())) {
                return BaseRspUtils.createErrorRsp((String)"\u6a21\u677f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            TdhIndexTemplate template = new TdhIndexTemplate();
            BeanUtils.copyProperties((Object)reqBO, (Object)template);
            template.setTplId(StringUtils.isNotBlank((CharSequence)reqBO.getTplId()) ? reqBO.getTplId() : IdWorker.nextAutoIdStr());
            template.setCreateTime(new Date());
            template.setIsValid(EntityValidType.NORMAL.getCode());
            if (StringUtils.isBlank((CharSequence)template.getStatus())) {
                template.setStatus("0");
            }
            if (template.getOrderIndex() == null) {
                template.setOrderIndex(Integer.valueOf(0));
            }
            template.setTplConfig(this.validateAndFormatJson(template.getTplConfig(), "{}"));
            template.setTplContent(this.validateAndFormatJson(template.getTplContent(), "{}"));
            int result = this.tdhIndexTemplateMapper.insertSelective(template);
            if (result > 0) {
                return BaseRspUtils.createSuccessRsp((Object)template.getTplId(), (String)"\u65b0\u589e\u6a21\u677f\u6210\u529f");
            }
            return BaseRspUtils.createErrorRsp((String)"\u65b0\u589e\u6a21\u677f\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u9996\u9875\u6a21\u677f\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u65b0\u589e\u6a21\u677f\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Rsp updateTemplate(TdhIndexTemplateQueryReqBO reqBO) {
        try {
            int result;
            if (StringUtils.isBlank((CharSequence)reqBO.getTplId())) {
                return BaseRspUtils.createErrorRsp((String)"\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            TdhIndexTemplate existTemplate = this.tdhIndexTemplateMapper.selectByPrimaryKey(reqBO.getTplId());
            if (existTemplate == null) {
                return BaseRspUtils.createErrorRsp((String)"\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            TdhIndexTemplate template = new TdhIndexTemplate();
            BeanUtils.copyProperties((Object)reqBO, (Object)template);
            template.setStatus(null);
            if (StringUtils.isNotBlank((CharSequence)template.getTplConfig())) {
                template.setTplConfig(this.validateAndFormatJson(template.getTplConfig(), "{}"));
            }
            if (StringUtils.isNotBlank((CharSequence)template.getTplContent())) {
                template.setTplContent(this.validateAndFormatJson(template.getTplContent(), "{}"));
            }
            if ((result = this.tdhIndexTemplateMapper.updateByPrimaryKeySelective(template)) > 0) {
                return BaseRspUtils.createSuccessRsp((Object)template.getTplId(), (String)"\u66f4\u65b0\u6a21\u677f\u6210\u529f");
            }
            return BaseRspUtils.createErrorRsp((String)"\u66f4\u65b0\u6a21\u677f\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u9996\u9875\u6a21\u677f\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u66f4\u65b0\u6a21\u677f\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Rsp deleteTemplate(TdhIndexTemplateDeleteReqBO reqBO) {
        try {
            if (reqBO == null || StringUtils.isBlank((CharSequence)reqBO.getTplId())) {
                return BaseRspUtils.createErrorRsp((String)"\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String tplId = reqBO.getTplId();
            TdhIndexTemplate existTemplate = this.tdhIndexTemplateMapper.selectByPrimaryKey(tplId);
            if (existTemplate == null) {
                return BaseRspUtils.createErrorRsp((String)"\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            TdhIndexTemplate template = new TdhIndexTemplate();
            template.setTplId(tplId);
            template.setIsValid(EntityValidType.DELETE.getCode());
            int result = this.tdhIndexTemplateMapper.updateByPrimaryKeySelective(template);
            if (result > 0) {
                return BaseRspUtils.createSuccessRsp((Object)tplId, (String)"\u5220\u9664\u6a21\u677f\u6210\u529f");
            }
            return BaseRspUtils.createErrorRsp((String)"\u5220\u9664\u6a21\u677f\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u9996\u9875\u6a21\u677f\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u5220\u9664\u6a21\u677f\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Rsp sortTemplates(TdhIndexTemplateSortReqBO reqBO) {
        try {
            if (reqBO == null || CollectionUtils.isEmpty((Collection)reqBO.getTplIds())) {
                return BaseRspUtils.createErrorRsp((String)"\u6a21\u677fID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List tplIds = reqBO.getTplIds();
            ArrayList<TdhIndexTemplate> updateList = new ArrayList<TdhIndexTemplate>();
            for (int i = 0; i < tplIds.size(); ++i) {
                String tplId = (String)tplIds.get(i);
                if (StringUtils.isBlank((CharSequence)tplId)) continue;
                TdhIndexTemplate existTemplate = this.tdhIndexTemplateMapper.selectByPrimaryKey(tplId);
                if (existTemplate == null) {
                    return BaseRspUtils.createErrorRsp((String)("\u6a21\u677f\u4e0d\u5b58\u5728\uff1a" + tplId));
                }
                TdhIndexTemplate template = new TdhIndexTemplate();
                template.setTplId(tplId);
                template.setOrderIndex(Integer.valueOf(i));
                updateList.add(template);
            }
            if (!updateList.isEmpty()) {
                int result = this.tdhIndexTemplateMapper.updateBatchSelective(updateList);
                if (result > 0) {
                    return BaseRspUtils.createSuccessRsp((Object)result, (String)"\u6a21\u677f\u6392\u5e8f\u6210\u529f");
                }
                return BaseRspUtils.createErrorRsp((String)"\u6a21\u677f\u6392\u5e8f\u5931\u8d25");
            }
            return BaseRspUtils.createErrorRsp((String)"\u6ca1\u6709\u6709\u6548\u7684\u6a21\u677fID");
        }
        catch (Exception e) {
            log.error("\u9996\u9875\u6a21\u677f\u6392\u5e8f\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u6a21\u677f\u6392\u5e8f\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public Rsp updateTemplateStatus(TdhIndexTemplateStatusReqBO reqBO) {
        try {
            if (reqBO == null || StringUtils.isBlank((CharSequence)reqBO.getTplId())) {
                return BaseRspUtils.createErrorRsp((String)"\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getStatus())) {
                return BaseRspUtils.createErrorRsp((String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String tplId = reqBO.getTplId();
            String status = reqBO.getStatus();
            if (!StateEnum.STATE.UNAVAILABLE.getCode().equals(status) && !StateEnum.STATE.AVAILABLE.getCode().equals(status)) {
                return BaseRspUtils.createErrorRsp((String)"\u72b6\u6001\u503c\u65e0\u6548\uff0c\u53ea\u80fd\u662f0\uff08\u4e0b\u67b6\uff09\u62161\uff08\u4e0a\u67b6\uff09");
            }
            TdhIndexTemplate existTemplate = this.tdhIndexTemplateMapper.selectByPrimaryKey(tplId);
            if (existTemplate == null) {
                return BaseRspUtils.createErrorRsp((String)"\u6a21\u677f\u4e0d\u5b58\u5728");
            }
            if (EntityValidType.DELETE.getCode().equals(existTemplate.getIsValid())) {
                return BaseRspUtils.createErrorRsp((String)"\u6a21\u677f\u5df2\u5220\u9664\uff0c\u65e0\u6cd5\u4fee\u6539\u72b6\u6001");
            }
            if (status.equals(existTemplate.getStatus())) {
                String statusDesc = StateEnum.STATE.AVAILABLE.getCode().equals(status) ? "\u4e0a\u67b6" : "\u4e0b\u67b6";
                return BaseRspUtils.createErrorRsp((String)("\u6a21\u677f\u5df2\u7ecf\u662f" + statusDesc + "\u72b6\u6001"));
            }
            TdhIndexTemplate template = new TdhIndexTemplate();
            template.setTplId(tplId);
            template.setStatus(status);
            int result = this.tdhIndexTemplateMapper.updateByPrimaryKeySelective(template);
            if (result > 0) {
                String operation = StateEnum.STATE.AVAILABLE.getCode().equals(status) ? "\u4e0a\u67b6" : "\u4e0b\u67b6";
                return BaseRspUtils.createSuccessRsp((Object)tplId, (String)("\u6a21\u677f" + operation + "\u6210\u529f"));
            }
            return BaseRspUtils.createErrorRsp((String)"\u6a21\u677f\u72b6\u6001\u66f4\u65b0\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u9996\u9875\u6a21\u677f\u4e0a\u4e0b\u67b6\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)("\u6a21\u677f\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    private String validateAndFormatJson(String jsonStr, String defaultValue) {
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            return defaultValue;
        }
        if (!(jsonStr = jsonStr.trim()).startsWith("{") && !jsonStr.startsWith("[")) {
            log.warn("\u8f93\u5165\u7684\u5b57\u7b26\u4e32\u4e0d\u662f\u6709\u6548\u7684JSON\u683c\u5f0f: {}", (Object)jsonStr);
            return defaultValue;
        }
        try {
            if (jsonStr.startsWith("{") && !jsonStr.endsWith("}")) {
                return defaultValue;
            }
            if (jsonStr.startsWith("[") && !jsonStr.endsWith("]")) {
                return defaultValue;
            }
            return jsonStr;
        }
        catch (Exception e) {
            log.warn("JSON\u683c\u5f0f\u9a8c\u8bc1\u5931\u8d25: {}", (Object)jsonStr, (Object)e);
            return defaultValue;
        }
    }

    public RspList<TdhIndexHumanQueryRspBO> getIndexHumans(TdhIndexTemplateQueryReqBO request) {
        try {
            ArrayList<TdhIndexHumanQueryRspBO> rspBOList = new ArrayList<TdhIndexHumanQueryRspBO>();
            TdhIndexTemplate queryCondition = new TdhIndexTemplate();
            BeanUtils.copyProperties((Object)request, (Object)queryCondition);
            queryCondition.setTplType("human");
            queryCondition.setIsValid(EntityValidType.NORMAL.getCode());
            queryCondition.setStatus(StateEnum.STATE.AVAILABLE.getCode());
            Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
            this.tdhIndexTemplateMapper.selectList(queryCondition);
            if (CollectionUtils.isEmpty((Collection)page.getResult())) {
                return BaseRspUtils.createSuccessRspList(rspBOList, (long)0L);
            }
            ArrayList<String> tplIds = new ArrayList<String>();
            for (TdhIndexTemplate template : page.getResult()) {
                tplIds.add(template.getTplId());
            }
            List humanList = new ArrayList();
            if (!tplIds.isEmpty()) {
                humanList = this.tdhVirtualHumanMapper.selectByTplIds(tplIds);
            }
            HashMap<String, TdhVirtualHuman> humanMap = new HashMap<String, TdhVirtualHuman>();
            for (TdhVirtualHuman human : humanList) {
                if (human == null || !EntityValidType.NORMAL.getCode().equals(human.getIsValid())) continue;
                humanMap.put(human.getTdhId(), human);
            }
            for (TdhIndexTemplate template : page.getResult()) {
                TdhIndexHumanQueryRspBO rspBO = new TdhIndexHumanQueryRspBO();
                BeanUtils.copyProperties((Object)template, (Object)rspBO);
                String tdhId = template.getTplId();
                rspBO.setTdhId(tdhId);
                TdhVirtualHuman human = (TdhVirtualHuman)humanMap.get(tdhId);
                if (human != null) {
                    TdhVirtualHumanQueryRspBO humanInfo = new TdhVirtualHumanQueryRspBO();
                    BeanUtils.copyProperties((Object)human, (Object)humanInfo);
                    rspBO.setHumanInfo(humanInfo);
                }
                rspBOList.add(rspBO);
            }
            this.setFavoriteStatusForHumans(rspBOList, request.getTargetUserId(), request.getTargetTenantCode());
            return BaseRspUtils.createSuccessRspList(rspBOList, (long)page.getTotal());
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u9996\u9875\u6570\u5b57\u4eba\u5217\u8868\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRspList((String)("\u67e5\u8be2\u9996\u9875\u6570\u5b57\u4eba\u5217\u8868\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    private void setFavoriteStatusForHumans(List<TdhIndexHumanQueryRspBO> rspList, String userId, String tenantCode) {
        if (StringUtils.isBlank((CharSequence)userId) || CollectionUtils.isEmpty(rspList)) {
            return;
        }
        try {
            UserStarListRequest starRequest = new UserStarListRequest();
            starRequest.setUserId(userId);
            starRequest.setTenantCode(tenantCode);
            starRequest.setBusiType("tdh_human");
            starRequest.setBusiIds(rspList.stream().map(TdhIndexHumanQueryRspBO::getTdhId).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList()));
            if (starRequest.getBusiIds().isEmpty()) {
                return;
            }
            log.info("\u83b7\u53d6\u7528\u6237\u6536\u85cf\u6570\u636e - \u8bf7\u6c42\u53c2\u6570: {}", (Object)starRequest);
            RspList starRsp = this.sysUserStarApi.getStarList(starRequest);
            log.info("\u83b7\u53d6\u7528\u6237\u6536\u85cf\u6570\u636e - \u54cd\u5e94: {}", (Object)starRsp);
            Map<Object, Object> favoriteMap = new HashMap();
            if (starRsp != null && starRsp.isSuccess() && starRsp.getRows() != null && !starRsp.getRows().isEmpty()) {
                favoriteMap = starRsp.getRows().stream().filter(bo -> bo != null && StringUtils.isNotBlank((CharSequence)bo.getBusiId())).collect(Collectors.toMap(SysUserStarBo::getBusiId, Function.identity(), (existing, replacement) -> existing));
            }
            for (TdhIndexHumanQueryRspBO bo2 : rspList) {
                SysUserStarBo favoriteInfo;
                if (StringUtils.isBlank((CharSequence)bo2.getTdhId())) continue;
                String cleanTdhId = bo2.getTdhId().trim();
                boolean isFavorite = favoriteMap.containsKey(cleanTdhId);
                bo2.setIsFavorite(String.valueOf(isFavorite));
                if (!isFavorite || (favoriteInfo = (SysUserStarBo)favoriteMap.get(cleanTdhId)) == null || favoriteInfo.getCreateTime() == null) continue;
                bo2.setFavoriteTime(favoriteInfo.getCreateTime());
            }
        }
        catch (Exception e) {
            log.error("\u8bbe\u7f6e\u6536\u85cf\u72b6\u6001\u65f6\u53d1\u751f\u5f02\u5e38\uff0cuserId: {}, tenantCode: {}", new Object[]{userId, tenantCode, e});
            for (TdhIndexHumanQueryRspBO bo3 : rspList) {
                bo3.setIsFavorite("false");
            }
        }
    }
}

