/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.train.api.bo.eums.StateEnum;
import com.tydic.nbchat.train.api.bo.eums.TemplateSourceType;
import com.tydic.nbchat.train.api.bo.eums.VipFlagType;
import com.tydic.nbchat.train.api.bo.template.TdhSortBO;
import com.tydic.nbchat.train.api.bo.template.TdhTemplateLayoutBO;
import com.tydic.nbchat.train.api.bo.template.TdhTemplateLayoutRelBO;
import com.tydic.nbchat.train.api.bo.template.TdhTemplateLayoutReq;
import com.tydic.nbchat.train.api.tdh.TdhLayoutApi;
import com.tydic.nbchat.train.mapper.TdhTemplateLayoutMapper;
import com.tydic.nbchat.train.mapper.TdhTemplateLayoutRelMapper;
import com.tydic.nbchat.train.mapper.po.TdhTemplateLayout;
import com.tydic.nbchat.train.mapper.po.TdhTemplateLayoutRel;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class TdhLayoutServiceImpl
implements TdhLayoutApi {
    private static final Logger log = LoggerFactory.getLogger(TdhLayoutServiceImpl.class);
    @Resource
    TdhTemplateLayoutMapper tdhTemplateLayoutMapper;
    @Resource
    TdhTemplateLayoutRelMapper tdhTemplateLayoutRelMapper;

    public Rsp save(TdhTemplateLayoutBO request) {
        log.info("\u4fdd\u5b58\u89c6\u9891\u5e03\u5c40\u4fe1\u606f:{}", (Object)request);
        TdhTemplateLayout po = new TdhTemplateLayout();
        BeanUtils.copyProperties((Object)request, (Object)po);
        if (StringUtils.isNotEmpty((CharSequence)request.getTargetTenantCode())) {
            po.setTenantCode(request.getTargetTenantCode());
        }
        this.setDefaultValues(po, request);
        if (StringUtils.isEmpty((CharSequence)request.getLayoutId())) {
            po.setLayoutId(IdWorker.nextAutoIdStr());
            po.setLayoutState("0");
            po.setCreateTime(new Date());
            po.setCreateBy(request.getUserId());
            this.tdhTemplateLayoutMapper.insertSelective(po);
        } else {
            if (StringUtils.isBlank((CharSequence)request.getTargetTenantCode())) {
                po.setTenantCode(null);
                po.setUserId(null);
                po.setLayoutSource(null);
            }
            po.setUpdateTime(new Date());
            po.setUpdateBy(request.getUserId());
            this.tdhTemplateLayoutMapper.update(po);
        }
        return BaseRspUtils.createSuccessRsp((Object)po.getLayoutId());
    }

    private void setDefaultValues(TdhTemplateLayout po, TdhTemplateLayoutBO reqBO) {
        po.setVipFlag(Optional.ofNullable(po.getVipFlag()).filter(StringUtils::isNotBlank).orElse(VipFlagType.COMMON_USER.getCode()));
        String targetTenant = Optional.ofNullable(reqBO.getTargetTenantCode()).filter(StringUtils::isNotBlank).orElse(reqBO.getTenantCode());
        if (TemplateSourceType.CUSTOM.getCode().equals(reqBO.getLayoutSource())) {
            po.setUserId(reqBO.getUserId());
            po.setTenantCode(targetTenant);
            po.setLayoutState(reqBO.getLayoutState());
            po.setLayoutSource(TemplateSourceType.CUSTOM.getCode());
        } else if (StateEnum.SOURCE.PUBLIC.getCode().equals(reqBO.getTargetTenantCode())) {
            po.setUserId(StateEnum.SOURCE.PUBLIC.getCode());
            po.setTenantCode("00000000");
            po.setLayoutSource(StateEnum.SOURCE.SYSTEM.getCode());
            po.setLayoutState(reqBO.getLayoutState());
        } else {
            po.setUserId(targetTenant);
            po.setTenantCode(targetTenant);
            po.setLayoutSource(StateEnum.SOURCE.SYSTEM.getCode());
            po.setLayoutState(reqBO.getLayoutState());
        }
    }

    public RspList list(TdhTemplateLayoutReq request) {
        ArrayList res = new ArrayList();
        TdhTemplateLayout po = new TdhTemplateLayout();
        BeanUtils.copyProperties((Object)request, (Object)po);
        po.setIsValid(EntityValidType.NORMAL.getCode());
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        log.info("\u67e5\u8be2\u89c6\u9891\u5e03\u5c40\u4fe1\u606f:{}", (Object)po);
        this.tdhTemplateLayoutMapper.selectAll(po);
        List layouts = page.getResult();
        NiccCommonUtil.copyList((List)layouts, res, TdhTemplateLayoutBO.class);
        return BaseRspUtils.createSuccessRspList(res, (long)page.getTotal());
    }

    public Rsp info(TdhTemplateLayoutReq request) {
        log.info("\u67e5\u8be2\u89c6\u9891\u5e03\u5c40\u8be6\u60c5:{}", (Object)request);
        TdhTemplateLayout layout = this.tdhTemplateLayoutMapper.queryById(request.getLayoutId());
        TdhTemplateLayoutBO res = new TdhTemplateLayoutBO();
        if (layout != null) {
            BeanUtils.copyProperties((Object)layout, (Object)res);
        }
        return BaseRspUtils.createSuccessRsp((Object)res);
    }

    public Rsp sort(TdhSortBO request) {
        if (CollectionUtils.isEmpty((Collection)request.getIds())) {
            return BaseRspUtils.createErrorRsp((String)"\u6392\u5e8fID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<TdhTemplateLayout> layouts = new ArrayList<TdhTemplateLayout>();
        for (int i = 0; i < request.getIds().size(); ++i) {
            TdhTemplateLayout item = new TdhTemplateLayout();
            item.setLayoutId((String)request.getIds().get(i));
            item.setOrderIndex(Integer.valueOf(i + 1));
            layouts.add(item);
        }
        this.tdhTemplateLayoutMapper.updateOrderIndexBatch(layouts);
        return BaseRspUtils.createSuccessRsp(null);
    }

    public RspList listByRel(TdhTemplateLayoutReq request) {
        log.info("\u67e5\u8be2\u89c6\u9891\u5e03\u5c40\u5173\u8054\u4fe1\u606f:{}", (Object)request);
        ArrayList res = new ArrayList();
        TdhTemplateLayoutRel po = new TdhTemplateLayoutRel();
        po.setTpId(request.getTpId());
        po.setLayoutId(request.getLayoutId());
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.tdhTemplateLayoutRelMapper.selectAll(po);
        NiccCommonUtil.copyList((List)page.getResult(), res, TdhTemplateLayoutRelBO.class);
        return BaseRspUtils.createSuccessRspList(res, (long)page.getTotal());
    }
}

