/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.train.api.TdhMaterialPackageApi;
import com.tydic.nbchat.train.api.bo.tdh.TdhMaterialLibraryQueryBo;
import com.tydic.nbchat.train.api.bo.tdh.TdhMaterialLibraryRspBo;
import com.tydic.nbchat.train.api.bo.tdh.TdhMaterialPackageQueryBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhMaterialPackageRspBo;
import com.tydic.nbchat.train.mapper.TdhMaterialLibraryMapper;
import com.tydic.nbchat.train.mapper.TdhMaterialPackageMapper;
import com.tydic.nbchat.train.mapper.po.TdhMaterialLibrary;
import com.tydic.nbchat.train.mapper.po.TdhMaterialPackage;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class TdhMaterialPackageServiceImpl
implements TdhMaterialPackageApi {
    private static final Logger log = LoggerFactory.getLogger(TdhMaterialPackageServiceImpl.class);
    private final TdhMaterialPackageMapper tdhMaterialPackageMapper;
    private final TdhMaterialLibraryMapper tdhMaterialLibraryMapper;

    public TdhMaterialPackageServiceImpl(TdhMaterialPackageMapper tdhMaterialPackageMapper, TdhMaterialLibraryMapper tdhMaterialLibraryMapper) {
        this.tdhMaterialPackageMapper = tdhMaterialPackageMapper;
        this.tdhMaterialLibraryMapper = tdhMaterialLibraryMapper;
    }

    public RspList<TdhMaterialPackageRspBo> getMaterialPackageList(TdhMaterialPackageQueryBO request) {
        log.info("\u67e5\u8be2\u56fe\u5e93\u7d20\u6750\u5305\u5217\u8868-\u5f00\u59cb:{}", (Object)request);
        TdhMaterialPackage tdhMaterialPackage = new TdhMaterialPackage();
        BeanUtils.copyProperties((Object)request, (Object)tdhMaterialPackage);
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List list = this.tdhMaterialPackageMapper.selectByCondition(tdhMaterialPackage);
        ArrayList rspList = new ArrayList();
        NiccCommonUtil.copyList((List)list, rspList, TdhMaterialPackageRspBo.class);
        return BaseRspUtils.createSuccessRspList(rspList, (long)page.getTotal());
    }

    public Rsp<TdhMaterialPackageRspBo> saveMaterialPackage(TdhMaterialPackageQueryBO request) {
        log.info("\u4fdd\u5b58\u3001\u66f4\u65b0\u56fe\u5e93\u7d20\u6750\u5305-\u5f00\u59cb:{}", (Object)request);
        TdhMaterialPackage tdhMaterialPackage = new TdhMaterialPackage();
        BeanUtils.copyProperties((Object)request, (Object)tdhMaterialPackage);
        if (StringUtils.isBlank((CharSequence)request.getPkgId())) {
            tdhMaterialPackage.setCreateTime(new Date());
            tdhMaterialPackage.setUpdateTime(new Date());
            tdhMaterialPackage.setIsValid("1");
            tdhMaterialPackage.setStatus("0");
            this.tdhMaterialPackageMapper.insertSelective(tdhMaterialPackage);
        } else {
            tdhMaterialPackage.setUpdateTime(new Date());
            this.tdhMaterialPackageMapper.updateByPrimaryKeySelective(tdhMaterialPackage);
        }
        TdhMaterialPackageRspBo rspBo = new TdhMaterialPackageRspBo();
        BeanUtils.copyProperties((Object)tdhMaterialPackage, (Object)rspBo);
        return BaseRspUtils.createSuccessRsp((Object)rspBo);
    }

    public Rsp deleteMaterialPackage(String pkgId, String isValid) {
        log.info("\u5220\u9664\u7d20\u6750\u5305-\u5f00\u59cb:{}", (Object)pkgId);
        if (StringUtils.isBlank((CharSequence)pkgId)) {
            return BaseRspUtils.createErrorRsp((String)"\u7d20\u6750\u5305ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TdhMaterialPackage materialPackage = new TdhMaterialPackage();
        materialPackage.setPkgId(pkgId);
        materialPackage.setIsValid("0");
        materialPackage.setUpdateTime(new Date());
        this.tdhMaterialPackageMapper.updateByPrimaryKeySelective(materialPackage);
        TdhMaterialLibrary materialLibrary = new TdhMaterialLibrary();
        materialLibrary.setPkgId(pkgId);
        materialLibrary.setIsValid("0");
        materialLibrary.setUpdateTime(new Date());
        this.tdhMaterialLibraryMapper.updateByPkgId(materialLibrary);
        return BaseRspUtils.createSuccessRsp((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    public RspList<TdhMaterialLibraryRspBo> getMaterialPackageAndLibrary(TdhMaterialLibraryQueryBo queryBo) {
        log.info("\u7528\u6237\u83b7\u53d6\u7d20\u6750\u5305\u548c\u56fe\u7247\u7d20\u6750\u4fe1\u606f-\u5f00\u59cb:{}", (Object)queryBo);
        Page page = PageHelper.startPage((int)queryBo.getPage(), (int)queryBo.getLimit());
        List tdhMaterialLibraries = this.tdhMaterialLibraryMapper.selectByPkgId(queryBo.getPkgId());
        ArrayList rspList = new ArrayList();
        NiccCommonUtil.copyList((List)tdhMaterialLibraries, rspList, TdhMaterialLibraryRspBo.class);
        return BaseRspUtils.createSuccessRspList(rspList, (long)page.getTotal());
    }

    public RspList<TdhMaterialLibraryRspBo> getMaterialLibraryId(TdhMaterialLibraryQueryBo queryBo) {
        log.info("\u6839\u636e\u7d20\u6750\u5305id\u67e5\u8be2\u56fe\u7247\u7d20\u6750\u4fe1\u606f-\u5f00\u59cb:{}", (Object)queryBo);
        Page page = PageHelper.startPage((int)queryBo.getPage(), (int)queryBo.getLimit());
        List tdhMaterialLibraries = this.tdhMaterialLibraryMapper.selectByPkgId(queryBo.getPkgId());
        ArrayList rspList = new ArrayList();
        NiccCommonUtil.copyList((List)tdhMaterialLibraries, rspList, TdhMaterialLibraryRspBo.class);
        return BaseRspUtils.createSuccessRspList(rspList, (long)page.getTotal());
    }

    public Rsp<TdhMaterialLibraryRspBo> saveMaterialLibrary(TdhMaterialLibraryQueryBo queryBo) {
        log.info("\u4fdd\u5b58\u3001\u66f4\u65b0\u56fe\u7247\u7d20\u6750-\u5f00\u59cb:{}", (Object)queryBo);
        ArrayList<TdhMaterialLibrary> materialLibraryList = new ArrayList<TdhMaterialLibrary>();
        for (TdhMaterialLibraryRspBo item : queryBo.getMaterialLibraryList()) {
            TdhMaterialLibrary materialLibrary = new TdhMaterialLibrary();
            BeanUtils.copyProperties((Object)item, (Object)materialLibrary);
            if (StringUtils.isNotBlank((CharSequence)materialLibrary.getName()) && materialLibrary.getName().length() > 45) {
                materialLibrary.setName(materialLibrary.getName().substring(0, 45));
            }
            if (StringUtils.isBlank((CharSequence)item.getId())) {
                materialLibrary.setPkgId(queryBo.getPkgId());
                materialLibrary.setCreateTime(new Date());
                materialLibrary.setUpdateTime(new Date());
                materialLibrary.setIsValid("1");
                materialLibraryList.add(materialLibrary);
                continue;
            }
            materialLibrary.setUpdateTime(new Date());
            this.tdhMaterialLibraryMapper.updateByPrimaryKeySelective(materialLibrary);
        }
        if (!materialLibraryList.isEmpty()) {
            this.tdhMaterialLibraryMapper.batchInsert(materialLibraryList);
        }
        ArrayList rspList = new ArrayList();
        NiccCommonUtil.copyList(materialLibraryList, rspList, TdhMaterialLibraryRspBo.class);
        return BaseRspUtils.createSuccessRsp((Object)"\u64cd\u4f5c\u6210\u529f");
    }
}

