/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.tydic.nbchat.train.api.bo.tdh.TdhNoticeTaskBO;
import com.tydic.nbchat.train.api.tdh.TdhNoticeApi;
import com.tydic.nbchat.user.api.NbchatUserApi;
import com.tydic.nbchat.user.api.UserService;
import com.tydic.nbchat.user.api.bo.AuthUserReqBO;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TdhNoticeServiceImpl
implements TdhNoticeApi {
    private static final Logger log = LoggerFactory.getLogger(TdhNoticeServiceImpl.class);
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
    private NbchatUserApi nbchatUserApi;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=100000)
    private UserService userService;

    public Rsp sendNotice(TdhNoticeTaskBO request) {
        log.info("\u8981\u53d1\u9001\u901a\u77e5\u7684\u4efb\u52a1\uff1a{}", (Object)request);
        Rsp userInfo = this.nbchatUserApi.getUserInfo(request.getUserId());
        if (!userInfo.isSuccess()) {
            return BaseRspUtils.createErrorRsp((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        String phone = ((NbchatUserInfo)userInfo.getData()).getPhone();
        AuthUserReqBO reqBO = AuthUserReqBO.builder().smsTempCode(request.getSmsTempCode()).keyword(request.getCreationName()).phone(phone).build();
        return this.userService.sendSMSCommon(reqBO);
    }
}

