/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.tydic.nbchat.train.api.bo.tdh.TdhObjectShareBO;
import com.tydic.nbchat.train.api.tdh.TdhObjectShareApi;
import com.tydic.nbchat.train.mapper.TdhObjectShareMapper;
import com.tydic.nbchat.train.mapper.TdhTemplateMapper;
import com.tydic.nbchat.train.mapper.TdhVirtualAnchorMapper;
import com.tydic.nbchat.train.mapper.TdhVirtualHumanMapper;
import com.tydic.nbchat.train.mapper.po.TdhObjectShare;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TdhObjectShareServiceImpl
implements TdhObjectShareApi {
    private static final Logger log = LoggerFactory.getLogger(TdhObjectShareServiceImpl.class);
    @Resource
    TdhObjectShareMapper tdhObjectShareMapper;
    @Resource
    TdhVirtualHumanMapper tdhVirtualHumanMapper;
    @Resource
    TdhVirtualAnchorMapper tdhVirtualAnchorMapper;
    @Resource
    TdhTemplateMapper tdhTemplateMapper;

    public RspList queryShareList(TdhObjectShareBO request) {
        TdhObjectShare cond = new TdhObjectShare();
        cond.setObjectType(request.getObjectType());
        cond.setShareTo(request.getTenantCode());
        List tenantShares = this.tdhObjectShareMapper.selectAll(cond);
        cond.setShareTo(request.getUserId());
        List userShares = this.tdhObjectShareMapper.selectAll(cond);
        tenantShares.addAll(userShares);
        List data = new ArrayList();
        List collect = tenantShares.stream().map(TdhObjectShare::getObjectId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            if ("human".equals(request.getObjectType())) {
                data = this.tdhVirtualHumanMapper.selectByIds(collect);
            }
            if ("anchor".equals(request.getObjectType())) {
                data = this.tdhVirtualAnchorMapper.selectByIds(collect);
            }
            if ("template".equals(request.getObjectType())) {
                data = this.tdhTemplateMapper.selectByIds(collect);
            }
        }
        log.info("\u5171\u4eab\u5217\u8868\u67e5\u8be2\u7ed3\u679c:{}/\u6761", (Object)collect.size());
        return BaseRspUtils.createSuccessRspList(data);
    }
}

