/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.train.api.bo.tdh.TdhPipQueryReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhPipQueryRspBO;
import com.tydic.nbchat.train.api.tdh.TdhPipApi;
import com.tydic.nbchat.train.mapper.TdhPipMapper;
import com.tydic.nbchat.train.mapper.po.TdhPip;
import com.tydic.nbchat.train.mapper.po.TdhPipCondition;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TdhPipServiceImpl
implements TdhPipApi {
    private static final Logger log = LoggerFactory.getLogger(TdhPipServiceImpl.class);
    private final TdhPipMapper tdhPipMapper;

    @Transactional(rollbackFor={Exception.class})
    public RspList AddPip(TdhPipQueryReqBO reqBO) {
        ArrayList rspList = new ArrayList();
        TdhPip tdhPip = new TdhPip();
        BeanUtils.copyProperties((Object)reqBO, (Object)tdhPip);
        reqBO.getUrlList().forEach(pipUrlBO -> {
            String id = IdWorker.nextAutoIdStr();
            tdhPip.setName(pipUrlBO.getName());
            tdhPip.setPipUrl(pipUrlBO.getPipUrl());
            tdhPip.setCategory(pipUrlBO.getCategory());
            tdhPip.setPipDesc(pipUrlBO.getPipDesc());
            tdhPip.setPipType(pipUrlBO.getPipType());
            tdhPip.setDuration(pipUrlBO.getDuration());
            tdhPip.setFirstFrame(pipUrlBO.getFirstFrame());
            tdhPip.setIsValid("1");
            tdhPip.setCreateTime(new Date());
            tdhPip.setPipId(id);
            tdhPip.setPipSource("1");
            tdhPip.setTag(reqBO.getTag() == null ? "pip" : reqBO.getTag());
            int save = this.tdhPipMapper.insertSelective(tdhPip);
            log.info("\u65b0\u589e\u753b\u4e2d\u753b\u8bb0\u5f55\uff1a{}", (Object)save);
            if (save != 1) {
                log.info("\u65b0\u589e\u753b\u4e2d\u753b\u5931\u8d25");
            }
            log.info("\u65b0\u589e\u753b\u4e2d\u753b\u6210\u529f");
            TdhPipQueryRspBO tdhPipQueryRspBO = new TdhPipQueryRspBO();
            BeanUtils.copyProperties((Object)tdhPip, (Object)tdhPipQueryRspBO);
            rspList.add(tdhPipQueryRspBO);
        });
        return BaseRspUtils.createSuccessRspList(rspList, (long)rspList.size());
    }

    @Transactional(rollbackFor={Exception.class})
    public RspList update(TdhPipQueryReqBO reqBO) {
        ArrayList rspBOList = new ArrayList();
        TdhPip tdhPip = new TdhPip();
        BeanUtils.copyProperties((Object)reqBO, (Object)tdhPip);
        tdhPip.setIsValid(null);
        tdhPip.setCreateTime(null);
        reqBO.getUrlList().forEach(pipUrlBO -> {
            tdhPip.setPipId(pipUrlBO.getPipId());
            tdhPip.setName(pipUrlBO.getName());
            tdhPip.setPipUrl(pipUrlBO.getPipUrl());
            tdhPip.setCategory(pipUrlBO.getCategory());
            tdhPip.setPipDesc(pipUrlBO.getPipDesc());
            tdhPip.setPipType(pipUrlBO.getPipType());
            tdhPip.setDuration(pipUrlBO.getDuration());
            tdhPip.setFirstFrame(pipUrlBO.getFirstFrame());
            int update = this.tdhPipMapper.update(tdhPip);
            if (update != 1) {
                log.info("\u4fee\u6539\u753b\u4e2d\u753b\u5931\u8d25");
            }
            log.info("\u4fee\u6539\u753b\u4e2d\u753b\u6210\u529f");
            TdhPipQueryRspBO tdhPipQueryRspBO = new TdhPipQueryRspBO();
            BeanUtils.copyProperties((Object)tdhPip, (Object)tdhPipQueryRspBO);
            rspBOList.add(tdhPipQueryRspBO);
        });
        return BaseRspUtils.createSuccessRspList(rspBOList, (long)rspBOList.size());
    }

    public RspList queryRecentHistory(TdhPipQueryReqBO reqBO) {
        ArrayList rspBOList = new ArrayList();
        TdhPipCondition condition = new TdhPipCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)condition);
        condition.setTag(reqBO.getTag() == null ? "pip" : reqBO.getTag());
        if (reqBO.getTargetTenantCode() != null && !reqBO.getTargetTenantCode().isEmpty()) {
            condition.setUserId(null);
        }
        if ("image".equals(reqBO.getFileType())) {
            condition.setPipTypes(Arrays.asList("png", "jpg", "gif"));
        } else if ("video".equals(reqBO.getFileType())) {
            condition.setPipTypes(Arrays.asList("mp4", "avi", "mov"));
        }
        Page page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        log.info("\u67e5\u8be2\u6700\u8fd120\u6761\u4e0a\u4f20\u8bb0\u5f55-condition\uff1a{}", (Object)condition);
        List pipList = this.tdhPipMapper.selectPipRecentHistoryByCondition(condition);
        if (CollectionUtils.isEmpty((Collection)pipList)) {
            log.info("\u67e5\u8be2\u6700\u8fd120\u6761\u4e0a\u4f20\u8bb0\u5f55-\u7ed3\u679c\u4e3a\u7a7a");
            return BaseRspUtils.createSuccessRspList(rspBOList);
        }
        log.info("\u67e5\u8be2\u6700\u8fd120\u6761\u4e0a\u4f20\u8bb0\u5f55-\u7ed3\u679c\uff1a{}", (Object)pipList);
        NiccCommonUtil.copyList((List)page.getResult(), rspBOList, TdhPipQueryRspBO.class);
        log.info("\u67e5\u8be2\u6700\u8fd120\u6761\u4e0a\u4f20\u8bb0\u5f55-\u7ed3\u679c\uff1a{}|{}", (Object)page.getTotal(), rspBOList);
        return BaseRspUtils.createSuccessRspList(rspBOList, (long)page.getTotal());
    }

    public Rsp query(TdhPipQueryReqBO reqBO) {
        TdhPip tdhPip = this.tdhPipMapper.queryById(reqBO.getPipId());
        if (StringUtils.isEmpty((Object)tdhPip)) {
            log.info("\u67e5\u8be2\u753b\u4e2d\u753b\u5931\u8d25");
            return BaseRspUtils.createErrorRsp((String)"\u67e5\u8be2\u5931\u8d25");
        }
        log.info("\u67e5\u8be2\u753b\u4e2d\u753b\u6210\u529f:{}", (Object)tdhPip);
        return BaseRspUtils.createSuccessRsp((Object)tdhPip, (String)"\u67e5\u8be2\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp delete(TdhPipQueryReqBO reqBO) {
        TdhPip tdhPip = new TdhPip();
        tdhPip.setIsValid("0");
        tdhPip.setPipId(reqBO.getPipId());
        log.info("\u5220\u9664\u753b\u4e2d\u753b\uff1atdhPip-{}", (Object)tdhPip);
        int delete = this.tdhPipMapper.update(tdhPip);
        if (delete != 1) {
            log.info("\u5220\u9664\u753b\u4e2d\u753b\u5931\u8d25");
            return BaseRspUtils.createErrorRsp((String)"\u5220\u9664\u5931\u8d25");
        }
        log.info("\u5220\u9664\u753b\u4e2d\u753b\u6210\u529f");
        return BaseRspUtils.createSuccessRsp((Object)"\u5220\u9664\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp isShare(TdhPipQueryReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getShareStatus())) {
            return BaseRspUtils.createErrorRsp((String)"\u4f01\u4e1a\u5171\u4eab\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getPipId())) {
            return BaseRspUtils.createErrorRsp((String)"\u4f01\u4e1a\u5171\u4eabId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        TdhPip tdhPip = new TdhPip();
        tdhPip.setPipSource(reqBO.getShareStatus());
        tdhPip.setPipId(reqBO.getPipId());
        log.info("\u4f01\u4e1a\u5171\u4eab\uff1atdhPip-{}", (Object)tdhPip);
        int delete = this.tdhPipMapper.update(tdhPip);
        if (delete != 1) {
            log.info("\u4f01\u4e1a\u5171\u4eab\u5931\u8d25");
            return BaseRspUtils.createErrorRsp((String)"\u4f01\u4e1a\u5171\u4eab\u5931\u8d25");
        }
        log.info("\u4f01\u4e1a\u5171\u4eab\u6210\u529f");
        return BaseRspUtils.createSuccessRsp((Object)"\u4f01\u4e1a\u5171\u4eab\u6210\u529f");
    }

    public TdhPipServiceImpl(TdhPipMapper tdhPipMapper) {
        this.tdhPipMapper = tdhPipMapper;
    }
}

