/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.train.api.bo.tdh.TdhPortfolioObjectReqBo;
import com.tydic.nbchat.train.api.bo.tdh.TdhPortfolioObjectRspBo;
import com.tydic.nbchat.train.api.bo.tdh.TdhPortfolioQueryReqBo;
import com.tydic.nbchat.train.api.bo.tdh.TdhPortfolioQueryRspBo;
import com.tydic.nbchat.train.api.bo.tdh.TdhPortfolioReqBo;
import com.tydic.nbchat.train.api.bo.tdh.TdhPortfolioRspBo;
import com.tydic.nbchat.train.api.tdh.TdhPortfolioApi;
import com.tydic.nbchat.train.mapper.TdhPortfolioMapper;
import com.tydic.nbchat.train.mapper.TdhPortfolioObjectRelMapper;
import com.tydic.nbchat.train.mapper.po.TdhPortfolio;
import com.tydic.nbchat.train.mapper.po.TdhPortfolioObjectRel;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TdhPortfolioServiceImpl
implements TdhPortfolioApi {
    private static final Logger log = LoggerFactory.getLogger(TdhPortfolioServiceImpl.class);
    @Resource
    private TdhPortfolioMapper tdhPortfolioMapper;
    @Resource
    private TdhPortfolioObjectRelMapper tdhPortfolioObjectRelMapper;

    public RspList<TdhPortfolioQueryRspBo> getCreationList(TdhPortfolioQueryReqBo reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getUserId())) {
            BaseRspUtils.createErrorRspList((String)"\u4f5c\u54c1\u96c6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        TdhPortfolio portfolio = new TdhPortfolio();
        BeanUtils.copyProperties((Object)reqBO, (Object)portfolio);
        portfolio.setIsValid(EntityValidType.NORMAL.getCode());
        Page info = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        this.tdhPortfolioMapper.selectAll(portfolio);
        List result = info.getResult();
        ArrayList rspList = new ArrayList();
        NiccCommonUtil.copyList((List)result, rspList, TdhPortfolioQueryRspBo.class);
        return BaseRspUtils.createSuccessRspList(rspList, (long)info.getTotal());
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp save(TdhPortfolioReqBo reqBO) {
        log.info("\u4fdd\u5b58\u4f5c\u54c1\u96c6:{}", (Object)reqBO);
        TdhPortfolio portfolio = new TdhPortfolio();
        BeanUtils.copyProperties((Object)reqBO, (Object)portfolio);
        portfolio.setCreateTime(new Date());
        portfolio.setIsValid(EntityValidType.NORMAL.getCode());
        if (StringUtils.isEmpty((CharSequence)reqBO.getPortId())) {
            portfolio.setPortId(IdWorker.nextAutoIdStr());
            this.tdhPortfolioMapper.insert(portfolio);
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getWorksList())) {
                this.insertPortfolioObjectRel(reqBO, portfolio);
            }
        } else {
            portfolio.setUpdateTime(new Date());
            portfolio.setUpdateUser(reqBO.getUserId());
            this.tdhPortfolioMapper.update(portfolio);
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getWorksList())) {
                this.tdhPortfolioObjectRelMapper.deleteByPortId(reqBO.getPortId());
                this.insertPortfolioObjectRel(reqBO, portfolio);
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u4fdd\u5b58\u6210\u529f");
    }

    private void insertPortfolioObjectRel(TdhPortfolioReqBo reqBO, TdhPortfolio portfolio) {
        ArrayList<TdhPortfolioObjectRel> objectRelList = new ArrayList<TdhPortfolioObjectRel>();
        for (TdhPortfolioObjectReqBo objectReqBo : reqBO.getWorksList()) {
            TdhPortfolioObjectRel rel = new TdhPortfolioObjectRel();
            rel.setPortId(portfolio.getPortId());
            rel.setObjectId(objectReqBo.getObjectId());
            rel.setOrderIndex(objectReqBo.getOrderIndex());
            rel.setUserId(portfolio.getUserId());
            rel.setCreateTime(portfolio.getCreateTime());
            objectRelList.add(rel);
        }
        this.tdhPortfolioObjectRelMapper.insertBatch(objectRelList);
    }

    public Rsp getTdhPortfolio(TdhPortfolioQueryReqBo reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getUserId())) {
            BaseRspUtils.createErrorRspList((String)"\u4f5c\u54c1\u96c6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        TdhPortfolioRspBo rspBo = new TdhPortfolioRspBo();
        TdhPortfolio portfolio = this.tdhPortfolioMapper.selectByPortId(reqBO.getPortId());
        BeanUtils.copyProperties((Object)portfolio, (Object)rspBo);
        TdhPortfolioObjectRel rel = new TdhPortfolioObjectRel();
        rel.setPortId(reqBO.getPortId());
        rel.setUserId(reqBO.getUserId());
        List objectRelList = this.tdhPortfolioObjectRelMapper.getList(rel);
        ArrayList objectRelBOList = new ArrayList();
        NiccCommonUtil.copyList((List)objectRelList, objectRelBOList, TdhPortfolioObjectRspBo.class);
        rspBo.setWorksList(objectRelBOList);
        return BaseRspUtils.createSuccessRsp((Object)rspBo);
    }
}

