/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.admin.api.SysUserStarApi;
import com.tydic.nbchat.admin.api.bo.eum.StarType;
import com.tydic.nbchat.admin.api.star.UserStarRequest;
import com.tydic.nbchat.train.api.bo.eums.StateEnum;
import com.tydic.nbchat.train.api.bo.eums.TemplateSourceType;
import com.tydic.nbchat.train.api.bo.eums.VipFlagType;
import com.tydic.nbchat.train.api.bo.tdh.TdhHotTemplateQueryRspBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhTemplateQueryReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhTemplateQueryRspBO;
import com.tydic.nbchat.train.api.bo.template.TdhTemplateLayoutRelBO;
import com.tydic.nbchat.train.api.tdh.TdhTemplateApi;
import com.tydic.nbchat.train.mapper.TdhTemplateLayoutRelMapper;
import com.tydic.nbchat.train.mapper.TdhTemplateMapper;
import com.tydic.nbchat.train.mapper.po.TdhTemplate;
import com.tydic.nbchat.train.mapper.po.TdhTemplateLayoutRel;
import com.tydic.nbchat.train.mapper.po.TdhTemplateSelectCondition;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TdhTemplateServiceImpl
implements TdhTemplateApi {
    private static final Logger log = LoggerFactory.getLogger(TdhTemplateServiceImpl.class);
    @Resource
    TdhTemplateMapper tdhTemplateMapper;
    @Resource
    TdhTemplateLayoutRelMapper tdhTemplateLayoutRelMapper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=100000)
    private SysUserStarApi sysUserStarApi;

    public RspList<TdhTemplateQueryRspBO> getTemplateList(TdhTemplateQueryReqBO reqBO) {
        log.info("\u67e5\u8be2\u6a21\u677f\u5217\u8868 - \u79df\u6237: {}, \u7528\u6237: {}", (Object)reqBO.getTenantCode(), (Object)reqBO.getUserId());
        TdhTemplateSelectCondition cond = new TdhTemplateSelectCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)cond);
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        cond.setTpState(StateEnum.STATE.AVAILABLE.getCode());
        Page info = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        this.tdhTemplateMapper.queryTmplLayoutRels(cond);
        List result = info.getResult();
        ArrayList<TdhTemplateQueryRspBO> rspList = new ArrayList<TdhTemplateQueryRspBO>();
        NiccCommonUtil.copyList((List)result, rspList, TdhTemplateQueryRspBO.class);
        rspList.forEach(rsp -> rsp.setIsStar(this.isStar(reqBO, rsp.getTpId())));
        return BaseRspUtils.createSuccessRspList(rspList, (long)info.getTotal());
    }

    public RspList<TdhTemplateQueryRspBO> getTemplateAdminList(TdhTemplateQueryReqBO reqBO) {
        log.info("\u7ba1\u7406\u5458\u67e5\u8be2\u6a21\u677f\u5217\u8868 - \u76ee\u6807\u79df\u6237: {}", (Object)reqBO.getTargetTenant());
        TdhTemplateSelectCondition cond = new TdhTemplateSelectCondition();
        BeanUtils.copyProperties((Object)reqBO, (Object)cond);
        cond.setTenantCode(reqBO.getTargetTenant());
        cond.setUserId(null);
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTargetTenant())) {
            cond.setUserId(reqBO.getTargetTenant());
        }
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        cond.setTpSource("0");
        Page page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        this.tdhTemplateMapper.selectByCondition(cond);
        List result = page.getResult();
        ArrayList rspList = new ArrayList();
        NiccCommonUtil.copyList((List)result, rspList, TdhTemplateQueryRspBO.class);
        return BaseRspUtils.createSuccessRspList(rspList, (long)page.getTotal());
    }

    @Transactional(rollbackFor={Exception.class})
    public Rsp<TdhTemplateQueryRspBO> save(TdhTemplateQueryReqBO reqBO) {
        log.info("\u4fdd\u5b58\u6a21\u677f - ID: {}, \u540d\u79f0: {}", (Object)reqBO.getTpId(), (Object)reqBO.getTpName());
        TdhTemplate rec = new TdhTemplate();
        BeanUtils.copyProperties((Object)reqBO, (Object)rec);
        this.setDefaultValues(rec, reqBO);
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getTpId())) {
            if (StringUtils.isBlank((CharSequence)reqBO.getTargetTenant())) {
                rec.setTenantCode(null);
                rec.setUserId(null);
                rec.setTpSource(null);
            }
            rec.setUpdateTime(new Date());
            this.tdhTemplateMapper.update(rec);
        } else {
            this.setDefaultValues(rec, reqBO);
            rec.setTpId(IdWorker.nextAutoIdStr());
            rec.setCreateTime(new Date());
            this.tdhTemplateMapper.insertSelective(rec);
        }
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getRels())) {
            this.saveTemplateLayoutRel(rec.getTpId(), reqBO.getRels());
        }
        TdhTemplateQueryRspBO rsp = new TdhTemplateQueryRspBO();
        BeanUtils.copyProperties((Object)rec, (Object)rsp);
        return BaseRspUtils.createSuccessRsp((Object)rsp);
    }

    public void saveTemplateLayoutRel(String tpId, List<TdhTemplateLayoutRelBO> rels) {
        int i = this.tdhTemplateLayoutRelMapper.deleteByTpId(tpId);
        log.info("\u5220\u9664\u6a21\u677f\u5e03\u5c40\u5173\u7cfb\u8bb0\u5f55\u6570: {} , \u6a21\u7248id:{}", (Object)i, (Object)tpId);
        for (TdhTemplateLayoutRelBO rel : rels) {
            TdhTemplateLayoutRel po = new TdhTemplateLayoutRel();
            BeanUtils.copyProperties((Object)rel, (Object)po);
            po.setId(IdWorker.nextAutoIdStr());
            po.setTpId(tpId);
            po.setCreateTime(new Date());
            this.tdhTemplateLayoutRelMapper.insertSelective(po);
        }
    }

    private void setDefaultValues(TdhTemplate rec, TdhTemplateQueryReqBO reqBO) {
        rec.setVipFlag(Optional.ofNullable(rec.getVipFlag()).filter(StringUtils::isNotBlank).orElse(VipFlagType.COMMON_USER.getCode()));
        String targetTenant = Optional.ofNullable(reqBO.getTargetTenant()).filter(StringUtils::isNotBlank).orElse(reqBO.getTenantCode());
        if (TemplateSourceType.CUSTOM.getCode().equals(reqBO.getTpSource())) {
            rec.setUserId(reqBO.getUserId());
            rec.setTenantCode(targetTenant);
            rec.setTpState(reqBO.getTpState());
            rec.setTpSource(TemplateSourceType.CUSTOM.getCode());
        } else if (StateEnum.SOURCE.PUBLIC.getCode().equals(reqBO.getTargetTenant())) {
            rec.setUserId(StateEnum.SOURCE.PUBLIC.getCode());
            rec.setTenantCode("00000000");
            rec.setTpSource(StateEnum.SOURCE.SYSTEM.getCode());
            rec.setTpState(reqBO.getTpState());
        } else {
            rec.setUserId(targetTenant);
            rec.setTenantCode(targetTenant);
            rec.setTpSource(StateEnum.SOURCE.SYSTEM.getCode());
            rec.setTpState(reqBO.getTpState());
        }
    }

    public Rsp getTemplate(TdhTemplateQueryReqBO request) {
        log.info("\u67e5\u8be2\u6a21\u677f\u8be6\u60c5 - ID: {}", (Object)request.getTpId());
        TdhTemplate res = this.tdhTemplateMapper.queryById(request.getTpId());
        if (res != null) {
            TdhTemplateQueryRspBO rsp = new TdhTemplateQueryRspBO();
            BeanUtils.copyProperties((Object)res, (Object)rsp);
            return BaseRspUtils.createSuccessRsp((Object)rsp);
        }
        log.info("\u672a\u627e\u5230\u8be5\u6a21\u677f\u6216\u5df2\u5931\u6548\uff1a{}", (Object)request.getTpId());
        return BaseRspUtils.createErrorRsp((String)"\u672a\u627e\u5230\u8be5\u6a21\u677f\u6216\u5df2\u5931\u6548");
    }

    public RspList getHotTemplateList(TdhTemplateQueryReqBO request) {
        log.info("\u67e5\u8be2\u70ed\u95e8\u6a21\u677f\u5217\u8868 - \u79df\u6237: {}", (Object)request.getTenantCode());
        TdhTemplateSelectCondition cond = new TdhTemplateSelectCondition();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        cond.setTpState(StateEnum.STATE.AVAILABLE.getCode());
        cond.setIsHot(EntityValidType.NORMAL.getCode());
        cond.setTenantCode(StateEnum.SOURCE.PUBLIC.getCode());
        cond.setTpSource(StateEnum.SOURCE.SYSTEM.getCode());
        Page info = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.tdhTemplateMapper.selectByCondition(cond);
        List result = info.getResult();
        ArrayList rspList = new ArrayList();
        NiccCommonUtil.copyList((List)result, rspList, TdhHotTemplateQueryRspBO.class);
        return BaseRspUtils.createSuccessRspList(rspList, (long)info.getTotal());
    }

    public RspList getStarTemplateList(TdhTemplateQueryReqBO request) {
        log.info("\u67e5\u8be2\u6536\u85cf\u6a21\u677f\u5217\u8868 - \u7528\u6237: {}", (Object)request.getUserId());
        TdhTemplateSelectCondition cond = new TdhTemplateSelectCondition();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        cond.setTpState(StateEnum.STATE.AVAILABLE.getCode());
        Page info = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.tdhTemplateMapper.selectStarTemplateByCondition(cond);
        List result = info.getResult();
        ArrayList<TdhTemplateQueryRspBO> rspList = new ArrayList<TdhTemplateQueryRspBO>();
        NiccCommonUtil.copyList((List)result, rspList, TdhTemplateQueryRspBO.class);
        rspList.forEach(r -> r.setIsStar(StarType.FAVORITED.getCode()));
        return BaseRspUtils.createSuccessRspList(rspList, (long)info.getTotal());
    }

    public String isStar(TdhTemplateQueryReqBO reqBO, String busiId) {
        UserStarRequest request = new UserStarRequest();
        request.setBusiId(busiId);
        request.setUserId(reqBO.getUserId());
        request.setTenantCode(reqBO.getTenantCode());
        request.setBusiType("tdh_template");
        Rsp rsp = null;
        try {
            rsp = this.sysUserStarApi.getStar(request);
        }
        catch (Exception e) {
            log.warn("\u6570\u5b57\u4eba\u9762\u677f-\u83b7\u53d6\u7528\u6237\u6a21\u677f-\u67e5\u8be2\u6536\u85cf\u72b6\u6001\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        return rsp != null && rsp.isSuccess() ? StarType.FAVORITED.getCode() : StarType.UNFAVORITED.getCode();
    }
}

