/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.admin.api.SysDictConfigService;
import com.tydic.nbchat.admin.api.bo.SysDictConfigQueryReqBO;
import com.tydic.nbchat.train.api.bo.eums.CustomizePayType;
import com.tydic.nbchat.train.api.bo.eums.LanguageType;
import com.tydic.nbchat.train.api.bo.tdh.TdhVirtualAnchorQueryReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhVirtualAnchorQueryRspBO;
import com.tydic.nbchat.train.api.tdh.TdhVirtualAnchorApi;
import com.tydic.nbchat.train.core.entity.ExpireEnum;
import com.tydic.nbchat.train.mapper.TdhCustomizeRecordMapper;
import com.tydic.nbchat.train.mapper.TdhVirtualAnchorMapper;
import com.tydic.nbchat.train.mapper.po.TdhCustomizeRecord;
import com.tydic.nbchat.train.mapper.po.TdhVirtualAnchor;
import com.tydic.nbchat.user.api.NbchatUserApi;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;

@Service
public class TdhVirtualAnchorServiceImpl
implements TdhVirtualAnchorApi {
    private static final Logger log = LoggerFactory.getLogger(TdhVirtualAnchorServiceImpl.class);
    @Resource
    private TdhVirtualAnchorMapper tdhVirtualAnchorMapper;
    @Resource
    TdhCustomizeRecordMapper tdhCustomizeRecordMapper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=3000)
    SysDictConfigService sysDictConfigService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=10000)
    NbchatUserApi nbchatUserApi;
    private final String DICT_CODE = "language";

    public RspList<TdhVirtualAnchorQueryRspBO> getVirtualAnchorList(TdhVirtualAnchorQueryReqBO reqBO) {
        log.info("\u67e5\u8be2\u865a\u62df\u4e3b\u64ad\u5217\u8868 - \u79df\u6237: {}, \u7528\u6237: {}", (Object)reqBO.getTenantCode(), (Object)reqBO.getUserId());
        TdhVirtualAnchor cond = new TdhVirtualAnchor();
        BeanUtils.copyProperties((Object)reqBO, (Object)cond);
        cond.setBusiType(StringUtils.isBlank((CharSequence)reqBO.getBusiType()) ? EntityValidType.NORMAL.getCode() : reqBO.getBusiType());
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        Page page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        this.tdhVirtualAnchorMapper.selectAll(cond);
        ArrayList<TdhVirtualAnchorQueryRspBO> rspList = new ArrayList<TdhVirtualAnchorQueryRspBO>();
        NiccCommonUtil.copyList((List)page.getResult(), rspList, TdhVirtualAnchorQueryRspBO.class);
        this.fillLanguageType(rspList);
        this.fillOrderInfo(rspList);
        return BaseRspUtils.createSuccessRspList(rspList, (long)page.getTotal());
    }

    private void fillLanguageType(List<TdhVirtualAnchorQueryRspBO> rspList) {
        if (CollectionUtils.isEmpty(rspList)) {
            return;
        }
        HashMap languageMap = new HashMap();
        try {
            SysDictConfigQueryReqBO dictQuery = new SysDictConfigQueryReqBO();
            dictQuery.setDictCode("language");
            RspList dictResult = this.sysDictConfigService.getSysDictValues(dictQuery);
            if (dictResult != null && dictResult.isSuccess() && !CollectionUtils.isEmpty((Collection)dictResult.getRows())) {
                dictResult.getRows().forEach(dict -> languageMap.put(dict.getDictName(), dict.getDictDesc()));
                log.info("\u6210\u529f\u4ece\u5b57\u5178\u670d\u52a1\u83b7\u53d6\u8bed\u8a00\u6620\u5c04");
            } else {
                log.warn("\u8fdc\u7a0b\u83b7\u53d6\u8bed\u79cd\u5931\u8d25\uff0c\u4f7f\u7528\u672c\u5730\u6620\u5c04");
                languageMap.putAll(LanguageType.getLanguageMap());
            }
        }
        catch (Exception e) {
            log.error("\u8fdc\u7a0b\u83b7\u53d6\u8bed\u79cd\u5f02\u5e38\uff0c\u4f7f\u7528\u672c\u5730\u6620\u5c04: {}", (Object)e.getMessage());
            languageMap.putAll(LanguageType.getLanguageMap());
        }
        rspList.forEach(bo -> {
            if (StringUtils.isNotBlank((CharSequence)bo.getLanguage())) {
                String languageType = Arrays.stream(bo.getLanguage().split(",")).map(String::trim).map(lang -> languageMap.getOrDefault(lang, lang)).collect(Collectors.joining(","));
                bo.setLanguageType(languageType);
            }
        });
    }

    private void fillOrderInfo(List<TdhVirtualAnchorQueryRspBO> rspList) {
        for (TdhVirtualAnchorQueryRspBO bo : rspList) {
            TdhCustomizeRecord record;
            if (StringUtils.isEmpty((CharSequence)bo.getOrderNo()) || (record = this.tdhCustomizeRecordMapper.findByOrderNo(bo.getOrderNo())) == null) continue;
            bo.setIsExpire(ExpireEnum.no.getCode());
            bo.setCustomizeStatus(record.getCustomizeStatus());
            bo.setOrderStatus(record.getOrderStatus());
            bo.setCustomizeType(record.getCustomizeType());
            if ("00000000".equals(record.getTenantCode())) {
                try {
                    if (CustomizePayType.isProfess((String)record.getPayType())) {
                        Rsp userInfo = this.nbchatUserApi.getUserInfo(record.getUserId());
                        if (!userInfo.isSuccess()) continue;
                        String vipStatus = ((NbchatUserInfo)userInfo.getData()).getVipInfo().getVipStatus();
                        bo.setIsExpire(vipStatus.equals("1") ? ExpireEnum.no.getCode() : ExpireEnum.yes.getCode());
                        continue;
                    }
                    if (!this.isExpire(record.getEndTime())) continue;
                    bo.setIsExpire(ExpireEnum.yes.getCode());
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38: ", (Throwable)e);
                }
                continue;
            }
            if (!this.isExpire(record.getEndTime())) continue;
            bo.setIsExpire(ExpireEnum.yes.getCode());
        }
    }

    public boolean isExpire(Date date) {
        return ObjectUtils.isNotEmpty((Object)date) && date.before(new Date());
    }

    @CacheEvict(cacheNames={"nbchat-train:tdh_virtual_anchor"}, allEntries=true)
    public Rsp updateEmotion(TdhVirtualAnchorQueryReqBO reqBO) {
        log.info("\u66f4\u65b0\u865a\u62df\u4e3b\u64ad\u60c5\u611f - ID: {}", (Object)reqBO.getAnchorId());
        String emotion = reqBO.getEmotion();
        JSONObject jsonObject = JSONObject.parseObject((String)emotion);
        String value = jsonObject.getString("value");
        String url = jsonObject.getString("url");
        TdhVirtualAnchor tdhVirtualAnchor = this.tdhVirtualAnchorMapper.queryById(reqBO.getAnchorId());
        String emotionArr = tdhVirtualAnchor.getEmotion();
        if (!JSONArray.isValidArray((String)emotionArr)) {
            return BaseRspUtils.createErrorRsp((String)"\u914d\u7f6e\u60c5\u611f\u4fe1\u606f\u9519\u8bef");
        }
        JSONArray jsonArray = JSONArray.parseArray((String)emotionArr);
        for (Object obj : jsonArray) {
            JSONObject object = (JSONObject)obj;
            if (!object.getString("value").equals(value)) continue;
            object.put("url", (Object)url);
            break;
        }
        TdhVirtualAnchor po = new TdhVirtualAnchor();
        po.setAnchorId(reqBO.getAnchorId());
        po.setEmotion(jsonArray.toString());
        this.tdhVirtualAnchorMapper.update(po);
        return BaseRspUtils.createSuccessRsp((Object)"");
    }
}

