/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tdh;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.admin.api.SysUserStarApi;
import com.tydic.nbchat.admin.api.bo.SysUserStarBo;
import com.tydic.nbchat.admin.api.bo.eum.OrderStatusEnum;
import com.tydic.nbchat.admin.api.star.UserStarListRequest;
import com.tydic.nbchat.train.api.bo.eums.CustomizePayType;
import com.tydic.nbchat.train.api.bo.eums.CustomizeStatusEnum;
import com.tydic.nbchat.train.api.bo.eums.QCStateEnum;
import com.tydic.nbchat.train.api.bo.eums.TdhHumanType;
import com.tydic.nbchat.train.api.bo.eums.TdhVirtualHumanType;
import com.tydic.nbchat.train.api.bo.tdh.TdhVirtualHumanQueryReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhVirtualHumanQueryRspBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhVirtualHumanSortReqBO;
import com.tydic.nbchat.train.api.bo.tdh.TdhVirtualHumanUpdateReqBO;
import com.tydic.nbchat.train.api.tdh.TdhVirtualHumanApi;
import com.tydic.nbchat.train.core.entity.ExpireEnum;
import com.tydic.nbchat.train.mapper.TdhCustomizeRecordMapper;
import com.tydic.nbchat.train.mapper.TdhVirtualHumanMapper;
import com.tydic.nbchat.train.mapper.po.TdhCustomizeRecord;
import com.tydic.nbchat.train.mapper.po.TdhVirtualHuman;
import com.tydic.nbchat.user.api.NbchatUserApi;
import com.tydic.nbchat.user.api.bo.NbchatUserInfo;
import com.tydic.nbchat.user.api.bo.eums.UserVipType;
import com.tydic.nbchat.user.api.bo.vip.UserVipBO;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TdhVirtualHumanServiceImpl
implements TdhVirtualHumanApi {
    private static final Logger log = LoggerFactory.getLogger(TdhVirtualHumanServiceImpl.class);
    @Resource
    TdhVirtualHumanMapper tdhVirtualHumanMapper;
    @Resource
    TdhCustomizeRecordMapper tdhCustomizeRecordMapper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=10000)
    NbchatUserApi nbchatUserApi;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=10000)
    SysUserStarApi sysUserStarApi;

    public RspList<TdhVirtualHumanQueryRspBO> getVirtualHumanList(TdhVirtualHumanQueryReqBO reqBO) {
        log.info("\u67e5\u8be2\u865a\u62df\u4eba\u5217\u8868 - \u79df\u6237: {}, \u7c7b\u578b: {}", (Object)reqBO.getTenantCode(), (Object)reqBO.getTdhType());
        TdhVirtualHuman cond = new TdhVirtualHuman();
        BeanUtils.copyProperties((Object)reqBO, (Object)cond);
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        Page page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        this.tdhVirtualHumanMapper.selectAll(cond);
        ArrayList rspList = new ArrayList();
        NiccCommonUtil.copyList((List)page.getResult(), rspList, TdhVirtualHumanQueryRspBO.class);
        this.setFavoriteStatus(rspList, reqBO.getUserId(), reqBO.getTenantCode());
        rspList.sort(Comparator.comparing(TdhVirtualHumanQueryRspBO::getFavoriteTime, Comparator.nullsLast(Comparator.reverseOrder())));
        for (TdhVirtualHumanQueryRspBO bo2 : rspList) {
            TdhCustomizeRecord record;
            if (bo2.getTdhSource().equals("1")) {
                bo2.setTdhGroup("\u5b9a\u5236\u5f62\u8c61");
            } else if (TdhHumanType.GIF.getName().equals(bo2.getTdhType())) {
                bo2.setTdhGroup("\u5361\u901a\u5f62\u8c61");
            } else if (TdhHumanType.CUSTOM.getName().equals(bo2.getTdhType()) && "2".equals(bo2.getTdhSource())) {
                bo2.setTdhGroup("\u5361\u901a\u5f62\u8c61");
            } else if (TdhHumanType.CUSTOM2.getName().equals(bo2.getTdhType()) && "2".equals(bo2.getTdhSource())) {
                bo2.setTdhGroup("\u5361\u901a\u5f62\u8c61");
            } else if (TdhHumanType.CUSTOM.getName().equals(bo2.getTdhType()) || TdhHumanType.RAIN.getName().equals(bo2.getTdhType()) || TdhHumanType.CUSTOM2.getName().equals(bo2.getTdhType())) {
                bo2.setTdhGroup("\u5199\u5b9e\u5f62\u8c61");
            } else if (TdhHumanType.CUSTOM_PHOTO.getName().equals(bo2.getTdhType())) {
                bo2.setTdhGroup("\u7167\u7247\u5f62\u8c61");
            } else {
                bo2.setTdhGroup("\u5176\u4ed6\u5f62\u8c61");
            }
            bo2.setIsExpire(ExpireEnum.no.getCode());
            if (!StringUtils.isNotEmpty((CharSequence)bo2.getOrderNo()) || !ObjectUtils.isNotEmpty((Object)(record = this.tdhCustomizeRecordMapper.findByOrderNo(bo2.getOrderNo())))) continue;
            bo2.setCustomizeStatus(record.getCustomizeStatus());
            bo2.setOrderStatus(record.getOrderStatus());
            bo2.setQcStatus(record.getQcStatus());
            bo2.setPayType(record.getPayType());
            if ("00000000".equals(reqBO.getTenantCode())) {
                try {
                    if (CustomizePayType.isProfess((String)record.getPayType())) {
                        Rsp userInfo = this.nbchatUserApi.getUserInfo(record.getUserId());
                        if (!userInfo.isSuccess()) continue;
                        UserVipBO vipInfo = ((NbchatUserInfo)userInfo.getData()).getVipInfo();
                        if (UserVipType.isProfessional((String)vipInfo.getVipType())) {
                            String vipStatus = vipInfo.getVipStatus();
                            bo2.setIsExpire(vipStatus.equals("1") ? ExpireEnum.no.getCode() : ExpireEnum.yes.getCode());
                            continue;
                        }
                        bo2.setIsExpire(ExpireEnum.yes.getCode());
                        continue;
                    }
                    if (!this.isExpire(record.getEndTime())) continue;
                    bo2.setIsExpire(ExpireEnum.yes.getCode());
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38: ", (Throwable)e);
                }
                continue;
            }
            if (!this.isExpire(record.getEndTime())) continue;
            bo2.setIsExpire(ExpireEnum.yes.getCode());
        }
        rspList = rspList.stream().filter(bo -> {
            if (QCStateEnum.VIOLATION.equals(bo.getQcStatus())) {
                return false;
            }
            if (StringUtils.isNotEmpty((CharSequence)bo.getOrderNo())) {
                if ("00000000".equals(reqBO.getTenantCode())) {
                    return CustomizeStatusEnum.CUSTOMIZE_COMPLETED.getCode().equals(bo.getCustomizeStatus());
                }
                return CustomizeStatusEnum.CUSTOMIZE_COMPLETED.getCode().equals(bo.getCustomizeStatus()) && OrderStatusEnum.PAY_SUCCESS.getCode().equals(bo.getOrderStatus());
            }
            return true;
        }).collect(Collectors.toCollection(ArrayList::new));
        return BaseRspUtils.createSuccessRspList((List)rspList, (long)page.getTotal());
    }

    private void setFavoriteStatus(List<TdhVirtualHumanQueryRspBO> rspList, String userId, String tenantCode) {
        UserStarListRequest starRequest = new UserStarListRequest();
        starRequest.setUserId(userId);
        starRequest.setTenantCode(tenantCode);
        starRequest.setBusiType("tdh_human");
        starRequest.setBusiIds(rspList.stream().map(TdhVirtualHumanQueryRspBO::getTdhId).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList()));
        if (starRequest.getBusiIds().isEmpty()) {
            return;
        }
        RspList starRsp = this.sysUserStarApi.getStarList(starRequest);
        log.info("\u83b7\u53d6\u7528\u6237\u6536\u85cf\u6570\u636e - \u54cd\u5e94: {}", (Object)starRsp);
        Map<Object, Object> favoriteMap = new HashMap();
        if (starRsp != null && starRsp.isSuccess() && starRsp.getRows() != null && !starRsp.getRows().isEmpty()) {
            favoriteMap = starRsp.getRows().stream().filter(bo -> bo != null && StringUtils.isNotBlank((CharSequence)bo.getBusiId())).collect(Collectors.toMap(SysUserStarBo::getBusiId, Function.identity(), (existing, replacement) -> existing));
        }
        for (TdhVirtualHumanQueryRspBO bo2 : rspList) {
            SysUserStarBo favoriteInfo;
            if (StringUtils.isBlank((CharSequence)bo2.getTdhId())) continue;
            String cleanTdhId = bo2.getTdhId().trim();
            boolean isFavorite = favoriteMap.containsKey(cleanTdhId);
            bo2.setIsFavorite(String.valueOf(isFavorite));
            if (!isFavorite || (favoriteInfo = (SysUserStarBo)favoriteMap.get(cleanTdhId)) == null || favoriteInfo.getCreateTime() == null) continue;
            bo2.setFavoriteTime(favoriteInfo.getCreateTime());
        }
    }

    public boolean isExpire(Date date) {
        return ObjectUtils.isNotEmpty((Object)date) && date.before(new Date());
    }

    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(cacheNames={"nbchat-train:tdh_virtual_human"}, allEntries=true)
    public Rsp saveOrUpdateVirtualHuman(TdhVirtualHumanUpdateReqBO request) {
        log.info("\u4fdd\u5b58\u6216\u66f4\u65b0\u865a\u62df\u4eba - ID: {}, \u7c7b\u578b: {}", (Object)request.getTdhId(), (Object)request.getTdhType());
        if (!TdhVirtualHumanType.GIF.getCode().equals(request.getTdhSource()) && StringUtils.isBlank((CharSequence)request.getTdhId())) {
            return BaseRspUtils.createErrorRsp((String)"\u975eGIF\u7c7b\u578b\u6570\u5b57\u4eba\u5fc5\u987b\u4f20\u5165ID");
        }
        TdhVirtualHuman tdhVirtualHuman = new TdhVirtualHuman();
        BeanUtils.copyProperties((Object)request, (Object)tdhVirtualHuman);
        if (TdhVirtualHumanType.GIF.getCode().equals(request.getTdhSource())) {
            tdhVirtualHuman.setTdhSource("2");
            if (StringUtils.isNotBlank((CharSequence)request.getSpecifyTenantCode())) {
                tdhVirtualHuman.setUserId(request.getSpecifyTenantCode());
                tdhVirtualHuman.setTenantCode(request.getSpecifyTenantCode());
            } else {
                tdhVirtualHuman.setUserId("00000000");
                tdhVirtualHuman.setTenantCode("00000000");
            }
        } else if (TdhVirtualHumanType.CUSTOM.getCode().equals(request.getTdhSource())) {
            if (StringUtils.isBlank((CharSequence)request.getSpecifyTenantCode())) {
                request.setSpecifyTenantCode(request.getTenantCode());
            }
            tdhVirtualHuman.setUserId(request.getSpecifyTenantCode());
            tdhVirtualHuman.setTenantCode(request.getSpecifyTenantCode());
        } else {
            tdhVirtualHuman.setUserId("00000000");
            tdhVirtualHuman.setTenantCode("00000000");
        }
        TdhVirtualHuman human = this.tdhVirtualHumanMapper.queryById(request.getTdhId());
        if (ObjectUtils.isEmpty((Object)human)) {
            if (TdhVirtualHumanType.GIF.getCode().equals(request.getTdhSource())) {
                tdhVirtualHuman.setTdhId(IdWorker.nextAutoIdStr());
            }
            tdhVirtualHuman.setIsValid(EntityValidType.DELETE.getCode());
            tdhVirtualHuman.setCreateTime(new Date());
            this.tdhVirtualHumanMapper.insertSelective(tdhVirtualHuman);
        } else {
            tdhVirtualHuman.setOrderIndex(null);
            tdhVirtualHuman.setOrderNo("");
            this.tdhVirtualHumanMapper.update(tdhVirtualHuman);
        }
        return BaseRspUtils.createSuccessRsp((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(cacheNames={"nbchat-train:tdh_virtual_human"}, allEntries=true)
    public Rsp sort(TdhVirtualHumanSortReqBO request) {
        log.info("\u865a\u62df\u4eba\u6392\u5e8f - \u6570\u91cf: {}", (Object)request.getVirtualHumanIds().size());
        ArrayList humanList = new ArrayList();
        IntStream.range(0, request.getVirtualHumanIds().size()).forEach(i -> {
            TdhVirtualHuman human = new TdhVirtualHuman();
            human.setTdhId((String)request.getVirtualHumanIds().get(i));
            human.setOrderIndex(Integer.valueOf(i));
            humanList.add(human);
        });
        this.tdhVirtualHumanMapper.updateBatchSelective(humanList);
        return BaseRspUtils.createSuccessRsp((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @CacheEvict(cacheNames={"nbchat-train:tdh_virtual_human"}, allEntries=true)
    public Rsp updateStatus(TdhVirtualHumanUpdateReqBO request) {
        log.info("\u66f4\u65b0\u865a\u62df\u4eba\u72b6\u6001 - ID: {}, \u72b6\u6001: {}", (Object)request.getTdhId(), (Object)request.getIsValid());
        TdhVirtualHuman tdhVirtualHuman = new TdhVirtualHuman();
        tdhVirtualHuman.setTdhId(request.getTdhId());
        tdhVirtualHuman.setIsValid(request.getIsValid());
        this.tdhVirtualHumanMapper.update(tdhVirtualHuman);
        return BaseRspUtils.createSuccessRsp((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @CacheEvict(cacheNames={"nbchat-train:tdh_virtual_human"}, allEntries=true)
    public Rsp delete(TdhVirtualHumanUpdateReqBO request) {
        log.info("\u5220\u9664\u865a\u62df\u4eba - ID: {}", (Object)request.getTdhId());
        TdhVirtualHuman tdhVirtualHuman = new TdhVirtualHuman();
        tdhVirtualHuman.setTdhId(request.getTdhId());
        this.tdhVirtualHumanMapper.deleteById(request.getTdhId());
        return BaseRspUtils.createSuccessRsp((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    public RspList<TdhVirtualHumanQueryRspBO> getQueryVirtualHumanList(TdhVirtualHumanQueryReqBO request) {
        log.info("\u8fd0\u8425\u5e73\u53f0\u67e5\u8be2\u865a\u62df\u4eba\u5217\u8868 - \u79df\u6237: {}", (Object)request.getSpecifyTenantCode());
        TdhVirtualHuman queryRspBO = new TdhVirtualHuman();
        BeanUtils.copyProperties((Object)request, (Object)queryRspBO);
        if (StringUtils.isNotEmpty((CharSequence)request.getSpecifyTenantCode())) {
            queryRspBO.setTenantCode(request.getSpecifyTenantCode());
            queryRspBO.setUserId(request.getSpecifyTenantCode());
        } else {
            queryRspBO.setTenantCode(null);
            queryRspBO.setUserId(null);
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        List resultList = this.tdhVirtualHumanMapper.selectByConditions(queryRspBO);
        ArrayList rspList = new ArrayList();
        NiccCommonUtil.copyList((List)resultList, rspList, TdhVirtualHumanQueryRspBO.class);
        return BaseRspUtils.createSuccessRspList(rspList, (long)page.getTotal());
    }

    public RspList<TdhVirtualHumanQueryRspBO> getUserVirtualHumanList(TdhVirtualHumanQueryReqBO reqBO) {
        log.info("\u7528\u6237\u865a\u62df\u4eba\u5217\u8868\u67e5\u8be2 - \u7528\u6237: {}, \u79df\u6237: {}", (Object)reqBO.getUserId(), (Object)reqBO.getTenantCode());
        TdhVirtualHuman cond = new TdhVirtualHuman();
        BeanUtils.copyProperties((Object)reqBO, (Object)cond);
        cond.setIsValid(EntityValidType.NORMAL.getCode());
        Page page = PageHelper.startPage((int)reqBO.getPage(), (int)reqBO.getLimit());
        this.tdhVirtualHumanMapper.selectUserVirtualHumans(cond);
        ArrayList<TdhVirtualHumanQueryRspBO> rspList = new ArrayList<TdhVirtualHumanQueryRspBO>();
        NiccCommonUtil.copyList((List)page.getResult(), rspList, TdhVirtualHumanQueryRspBO.class);
        for (TdhVirtualHumanQueryRspBO bo : rspList) {
            if (TdhHumanType.GIF.getName().equals(bo.getTdhType())) {
                bo.setTdhGroup("\u5361\u901a\u5f62\u8c61");
                continue;
            }
            if (TdhHumanType.CUSTOM.getName().equals(bo.getTdhType()) && "2".equals(bo.getTdhSource())) {
                bo.setTdhGroup("\u5361\u901a\u5f62\u8c61");
                continue;
            }
            if (TdhHumanType.CUSTOM2.getName().equals(bo.getTdhType()) && "2".equals(bo.getTdhSource())) {
                bo.setTdhGroup("\u5361\u901a\u5f62\u8c61");
                continue;
            }
            if (TdhHumanType.CUSTOM.getName().equals(bo.getTdhType()) || TdhHumanType.RAIN.getName().equals(bo.getTdhType()) || TdhHumanType.CUSTOM2.getName().equals(bo.getTdhType())) {
                bo.setTdhGroup("\u5199\u5b9e\u5f62\u8c61");
                continue;
            }
            if (TdhHumanType.CUSTOM_PHOTO.getName().equals(bo.getTdhType())) {
                bo.setTdhGroup("\u7167\u7247\u5f62\u8c61");
                continue;
            }
            bo.setTdhGroup("\u5176\u4ed6\u5f62\u8c61");
        }
        this.setFavoriteStatus(rspList, reqBO.getUserId(), reqBO.getTenantCode());
        return BaseRspUtils.createSuccessRspList(rspList, (long)page.getTotal());
    }
}

