/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.trainTask;

import com.tydic.nbchat.admin.api.bo.file.FileUploadRequest;
import com.tydic.nbchat.admin.api.fileMannager.FileManageService;
import com.tydic.nbchat.train.api.bo.eums.ProjectType;
import com.tydic.nbchat.train.api.bo.train.scene.NbchatTrainTaskDegreeBO;
import com.tydic.nbchat.train.api.trainTask.CreateDegreeApi;
import com.tydic.nbchat.train.core.config.DegreeConfigProperties;
import com.tydic.nbchat.train.core.service.impl.degree.DegreeFactory;
import com.tydic.nbchat.train.mapper.NameMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainTaskDegreeMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainTaskMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainTask;
import com.tydic.nbchat.train.mapper.po.NbchatTrainTaskDegree;
import com.tydic.nicc.common.bo.file.FileManageSaveBO;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class CreateDegreeServiceImpl
implements CreateDegreeApi {
    private static final Logger log = LoggerFactory.getLogger(CreateDegreeServiceImpl.class);
    @Resource
    NbchatTrainTaskDegreeMapper nbchatTrainTaskDegreeMapper;
    @Resource
    NbchatTrainTaskMapper nbchatTrainTaskMapper;
    @Resource
    NameMapper nameMapper;
    private final DegreeFactory degreeFactory;
    private final DegreeConfigProperties degreeConfigProperties;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=50000)
    private FileManageService fileManageService;

    public CreateDegreeServiceImpl(DegreeFactory degreeFactory, DegreeConfigProperties degreeConfigProperties) {
        this.degreeFactory = degreeFactory;
        this.degreeConfigProperties = degreeConfigProperties;
    }

    public Rsp makeDegree(String degreeId) throws Exception {
        this.degreeFactory.createDegree(degreeId, ProjectType.Zhongjiao);
        return null;
    }

    public Rsp create(NbchatTrainTaskDegreeBO request) {
        log.info("\u521b\u5efa/\u66f4\u65b0\u8bc1\u4e66\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)request);
        if (StringUtils.isEmpty((CharSequence)request.getId())) {
            if (StringUtils.isEmpty((CharSequence)request.getTaskId())) {
                return BaseRspUtils.createErrorRsp((String)"\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            NbchatTrainTask trainTask = this.nbchatTrainTaskMapper.queryTask(Integer.valueOf(request.getTaskId()));
            if (ObjectUtils.isEmpty((Object)trainTask)) {
                return BaseRspUtils.createErrorRsp((String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
            }
            NbchatTrainTaskDegree degreeRecord = this.nbchatTrainTaskDegreeMapper.queryDegree(String.valueOf(request.getTaskId()), request.getUserId());
            if (ObjectUtils.isNotEmpty((Object)degreeRecord) && StringUtils.isNotEmpty((CharSequence)degreeRecord.getDegreeUrl())) {
                log.info("\u5df2\u83b7\u53d6\u8bc1\u4e661\uff1auserId={}|degreeId={}", (Object)request.getUserId(), (Object)degreeRecord.getId());
                return BaseRspUtils.createSuccessRsp((Object)degreeRecord);
            }
            if (trainTask.getEndTime().before(new Date())) {
                log.warn("\u4efb\u52a1\u5df2\u8fc7\u671f\uff0c\u65e0\u6cd5\u53d1\u653e\u8bc1\u4e66\uff1ataskId={},userId={}", (Object)request.getTaskId(), (Object)request.getUserId());
                return BaseRspUtils.createErrorRsp((String)"\u4efb\u52a1\u5df2\u8fc7\u671f\uff0c\u65e0\u6cd5\u53d6\u8bc1");
            }
            NbchatTrainTaskDegree po = new NbchatTrainTaskDegree();
            BeanUtils.copyProperties((Object)request, (Object)po);
            List degrees = this.nbchatTrainTaskDegreeMapper.selectAll(po);
            if (CollectionUtils.isNotEmpty((Collection)degrees)) {
                if (StringUtils.isEmpty((CharSequence)((NbchatTrainTaskDegree)degrees.get(0)).getDegreeUrl())) {
                    return this.make((NbchatTrainTaskDegree)degrees.get(0));
                }
                log.info("\u5df2\u83b7\u53d6\u8bc1\u4e662\uff1a{}|{}", (Object)request.getUserId(), degrees.get(0));
                return BaseRspUtils.createSuccessRsp(degrees.get(0));
            }
            NbchatTrainTaskDegree degree = this.saveRecord(request, trainTask);
            return this.make(degree);
        }
        if (StringUtils.isEmpty((CharSequence)request.getId())) {
            return BaseRspUtils.createErrorRsp((String)"\u8bc1\u4e66id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        NbchatTrainTaskDegree po = new NbchatTrainTaskDegree();
        po.setId(request.getId());
        po.setStatus(request.getStatus());
        this.nbchatTrainTaskDegreeMapper.update(po);
        return BaseRspUtils.createSuccessRsp((Object)"\u66f4\u65b0\u8bc1\u4e66\u72b6\u6001\u6210\u529f");
    }

    public Rsp make(NbchatTrainTaskDegree degree) {
        try {
            ProjectType type = this.getProjectType(degree.getTenantCode());
            String degreePath = this.degreeFactory.createDegree(degree.getId(), type);
            if (StringUtils.isEmpty((CharSequence)degreePath)) {
                return BaseRspUtils.createErrorRsp((String)"\u521b\u5efa\u8bc1\u4e66\u5931\u8d25");
            }
            RspList rspList = this.uploadDegree(degreePath, degree.getTenantCode(), degree.getUserId());
            if (rspList.isSuccess()) {
                FileManageSaveBO res = (FileManageSaveBO)rspList.getRows().get(0);
                degree.setDegreeUrl(res.getAccessUrl());
                this.nbchatTrainTaskDegreeMapper.update(degree);
                log.info("\u4e0a\u4f20\u8bc1\u4e66\u6210\u529f\uff0c\u8bc1\u4e66\u5730\u5740\uff1a{}", (Object)res.getAccessUrl());
                return BaseRspUtils.createSuccessRsp((Object)degree);
            }
            return BaseRspUtils.createErrorRsp((String)"\u4e0a\u4f20\u8bc1\u4e66\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRsp((String)"\u521b\u5efa\u8bc1\u4e66\u5931\u8d25");
        }
    }

    public ProjectType getProjectType(String tenantCode) {
        ProjectType type = ProjectType.Zhongjiao;
        String code = this.degreeConfigProperties.getProjectCode().get(tenantCode);
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            type = ProjectType.getByCode((String)code);
        }
        return type;
    }

    public RspList uploadDegree(String degreePath, String tenantCode, String userId) throws Exception {
        log.info("\u4e0a\u4f20\u8bc1\u4e66\u8bf7\u6c42\u53c2\u6570\uff1a\u8bc1\u4e66\u5730\u5740\uff1a{}", (Object)degreePath);
        String fileName = degreePath.substring(degreePath.lastIndexOf("/") + 1);
        byte[] byteArray = IOUtils.toByteArray((InputStream)new FileInputStream(degreePath));
        FileUploadRequest uploadRequest = FileUploadRequest.builder().file(byteArray).fileName(fileName).autoDir(false).targetDir("tdh/degree").uploadUser(userId).tenantCode(tenantCode).build();
        return this.fileManageService.fileUploadRequest(uploadRequest);
    }

    public NbchatTrainTaskDegree saveRecord(NbchatTrainTaskDegreeBO request, NbchatTrainTask trainTask) {
        NbchatTrainTaskDegree po = new NbchatTrainTaskDegree();
        BeanUtils.copyProperties((Object)request, (Object)po);
        po.setId(IdWorker.nextAutoIdStr());
        String phone = this.nameMapper.queryUserPhone(request.getUserId(), request.getTenantCode());
        po.setPhone(phone);
        String userName = this.nameMapper.queryUserName(request.getUserId(), request.getTenantCode());
        po.setUserName(userName);
        String deptId = this.nameMapper.queryDeptId(request.getUserId(), request.getTenantCode());
        po.setDeptId(deptId);
        po.setPostId(trainTask.getPostId());
        po.setDegreeName(trainTask.getDegreeName());
        po.setValidityPeriod(trainTask.getDegreeValidity());
        po.setIssueDate(new Date());
        this.nbchatTrainTaskDegreeMapper.insertSelective(po);
        return po;
    }
}

