/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.trainTask;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.train.api.bo.task.NbchatTaskRecordBO;
import com.tydic.nbchat.train.api.bo.train.scene.NbchatTrainTaskDegreeBO;
import com.tydic.nbchat.train.api.trainTask.QueryDegreeApi;
import com.tydic.nbchat.train.core.service.impl.trainTask.TrainTaskServiceImpl;
import com.tydic.nbchat.train.mapper.NameMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainTaskDegreeMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainTaskDegree;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class QueryDegreeServiceImpl
implements QueryDegreeApi {
    private static final Logger log = LoggerFactory.getLogger(QueryDegreeServiceImpl.class);
    @Resource
    NbchatTrainTaskDegreeMapper nbchatTrainTaskDegreeMapper;
    @Resource
    TrainTaskServiceImpl trainTaskService;
    @Resource
    NameMapper nameMapper;

    public RspList list(NbchatTrainTaskDegreeBO request) {
        log.info("\u67e5\u8be2\u8bc1\u4e66\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)request);
        NbchatTrainTaskDegree po = new NbchatTrainTaskDegree();
        BeanUtils.copyProperties((Object)request, (Object)po);
        po.setUserId(null);
        if (StringUtils.isNotEmpty((CharSequence)request.getChannelCode()) && "userClient".equals(request.getChannelCode())) {
            po.setUserId(request.getUserId());
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.nbchatTrainTaskDegreeMapper.selectAll(po);
        List result = page.getResult();
        ArrayList list = new ArrayList();
        NiccCommonUtil.copyList((List)result, list, NbchatTrainTaskDegreeBO.class);
        for (NbchatTrainTaskDegreeBO degreeBO : list) {
            if (StringUtils.isNotEmpty((CharSequence)degreeBO.getDeptId())) {
                String deptName = this.nameMapper.queryOrganizeName(degreeBO.getDeptId());
                degreeBO.setDeptName(deptName);
            }
            if (StringUtils.isNotEmpty((CharSequence)degreeBO.getPostId())) {
                String postName = this.nameMapper.queryPostName(degreeBO.getPostId());
                degreeBO.setPostName(postName);
            }
            String desc = this.nameMapper.queryTaskFiled(degreeBO.getTaskId());
            degreeBO.setDegreeDesc(desc);
        }
        return BaseRspUtils.createSuccessRspList(list, (long)page.getTotal());
    }

    public RspList analysis(NbchatTrainTaskDegreeBO request) {
        log.info("\u8bc1\u4e66\u7edf\u8ba1\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)request);
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.nbchatTrainTaskDegreeMapper.analysis(request.getTenantCode(), request.getDeptId(), request.getDegreeName());
        ArrayList list = new ArrayList();
        NiccCommonUtil.copyList((List)page.getResult(), list, NbchatTrainTaskDegreeBO.class);
        return BaseRspUtils.createSuccessRspList(list, (long)page.getTotal());
    }

    public RspList newAnalysis(NbchatTrainTaskDegreeBO request) {
        log.info("\u65b0\u8bc1\u4e66\u7edf\u8ba1\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)request);
        long time = new Date().getTime();
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        NbchatTrainTaskDegree cond = new NbchatTrainTaskDegree();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        this.nbchatTrainTaskDegreeMapper.newAnalysis(cond);
        log.info("\u67e5\u8be2\u8bc1\u4e66\u7edf\u8ba1\u8017\u65f6\uff1a{}", (Object)(new Date().getTime() - time));
        ArrayList list = new ArrayList();
        NiccCommonUtil.copyList((List)page.getResult(), list, NbchatTrainTaskDegreeBO.class);
        long times = new Date().getTime();
        for (NbchatTrainTaskDegreeBO degreeBO : list) {
            if (StringUtils.isNotEmpty((CharSequence)degreeBO.getDeptId())) {
                String TargetName = this.nameMapper.queryOrganizeName(degreeBO.getTargetId());
                String deptName = this.nameMapper.queryOrganizeName(degreeBO.getDeptId());
                degreeBO.setTargetName(TargetName);
                degreeBO.setDeptName(deptName);
            }
            long time1 = new Date().getTime();
            if (StringUtils.isNotEmpty((CharSequence)degreeBO.getTaskId())) {
                HashSet<String> userIds = new HashSet<String>();
                int taskId = Integer.parseInt(degreeBO.getTaskId());
                this.getSetUsers(userIds, degreeBO.getSupportSubDept(), degreeBO.getPostId(), request.getTenantCode(), degreeBO.getDeptId());
                degreeBO.setTargetUserCount(Integer.valueOf(userIds.size()));
                int finishUserCount = 0;
                for (String userId : userIds) {
                    NbchatTaskRecordBO taskBO = new NbchatTaskRecordBO();
                    this.trainTaskService.handleStatus(taskId, userId, taskBO);
                    if (!"2".equals(taskBO.getStatus())) continue;
                    ++finishUserCount;
                }
                degreeBO.setFinishUserCount(Integer.valueOf(finishUserCount));
                if (degreeBO.getTargetUserCount() != 0) {
                    String rate = String.format("%.2f%%", Float.valueOf((float)finishUserCount / (float)degreeBO.getTargetUserCount().intValue() * 100.0f));
                    degreeBO.setFinishRate(rate);
                }
            }
            log.info("\u67e5\u8be2\u5355\u4e2a\u673a\u6784\u4e0b\u9762\u7684\u7528\u6237\uff1a{}", (Object)(new Date().getTime() - time1));
            if (!StringUtils.isNotEmpty((CharSequence)degreeBO.getPostId())) continue;
            String postNameStr = Arrays.stream(degreeBO.getPostId().split(",")).map(arg_0 -> ((NameMapper)this.nameMapper).queryPostName(arg_0)).collect(Collectors.joining(","));
            degreeBO.setPostName(postNameStr);
        }
        log.info("\u67e5\u8be2\u5168\u90e8\u7684\u7528\u6237\u8017\u65f6\uff1a{}", (Object)(new Date().getTime() - times));
        return BaseRspUtils.createSuccessRspList(list, (long)page.getTotal());
    }

    public String getSetUsers(Set<String> userIds, String supportSubDept, String postId, String tenantCode, String deptId) {
        Set users = this.nameMapper.queryDeptPostUser(deptId, supportSubDept, postId, tenantCode);
        userIds.addAll(users);
        return "";
    }
}

