/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.trainTask;

import com.tydic.nbchat.train.mapper.NameMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainTaskDeptRelMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainTaskUserRelMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainTaskDeptRel;
import com.tydic.nbchat.train.mapper.po.NbchatTrainTaskUserRel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class QueryUserService {
    private static final Logger log = LoggerFactory.getLogger(QueryUserService.class);
    @Resource
    private NbchatTrainTaskDeptRelMapper nbchatTrainTaskDeptRelMapper;
    @Resource
    private NbchatTrainTaskUserRelMapper nbchatTrainTaskUserRelMapper;
    @Resource
    private NameMapper nameMapper;

    public List<String> getDeptPostUsers(Integer taskId, String supportSubDept, String postId, String tenantCode) {
        ArrayList<String> userIds = new ArrayList<String>();
        NbchatTrainTaskDeptRel po = new NbchatTrainTaskDeptRel();
        po.setTaskId(taskId);
        List taskDeptRels = this.nbchatTrainTaskDeptRelMapper.selectAll(po);
        if (CollectionUtils.isEmpty((Collection)taskDeptRels)) {
            return userIds;
        }
        for (NbchatTrainTaskDeptRel taskDeptRel : taskDeptRels) {
            List<String> postIds = Arrays.asList(postId.split(","));
            Set users = this.nameMapper.queryDeptPostListUser(taskDeptRel.getDeptId(), supportSubDept, postIds, tenantCode);
            userIds.addAll(users);
        }
        log.info("\u83b7\u53d6\u90e8\u95e8\u3001\u5c97\u4f4d\u4e0b\u6240\u6709\u7528\u6237\uff1a{}|{}|{}|{}|{}", new Object[]{taskId, supportSubDept, postId, tenantCode, userIds.size()});
        return userIds;
    }

    public List<String> getUsers(Integer taskId) {
        NbchatTrainTaskUserRel po = new NbchatTrainTaskUserRel();
        po.setTaskId(taskId);
        List userRels = this.nbchatTrainTaskUserRelMapper.queryAll(po);
        if (CollectionUtils.isEmpty((Collection)userRels)) {
            return new ArrayList<String>();
        }
        return userRels.stream().map(NbchatTrainTaskUserRel::getUserId).collect(Collectors.toList());
    }
}

