/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.trainTask;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.nbchat.train.api.bo.eums.CourseType;
import com.tydic.nbchat.train.api.bo.eums.StateEnum;
import com.tydic.nbchat.train.api.bo.task.CourseFinishInfo;
import com.tydic.nbchat.train.api.bo.task.NbchatTaskRecordBO;
import com.tydic.nbchat.train.api.bo.train.scene.NbchatTaskInfoBO;
import com.tydic.nbchat.train.api.bo.train.scene.NbchatTrainTaskBO;
import com.tydic.nbchat.train.api.bo.train.scene.NbchatTrainTaskConfigBO;
import com.tydic.nbchat.train.api.bo.train.scene.NbchatTrainTaskCourseRelBO;
import com.tydic.nbchat.train.api.trainTask.TrainTaskApi;
import com.tydic.nbchat.train.mapper.NameMapper;
import com.tydic.nbchat.train.mapper.NbchatExamTestRecordMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainCourseMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainRecordMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainTaskCourseRelMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainTaskDegreeMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainTaskDeptRelMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainTaskMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainTaskUserRelMapper;
import com.tydic.nbchat.train.mapper.NbchatTrainTaskWhiteListMapper;
import com.tydic.nbchat.train.mapper.po.NbchatTrainCourse;
import com.tydic.nbchat.train.mapper.po.NbchatTrainRecord;
import com.tydic.nbchat.train.mapper.po.NbchatTrainTask;
import com.tydic.nbchat.train.mapper.po.NbchatTrainTaskCourseRel;
import com.tydic.nbchat.train.mapper.po.NbchatTrainTaskDegree;
import com.tydic.nbchat.train.mapper.po.NbchatTrainTaskDeptRel;
import com.tydic.nbchat.train.mapper.po.NbchatTrainTaskWhiteList;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TrainTaskServiceImpl
implements TrainTaskApi {
    private static final Logger log = LoggerFactory.getLogger(TrainTaskServiceImpl.class);
    @Resource
    private NbchatTrainTaskMapper nbchatTrainTaskMapper;
    @Resource
    private NbchatTrainTaskCourseRelMapper nbchatTrainTaskCourseRelMapper;
    @Resource
    private NameMapper nameMapper;
    @Resource
    private NbchatTrainRecordMapper nbchatTrainRecordMapper;
    @Resource
    private NbchatTrainTaskWhiteListMapper nbchatTrainTaskWhiteListMapper;
    @Resource
    private NbchatTrainCourseMapper nbchatTrainCourseMapper;
    @Resource
    private NbchatTrainTaskDeptRelMapper nbchatTrainTaskDeptRelMapper;
    @Resource
    private NbchatExamTestRecordMapper nbchatExamTestRecordMapper;
    @Resource
    private NbchatTrainTaskDegreeMapper nbchatTrainTaskDegreeMapper;
    @Resource
    private NbchatTrainTaskUserRelMapper nbchatTrainTaskUserRelMapper;

    @Transactional
    public Rsp save(NbchatTrainTaskConfigBO request) {
        Integer taskId;
        block9: {
            NbchatTrainTaskBO taskConfig;
            block8: {
                List courseRelList;
                log.info("\u4fdd\u5b58\u5b66\u4e60\u4efb\u52a1\u4fe1\u606f\uff1a{}", (Object)request);
                taskConfig = request.getTaskConfig();
                taskId = request.getTaskConfig().getId();
                if (!ObjectUtils.isEmpty((Object)taskId)) break block8;
                NbchatTrainTask trainTask = new NbchatTrainTask();
                BeanUtils.copyProperties((Object)taskConfig, (Object)trainTask);
                trainTask.setCreateUser(request.getUserId());
                trainTask.setTenantCode(request.getTenantCode());
                this.nbchatTrainTaskMapper.insertSelective(trainTask);
                taskId = trainTask.getId();
                if (CollectionUtils.isNotEmpty((Collection)taskConfig.getDeptIds())) {
                    this.nbchatTrainTaskDeptRelMapper.insertBatch(taskId, taskConfig.getDeptIds());
                }
                if (CollectionUtils.isNotEmpty((Collection)taskConfig.getTargetUserIds())) {
                    this.nbchatTrainTaskUserRelMapper.insertBatch(taskId, taskConfig.getTargetUserIds());
                }
                if (!CollectionUtils.isNotEmpty((Collection)(courseRelList = request.getCourseRelList()))) break block9;
                for (NbchatTrainTaskCourseRelBO relBO : courseRelList) {
                    NbchatTrainTaskCourseRel po = new NbchatTrainTaskCourseRel();
                    BeanUtils.copyProperties((Object)relBO, (Object)po);
                    po.setTaskId(String.valueOf(trainTask.getId()));
                    this.nbchatTrainTaskCourseRelMapper.insertSelective(po);
                }
                break block9;
            }
            NbchatTrainTask trainTask = new NbchatTrainTask();
            BeanUtils.copyProperties((Object)taskConfig, (Object)trainTask);
            trainTask.setUpdateUser(request.getUserId());
            List deptIds = taskConfig.getDeptIds();
            List userIds = taskConfig.getTargetUserIds();
            if (CollectionUtils.isEmpty((Collection)deptIds) && CollectionUtils.isNotEmpty((Collection)userIds)) {
                this.nbchatTrainTaskDeptRelMapper.deleteByTaskId(taskId);
                this.nbchatTrainTaskUserRelMapper.deleteByTaskId(taskId);
                this.nbchatTrainTaskUserRelMapper.insertBatch(taskId, userIds);
                trainTask.setPostId("");
            }
            if (CollectionUtils.isEmpty((Collection)userIds) && CollectionUtils.isNotEmpty((Collection)deptIds)) {
                this.nbchatTrainTaskUserRelMapper.deleteByTaskId(taskId);
                this.nbchatTrainTaskDeptRelMapper.deleteByTaskId(taskId);
                this.nbchatTrainTaskDeptRelMapper.insertBatch(taskId, deptIds);
            }
            this.nbchatTrainTaskMapper.update(trainTask);
            if (CollectionUtils.isNotEmpty((Collection)request.getCourseRelList())) {
                this.nbchatTrainTaskCourseRelMapper.deleteByTaskId(String.valueOf(trainTask.getId()));
                List courseRelList = request.getCourseRelList();
                if (CollectionUtils.isNotEmpty((Collection)courseRelList)) {
                    for (NbchatTrainTaskCourseRelBO relBO : courseRelList) {
                        NbchatTrainTaskCourseRel po = new NbchatTrainTaskCourseRel();
                        BeanUtils.copyProperties((Object)relBO, (Object)po);
                        po.setTaskId(String.valueOf(trainTask.getId()));
                        this.nbchatTrainTaskCourseRelMapper.insertSelective(po);
                    }
                }
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)taskId);
    }

    public RspList list(NbchatTrainTaskBO request) {
        log.info("\u67e5\u8be2\u5b66\u4e60\u4efb\u52a1\u5217\u8868\uff1a{}", (Object)request);
        NbchatTrainTask cond = new NbchatTrainTask();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.nbchatTrainTaskMapper.selectList(cond);
        ArrayList res = new ArrayList();
        NiccCommonUtil.copyList((List)page.getResult(), res, NbchatTrainTaskBO.class);
        for (NbchatTrainTaskBO re : res) {
            String deptNames = this.getDeptNamesAndSetUsers(re.getId(), new HashSet<String>(), "0", null, request.getTenantCode());
            re.setDeptName(deptNames);
            String postNameStr = Arrays.stream(re.getPostId().split(",")).map(arg_0 -> ((NameMapper)this.nameMapper).queryPostName(arg_0)).collect(Collectors.joining(","));
            re.setPostName(postNameStr);
            int taskCount = this.nameMapper.queryTaskCount(re.getId());
            re.setTaskCount(Integer.valueOf(taskCount));
            String userName = this.nameMapper.queryUserName(re.getCreateUser(), re.getTenantCode());
            re.setCreateUserName(userName);
            String updateUserName = this.nameMapper.queryUserName(re.getUpdateUser(), re.getTenantCode());
            re.setUpdateUserName(updateUserName);
            List taskUserRels = this.nbchatTrainTaskUserRelMapper.queryUserName(re.getId(), request.getTenantCode());
            if (!CollectionUtils.isNotEmpty((Collection)taskUserRels)) continue;
            re.setTargetUserInfoList(taskUserRels);
        }
        return BaseRspUtils.createSuccessRspList(res, (long)page.getTotal());
    }

    public Rsp info(NbchatTrainTaskBO request) {
        List rels;
        List taskUserRels;
        log.info("\u67e5\u8be2\u5b66\u4e60\u4efb\u52a1\u660e\u7ec6\uff1a{}", (Object)request);
        NbchatTrainTaskConfigBO info = new NbchatTrainTaskConfigBO();
        NbchatTrainTask trainTask = this.nbchatTrainTaskMapper.queryById(request.getId());
        if (ObjectUtils.isEmpty((Object)trainTask)) {
            return BaseRspUtils.createSuccessRsp((Object)"\u672a\u67e5\u8be2\u5230\u5b66\u4e60\u4efb\u52a1\u4fe1\u606f");
        }
        NbchatTrainTaskBO taskConfig = new NbchatTrainTaskBO();
        BeanUtils.copyProperties((Object)trainTask, (Object)taskConfig);
        info.setTaskConfig(taskConfig);
        NbchatTrainTaskDeptRel po = NbchatTrainTaskDeptRel.builder().taskId(request.getId()).build();
        List taskDeptRels = this.nbchatTrainTaskDeptRelMapper.selectAll(po);
        if (CollectionUtils.isNotEmpty((Collection)taskDeptRels)) {
            List deptIds = taskDeptRels.stream().map(NbchatTrainTaskDeptRel::getDeptId).collect(Collectors.toList());
            info.getTaskConfig().setDeptIds(deptIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)(taskUserRels = this.nbchatTrainTaskUserRelMapper.queryUserName(request.getId(), request.getTenantCode())))) {
            info.getTaskConfig().setTargetUserInfoList(taskUserRels);
        }
        if (CollectionUtils.isNotEmpty((Collection)(rels = this.nbchatTrainTaskCourseRelMapper.selectByTaskId(String.valueOf(request.getId()))))) {
            ArrayList<NbchatTrainTaskCourseRelBO> courseRelList = new ArrayList<NbchatTrainTaskCourseRelBO>();
            for (NbchatTrainTaskCourseRel rel : rels) {
                NbchatTrainCourse course = this.nbchatTrainCourseMapper.selectByPrimaryKey(rel.getCourseId());
                if (StateEnum.COURSE.ON.getCode().equals(course.getCourseState())) {
                    NbchatTrainTaskCourseRelBO bo = new NbchatTrainTaskCourseRelBO();
                    BeanUtils.copyProperties((Object)rel, (Object)bo);
                    courseRelList.add(bo);
                    bo.setCourseState(course.getCourseState());
                    bo.setTestPaperState(course.getTestPaperState());
                    bo.setDialogueState(course.getSceneState());
                    int i = this.nbchatTrainRecordMapper.countVideo(course.getCourseId());
                    bo.setVideoCount(i);
                    continue;
                }
                log.warn("\u8bfe\u7a0b\u672a\u4e0a\u67b6\uff1a{}", (Object)course);
            }
            info.setCourseRelList(courseRelList);
        }
        return BaseRspUtils.createSuccessRsp((Object)info);
    }

    public RspList queryTask(NbchatTrainTaskBO request) {
        log.info("\u67e5\u8be2\u5b66\u4e60\u4efb\u52a1\uff1a{}", (Object)request);
        String userId = request.getUserId();
        String tenantCode = request.getTenantCode();
        if (this.inWhiteList(tenantCode, userId).booleanValue()) {
            return BaseRspUtils.createSuccessRspList(new ArrayList());
        }
        List<Object> res = new ArrayList();
        String deptId = this.nameMapper.queryDeptId(userId, tenantCode);
        List postIds = this.nameMapper.queryPostId(userId, tenantCode);
        if (StringUtils.isEmpty((CharSequence)deptId) || CollectionUtils.isEmpty((Collection)postIds)) {
            log.info("\u672a\u67e5\u8be2\u5230\u7528\u6237\u5173\u8054\u7684\u90e8\u95e8\u3001\u5c97\u4f4d\u4fe1\u606f:{}|{}", (Object)userId, (Object)tenantCode);
            return BaseRspUtils.createSuccessRspList(new ArrayList());
        }
        for (String postId : postIds) {
            NbchatTrainTask cond = NbchatTrainTask.builder().startStatus(request.getStartStatus()).id(request.getId()).deptId(deptId).postId(postId).isDegree(request.getIsDegree()).userId(userId).build();
            List trainTasks = this.nbchatTrainTaskMapper.selectAllBySubDept(cond);
            if (CollectionUtils.isEmpty((Collection)trainTasks)) continue;
            for (NbchatTrainTask task : trainTasks) {
                NbchatTrainTaskDegree degree;
                List taskIds = res.stream().map(NbchatTaskRecordBO::getTaskId).collect(Collectors.toList());
                if (taskIds.contains(task.getId())) continue;
                NbchatTaskRecordBO bo = new NbchatTaskRecordBO();
                bo.setIsDegree(task.getIsDegree());
                bo.setTaskName(task.getTaskName());
                bo.setTaskId(task.getId());
                bo.setDegreeName(task.getDegreeName());
                bo.setDegreeDesc(task.getDegreeDesc());
                bo.setStartStatus(task.getStartStatus());
                bo.setUpdateTime(task.getUpdateTime());
                this.handleStatus(task.getId(), userId, bo);
                if (ObjectUtils.isNotEmpty((Object)task.getEndTime()) && task.getEndTime().before(new Date())) {
                    bo.setStatus("3");
                }
                bo.setHasDegree(ObjectUtils.isNotEmpty((Object)(degree = this.nbchatTrainTaskDegreeMapper.queryDegree(String.valueOf(task.getId()), userId))) ? "1" : "0");
                res.add(bo);
            }
        }
        res = res.stream().sorted(Comparator.comparing(NbchatTaskRecordBO::getUpdateTime).reversed()).collect(Collectors.toList());
        return BaseRspUtils.createSuccessRspList(res);
    }

    public RspList queryTaskCourse(NbchatTrainTaskBO request) {
        log.info("\u67e5\u8be2\u5b66\u4e60\u4efb\u52a1-\u4e0d\u540c\u7c7b\u578b\u8bfe\u7a0b\uff1a{}", (Object)request);
        RspList rspList = this.queryTask(request);
        if (!rspList.isSuccess() || CollectionUtils.isEmpty((Collection)rspList.getRows())) {
            return BaseRspUtils.createSuccessRspList(new ArrayList());
        }
        List<Object> list = new ArrayList();
        List res = rspList.getRows();
        if (CourseType.normal.getCode().equals(request.getCourseType())) {
            list = res.stream().flatMap(record -> record.getInfoList().stream()).filter(v -> v.getIsStudyVideo().equals("1")).distinct().collect(Collectors.toList());
        }
        if (CourseType.exam.getCode().equals(request.getCourseType())) {
            list = res.stream().flatMap(record -> record.getInfoList().stream()).filter(v -> v.getIsAfterTest().equals("1")).distinct().collect(Collectors.toList());
        }
        int total = list.size();
        list = list.stream().skip((request.getPage() - 1) * request.getLimit()).limit(request.getLimit()).collect(Collectors.toList());
        return BaseRspUtils.createSuccessRspList(list, (long)total);
    }

    public RspList analysis(NbchatTrainTaskBO request) {
        log.info("\u67e5\u8be2\u5b66\u4e60\u4efb\u52a1\u5206\u6790\uff1a{}", (Object)request);
        ArrayList<String> deptIds = new ArrayList<String>();
        deptIds.addAll(request.getDeptIds());
        NbchatTrainTask cond = new NbchatTrainTask();
        BeanUtils.copyProperties((Object)request, (Object)cond);
        if (cond.getAtDeptIds() == null || cond.getAtDeptIds().size() == 0) {
            if (cond.getTargetIds() != null && cond.getTargetIds().size() > 0) {
                cond.getTargetIds().removeAll(cond.getDeptIds());
            }
        } else {
            cond.getTargetIds().retainAll(cond.getAtDeptIds());
            cond.getDeptIds().retainAll(cond.getAtDeptIds());
            if (cond.getTargetIds().isEmpty()) {
                cond.getTargetIds().add("");
            }
            if (cond.getDeptIds().isEmpty()) {
                cond.getDeptIds().add("");
            }
        }
        Page page = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        this.nbchatTrainTaskMapper.selectAll(cond);
        if (CollectionUtils.isEmpty((Collection)page.getResult())) {
            return BaseRspUtils.createSuccessRspList(new ArrayList());
        }
        ArrayList<NbchatTaskInfoBO> res = new ArrayList<NbchatTaskInfoBO>();
        for (NbchatTrainTask trainTask : page.getResult()) {
            Integer taskId = trainTask.getId();
            NbchatTaskInfoBO bo = new NbchatTaskInfoBO();
            BeanUtils.copyProperties((Object)trainTask, (Object)bo);
            List<Integer> postIds = Arrays.stream(trainTask.getPostId().split(",")).map(item -> Integer.parseInt(item.trim())).collect(Collectors.toList());
            List postNameArr = this.nameMapper.queryPostName_opt(postIds);
            String postNameStr = postNameArr.stream().filter(Objects::nonNull).collect(Collectors.joining(","));
            bo.setPostName(postNameStr);
            HashSet<String> userIds = new HashSet<String>();
            String deptNames = this.getDeptNamesAndSetUsers(taskId, userIds, trainTask.getSupportSubDept(), postIds, request.getTenantCode(), deptIds);
            bo.setDeptName(deptNames);
            bo.setTargetUserCount(Integer.valueOf(userIds.size()));
            ArrayList<String> userIdArr = new ArrayList<String>(userIds);
            int finishUserCount = this.nameMapper.countFinish(String.valueOf(taskId), userIdArr);
            bo.setFinishUserCount(Integer.valueOf(finishUserCount));
            if (bo.getTargetUserCount() != 0) {
                String rate = String.format("%.2f%%", Float.valueOf((float)finishUserCount / (float)bo.getTargetUserCount().intValue() * 100.0f));
                bo.setFinishRate(rate);
            }
            res.add(bo);
        }
        return BaseRspUtils.createSuccessRspList(res, (long)page.getTotal());
    }

    public RspList queryTaskCourseList(NbchatTrainTaskBO request) {
        log.info("\u67e5\u8be2\u5b66\u4e60\u4efb\u52a1\u8bfe\u7a0b\u5217\u8868\uff1a{}", (Object)request);
        NbchatTaskRecordBO bo = new NbchatTaskRecordBO();
        this.handleStatus(request.getId(), request.getUserId(), bo, true);
        List infoList = bo.getInfoList();
        return BaseRspUtils.createSuccessRspList((List)infoList);
    }

    public String getDeptNamesAndSetUsers(Integer taskId, Set<String> userIds, String supportSubDept, String postId, String tenantCode) {
        StringBuilder names = new StringBuilder();
        NbchatTrainTaskDeptRel po = new NbchatTrainTaskDeptRel();
        po.setTaskId(taskId);
        List taskDeptRels = this.nbchatTrainTaskDeptRelMapper.selectAll(po);
        if (CollectionUtils.isEmpty((Collection)taskDeptRels)) {
            return names.toString();
        }
        for (NbchatTrainTaskDeptRel taskDeptRel : taskDeptRels) {
            String deptName = this.nameMapper.queryOrganizeName(taskDeptRel.getDeptId());
            if (StringUtils.isNotEmpty((CharSequence)deptName)) {
                names.append(deptName).append(",");
            }
            if (!StringUtils.isNotEmpty((CharSequence)postId)) continue;
            Set users = this.nameMapper.queryDeptPostUser(taskDeptRel.getDeptId(), supportSubDept, postId, tenantCode);
            userIds.addAll(users);
        }
        if (names.lastIndexOf(",") > 0) {
            return names.deleteCharAt(names.lastIndexOf(",")).toString();
        }
        return "";
    }

    public String getDeptNamesAndSetUsers(Integer taskId, Set<String> userIds, String supportSubDept, List<Integer> postIds, String tenantCode, List<String> deptIds) {
        StringBuilder names = new StringBuilder();
        NbchatTrainTaskDeptRel po = new NbchatTrainTaskDeptRel();
        po.setTaskId(taskId);
        List taskDeptRels = this.nbchatTrainTaskDeptRelMapper.selectAll(po);
        if (CollectionUtils.isEmpty((Collection)taskDeptRels)) {
            return names.toString();
        }
        List depts = taskDeptRels.stream().map(NbchatTrainTaskDeptRel::getDeptId).collect(Collectors.toList());
        String deptName = this.nameMapper.queryOrganizeName_opt(depts);
        names.append(deptName).append(",");
        for (NbchatTrainTaskDeptRel taskDeptRel : taskDeptRels) {
            if (!CollectionUtils.isNotEmpty(postIds)) continue;
            boolean b = deptIds.stream().anyMatch(deptId -> deptId.equals(taskDeptRel.getDeptId()));
            if (b) {
                taskDeptRel.setDeptId(deptIds.get(0));
            }
            Set _userIds = this.nameMapper.queryDeptPostUser_opt(taskDeptRel.getDeptId(), supportSubDept, postIds, tenantCode);
            userIds.addAll(_userIds);
        }
        if (names.lastIndexOf(",") > 0) {
            return names.deleteCharAt(names.lastIndexOf(",")).toString();
        }
        return "";
    }

    public void handleStatus(Integer taskId, String userId, NbchatTaskRecordBO bo) {
        this.handleStatus(taskId, userId, bo, true);
    }

    public void handleStatus(Integer taskId, String userId, NbchatTaskRecordBO bo, Boolean countScore) {
        this.handleStatus(taskId, userId, bo, countScore, true);
    }

    public void handleStatus(Integer taskId, String userId, NbchatTaskRecordBO bo, Boolean countScore, Boolean countVideo) {
        ArrayList<CourseFinishInfo> infoList = new ArrayList<CourseFinishInfo>();
        NbchatTrainTaskCourseRel cond = NbchatTrainTaskCourseRel.builder().taskId(String.valueOf(taskId)).build();
        List rels = this.nbchatTrainTaskCourseRelMapper.selectAll(cond);
        if (CollectionUtils.isEmpty((Collection)rels)) {
            return;
        }
        int finishCourse = 0;
        int courseOnCount = rels.size();
        for (NbchatTrainTaskCourseRel rel : rels) {
            NbchatTrainRecord trainRecord;
            String courseId = rel.getCourseId();
            NbchatTrainCourse course = this.nbchatTrainCourseMapper.selectByPrimaryKey(courseId);
            if (!StateEnum.COURSE.ON.getCode().equals(course.getCourseState())) {
                log.warn("\u8bfe\u7a0b\u672a\u4e0a\u67b6\uff1a{}|{}", (Object)taskId, (Object)course.getCourseId());
                --courseOnCount;
                continue;
            }
            CourseFinishInfo finishInfo = new CourseFinishInfo();
            BeanUtils.copyProperties((Object)rel, (Object)finishInfo);
            finishInfo.setCourseName(course.getCourseName());
            finishInfo.setCourseId(course.getCourseId());
            finishInfo.setImgAvatar(course.getImgAvatar());
            finishInfo.setCourseType(course.getCourseType());
            finishInfo.setCourseState(course.getCourseState());
            finishInfo.setTestPaperState(course.getTestPaperState());
            finishInfo.setDialogueState(course.getSceneState());
            if (countVideo.booleanValue()) {
                int i = this.nbchatTrainRecordMapper.countVideo(course.getCourseId());
                finishInfo.setVideoCount(i);
            }
            if (ObjectUtils.isNotEmpty((Object)(trainRecord = this.nbchatTrainRecordMapper.selectByUserAndCourseId(userId, courseId)))) {
                Integer score;
                BeanUtils.copyProperties((Object)trainRecord, (Object)finishInfo);
                bo.setStatus("1");
                finishInfo.setTestState(trainRecord.getTestPassState());
                finishInfo.setSceneState(trainRecord.getScenePassState());
                if (countScore.booleanValue() && ObjectUtils.isNotEmpty((Object)(score = this.nbchatExamTestRecordMapper.queryScore(userId, courseId)))) {
                    finishInfo.setTestScore(score);
                }
            }
            infoList.add(finishInfo);
            if (!this.checkIsFinish(finishInfo)) continue;
            ++finishCourse;
        }
        if (finishCourse == courseOnCount) {
            bo.setStatus("2");
            bo.setFinishStatus("1");
        }
        bo.setInfoList(infoList);
    }

    public Boolean inWhiteList(String tenantCode, String userId) {
        NbchatTrainTaskWhiteList cond = new NbchatTrainTaskWhiteList();
        cond.setTenantCode(tenantCode);
        cond.setUserId(userId);
        List whiteLists = this.nbchatTrainTaskWhiteListMapper.selectAll(cond);
        if (CollectionUtils.isNotEmpty((Collection)whiteLists)) {
            log.info("\u5339\u914d\u5230\u767d\u540d\u5355\uff1a{}", (Object)JSON.toJSONString((Object)whiteLists));
            return true;
        }
        return false;
    }

    public boolean checkIsFinish(CourseFinishInfo finishInfo) {
        boolean finish1 = true;
        boolean finish2 = true;
        boolean finish3 = true;
        if ("1".equals(finishInfo.getIsStudyVideo())) {
            finish1 = EntityValidType.NORMAL.getCode().equals(finishInfo.getTrainState());
        }
        if ("1".equals(finishInfo.getIsAfterTest())) {
            finish2 = EntityValidType.NORMAL.getCode().equals(finishInfo.getTestState());
        }
        if ("1".equals(finishInfo.getIsHumanMachine())) {
            finish3 = EntityValidType.NORMAL.getCode().equals(finishInfo.getSceneState());
        }
        return finish1 && finish2 && finish3;
    }
}

