/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.trainTask;

import com.tydic.nbchat.admin.api.NbchatSysTenantApi;
import com.tydic.nbchat.admin.api.bo.SysTenantUserQueryRspBO;
import com.tydic.nbchat.admin.api.bo.dept.SysDeptUserQueryReqBO;
import com.tydic.nbchat.train.api.bo.train.scene.NbchatTrainTaskBO;
import com.tydic.nbchat.train.api.bo.train.task.UserTaskProgressBO;
import com.tydic.nbchat.train.api.trainTask.TrainTaskApi;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class UserTaskService {
    private static final Logger log = LoggerFactory.getLogger(UserTaskService.class);
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
    NbchatSysTenantApi nbchatSysTenantApi;
    private final TrainTaskApi trainTaskApi;

    public UserTaskService(TrainTaskApi trainTaskApi) {
        this.trainTaskApi = trainTaskApi;
    }

    public RspList userProgress(SysDeptUserQueryReqBO request) {
        log.info("\u5b66\u5458\u5b66\u4e60\u8fdb\u5ea6\u67e5\u8be2:{}", (Object)request);
        RspList rspList = this.nbchatSysTenantApi.getTenantUsers(request);
        if (!rspList.isSuccess()) {
            return rspList;
        }
        ArrayList<UserTaskProgressBO> res = new ArrayList<UserTaskProgressBO>();
        List rows = rspList.getRows();
        for (SysTenantUserQueryRspBO row : rows) {
            UserTaskProgressBO bo = new UserTaskProgressBO();
            BeanUtils.copyProperties((Object)row, (Object)bo);
            this.calData(bo, request.getTenantCode(), row.getUserId());
            res.add(bo);
        }
        return BaseRspUtils.createSuccessRspList(res, (long)rspList.getCount());
    }

    public void calData(UserTaskProgressBO bo, String tenantCode, String userId) {
        NbchatTrainTaskBO request = new NbchatTrainTaskBO();
        request.setTenantCode(tenantCode);
        request.setUserId(userId);
        request.setStartStatus("1");
        RspList rspList = this.trainTaskApi.queryTask(request);
        if (!rspList.isSuccess()) {
            log.warn("\u67e5\u8be2\u7528\u6237\u5b66\u4e60\u4efb\u52a1\u5931\u8d25:{}", (Object)rspList);
            return;
        }
        List rows = rspList.getRows();
        long finished = rows.stream().filter(v -> v.getFinishStatus().equals("1")).count();
        bo.setFinished(Integer.valueOf((int)finished));
        bo.setShouldFinished(Integer.valueOf((int)rspList.getCount()));
        if (bo.getShouldFinished() > 0) {
            bo.setFinishedRate(String.format("%.2f", (double)finished * 100.0 / (double)rspList.getCount()) + "%");
        } else {
            bo.setFinishedRate("0.00%");
        }
    }
}

