/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.impl.tts;

import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceTaskContext;
import com.tydic.nbchat.train.api.bo.asr_tts.TtsVoiceTaskRequest;
import com.tydic.nbchat.train.api.bo.eums.FileUploadDirEnum;
import com.tydic.nbchat.train.api.tts.TdhTtsApi;
import com.tydic.nbchat.train.core.helper.NlsStrategyInvokeFactory;
import com.tydic.nbchat.train.core.util.TrainCommonUtil;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@DubboService(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", timeout=5000)
public class TdhTtsServiceImpl
implements TdhTtsApi {
    private static final Logger log = LoggerFactory.getLogger(TdhTtsServiceImpl.class);
    private final NlsStrategyInvokeFactory nlsStrategyInvokeFactory;

    public TdhTtsServiceImpl(NlsStrategyInvokeFactory nlsStrategyInvokeFactory) {
        this.nlsStrategyInvokeFactory = nlsStrategyInvokeFactory;
    }

    public Rsp convertTextToSpeech(TtsVoiceTaskRequest request) {
        String text = TrainCommonUtil.removeXMLTags(request.getText()).trim();
        if (StringUtils.isBlank((CharSequence)text.trim())) {
            return BaseRspUtils.createErrorRsp((String)"\u8bf7\u8f93\u5165\u6587\u672c\u5185\u5bb9!");
        }
        request.setSectionId(FileUploadDirEnum.TTS_DIR.getCode());
        TtsVoiceTaskContext context = this.nlsStrategyInvokeFactory.createAudioTask(request);
        if (context.isSuccess()) {
            return BaseRspUtils.createSuccessRsp((Object)context);
        }
        return BaseRspUtils.createErrorRsp((Object)context, (String)"\u8bed\u97f3\u5408\u6210\u5f02\u5e38!");
    }

    public TtsVoiceTaskContext createTtsTask(TtsVoiceTaskRequest request) {
        return this.nlsStrategyInvokeFactory.createAudioTask(request);
    }
}

