/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.tdh.aimatch.factory;

import com.tydic.nbchat.train.api.tdh.enums.PptTypeEnum;
import com.tydic.nbchat.train.core.service.tdh.aimatch.factory.ContentFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ContentFactorySelector {
    private static final Logger log = LoggerFactory.getLogger(ContentFactorySelector.class);
    @Resource
    private List<ContentFactory> contentFactories;
    private Map<PptTypeEnum, ContentFactory> factoryMap = new HashMap<PptTypeEnum, ContentFactory>();

    @PostConstruct
    public void init() {
        for (ContentFactory factory : this.contentFactories) {
            this.factoryMap.put(factory.getSupportedPptType(), factory);
            log.info("\u6ce8\u518c\u5185\u5bb9\u5de5\u5382: {} -> {}", (Object)factory.getSupportedPptType(), (Object)factory.getClass().getSimpleName());
        }
    }

    public ContentFactory selectFactory(PptTypeEnum pptType) {
        ContentFactory factory = this.factoryMap.get(pptType);
        if (factory == null) {
            log.warn("\u672a\u627e\u5230PPT\u7c7b\u578b {} \u5bf9\u5e94\u7684\u5de5\u5382\uff0c\u4f7f\u7528\u9ed8\u8ba4\u5de5\u5382", (Object)pptType);
            factory = this.factoryMap.get(PptTypeEnum.UPLOAD);
        }
        return factory;
    }
}

