/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.tdh.aimatch.matcher;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.train.core.config.TdhTemplateConfigProperties;
import com.tydic.nbchat.train.core.service.tdh.aimatch.strategy.AudioMatchStrategy;
import com.tydic.nbchat.train.mapper.po.TdhAudio;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CommonAudioMatchProcessor {
    private static final Logger log = LoggerFactory.getLogger(CommonAudioMatchProcessor.class);
    private static final String SCENE_KEY = "scene";
    private static final String STYLE_KEY = "style";

    public static List<String> matchAudioIdsWithAi(AudioMatchStrategy strategy, String tenantCode, String userId, String userVipFlag, JSONObject aiResult, String defaultScene, String defaultStyle, TdhTemplateConfigProperties configProperties) {
        try {
            List<String> audioIds;
            boolean hasValidParams;
            if (aiResult == null) {
                log.info("\u80cc\u666f\u97f3\u4e50\u5339\u914d-AI\u7ed3\u679c\u4e3a\u7a7a\uff0c\u76f4\u63a5\u542f\u7528\u968f\u673a\u80cc\u666f\u97f3\u4e50\u7b56\u7565");
                return CommonAudioMatchProcessor.getFallbackAudioIds(strategy, tenantCode, userId, userVipFlag, configProperties);
            }
            AudioMatchParams params = CommonAudioMatchProcessor.parseAiResultOrDefaults(aiResult, defaultScene, defaultStyle);
            boolean bl = hasValidParams = StringUtils.isNotBlank((CharSequence)params.scene) || !CollectionUtils.isEmpty(params.styleList);
            if (!hasValidParams) {
                log.info("\u80cc\u666f\u97f3\u4e50\u5339\u914d-\u65e0\u6709\u6548\u5339\u914d\u53c2\u6570\uff0c\u76f4\u63a5\u542f\u7528\u968f\u673a\u80cc\u666f\u97f3\u4e50\u7b56\u7565");
                return CommonAudioMatchProcessor.getFallbackAudioIds(strategy, tenantCode, userId, userVipFlag, configProperties);
            }
            List<TdhAudio> candidates = strategy.findCandidateAudios(tenantCode, userId, userVipFlag);
            if (!CollectionUtils.isEmpty(candidates)) {
                audioIds = strategy.findBestMatchIds(candidates, params.scene, params.styleList);
                if (!audioIds.isEmpty() && audioIds.size() <= 3) {
                    log.info("\u80cc\u666f\u97f3\u4e50\u5339\u914d-\u627e\u5230\u6700\u4f73\u5339\u914d\u5217\u8868: {}, \u573a\u666f: {}, \u98ce\u683c: {}, VIP\u72b6\u6001: {}", new Object[]{audioIds, params.scene, params.styleList, userVipFlag});
                    return audioIds;
                }
                if (!audioIds.isEmpty()) {
                    List<String> limitedIds = audioIds.subList(0, Math.min(3, audioIds.size()));
                    log.info("\u80cc\u666f\u97f3\u4e50\u5339\u914d-\u5339\u914d\u80cc\u666f\u97f3\u4e50\u8fc7\u591a\uff0c\u9650\u5236\u8fd4\u56de\u6570\u91cf: {}, \u603b\u5339\u914d\u6570: {}", limitedIds, (Object)audioIds.size());
                    return limitedIds;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)params.scene)) {
                log.info("\u80cc\u666f\u97f3\u4e50\u5339\u914d-\u6309\u573a\u666f\u672a\u627e\u5230\uff0c\u5c1d\u8bd5\u5168\u5c40\u67e5\u8be2");
                candidates = strategy.findCandidateAudios(tenantCode, userId, userVipFlag);
                if (!CollectionUtils.isEmpty(candidates)) {
                    audioIds = strategy.findBestMatchIds(candidates, params.scene, params.styleList);
                    if (!audioIds.isEmpty() && audioIds.size() <= 3) {
                        log.info("\u80cc\u666f\u97f3\u4e50\u5339\u914d-\u5168\u5c40\u67e5\u8be2\u627e\u5230\u5339\u914d\u5217\u8868: {}", audioIds);
                        return audioIds;
                    }
                    if (!audioIds.isEmpty()) {
                        List<String> limitedIds = audioIds.subList(0, Math.min(3, audioIds.size()));
                        log.info("\u80cc\u666f\u97f3\u4e50\u5339\u914d-\u5168\u5c40\u67e5\u8be2\u5339\u914d\u80cc\u666f\u97f3\u4e50\u8fc7\u591a\uff0c\u9650\u5236\u8fd4\u56de\u6570\u91cf: {}, \u603b\u5339\u914d\u6570: {}", limitedIds, (Object)audioIds.size());
                        return limitedIds;
                    }
                }
            }
            log.info("\u80cc\u666f\u97f3\u4e50\u5339\u914d-\u672a\u627e\u5230\u5339\u914d\u80cc\u666f\u97f3\u4e50\uff0c\u542f\u7528\u5907\u7528\u7b56\u7565");
            return CommonAudioMatchProcessor.getFallbackAudioIds(strategy, tenantCode, userId, userVipFlag, configProperties);
        }
        catch (Exception e) {
            log.error("\u80cc\u666f\u97f3\u4e50\u5339\u914d-\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            return CommonAudioMatchProcessor.getFallbackAudioIds(strategy, tenantCode, userId, userVipFlag, configProperties);
        }
    }

    public static String matchAudioWithAi(AudioMatchStrategy strategy, String tenantCode, String userId, String userVipFlag, JSONObject aiResult, String defaultScene, String defaultStyle, TdhTemplateConfigProperties configProperties) {
        try {
            Optional<TdhAudio> bestMatch;
            boolean hasValidParams;
            if (aiResult == null) {
                log.info("\u80cc\u666f\u97f3\u4e50\u5339\u914d-AI\u7ed3\u679c\u4e3a\u7a7a\uff0c\u76f4\u63a5\u542f\u7528\u968f\u673a\u80cc\u666f\u97f3\u4e50\u7b56\u7565");
                List<String> fallbackIds = CommonAudioMatchProcessor.getFallbackAudioIds(strategy, tenantCode, userId, userVipFlag, configProperties);
                return fallbackIds.isEmpty() ? null : fallbackIds.get(0);
            }
            AudioMatchParams params = CommonAudioMatchProcessor.parseAiResultOrDefaults(aiResult, defaultScene, defaultStyle);
            boolean bl = hasValidParams = StringUtils.isNotBlank((CharSequence)params.scene) || !CollectionUtils.isEmpty(params.styleList);
            if (!hasValidParams) {
                log.info("\u80cc\u666f\u97f3\u4e50\u5339\u914d-\u65e0\u6709\u6548\u5339\u914d\u53c2\u6570\uff0c\u76f4\u63a5\u542f\u7528\u968f\u673a\u80cc\u666f\u97f3\u4e50\u7b56\u7565");
                List<String> fallbackIds = CommonAudioMatchProcessor.getFallbackAudioIds(strategy, tenantCode, userId, userVipFlag, configProperties);
                return fallbackIds.isEmpty() ? null : fallbackIds.get(0);
            }
            List<TdhAudio> candidates = strategy.findCandidateAudios(tenantCode, userId, userVipFlag);
            if (!CollectionUtils.isEmpty(candidates) && (bestMatch = strategy.findBestMatch(candidates, params.scene, params.styleList)).isPresent()) {
                String audioId = strategy.extractAudioId(bestMatch.get());
                log.info("\u80cc\u666f\u97f3\u4e50\u5339\u914d-\u627e\u5230\u6700\u4f73\u5339\u914d: {}, \u573a\u666f: {}, \u98ce\u683c: {}, VIP\u72b6\u6001: {}", new Object[]{audioId, params.scene, params.styleList, userVipFlag});
                return audioId;
            }
            if (StringUtils.isNotBlank((CharSequence)params.scene)) {
                log.info("\u80cc\u666f\u97f3\u4e50\u5339\u914d-\u6309\u573a\u666f\u672a\u627e\u5230\uff0c\u5c1d\u8bd5\u5168\u5c40\u67e5\u8be2");
                candidates = strategy.findCandidateAudios(tenantCode, userId, userVipFlag);
                if (!CollectionUtils.isEmpty(candidates) && (bestMatch = strategy.findBestMatch(candidates, params.scene, params.styleList)).isPresent()) {
                    String audioId = strategy.extractAudioId(bestMatch.get());
                    log.info("\u80cc\u666f\u97f3\u4e50\u5339\u914d-\u5168\u5c40\u67e5\u8be2\u627e\u5230\u5339\u914d: {}", (Object)audioId);
                    return audioId;
                }
            }
            log.info("\u80cc\u666f\u97f3\u4e50\u5339\u914d-\u672a\u627e\u5230\u5339\u914d\u80cc\u666f\u97f3\u4e50\uff0c\u542f\u7528\u5907\u7528\u7b56\u7565");
            List<String> fallbackIds = CommonAudioMatchProcessor.getFallbackAudioIds(strategy, tenantCode, userId, userVipFlag, configProperties);
            return fallbackIds.isEmpty() ? null : fallbackIds.get(0);
        }
        catch (Exception e) {
            log.error("\u80cc\u666f\u97f3\u4e50\u5339\u914d-\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            List<String> fallbackIds = CommonAudioMatchProcessor.getFallbackAudioIds(strategy, tenantCode, userId, userVipFlag, configProperties);
            return fallbackIds.isEmpty() ? null : fallbackIds.get(0);
        }
    }

    private static AudioMatchParams parseAiResultOrDefaults(JSONObject aiResult, String defaultScene, String defaultStyle) {
        AudioMatchParams params = new AudioMatchParams();
        params.scene = defaultScene;
        if (aiResult != null) {
            String aiScene = aiResult.getString(SCENE_KEY);
            if (StringUtils.isNotBlank((CharSequence)aiScene)) {
                params.scene = aiScene;
            }
            if (aiResult.containsKey((Object)STYLE_KEY)) {
                String styleStr;
                Object styleValue = aiResult.get((Object)STYLE_KEY);
                if (styleValue instanceof List) {
                    params.styleList = aiResult.getJSONArray(STYLE_KEY).toJavaList(String.class);
                } else if (styleValue instanceof String && StringUtils.isNotBlank((CharSequence)(styleStr = (String)styleValue))) {
                    params.styleList = Arrays.asList(styleStr.split(","));
                }
            } else if (StringUtils.isNotBlank((CharSequence)defaultStyle)) {
                params.styleList = Arrays.asList(defaultStyle.split(","));
            }
        } else if (StringUtils.isNotBlank((CharSequence)defaultStyle)) {
            params.styleList = Arrays.asList(defaultStyle.split(","));
        }
        return params;
    }

    private static List<String> getFallbackAudioIds(AudioMatchStrategy strategy, String tenantCode, String userId, String userVipFlag, TdhTemplateConfigProperties configProperties) {
        log.info("\u5907\u7528\u7b56\u7565-\u4f7f\u7528\u968f\u673a\u80cc\u666f\u97f3\u4e50");
        String randomAudioId = strategy.getRandomAudioId(tenantCode, userId, userVipFlag);
        return randomAudioId != null ? List.of(randomAudioId) : List.of();
    }

    private static class AudioMatchParams {
        String scene;
        List<String> styleList;

        private AudioMatchParams() {
        }
    }
}

