/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.tdh.aimatch.matcher;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.train.core.config.TdhTemplateConfigProperties;
import com.tydic.nbchat.train.core.service.tdh.aimatch.matcher.TdhTemplateMatchStrategy;
import com.tydic.nbchat.train.core.service.tdh.aimatch.matcher.TemplateMatchStrategy;
import com.tydic.nbchat.train.mapper.po.TdhTemplate;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CommonTemplateMatchProcessor {
    private static final Logger log = LoggerFactory.getLogger(CommonTemplateMatchProcessor.class);
    private static final String SCENE_KEY = "scene";
    private static final String STYLE_KEY = "style";
    private static final String COLOR_KEY = "color";

    public static <T> List<String> matchTemplateIdsWithAi(TemplateMatchStrategy<T> strategy, String tenantCode, String userId, String userVipFlag, String layoutId, JSONObject aiResult, String defaultScene, String defaultStyle, String defaultColor, TdhTemplateConfigProperties configProperties) {
        try {
            List<String> templateIds;
            boolean hasValidParams;
            if (aiResult == null) {
                log.info("\u6a21\u677f\u5339\u914d-AI\u7ed3\u679c\u4e3a\u7a7a\uff0c\u76f4\u63a5\u542f\u7528\u56fa\u5b9a\u6a21\u677f\u7b56\u7565");
                return CommonTemplateMatchProcessor.getFallbackTemplateIds(strategy, tenantCode, userId, userVipFlag, layoutId, configProperties);
            }
            MatchParams params = CommonTemplateMatchProcessor.parseAiResultOrDefaults(aiResult, defaultScene, defaultStyle, defaultColor);
            boolean bl = hasValidParams = StringUtils.isNotBlank((CharSequence)params.scene) || !CollectionUtils.isEmpty(params.styleList) || !CollectionUtils.isEmpty(params.colorList);
            if (!hasValidParams) {
                log.info("\u6a21\u677f\u5339\u914d-\u65e0\u6709\u6548\u5339\u914d\u53c2\u6570\uff0c\u76f4\u63a5\u542f\u7528\u56fa\u5b9a\u6a21\u677f\u7b56\u7565");
                return CommonTemplateMatchProcessor.getFallbackTemplateIds(strategy, tenantCode, userId, userVipFlag, layoutId, configProperties);
            }
            List<T> candidates = CommonTemplateMatchProcessor.getCandidateTemplates(strategy, tenantCode, userId, userVipFlag, layoutId);
            if (!CollectionUtils.isEmpty(candidates) && !(templateIds = strategy.findBestMatchIds(candidates, params.styleList, params.colorList)).isEmpty()) {
                List<String> prioritySelectedIds = CommonTemplateMatchProcessor.selectTemplatesByPriority(candidates, templateIds, strategy, 10);
                log.info("\u6a21\u677f\u5339\u914d-\u627e\u5230\u6700\u4f73\u5339\u914d\u5217\u8868: {}, \u573a\u666f: {}, \u98ce\u683c: {}, \u989c\u8272: {}, VIP\u72b6\u6001: {}, \u5e03\u5c40ID: {}", new Object[]{prioritySelectedIds, params.scene, params.styleList, params.colorList, userVipFlag, layoutId});
                return prioritySelectedIds;
            }
            if (StringUtils.isNotBlank((CharSequence)params.scene)) {
                log.info("\u6a21\u677f\u5339\u914d-\u6309\u573a\u666f\u672a\u627e\u5230\uff0c\u5c1d\u8bd5\u5168\u5c40\u67e5\u8be2");
                candidates = CommonTemplateMatchProcessor.getCandidateTemplates(strategy, tenantCode, userId, userVipFlag, layoutId);
                if (!CollectionUtils.isEmpty(candidates) && !(templateIds = strategy.findBestMatchIds(candidates, params.styleList, params.colorList)).isEmpty()) {
                    List<String> prioritySelectedIds = CommonTemplateMatchProcessor.selectTemplatesByPriority(candidates, templateIds, strategy, 10);
                    log.info("\u6a21\u677f\u5339\u914d-\u5168\u5c40\u67e5\u8be2\u627e\u5230\u5339\u914d\u5217\u8868: {}", prioritySelectedIds);
                    return prioritySelectedIds;
                }
            }
            log.info("\u6a21\u677f\u5339\u914d-\u672a\u627e\u5230\u5339\u914d\u6a21\u677f\uff0c\u542f\u7528\u5907\u7528\u7b56\u7565");
            return CommonTemplateMatchProcessor.getFallbackTemplateIds(strategy, tenantCode, userId, userVipFlag, layoutId, configProperties);
        }
        catch (Exception e) {
            log.error("\u6a21\u677f\u5339\u914d-\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            return CommonTemplateMatchProcessor.getFallbackTemplateIds(strategy, tenantCode, userId, userVipFlag, layoutId, configProperties);
        }
    }

    public static <T> String matchTemplateWithAi(TemplateMatchStrategy<T> strategy, String tenantCode, String userId, String userVipFlag, String layoutId, JSONObject aiResult, String defaultScene, String defaultStyle, String defaultColor, TdhTemplateConfigProperties configProperties) {
        try {
            Optional<T> bestMatch;
            boolean hasValidParams;
            if (aiResult == null) {
                log.info("\u6a21\u677f\u5339\u914d-AI\u7ed3\u679c\u4e3a\u7a7a\uff0c\u76f4\u63a5\u542f\u7528\u56fa\u5b9a\u6a21\u677f\u7b56\u7565");
                List<String> fallbackIds = CommonTemplateMatchProcessor.getFallbackTemplateIds(strategy, tenantCode, userId, userVipFlag, layoutId, configProperties);
                return fallbackIds.isEmpty() ? null : fallbackIds.get(0);
            }
            MatchParams params = CommonTemplateMatchProcessor.parseAiResultOrDefaults(aiResult, defaultScene, defaultStyle, defaultColor);
            boolean bl = hasValidParams = StringUtils.isNotBlank((CharSequence)params.scene) || !CollectionUtils.isEmpty(params.styleList) || !CollectionUtils.isEmpty(params.colorList);
            if (!hasValidParams) {
                log.info("\u6a21\u677f\u5339\u914d-\u65e0\u6709\u6548\u5339\u914d\u53c2\u6570\uff0c\u76f4\u63a5\u542f\u7528\u56fa\u5b9a\u6a21\u677f\u7b56\u7565");
                List<String> fallbackIds = CommonTemplateMatchProcessor.getFallbackTemplateIds(strategy, tenantCode, userId, userVipFlag, layoutId, configProperties);
                return fallbackIds.isEmpty() ? null : fallbackIds.get(0);
            }
            List<T> candidates = CommonTemplateMatchProcessor.getCandidateTemplates(strategy, tenantCode, userId, userVipFlag, layoutId);
            if (!CollectionUtils.isEmpty(candidates) && (bestMatch = strategy.findBestMatch(candidates, params.styleList, params.colorList)).isPresent()) {
                String templateId = strategy.extractTemplateId(bestMatch.get());
                log.info("\u6a21\u677f\u5339\u914d-\u627e\u5230\u6700\u4f73\u5339\u914d: {}, \u573a\u666f: {}, \u98ce\u683c: {}, \u989c\u8272: {}, VIP\u72b6\u6001: {}, \u5e03\u5c40ID: {}", new Object[]{templateId, params.scene, params.styleList, params.colorList, userVipFlag, layoutId});
                return templateId;
            }
            if (StringUtils.isNotBlank((CharSequence)params.scene)) {
                log.info("\u6a21\u677f\u5339\u914d-\u6309\u573a\u666f\u672a\u627e\u5230\uff0c\u5c1d\u8bd5\u5168\u5c40\u67e5\u8be2");
                candidates = CommonTemplateMatchProcessor.getCandidateTemplates(strategy, tenantCode, userId, userVipFlag, layoutId);
                if (!CollectionUtils.isEmpty(candidates) && (bestMatch = strategy.findBestMatch(candidates, params.styleList, params.colorList)).isPresent()) {
                    String templateId = strategy.extractTemplateId(bestMatch.get());
                    log.info("\u6a21\u677f\u5339\u914d-\u5168\u5c40\u67e5\u8be2\u627e\u5230\u5339\u914d: {}", (Object)templateId);
                    return templateId;
                }
            }
            log.info("\u6a21\u677f\u5339\u914d-\u672a\u627e\u5230\u5339\u914d\u6a21\u677f\uff0c\u542f\u7528\u5907\u7528\u7b56\u7565");
            List<String> fallbackIds = CommonTemplateMatchProcessor.getFallbackTemplateIds(strategy, tenantCode, userId, userVipFlag, layoutId, configProperties);
            return fallbackIds.isEmpty() ? null : fallbackIds.get(0);
        }
        catch (Exception e) {
            log.error("\u6a21\u677f\u5339\u914d-\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            List<String> fallbackIds = CommonTemplateMatchProcessor.getFallbackTemplateIds(strategy, tenantCode, userId, userVipFlag, layoutId, configProperties);
            return fallbackIds.isEmpty() ? null : fallbackIds.get(0);
        }
    }

    private static MatchParams parseAiResultOrDefaults(JSONObject aiResult, String defaultScene, String defaultStyle, String defaultColor) {
        MatchParams params = new MatchParams();
        params.scene = defaultScene;
        if (aiResult != null) {
            String aiScene = aiResult.getString(SCENE_KEY);
            if (StringUtils.isNotBlank((CharSequence)aiScene)) {
                params.scene = aiScene;
            }
            if (aiResult.containsKey((Object)STYLE_KEY)) {
                params.styleList = aiResult.getJSONArray(STYLE_KEY).toJavaList(String.class);
            } else if (StringUtils.isNotBlank((CharSequence)defaultStyle)) {
                params.styleList = Arrays.asList(defaultStyle.split(","));
            }
            if (aiResult.containsKey((Object)COLOR_KEY)) {
                params.colorList = aiResult.getJSONArray(COLOR_KEY).toJavaList(String.class);
            } else if (StringUtils.isNotBlank((CharSequence)defaultColor)) {
                params.colorList = Arrays.asList(defaultColor.split(","));
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)defaultStyle)) {
                params.styleList = Arrays.asList(defaultStyle.split(","));
            }
            if (StringUtils.isNotBlank((CharSequence)defaultColor)) {
                params.colorList = Arrays.asList(defaultColor.split(","));
            }
        }
        return params;
    }

    private static <T> List<T> getCandidateTemplates(TemplateMatchStrategy<T> strategy, String tenantCode, String userId, String userVipFlag, String layoutId) {
        if (strategy instanceof TdhTemplateMatchStrategy && StringUtils.isNotBlank((CharSequence)layoutId)) {
            TdhTemplateMatchStrategy tdhStrategy = (TdhTemplateMatchStrategy)strategy;
            return tdhStrategy.findCandidateTemplatesByLayout(tenantCode, userId, userVipFlag, layoutId);
        }
        return strategy.findCandidateTemplates(tenantCode, userId, userVipFlag);
    }

    private static <T> List<String> getFallbackTemplateIds(TemplateMatchStrategy<T> strategy, String tenantCode, String userId, String userVipFlag, String layoutId, TdhTemplateConfigProperties configProperties) {
        if (configProperties != null && configProperties.isEnableDefaultTemplate() && StringUtils.isNotBlank((CharSequence)configProperties.getDefaultTemplateId())) {
            String defaultTemplateId = configProperties.getDefaultTemplateId();
            log.info("\u5907\u7528\u7b56\u7565-\u68c0\u67e5\u56fa\u5b9a\u6a21\u677f: {}", (Object)defaultTemplateId);
            if (strategy instanceof TdhTemplateMatchStrategy) {
                TdhTemplateMatchStrategy tdhStrategy = (TdhTemplateMatchStrategy)strategy;
                if (tdhStrategy.isTemplateExists(defaultTemplateId, tenantCode, userId, userVipFlag)) {
                    log.info("\u5907\u7528\u7b56\u7565-\u4f7f\u7528\u56fa\u5b9a\u6a21\u677f: {}", (Object)defaultTemplateId);
                    return List.of(defaultTemplateId);
                }
                log.info("\u5907\u7528\u7b56\u7565-\u56fa\u5b9a\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u65e0\u6743\u9650\u8bbf\u95ee: {}", (Object)defaultTemplateId);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)layoutId) && strategy instanceof TdhTemplateMatchStrategy) {
            TdhTemplateMatchStrategy tdhStrategy = (TdhTemplateMatchStrategy)strategy;
            List<TdhTemplate> layoutCandidates = tdhStrategy.findCandidateTemplatesByLayout(tenantCode, userId, userVipFlag, layoutId);
            if (!CollectionUtils.isEmpty(layoutCandidates)) {
                List<String> limitedLayoutIds = layoutCandidates.stream().sorted((t1, t2) -> {
                    Integer priority1 = CommonTemplateMatchProcessor.extractPriority(t1);
                    Integer priority2 = CommonTemplateMatchProcessor.extractPriority(t2);
                    return Integer.compare(priority2, priority1);
                }).limit(3L).map(template -> strategy.extractTemplateId(template)).collect(Collectors.toList());
                log.info("\u5907\u7528\u7b56\u7565-\u4f7f\u7528\u5e03\u5c40\u76f8\u5173\u6a21\u677f(\u6309\u4f18\u5148\u7ea7): {}, \u5e03\u5c40ID: {}", limitedLayoutIds, (Object)layoutId);
                return limitedLayoutIds;
            }
            log.info("\u5907\u7528\u7b56\u7565-\u5e03\u5c40\u76f8\u5173\u6a21\u677f\u672a\u627e\u5230\uff0c\u5e03\u5c40ID: {}", (Object)layoutId);
        }
        log.info("\u5907\u7528\u7b56\u7565-\u4f7f\u7528\u5168\u5c40\u968f\u673a\u6a21\u677f");
        String globalRandomId = strategy.getRandomTemplateId(tenantCode, userId, userVipFlag);
        return globalRandomId != null ? List.of(globalRandomId) : List.of();
    }

    public static <T> List<String> matchTemplateIdsWithAi(TemplateMatchStrategy<T> strategy, String tenantCode, String userId, String userVipFlag, JSONObject aiResult, String defaultScene, String defaultStyle, String defaultColor) {
        return CommonTemplateMatchProcessor.matchTemplateIdsWithAi(strategy, tenantCode, userId, userVipFlag, null, aiResult, defaultScene, defaultStyle, defaultColor, null);
    }

    public static <T> String matchTemplateWithAi(TemplateMatchStrategy<T> strategy, String tenantCode, String userId, String userVipFlag, JSONObject aiResult, String defaultScene, String defaultStyle, String defaultColor) {
        return CommonTemplateMatchProcessor.matchTemplateWithAi(strategy, tenantCode, userId, userVipFlag, null, aiResult, defaultScene, defaultStyle, defaultColor, null);
    }

    private static <T> Integer extractPriority(T template) {
        if (template == null) {
            return 0;
        }
        if (template instanceof TdhTemplate) {
            TdhTemplate tdhTemplate = (TdhTemplate)template;
            Integer priority = tdhTemplate.getPriority();
            return priority != null ? priority : 0;
        }
        try {
            Field priorityField = template.getClass().getDeclaredField("priority");
            priorityField.setAccessible(true);
            Object priorityValue = priorityField.get(template);
            if (priorityValue instanceof Integer) {
                return (Integer)priorityValue;
            }
        }
        catch (Exception e) {
            log.warn("\u65e0\u6cd5\u63d0\u53d6\u6a21\u677f\u4f18\u5148\u7ea7\uff0c\u6a21\u677f\u7c7b\u578b: {}, \u4f7f\u7528\u9ed8\u8ba4\u4f18\u5148\u7ea70", (Object)template.getClass().getSimpleName());
        }
        return 0;
    }

    private static <T> List<String> selectTemplatesByPriority(List<T> allCandidates, List<String> matchedTemplateIds, TemplateMatchStrategy<T> strategy, int maxCount) {
        try {
            String[] priorityOrder;
            List matchedTemplates = allCandidates.stream().filter(template -> matchedTemplateIds.contains(strategy.extractTemplateId(template))).collect(Collectors.toList());
            if (matchedTemplates.isEmpty()) {
                return List.of();
            }
            Map<String, List<Object>> priorityGroups = matchedTemplates.stream().collect(Collectors.groupingBy(template -> {
                Integer priority = CommonTemplateMatchProcessor.extractPriority(template);
                if (priority == null || priority <= 0) {
                    return "\u4f4e";
                }
                if (priority >= 9) {
                    return "\u9ad8";
                }
                if (priority >= 5) {
                    return "\u4e2d";
                }
                return "\u4f4e";
            }));
            ArrayList<String> result = new ArrayList<String>();
            for (String priorityLevel : priorityOrder = new String[]{"\u9ad8", "\u4e2d", "\u4f4e"}) {
                List<Object> templates = priorityGroups.get(priorityLevel);
                if (templates == null || templates.isEmpty() || result.size() >= maxCount) continue;
                ArrayList<Object> shuffledTemplates = new ArrayList<Object>(templates);
                Collections.shuffle(shuffledTemplates);
                int remainingCount = maxCount - result.size();
                int takeCount = Math.min(remainingCount, shuffledTemplates.size());
                List selectedIds = shuffledTemplates.stream().limit(takeCount).map(template -> strategy.extractTemplateId(template)).collect(Collectors.toList());
                result.addAll(selectedIds);
                log.info("\u6309\u4f18\u5148\u7ea7\u9009\u62e9\u6a21\u677f-{}\u4f18\u5148\u7ea7: \u53ef\u9009\u6570\u91cf={}, \u5df2\u9009\u6570\u91cf={}, \u5df2\u9009\u6a21\u677f={}", new Object[]{priorityLevel, templates.size(), selectedIds.size(), selectedIds});
            }
            log.info("\u6309\u4f18\u5148\u7ea7\u9009\u62e9\u6a21\u677f-\u6700\u7ec8\u7ed3\u679c: \u603b\u6570\u91cf={}, \u6a21\u677f\u5217\u8868={}", (Object)result.size(), result);
            return result;
        }
        catch (Exception e) {
            log.error("\u6309\u4f18\u5148\u7ea7\u9009\u62e9\u6a21\u677f\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
            return matchedTemplateIds.stream().limit(maxCount).collect(Collectors.toList());
        }
    }

    private static class MatchParams {
        String scene;
        List<String> styleList;
        List<String> colorList;

        private MatchParams() {
        }
    }
}

