/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.tdh.aimatch.matcher;

import com.tydic.nbchat.train.api.bo.eums.ComposeType;
import com.tydic.nbchat.train.api.bo.eums.StateEnum;
import com.tydic.nbchat.train.core.service.tdh.aimatch.matcher.TemplateMatchStrategy;
import com.tydic.nbchat.train.core.util.PptThemeMatcherProcessor;
import com.tydic.nbchat.train.mapper.PptThemeMapper;
import com.tydic.nbchat.train.mapper.po.PptTheme;
import com.tydic.nicc.common.eums.EntityValidType;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class PptThemeMatchStrategy
implements TemplateMatchStrategy<PptTheme> {
    @Resource
    private PptThemeMapper pptThemeMapper;

    @Override
    public List<PptTheme> findCandidateTemplates(String tenantCode, String userId, String userVipFlag) {
        PptTheme pptTheme = new PptTheme();
        pptTheme.setTenantCode(tenantCode);
        pptTheme.setUserId(userId);
        pptTheme.setIsValid(EntityValidType.NORMAL.getCode());
        pptTheme.setThemeState(EntityValidType.NORMAL.getCode());
        pptTheme.setThemeSource(StateEnum.SOURCE.SYSTEM.getCode());
        pptTheme.setComposeType(ComposeType.THEME.getCode());
        pptTheme.setCategory("ppt");
        return this.pptThemeMapper.selectAll(pptTheme);
    }

    @Override
    public List<String> findBestMatchIds(List<PptTheme> candidates, List<String> styleList, List<String> colorList) {
        Optional<PptTheme> bestMatch = PptThemeMatcherProcessor.findBestMatch(candidates, styleList, colorList);
        if (bestMatch.isPresent()) {
            return List.of(bestMatch.get().getThemeId());
        }
        return List.of();
    }

    @Override
    public Optional<PptTheme> findBestMatch(List<PptTheme> candidates, List<String> styleList, List<String> colorList) {
        return PptThemeMatcherProcessor.findBestMatch(candidates, styleList, colorList);
    }

    @Override
    public String getRandomTemplateId(String tenantCode, String userId, String userVipFlag) {
        return this.pptThemeMapper.findRandomThemeId();
    }

    @Override
    public String extractTemplateId(PptTheme template) {
        return template.getThemeId();
    }
}

