/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.tdh.aimatch.matcher;

import com.tydic.nbchat.train.core.service.tdh.aimatch.matcher.TemplateMatchStrategy;
import com.tydic.nbchat.train.core.service.tdh.aimatch.service.TemplateService;
import com.tydic.nbchat.train.core.util.TdhTemplateMatcherProcessor;
import com.tydic.nbchat.train.mapper.po.TdhTemplate;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class TdhTemplateMatchStrategy
implements TemplateMatchStrategy<TdhTemplate> {
    @Resource
    private TemplateService templateService;

    @Override
    public List<TdhTemplate> findCandidateTemplates(String tenantCode, String userId, String userVipFlag) {
        return this.templateService.findCandidateTemplates(tenantCode, userId, userVipFlag);
    }

    public List<TdhTemplate> findCandidateTemplatesByLayout(String tenantCode, String userId, String userVipFlag, String layoutId) {
        if (StringUtils.isBlank((CharSequence)layoutId)) {
            return this.findCandidateTemplates(tenantCode, userId, userVipFlag);
        }
        return this.templateService.findCandidateTemplatesByLayout(tenantCode, userId, userVipFlag, layoutId);
    }

    public boolean isTemplateExists(String templateId, String tenantCode, String userId, String userVipFlag) {
        return this.templateService.isTemplateExists(templateId, tenantCode, userId, userVipFlag);
    }

    public String getRandomTemplateIdByLayout(String tenantCode, String userId, String userVipFlag, String layoutId) {
        return this.templateService.getRandomTemplateIdByLayout(tenantCode, userId, userVipFlag, layoutId);
    }

    @Override
    public List<String> findBestMatchIds(List<TdhTemplate> candidates, List<String> styleList, List<String> colorList) {
        return TdhTemplateMatcherProcessor.findBestMatchIds(candidates, styleList, colorList);
    }

    @Override
    public Optional<TdhTemplate> findBestMatch(List<TdhTemplate> candidates, List<String> styleList, List<String> colorList) {
        return TdhTemplateMatcherProcessor.findBestMatch(candidates, styleList, colorList);
    }

    @Override
    public String getRandomTemplateId(String tenantCode, String userId, String userVipFlag) {
        return this.templateService.getRandomTemplateId(tenantCode, userId, userVipFlag);
    }

    @Override
    public String extractTemplateId(TdhTemplate template) {
        return template.getTpId();
    }
}

