/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.core.service.tdh.aimatch.service.impl;

import com.tydic.nbchat.train.core.service.tdh.aimatch.service.AvatarService;
import com.tydic.nbchat.train.mapper.TdhVirtualHumanMapper;
import com.tydic.nbchat.train.mapper.po.TdhVirtualHuman;
import com.tydic.nicc.common.eums.EntityValidType;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AvatarServiceImpl
implements AvatarService {
    private static final Logger log = LoggerFactory.getLogger(AvatarServiceImpl.class);
    @Resource
    private TdhVirtualHumanMapper tdhVirtualHumanMapper;

    @Override
    public List<TdhVirtualHuman> findAllAvailableAvatars(String tenantCode, String userId, String userVipFlag) {
        log.info("\u67e5\u8be2\u6240\u6709\u53ef\u7528\u6570\u5b57\u4eba - tenantCode: {}, userId: {}, userVipFlag: {}", new Object[]{tenantCode, userId, userVipFlag});
        TdhVirtualHuman queryCondition = new TdhVirtualHuman();
        queryCondition.setUserId("00000000");
        queryCondition.setTenantCode("00000000");
        queryCondition.setIsValid(EntityValidType.NORMAL.getCode());
        queryCondition.setVipFlag(StringUtils.isNotBlank((CharSequence)userVipFlag) ? userVipFlag : "0");
        List avatars = this.tdhVirtualHumanMapper.selectAll(queryCondition);
        log.info("\u67e5\u8be2\u5230\u6240\u6709\u53ef\u7528\u6570\u5b57\u4eba\u6570\u91cf: {}, VIP\u72b6\u6001: {}", (Object)avatars.size(), (Object)userVipFlag);
        return avatars;
    }

    @Override
    public String getRandomAvatarId(String tenantCode, String userId, String userVipFlag) {
        log.info("\u83b7\u53d6\u968f\u673a\u6570\u5b57\u4ebaID - tenantCode: {}, userId: {}, userVipFlag: {}", new Object[]{tenantCode, userId, userVipFlag});
        String avatarId = this.tdhVirtualHumanMapper.findRandomTdhId(tenantCode, userId, userVipFlag);
        log.info("\u968f\u673a\u6570\u5b57\u4ebaID: {}, VIP\u72b6\u6001: {}", (Object)avatarId, (Object)userVipFlag);
        return avatarId;
    }

    @Override
    public boolean isAvatarExists(String avatarId, String tenantCode, String userId, String userVipFlag) {
        try {
            String currentUserVipFlag;
            if (StringUtils.isBlank((CharSequence)avatarId)) {
                log.warn("\u68c0\u67e5\u6570\u5b57\u4eba\u5b58\u5728\u6027-\u6570\u5b57\u4ebaID\u4e3a\u7a7a");
                return false;
            }
            log.info("\u68c0\u67e5\u6570\u5b57\u4eba\u5b58\u5728\u6027 - avatarId: {}, tenantCode: {}, userId: {}, userVipFlag: {}", new Object[]{avatarId, tenantCode, userId, userVipFlag});
            TdhVirtualHuman avatar = this.tdhVirtualHumanMapper.queryById(avatarId);
            if (avatar == null) {
                log.info("\u6570\u5b57\u4eba\u4e0d\u5b58\u5728: {}", (Object)avatarId);
                return false;
            }
            if (!EntityValidType.NORMAL.getCode().equals(avatar.getIsValid())) {
                log.info("\u6570\u5b57\u4eba\u5df2\u5220\u9664\u6216\u65e0\u6548: {}, isValid: {}", (Object)avatarId, (Object)avatar.getIsValid());
                return false;
            }
            String avatarVipFlag = StringUtils.isBlank((CharSequence)avatar.getVipFlag()) ? "0" : avatar.getVipFlag();
            String string = currentUserVipFlag = StringUtils.isBlank((CharSequence)userVipFlag) ? "0" : userVipFlag;
            if (Integer.parseInt(avatarVipFlag) > Integer.parseInt(currentUserVipFlag)) {
                log.info("\u7528\u6237VIP\u7b49\u7ea7\u4e0d\u8db3\u4ee5\u8bbf\u95ee\u6570\u5b57\u4eba: {}, \u9700\u8981VIP\u7b49\u7ea7: {}, \u7528\u6237VIP\u7b49\u7ea7: {}", new Object[]{avatarId, avatarVipFlag, currentUserVipFlag});
                return false;
            }
            String avatarUserId = avatar.getUserId();
            String avatarTenantCode = avatar.getTenantCode();
            String avatarSource = avatar.getTdhSource();
            if ("00000000".equals(avatarUserId) && "0".equals(avatarSource)) {
                log.info("\u6570\u5b57\u4eba\u5b58\u5728\u4e14\u7528\u6237\u6709\u6743\u9650\u8bbf\u95ee - \u7cfb\u7edf\u5185\u7f6e\u6570\u5b57\u4eba: {}", (Object)avatarId);
                return true;
            }
            if (tenantCode.equals(avatarUserId) && "1".equals(avatarSource)) {
                log.info("\u6570\u5b57\u4eba\u5b58\u5728\u4e14\u7528\u6237\u6709\u6743\u9650\u8bbf\u95ee - \u4f01\u4e1a\u5b9a\u5236\u6570\u5b57\u4eba: {}", (Object)avatarId);
                return true;
            }
            if (tenantCode.equals(avatarTenantCode) && "0".equals(avatarSource)) {
                log.info("\u6570\u5b57\u4eba\u5b58\u5728\u4e14\u7528\u6237\u6709\u6743\u9650\u8bbf\u95ee - \u4f01\u4e1a\u901a\u7528\u6570\u5b57\u4eba: {}", (Object)avatarId);
                return true;
            }
            if (tenantCode.equals(avatarTenantCode) && userId.equals(avatarUserId) && "1".equals(avatarSource)) {
                log.info("\u6570\u5b57\u4eba\u5b58\u5728\u4e14\u7528\u6237\u6709\u6743\u9650\u8bbf\u95ee - \u4e2a\u4eba\u5b9a\u5236\u6570\u5b57\u4eba: {}", (Object)avatarId);
                return true;
            }
            if ("00000000".equals(avatarUserId) && "2".equals(avatarSource)) {
                log.info("\u6570\u5b57\u4eba\u5b58\u5728\u4e14\u7528\u6237\u6709\u6743\u9650\u8bbf\u95ee - \u516c\u6709\u5361\u901a\u6570\u5b57\u4eba: {}", (Object)avatarId);
                return true;
            }
            if (tenantCode.equals(avatarUserId) && "2".equals(avatarSource)) {
                log.info("\u6570\u5b57\u4eba\u5b58\u5728\u4e14\u7528\u6237\u6709\u6743\u9650\u8bbf\u95ee - \u79c1\u6709\u5361\u901a\u6570\u5b57\u4eba: {}", (Object)avatarId);
                return true;
            }
            log.info("\u7528\u6237\u65e0\u6743\u9650\u8bbf\u95ee\u6570\u5b57\u4eba: {}, avatarUserId: {}, avatarTenantCode: {}, avatarSource: {}", new Object[]{avatarId, avatarUserId, avatarTenantCode, avatarSource});
            return false;
        }
        catch (Exception e) {
            log.error("\u68c0\u67e5\u6570\u5b57\u4eba\u5b58\u5728\u6027\u5f02\u5e38 - avatarId: {}, \u9519\u8bef: {}", new Object[]{avatarId, e.getMessage(), e});
            return false;
        }
    }
}

